/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.FloatRange;
import yslelf.cloudpick.graphics.graphics.BlendMode;
import yslelf.cloudpick.graphics.graphics.Matrix;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.render.core.Matrix4;

@ApiStatus.Internal
public class RenderProperties {
    public static final int CLIP_TO_BOUNDS = 1;
    public static final int CLIP_TO_CLIP_BOUNDS = 2;
    @Nullable
    private Matrix4 mTransform;
    private final Matrix mMatrix = new Matrix();
    @Nullable
    private Matrix mInverseMatrix;
    private Rect mClipBounds;
    @Nullable
    private Matrix mAnimationMatrix;
    private boolean mForceToLayer = false;
    private int mLayerAlpha;
    private BlendMode mLayerMode = null;
    private int mLeft = 0;
    private int mTop = 0;
    private int mRight = 0;
    private int mBottom = 0;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mClippingFlags = 1;
    private float mAlpha = 1.0f;
    private float mTranslationX = 0.0f;
    private float mTranslationY = 0.0f;
    private float mTranslationZ = 0.0f;
    private float mElevation;
    private float mRotationX = 0.0f;
    private float mRotationY = 0.0f;
    private float mRotationZ = 0.0f;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mPivotX = 0.0f;
    private float mPivotY = 0.0f;
    private boolean mHasOverlappingRendering = false;
    private boolean mPivotExplicitlySet = false;
    private boolean mMatrixOrPivotDirty = false;
    private float mCameraDistance = 1.0f;
    private boolean mCameraDistanceExplicitlySet = false;

    public RenderProperties() {
        this.setLayerPaint(null);
    }

    void computeTransform() {
        this.mMatrixOrPivotDirty = false;
        if (!this.mPivotExplicitlySet) {
            this.mPivotX = (float)this.mWidth / 2.0f;
            this.mPivotY = (float)this.mHeight / 2.0f;
        }
        if (!this.mCameraDistanceExplicitlySet) {
            this.mCameraDistance = Math.max(this.mWidth, this.mHeight);
        }
        if (this.mTransform == null) {
            this.mTransform = new Matrix4();
        }
        Matrix4 matrix = this.mTransform;
        matrix.setIdentity();
        if (Math.abs(this.mRotationX) == 0.0f && Math.abs(this.mRotationY) == 0.0f) {
            matrix.preRotateZ(Math.toRadians(this.mRotationZ));
        } else {
            matrix.m34 = -1.0f / this.mCameraDistance;
            matrix.preRotate(Math.toRadians(this.mRotationX), Math.toRadians(this.mRotationY), Math.toRadians(this.mRotationZ));
        }
        matrix.preTranslate(this.mTranslationX, this.mTranslationY, this.mTranslationZ);
        matrix.preScale(this.mScaleX, this.mScaleY);
        matrix.preTranslate(-this.mPivotX, -this.mPivotY);
        matrix.postTranslate(this.mPivotX + this.mTranslationX, this.mPivotY + this.mTranslationY, this.mTranslationZ);
        matrix.toMatrix(this.mMatrix);
    }

    public Matrix getMatrix() {
        if (this.mMatrixOrPivotDirty) {
            this.computeTransform();
        }
        return this.mMatrix;
    }

    public Matrix getInverseMatrix() {
        Matrix matrix = this.getMatrix();
        if (matrix == null) {
            return null;
        }
        if (this.mInverseMatrix == null) {
            this.mInverseMatrix = new Matrix();
        }
        if (!matrix.invert(this.mInverseMatrix)) {
            this.mInverseMatrix.setIdentity();
        }
        return this.mInverseMatrix;
    }

    public boolean setUseCompositingLayer(boolean forceToLayer, @Nullable Paint paint) {
        boolean changed;
        boolean bl = changed = this.mForceToLayer != forceToLayer;
        if (changed) {
            this.mForceToLayer = forceToLayer;
        }
        return changed |= this.setLayerPaint(forceToLayer ? paint : null);
    }

    public boolean getUseCompositingLayer() {
        return this.mForceToLayer;
    }

    private boolean setLayerPaint(@Nullable Paint paint) {
        BlendMode mode;
        int alpha;
        boolean changed = false;
        int n2 = alpha = paint != null ? paint.getAlpha() : 255;
        if (this.mLayerAlpha != alpha) {
            this.mLayerAlpha = alpha;
            changed = true;
        }
        BlendMode blendMode = mode = paint != null ? paint.getBlendMode() : BlendMode.SRC_OVER;
        if (this.mLayerMode != mode) {
            this.mLayerMode = mode;
            changed = true;
        }
        return changed;
    }

    public boolean getUseTransientLayer() {
        return this.mAlpha < 1.0f && this.mAlpha > 0.0f && this.mHasOverlappingRendering;
    }

    public int getLayerAlpha() {
        return this.mLayerAlpha;
    }

    public BlendMode getLayerBlendMode() {
        return this.mLayerMode;
    }

    public boolean setClipBounds(@Nullable Rect clipBounds) {
        boolean ret;
        if (clipBounds == null) {
            if ((this.mClippingFlags & 2) != 0) {
                this.mClippingFlags &= 0xFFFFFFFD;
                return true;
            }
            return false;
        }
        boolean bl = ret = (this.mClippingFlags & 2) == 0;
        if (ret) {
            this.mClippingFlags |= 2;
        }
        if (this.mClipBounds == null) {
            this.mClipBounds = new Rect(clipBounds);
        } else {
            if (this.mClipBounds.equals(clipBounds)) {
                return ret;
            }
            this.mClipBounds.set(clipBounds);
        }
        return true;
    }

    public boolean setClipToBounds(boolean clipToBounds) {
        if (clipToBounds) {
            if ((this.mClippingFlags & 1) == 0) {
                this.mClippingFlags |= 1;
                return true;
            }
        } else if ((this.mClippingFlags & 1) != 0) {
            this.mClippingFlags &= 0xFFFFFFFE;
            return true;
        }
        return false;
    }

    public int getClippingFlags() {
        return this.mClippingFlags;
    }

    public Rect getClipBounds() {
        return this.mClipBounds;
    }

    public boolean getClipToBounds() {
        return (this.mClippingFlags & 1) != 0;
    }

    public boolean setAnimationMatrix(@Nullable Matrix matrix) {
        if (matrix == null) {
            if (this.mAnimationMatrix != null) {
                this.mAnimationMatrix = null;
                return true;
            }
            return false;
        }
        if (this.mAnimationMatrix == null) {
            this.mAnimationMatrix = new Matrix(matrix);
        } else if (!this.mAnimationMatrix.isApproxEqual(matrix)) {
            this.mAnimationMatrix.set(matrix);
        } else {
            return false;
        }
        return true;
    }

    @Nullable
    public Matrix getAnimationMatrix() {
        return this.mAnimationMatrix;
    }

    public boolean setAlpha(float alpha) {
        if (alpha <= 0.001f) {
            alpha = 0.0f;
        } else if (alpha >= 0.999f) {
            alpha = 1.0f;
        }
        if (this.mAlpha != alpha) {
            this.mAlpha = alpha;
            return true;
        }
        return false;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public boolean setHasOverlappingRendering(boolean hasOverlappingRendering) {
        if (this.mHasOverlappingRendering != hasOverlappingRendering) {
            this.mHasOverlappingRendering = hasOverlappingRendering;
            return true;
        }
        return false;
    }

    public boolean getHasOverlappingRendering() {
        return this.mHasOverlappingRendering;
    }

    public boolean setElevation(float lift) {
        if (this.mElevation != lift) {
            this.mElevation = lift;
            return true;
        }
        return false;
    }

    public float getElevation() {
        return this.mElevation;
    }

    public boolean setTranslationX(float translationX) {
        if (this.mTranslationX != translationX) {
            this.mTranslationX = translationX;
            this.mMatrixOrPivotDirty = true;
            return true;
        }
        return false;
    }

    public float getTranslationX() {
        return this.mTranslationX;
    }

    public boolean setTranslationY(float translationY) {
        if (this.mTranslationY != translationY) {
            this.mTranslationY = translationY;
            this.mMatrixOrPivotDirty = true;
            return true;
        }
        return false;
    }

    public float getTranslationY() {
        return this.mTranslationY;
    }

    public boolean setTranslationZ(float translationZ) {
        if (this.mTranslationZ != translationZ) {
            this.mTranslationZ = translationZ;
            return true;
        }
        return false;
    }

    public float getTranslationZ() {
        return this.mTranslationZ;
    }

    public boolean setX(float x) {
        return this.setTranslationX(x - (float)this.mLeft);
    }

    public float getX() {
        return (float)this.mLeft + this.mTranslationX;
    }

    public boolean setY(float y) {
        return this.setTranslationY(y - (float)this.mTop);
    }

    public float getY() {
        return (float)this.mTop + this.mTranslationY;
    }

    public boolean setZ(float z) {
        return this.setTranslationZ(z - this.mElevation);
    }

    public float getZ() {
        return this.mElevation + this.mTranslationZ;
    }

    public boolean setRotationX(float rotationX) {
        if (this.mRotationX != rotationX) {
            this.mRotationX = rotationX;
            this.mMatrixOrPivotDirty = true;
            return true;
        }
        return false;
    }

    public float getRotationX() {
        return this.mRotationX;
    }

    public boolean setRotationY(float rotationY) {
        if (this.mRotationY != rotationY) {
            this.mRotationY = rotationY;
            this.mMatrixOrPivotDirty = true;
            return true;
        }
        return false;
    }

    public float getRotationY() {
        return this.mRotationY;
    }

    public boolean setRotationZ(float rotationZ) {
        if (this.mRotationZ != rotationZ) {
            this.mRotationZ = rotationZ;
            this.mMatrixOrPivotDirty = true;
            return true;
        }
        return false;
    }

    public float getRotationZ() {
        return this.mRotationZ;
    }

    public boolean setScaleX(float scaleX) {
        if (this.mScaleX != scaleX) {
            this.mScaleX = scaleX;
            this.mMatrixOrPivotDirty = true;
            return true;
        }
        return false;
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public boolean setScaleY(float scaleY) {
        if (this.mScaleY != scaleY) {
            this.mScaleY = scaleY;
            this.mMatrixOrPivotDirty = true;
            return true;
        }
        return false;
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public boolean setPivotX(float pivotX) {
        boolean dirty;
        boolean bl = dirty = this.mPivotX != pivotX;
        if (dirty) {
            this.mPivotX = pivotX;
        }
        if (dirty || !this.mPivotExplicitlySet) {
            this.mMatrixOrPivotDirty = true;
            this.mPivotExplicitlySet = true;
            return true;
        }
        return false;
    }

    public float getPivotX() {
        if (!this.mPivotExplicitlySet) {
            return (float)this.mWidth / 2.0f;
        }
        return this.mPivotX;
    }

    public boolean setPivotY(float pivotY) {
        boolean dirty;
        boolean bl = dirty = this.mPivotY != pivotY;
        if (dirty) {
            this.mPivotY = pivotY;
        }
        if (dirty || !this.mPivotExplicitlySet) {
            this.mMatrixOrPivotDirty = true;
            this.mPivotExplicitlySet = true;
            return true;
        }
        return false;
    }

    public float getPivotY() {
        if (!this.mPivotExplicitlySet) {
            return (float)this.mHeight / 2.0f;
        }
        return this.mPivotY;
    }

    public boolean isPivotExplicitlySet() {
        return this.mPivotExplicitlySet;
    }

    public boolean resetPivot() {
        if (this.mPivotExplicitlySet) {
            this.mPivotExplicitlySet = false;
            this.mMatrixOrPivotDirty = true;
            return true;
        }
        return false;
    }

    public boolean setCameraDistance(@FloatRange(from=0.0, to=3.4028234663852886E38) float distance) {
        boolean dirty;
        if (!Float.isFinite(distance) || distance <= 0.0f) {
            throw new IllegalArgumentException("distance must be finite & positive, given=" + distance);
        }
        boolean bl = dirty = this.mCameraDistance != distance;
        if (dirty) {
            this.mCameraDistance = distance;
        }
        if (dirty || !this.mCameraDistanceExplicitlySet) {
            this.mMatrixOrPivotDirty = true;
            this.mCameraDistanceExplicitlySet = true;
            return true;
        }
        return false;
    }

    @FloatRange(from=0.0, to=3.4028234663852886E38)
    public float getCameraDistance() {
        if (!this.mCameraDistanceExplicitlySet) {
            return Math.max(this.mWidth, this.mHeight);
        }
        return this.mCameraDistance;
    }

    public boolean isCameraDistanceExplicitlySet() {
        return this.mCameraDistanceExplicitlySet;
    }

    public boolean resetCameraDistance() {
        if (this.mCameraDistanceExplicitlySet) {
            this.mCameraDistanceExplicitlySet = false;
            this.mMatrixOrPivotDirty = true;
            return true;
        }
        return false;
    }

    public boolean setLeft(int left) {
        if (this.mLeft != left) {
            this.mLeft = left;
            this.mWidth = this.mRight - left;
            if (!this.mPivotExplicitlySet) {
                this.mMatrixOrPivotDirty = true;
            }
            return true;
        }
        return false;
    }

    public int getLeft() {
        return this.mLeft;
    }

    public boolean setTop(int top) {
        if (this.mTop != top) {
            this.mTop = top;
            this.mHeight = this.mBottom - top;
            if (!this.mPivotExplicitlySet) {
                this.mMatrixOrPivotDirty = true;
            }
            return true;
        }
        return false;
    }

    public int getTop() {
        return this.mTop;
    }

    public boolean setRight(int right) {
        if (this.mRight != right) {
            this.mRight = right;
            this.mWidth = right - this.mLeft;
            if (!this.mPivotExplicitlySet) {
                this.mMatrixOrPivotDirty = true;
            }
            return true;
        }
        return false;
    }

    public int getRight() {
        return this.mRight;
    }

    public boolean setBottom(int bottom) {
        if (this.mBottom != bottom) {
            this.mBottom = bottom;
            this.mHeight = bottom - this.mTop;
            if (!this.mPivotExplicitlySet) {
                this.mMatrixOrPivotDirty = true;
            }
            return true;
        }
        return false;
    }

    public int getBottom() {
        return this.mBottom;
    }

    public boolean setPosition(int left, int top, int right, int bottom) {
        if (left != this.mLeft || top != this.mTop || right != this.mRight || bottom != this.mBottom) {
            this.mLeft = left;
            this.mTop = top;
            this.mRight = right;
            this.mBottom = bottom;
            this.mWidth = right - left;
            this.mHeight = bottom - top;
            if (!this.mPivotExplicitlySet) {
                this.mMatrixOrPivotDirty = true;
            }
            return true;
        }
        return false;
    }

    public boolean setPosition(@Nonnull Rect position) {
        return this.setPosition(position.left, position.top, position.right, position.bottom);
    }

    public boolean offsetLeftAndRight(int offset) {
        if (offset != 0) {
            this.mLeft += offset;
            this.mRight += offset;
            return true;
        }
        return false;
    }

    public boolean offsetTopAndBottom(int offset) {
        if (offset != 0) {
            this.mTop += offset;
            this.mBottom += offset;
            return true;
        }
        return false;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }
}

