/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.core.Core;
import yslelf.cloudpick.graphics.graphics.drawable.Animatable;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.graphics.drawable.DrawableContainer;
import yslelf.cloudpick.graphics.resources.Resources;

public class AnimationDrawable
extends DrawableContainer
implements Runnable,
Animatable {
    private AnimationState mAnimationState;
    private int mCurFrame = 0;
    private boolean mRunning;
    private boolean mAnimating;
    private boolean mMutated;

    public AnimationDrawable() {
        this(null, null);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (visible) {
            if (restart || changed) {
                boolean startFromZero = restart || !this.mRunning && !this.mAnimationState.mOneShot || this.mCurFrame >= this.mAnimationState.getChildCount();
                this.setFrame(startFromZero ? 0 : this.mCurFrame, true, this.mAnimating);
            }
        } else {
            this.unscheduleSelf(this);
        }
        return changed;
    }

    @Override
    public void start() {
        this.mAnimating = true;
        if (!this.isRunning()) {
            this.setFrame(0, false, this.mAnimationState.getChildCount() > 1 || !this.mAnimationState.mOneShot);
        }
    }

    @Override
    public void stop() {
        this.mAnimating = false;
        if (this.isRunning()) {
            this.mCurFrame = 0;
            this.unscheduleSelf(this);
        }
    }

    @Override
    public boolean isRunning() {
        return this.mRunning;
    }

    @Override
    public void run() {
        this.nextFrame(false);
    }

    @Override
    public void unscheduleSelf(@NonNull Runnable what) {
        this.mRunning = false;
        super.unscheduleSelf(what);
    }

    public int getNumberOfFrames() {
        return this.mAnimationState.getChildCount();
    }

    public Drawable getFrame(int index) {
        return this.mAnimationState.getChild(index);
    }

    public int getDuration(int i) {
        return this.mAnimationState.mDurations[i];
    }

    public boolean isOneShot() {
        return this.mAnimationState.mOneShot;
    }

    public void setOneShot(boolean oneShot) {
        this.mAnimationState.mOneShot = oneShot;
    }

    public void addFrame(@NonNull Drawable frame, int duration) {
        this.mAnimationState.addFrame(frame, duration);
        if (!this.mRunning) {
            this.setFrame(0, true, false);
        }
    }

    private void nextFrame(boolean unschedule) {
        boolean isLastFrame;
        int nextFrame = this.mCurFrame + 1;
        int numFrames = this.mAnimationState.getChildCount();
        boolean bl = isLastFrame = this.mAnimationState.mOneShot && nextFrame >= numFrames - 1;
        if (!this.mAnimationState.mOneShot && nextFrame >= numFrames) {
            nextFrame = 0;
        }
        this.setFrame(nextFrame, unschedule, !isLastFrame);
    }

    private void setFrame(int frame, boolean unschedule, boolean animate) {
        if (frame >= this.mAnimationState.getChildCount()) {
            return;
        }
        this.mAnimating = animate;
        this.mCurFrame = frame;
        this.selectDrawable(frame);
        if (unschedule || animate) {
            this.unscheduleSelf(this);
        }
        if (animate) {
            this.mCurFrame = frame;
            this.mRunning = true;
            this.scheduleSelf(this, Core.timeMillis() + (long)this.mAnimationState.mDurations[frame]);
        }
    }

    @Override
    @NonNull
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mAnimationState.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    AnimationState cloneConstantState() {
        return new AnimationState(this.mAnimationState, this, null);
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    @Override
    protected void setConstantState(@NonNull DrawableContainer.DrawableContainerState state) {
        super.setConstantState(state);
        if (state instanceof AnimationState) {
            this.mAnimationState = (AnimationState)state;
        }
    }

    public long getTotalDuration() {
        return this.mAnimationState.getTotalDuration();
    }

    private AnimationDrawable(AnimationState state, Resources res) {
        AnimationState as = new AnimationState(state, this, res);
        this.setConstantState(as);
        if (state != null) {
            this.setFrame(0, true, false);
        }
    }

    private static final class AnimationState
    extends DrawableContainer.DrawableContainerState {
        private int[] mDurations;
        private boolean mOneShot;

        AnimationState(AnimationState orig, AnimationDrawable owner, Resources res) {
            super(orig, owner, res);
            if (orig != null) {
                this.mDurations = orig.mDurations;
                this.mOneShot = orig.mOneShot;
            } else {
                this.mDurations = new int[this.getCapacity()];
                this.mOneShot = false;
            }
        }

        private void mutate() {
            this.mDurations = (int[])this.mDurations.clone();
        }

        @Override
        @NonNull
        public Drawable newDrawable() {
            return new AnimationDrawable(this, null);
        }

        @Override
        @NonNull
        public Drawable newDrawable(Resources res) {
            return new AnimationDrawable(this, res);
        }

        public void addFrame(Drawable dr, int dur) {
            int pos = super.addChild(dr);
            this.mDurations[pos] = dur;
        }

        @Override
        public void growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[] newDurations = new int[newSize];
            System.arraycopy(this.mDurations, 0, newDurations, 0, oldSize);
            this.mDurations = newDurations;
        }

        public long getTotalDuration() {
            if (this.mDurations != null) {
                int total = 0;
                for (int dur : this.mDurations) {
                    total += dur;
                }
                return total;
            }
            return 0L;
        }
    }
}

