/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.graphics.drawable.DrawableWrapper;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.view.Gravity;

public class ClipDrawable
extends DrawableWrapper {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private final Rect mTmpRect = new Rect();
    private ClipState mState;

    ClipDrawable() {
        this(new ClipState(null, null), null);
    }

    public ClipDrawable(Drawable drawable, int gravity, int orientation) {
        this(new ClipState(null, null), null);
        this.mState.mGravity = gravity;
        this.mState.mOrientation = orientation;
        this.setDrawable(drawable);
    }

    @Override
    protected boolean onLevelChange(int level) {
        super.onLevelChange(level);
        this.invalidateSelf();
        return true;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        Drawable dr = this.getDrawable();
        if (dr == null || dr.getLevel() == 0) {
            return;
        }
        Rect r = this.mTmpRect;
        Rect bounds = this.getBounds();
        int level = this.getLevel();
        int w = bounds.width();
        boolean iw = false;
        if ((this.mState.mOrientation & 1) != 0) {
            w -= (w - 0) * (10000 - level) / 10000;
        }
        int h2 = bounds.height();
        boolean ih = false;
        if ((this.mState.mOrientation & 2) != 0) {
            h2 -= (h2 - 0) * (10000 - level) / 10000;
        }
        int layoutDirection = this.getLayoutDirection();
        Gravity.apply(this.mState.mGravity, w, h2, bounds, r, layoutDirection);
        if (w > 0 && h2 > 0) {
            canvas.save();
            canvas.clipRect(r);
            dr.draw(canvas);
            canvas.restore();
        }
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        this.mState = new ClipState(this.mState, null);
        return this.mState;
    }

    private ClipDrawable(ClipState state, Resources res) {
        super(state, res);
        this.mState = state;
    }

    static final class ClipState
    extends DrawableWrapper.DrawableWrapperState {
        int mOrientation = 1;
        int mGravity = 3;

        ClipState(ClipState orig, Resources res) {
            super(orig, res);
            if (orig != null) {
                this.mOrientation = orig.mOrientation;
                this.mGravity = orig.mGravity;
            }
        }

        @Override
        @NonNull
        public Drawable newDrawable(Resources res) {
            return new ClipDrawable(this, res);
        }
    }
}

