/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import java.util.Objects;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.BlendMode;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.ColorDrawable;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.util.ColorStateList;

public class ColorStateListDrawable
extends Drawable
implements Drawable.Callback {
    private ColorDrawable mColorDrawable;
    private ColorStateListDrawableState mState;
    private boolean mMutated = false;

    public ColorStateListDrawable() {
        this.mState = new ColorStateListDrawableState();
        this.initializeColorDrawable();
    }

    public ColorStateListDrawable(@NonNull ColorStateList colorStateList) {
        this.mState = new ColorStateListDrawableState();
        this.initializeColorDrawable();
        this.setColorStateList(colorStateList);
    }

    private ColorStateListDrawable(@NonNull ColorStateListDrawableState state) {
        this.mState = state;
        this.initializeColorDrawable();
        this.onStateChange(this.getState());
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        this.mColorDrawable.draw(canvas);
    }

    @Override
    public int getAlpha() {
        return this.mColorDrawable.getAlpha();
    }

    @Override
    public boolean isStateful() {
        return this.mState.isStateful();
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return this.mState.hasFocusStateSpecified();
    }

    @Override
    @NonNull
    public Drawable getCurrent() {
        return this.mColorDrawable;
    }

    @Override
    public void setAlpha(int alpha) {
        this.mState.mAlpha = alpha;
        this.onStateChange(this.getState());
    }

    public void clearAlpha() {
        this.mState.mAlpha = -1;
        this.onStateChange(this.getState());
    }

    @Override
    public void setTintList(@Nullable ColorStateList tint) {
        this.mState.mTint = tint;
        this.mColorDrawable.setTintList(tint);
        this.onStateChange(this.getState());
    }

    @Override
    public void setTintBlendMode(@NonNull BlendMode blendMode) {
        this.mState.mBlendMode = blendMode;
        this.mColorDrawable.setTintBlendMode(blendMode);
        this.onStateChange(this.getState());
    }

    @Override
    protected void onBoundsChange(@NonNull Rect bounds) {
        super.onBoundsChange(bounds);
        this.mColorDrawable.setBounds(bounds);
    }

    @Override
    protected boolean onStateChange(@NonNull int[] state) {
        if (this.mState.mColor != null) {
            int color = this.mState.mColor.getColorForState(state, this.mState.mColor.getDefaultColor());
            if (this.mState.mAlpha != -1) {
                color = color & 0xFFFFFF | this.mState.mAlpha << 24;
            }
            if (color != this.mColorDrawable.getColor()) {
                this.mColorDrawable.setColor(color);
                this.mColorDrawable.setState(state);
                return true;
            }
            return this.mColorDrawable.setState(state);
        }
        return false;
    }

    @Override
    public void invalidateDrawable(@NonNull Drawable who) {
        if (who == this.mColorDrawable && this.getCallback() != null) {
            this.getCallback().invalidateDrawable(this);
        }
    }

    @Override
    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        if (who == this.mColorDrawable && this.getCallback() != null) {
            this.getCallback().scheduleDrawable(this, what, when);
        }
    }

    @Override
    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        if (who == this.mColorDrawable && this.getCallback() != null) {
            this.getCallback().unscheduleDrawable(this, what);
        }
    }

    @Override
    @NonNull
    public Drawable.ConstantState getConstantState() {
        return this.mState;
    }

    @NonNull
    public ColorStateList getColorStateList() {
        return Objects.requireNonNullElseGet(this.mState.mColor, () -> ColorStateList.valueOf(this.mColorDrawable.getColor()));
    }

    @Override
    @NonNull
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState = new ColorStateListDrawableState(this.mState);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    public void setColorStateList(@NonNull ColorStateList colorStateList) {
        this.mState.mColor = colorStateList;
        this.onStateChange(this.getState());
    }

    private void initializeColorDrawable() {
        this.mColorDrawable = new ColorDrawable();
        this.mColorDrawable.setCallback(this);
        if (this.mState.mTint != null) {
            this.mColorDrawable.setTintList(this.mState.mTint);
        }
        if (this.mState.mBlendMode != DEFAULT_BLEND_MODE) {
            this.mColorDrawable.setTintBlendMode(this.mState.mBlendMode);
        }
    }

    static final class ColorStateListDrawableState
    extends Drawable.ConstantState {
        ColorStateList mColor = null;
        ColorStateList mTint = null;
        int mAlpha = -1;
        BlendMode mBlendMode = Drawable.DEFAULT_BLEND_MODE;

        ColorStateListDrawableState() {
        }

        ColorStateListDrawableState(ColorStateListDrawableState state) {
            this.mColor = state.mColor;
            this.mTint = state.mTint;
            this.mAlpha = state.mAlpha;
            this.mBlendMode = state.mBlendMode;
        }

        @Override
        @NonNull
        public Drawable newDrawable() {
            return new ColorStateListDrawable(this);
        }

        public boolean isStateful() {
            return this.mColor != null && this.mColor.isStateful() || this.mTint != null && this.mTint.isStateful();
        }

        public boolean hasFocusStateSpecified() {
            return this.mColor != null && this.mColor.hasFocusStateSpecified() || this.mTint != null && this.mTint.hasFocusStateSpecified();
        }
    }
}

