/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import java.io.InputStream;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.Bitmap;
import yslelf.cloudpick.graphics.graphics.BitmapFactory;
import yslelf.cloudpick.graphics.graphics.BlendMode;
import yslelf.cloudpick.graphics.graphics.BlendModeColorFilter;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.ColorFilter;
import yslelf.cloudpick.graphics.graphics.Image;
import yslelf.cloudpick.graphics.graphics.ImageShader;
import yslelf.cloudpick.graphics.graphics.Matrix;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.Shader;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.util.ColorStateList;
import yslelf.cloudpick.graphics.view.Gravity;

public class ImageDrawable
extends Drawable {
    private Rect mSrcRect;
    private final Rect mDstRect = new Rect();
    private ImageState mImageState;
    private BlendModeColorFilter mBlendModeFilter;
    private int mTargetDensity = 72;
    private boolean mFullImage = true;
    private boolean mDstRectAndInsetsDirty = true;
    private boolean mMutated;

    @Deprecated
    public ImageDrawable(Image image) {
        this.init(new ImageState(image), null);
    }

    public ImageDrawable(Resources res, Image image) {
        this.init(new ImageState(image), res);
    }

    public ImageDrawable(@NonNull String namespace, @NonNull String path) {
        Image image = Image.create(namespace, path);
        this.init(new ImageState(image), null);
    }

    @Deprecated
    public ImageDrawable(@NonNull InputStream stream) {
        this(null, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageDrawable(Resources res, @NonNull InputStream stream) {
        Image image = null;
        try (Bitmap bitmap = BitmapFactory.decodeStream(stream);){
            image = Image.createTextureFromBitmap(bitmap);
        }
        catch (Exception e) {
            CloudPick.LOGGER.warn(MarkerManager.getMarker((String)"ImageDrawable"), "Cannot create ImageDrawable from {}", (Object)stream, (Object)e);
        }
        finally {
            this.init(new ImageState(image), res);
        }
    }

    @NonNull
    public final Paint getPaint() {
        return this.mImageState.mPaint;
    }

    @Nullable
    public final Image getImage() {
        return this.mImageState.mImage;
    }

    public void setImage(@Nullable Image image) {
        if (this.mImageState.mImage != image) {
            this.mImageState.mImage = image;
            if (this.mSrcRect != null && image != null) {
                this.mSrcRect.set(0, 0, image.getWidth(), image.getWidth());
            }
            this.mFullImage = true;
            this.mDstRectAndInsetsDirty = true;
            this.invalidateSelf();
        }
    }

    public void setTargetDensity(int density) {
        if (density == 0) {
            density = 72;
        }
        if (this.mTargetDensity != density) {
            this.mTargetDensity = density;
            this.mDstRectAndInsetsDirty = true;
            this.invalidateSelf();
        }
    }

    public int getGravity() {
        return this.mImageState.mGravity;
    }

    public void setGravity(int gravity) {
        if (this.mImageState.mGravity != gravity) {
            this.mImageState.mGravity = gravity;
            this.mDstRectAndInsetsDirty = true;
            this.invalidateSelf();
        }
    }

    @Deprecated
    public void setSrcRect(int left, int top, int right, int bottom) {
        Image image = this.mImageState.mImage;
        if (image == null) {
            return;
        }
        this.setSubset(new Rect(left, top, right, bottom));
    }

    @Deprecated
    public void setSrcRect(@Nullable Rect srcRect) {
        this.setSubset(srcRect);
    }

    public void setSubset(@Nullable Rect subset) {
        Image image = this.mImageState.mImage;
        if (image == null) {
            return;
        }
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (subset == null || subset.contains(0, 0, imageWidth, imageHeight)) {
            if (!this.mFullImage) {
                this.invalidateSelf();
            }
            this.mFullImage = true;
        } else {
            if (this.mSrcRect == null) {
                this.mSrcRect = new Rect(0, 0, imageWidth, imageHeight);
                if (!this.mSrcRect.intersect(subset)) {
                    this.mSrcRect.setEmpty();
                }
                this.invalidateSelf();
            } else if (!this.mSrcRect.equals(subset)) {
                this.mSrcRect.set(0, 0, imageWidth, imageHeight);
                if (!this.mSrcRect.intersect(subset)) {
                    this.mSrcRect.setEmpty();
                }
                this.invalidateSelf();
            }
            this.mFullImage = false;
        }
    }

    @ApiStatus.Experimental
    public void setMipmap(boolean mipmap) {
    }

    @ApiStatus.Experimental
    public boolean hasMipmap() {
        return true;
    }

    public void setAntiAlias(boolean aa) {
        this.mImageState.mPaint.setAntiAlias(aa);
        this.invalidateSelf();
    }

    public boolean isAntiAlias() {
        return this.mImageState.mPaint.isAntiAlias();
    }

    public void setDither(boolean dither) {
        this.mImageState.mPaint.setDither(dither);
        this.invalidateSelf();
    }

    public boolean isDither() {
        return this.mImageState.mPaint.isDither();
    }

    public void setFilter(boolean filter) {
        if (this.mImageState.mPaint.isFilter() != filter) {
            this.mImageState.mPaint.setFilter(filter);
            this.mImageState.mRebuildShader = true;
            this.invalidateSelf();
        }
    }

    public boolean isFilter() {
        return this.mImageState.mPaint.isFilter();
    }

    @Nullable
    public Shader.TileMode getTileModeX() {
        return this.mImageState.mTileModeX;
    }

    @Nullable
    public Shader.TileMode getTileModeY() {
        return this.mImageState.mTileModeY;
    }

    public void setTileModeX(@Nullable Shader.TileMode mode) {
        this.setTileModeXY(mode, this.mImageState.mTileModeY);
    }

    public final void setTileModeY(@Nullable Shader.TileMode mode) {
        this.setTileModeXY(this.mImageState.mTileModeX, mode);
    }

    public void setTileModeXY(@Nullable Shader.TileMode tileModeX, @Nullable Shader.TileMode tileModeY) {
        ImageState state = this.mImageState;
        if (state.mTileModeX != tileModeX || state.mTileModeY != tileModeY) {
            state.mTileModeX = tileModeX;
            state.mTileModeY = tileModeY;
            state.mRebuildShader = true;
            this.mDstRectAndInsetsDirty = true;
            this.invalidateSelf();
        }
    }

    @Override
    public void setAutoMirrored(boolean mirrored) {
        if (this.mImageState.mAutoMirrored != mirrored) {
            this.mImageState.mAutoMirrored = mirrored;
            this.invalidateSelf();
        }
    }

    @Override
    public final boolean isAutoMirrored() {
        return this.mImageState.mAutoMirrored;
    }

    private boolean needMirroring() {
        return this.isAutoMirrored() && this.getLayoutDirection() == 1;
    }

    @Override
    protected void onBoundsChange(@NonNull Rect bounds) {
        this.mDstRectAndInsetsDirty = true;
        this.mImageState.mRebuildShader = true;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        boolean clearColorFilter;
        int restoreAlpha;
        boolean useShader;
        boolean rebuildShader;
        Image image = this.mImageState.mImage;
        if (image == null) {
            return;
        }
        ImageState state = this.mImageState;
        Paint paint = state.mPaint;
        Shader.TileMode tileModeX = state.mTileModeX;
        Shader.TileMode tileModeY = state.mTileModeY;
        if (state.mRebuildShader) {
            if (tileModeX == null && tileModeY == null) {
                paint.setShader(null);
                rebuildShader = false;
                useShader = false;
            } else {
                rebuildShader = true;
                useShader = true;
            }
            state.mRebuildShader = false;
        } else {
            rebuildShader = false;
            useShader = paint.hasShader();
        }
        if (state.mBaseAlpha != 1.0f) {
            Paint p2 = this.getPaint();
            restoreAlpha = p2.getAlpha();
            p2.setAlpha((int)((float)restoreAlpha * state.mBaseAlpha + 0.5f));
        } else {
            restoreAlpha = -1;
        }
        if (this.mBlendModeFilter != null && paint.getColorFilter() == null) {
            paint.setColorFilter(this.mBlendModeFilter);
            clearColorFilter = true;
        } else {
            clearColorFilter = false;
        }
        this.updateDstRectAndInsetsIfDirty();
        boolean needMirroring = this.needMirroring();
        if (!useShader) {
            if (needMirroring) {
                canvas.save();
                canvas.translate(this.mDstRect.width(), 0.0f);
                canvas.scale(-1.0f, 1.0f);
            }
            canvas.drawImage(image, this.mFullImage ? null : this.mSrcRect, this.mDstRect, paint);
            if (needMirroring) {
                canvas.restore();
            }
        } else {
            if (rebuildShader) {
                paint.setShader(new ImageShader(image, tileModeX == null ? Shader.TileMode.CLAMP : tileModeX, tileModeY == null ? Shader.TileMode.CLAMP : tileModeY, paint.getFilterMode(), this.updateShaderMatrix(image, needMirroring)));
            }
            canvas.drawRect(this.mDstRect, paint);
        }
        if (clearColorFilter) {
            paint.setColorFilter(null);
        }
        if (restoreAlpha >= 0) {
            paint.setAlpha(restoreAlpha);
        }
    }

    @Nullable
    private Matrix updateShaderMatrix(@NonNull Image image, boolean needMirroring) {
        boolean needScaling;
        int sourceDensity = image.getDensity();
        int targetDensity = this.mTargetDensity;
        boolean bl = needScaling = sourceDensity != 0 && sourceDensity != targetDensity;
        if (needScaling || needMirroring) {
            Matrix matrix = new Matrix();
            if (needMirroring) {
                matrix.setScaleTranslate(-1.0f, 1.0f, this.mDstRect.width(), 0.0f);
            }
            if (needScaling) {
                float densityScale = (float)targetDensity / (float)sourceDensity;
                matrix.postScale(densityScale, densityScale);
            }
            return matrix;
        }
        return null;
    }

    private void updateDstRectAndInsetsIfDirty() {
        if (this.mDstRectAndInsetsDirty) {
            if (this.mImageState.mTileModeX == null && this.mImageState.mTileModeY == null) {
                int layoutDirection = this.getLayoutDirection();
                Gravity.apply(this.mImageState.mGravity, this.getIntrinsicWidth(), this.getIntrinsicHeight(), this.getBounds(), this.mDstRect, layoutDirection);
            } else {
                this.copyBounds(this.mDstRect);
            }
            this.mDstRectAndInsetsDirty = false;
        }
    }

    @Override
    public void setAlpha(int alpha) {
        int oldAlpha = this.mImageState.mPaint.getAlpha();
        if (alpha != oldAlpha) {
            this.mImageState.mPaint.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    @Override
    public int getAlpha() {
        return this.mImageState.mPaint.getAlpha();
    }

    @Override
    public void setTintList(@Nullable ColorStateList tint) {
        ImageState state = this.mImageState;
        if (state.mTint != tint) {
            state.mTint = tint;
            this.mBlendModeFilter = this.updateBlendModeFilter(this.mBlendModeFilter, tint, this.mImageState.mBlendMode);
            this.invalidateSelf();
        }
    }

    @Override
    public void setTintBlendMode(@NonNull BlendMode blendMode) {
        ImageState state = this.mImageState;
        if (state.mBlendMode != blendMode) {
            state.mBlendMode = blendMode;
            this.mBlendModeFilter = this.updateBlendModeFilter(this.mBlendModeFilter, this.mImageState.mTint, blendMode);
            this.invalidateSelf();
        }
    }

    @Override
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mImageState.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    @Override
    @Nullable
    public ColorFilter getColorFilter() {
        return this.mImageState.mPaint.getColorFilter();
    }

    @Override
    @NonNull
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mImageState = new ImageState(this.mImageState);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    @Override
    protected boolean onStateChange(@NonNull int[] stateSet) {
        ImageState state = this.mImageState;
        if (state.mTint != null && state.mBlendMode != null) {
            this.mBlendModeFilter = this.updateBlendModeFilter(this.mBlendModeFilter, state.mTint, state.mBlendMode);
            return true;
        }
        return false;
    }

    @Override
    public boolean isStateful() {
        return this.mImageState.mTint != null && this.mImageState.mTint.isStateful() || super.isStateful();
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return this.mImageState.mTint != null && this.mImageState.mTint.hasFocusStateSpecified();
    }

    @Override
    public int getIntrinsicWidth() {
        Image image = this.mImageState.mImage;
        if (image == null) {
            return super.getIntrinsicWidth();
        }
        int width = this.mFullImage ? image.getWidth() : Math.min(this.mSrcRect.width(), image.getWidth());
        return Image.scaleFromDensity(width, image.getDensity(), this.mTargetDensity);
    }

    @Override
    public int getIntrinsicHeight() {
        Image image = this.mImageState.mImage;
        if (image == null) {
            return super.getIntrinsicHeight();
        }
        int height = this.mFullImage ? image.getHeight() : Math.min(this.mSrcRect.height(), image.getHeight());
        return Image.scaleFromDensity(height, image.getDensity(), this.mTargetDensity);
    }

    @Override
    public final Drawable.ConstantState getConstantState() {
        return this.mImageState;
    }

    private ImageDrawable(@NonNull ImageState state, Resources res) {
        this.init(state, res);
    }

    private void init(@NonNull ImageState state, Resources res) {
        this.mImageState = state;
        this.updateLocalState(res);
        if (res != null) {
            this.mImageState.mTargetDensity = this.mTargetDensity;
        }
    }

    private void updateLocalState(Resources res) {
        this.mTargetDensity = ImageDrawable.resolveDensity(res, this.mImageState.mTargetDensity);
        this.mBlendModeFilter = this.updateBlendModeFilter(this.mBlendModeFilter, this.mImageState.mTint, this.mImageState.mBlendMode);
    }

    static final class ImageState
    extends Drawable.ConstantState {
        final Paint mPaint;
        Image mImage;
        ColorStateList mTint = null;
        BlendMode mBlendMode = Drawable.DEFAULT_BLEND_MODE;
        int mGravity = 119;
        float mBaseAlpha = 1.0f;
        Shader.TileMode mTileModeX = null;
        Shader.TileMode mTileModeY = null;
        int mTargetDensity = 72;
        boolean mAutoMirrored = false;
        boolean mRebuildShader;

        ImageState(Image image) {
            this.mImage = image;
            this.mPaint = new Paint();
        }

        ImageState(@NonNull ImageState imageState) {
            this.mImage = imageState.mImage;
            this.mTint = imageState.mTint;
            this.mBlendMode = imageState.mBlendMode;
            this.mGravity = imageState.mGravity;
            this.mTileModeX = imageState.mTileModeX;
            this.mTileModeY = imageState.mTileModeY;
            this.mTargetDensity = imageState.mTargetDensity;
            this.mBaseAlpha = imageState.mBaseAlpha;
            this.mPaint = new Paint(imageState.mPaint);
            this.mRebuildShader = imageState.mRebuildShader;
            this.mAutoMirrored = imageState.mAutoMirrored;
        }

        @Override
        @NonNull
        public Drawable newDrawable() {
            return new ImageDrawable(this, null);
        }

        @Override
        @NonNull
        public Drawable newDrawable(Resources res) {
            return new ImageDrawable(this, res);
        }
    }
}

