/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.Image;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.graphics.drawable.DrawableWrapper;
import yslelf.cloudpick.graphics.resources.Resources;

public class InsetDrawable
extends DrawableWrapper {
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpInsetRect = new Rect();
    private InsetState mState;

    InsetDrawable() {
        this(new InsetState(null, null), null);
    }

    public InsetDrawable(@Nullable Drawable drawable, int inset) {
        this(drawable, inset, inset, inset, inset);
    }

    public InsetDrawable(@Nullable Drawable drawable, float inset) {
        this(drawable, inset, inset, inset, inset);
    }

    public InsetDrawable(@Nullable Drawable drawable, int insetLeft, int insetTop, int insetRight, int insetBottom) {
        this(new InsetState(null, null), null);
        this.mState.mInsetLeft = new InsetValue(0.0f, insetLeft);
        this.mState.mInsetTop = new InsetValue(0.0f, insetTop);
        this.mState.mInsetRight = new InsetValue(0.0f, insetRight);
        this.mState.mInsetBottom = new InsetValue(0.0f, insetBottom);
        this.setDrawable(drawable);
    }

    public InsetDrawable(@Nullable Drawable drawable, float insetLeftFraction, float insetTopFraction, float insetRightFraction, float insetBottomFraction) {
        this(new InsetState(null, null), null);
        this.mState.mInsetLeft = new InsetValue(insetLeftFraction, 0);
        this.mState.mInsetTop = new InsetValue(insetTopFraction, 0);
        this.mState.mInsetRight = new InsetValue(insetRightFraction, 0);
        this.mState.mInsetBottom = new InsetValue(insetBottomFraction, 0);
        this.setDrawable(drawable);
    }

    private void getInsets(Rect out) {
        Rect b = this.getBounds();
        out.left = this.mState.mInsetLeft.getDimension(b.width());
        out.right = this.mState.mInsetRight.getDimension(b.width());
        out.top = this.mState.mInsetTop.getDimension(b.height());
        out.bottom = this.mState.mInsetBottom.getDimension(b.height());
    }

    @Override
    public boolean getPadding(@NonNull Rect padding) {
        boolean pad = super.getPadding(padding);
        this.getInsets(this.mTmpInsetRect);
        padding.left += this.mTmpInsetRect.left;
        padding.right += this.mTmpInsetRect.right;
        padding.top += this.mTmpInsetRect.top;
        padding.bottom += this.mTmpInsetRect.bottom;
        return pad || (this.mTmpInsetRect.left | this.mTmpInsetRect.right | this.mTmpInsetRect.top | this.mTmpInsetRect.bottom) != 0;
    }

    @Override
    protected void onBoundsChange(@NonNull Rect bounds) {
        Rect r = this.mTmpRect;
        r.set(bounds);
        r.left += this.mState.mInsetLeft.getDimension(bounds.width());
        r.top += this.mState.mInsetTop.getDimension(bounds.height());
        r.right -= this.mState.mInsetRight.getDimension(bounds.width());
        r.bottom -= this.mState.mInsetBottom.getDimension(bounds.height());
        super.onBoundsChange(r);
    }

    @Override
    public int getIntrinsicWidth() {
        int childWidth = super.getIntrinsicWidth();
        float fraction = this.mState.mInsetLeft.mFraction + this.mState.mInsetRight.mFraction;
        if (childWidth < 0 || fraction >= 1.0f) {
            return -1;
        }
        return (int)((float)childWidth / (1.0f - fraction)) + this.mState.mInsetLeft.mDimension + this.mState.mInsetRight.mDimension;
    }

    @Override
    public int getIntrinsicHeight() {
        int childHeight = super.getIntrinsicHeight();
        float fraction = this.mState.mInsetTop.mFraction + this.mState.mInsetBottom.mFraction;
        if (childHeight < 0 || fraction >= 1.0f) {
            return -1;
        }
        return (int)((float)childHeight / (1.0f - fraction)) + this.mState.mInsetTop.mDimension + this.mState.mInsetBottom.mDimension;
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        this.mState = new InsetState(this.mState, null);
        return this.mState;
    }

    private InsetDrawable(@NonNull InsetState state, @Nullable Resources res) {
        super(state, res);
        this.mState = state;
    }

    static final class InsetState
    extends DrawableWrapper.DrawableWrapperState {
        private int[] mThemeAttrs;
        InsetValue mInsetLeft;
        InsetValue mInsetTop;
        InsetValue mInsetRight;
        InsetValue mInsetBottom;

        InsetState(@Nullable InsetState orig, @Nullable Resources res) {
            super(orig, res);
            if (orig != null) {
                this.mInsetLeft = orig.mInsetLeft.copy();
                this.mInsetTop = orig.mInsetTop.copy();
                this.mInsetRight = orig.mInsetRight.copy();
                this.mInsetBottom = orig.mInsetBottom.copy();
                if (orig.mDensity != this.mDensity) {
                    this.applyDensityScaling(orig.mDensity, this.mDensity);
                }
            } else {
                this.mInsetLeft = new InsetValue();
                this.mInsetTop = new InsetValue();
                this.mInsetRight = new InsetValue();
                this.mInsetBottom = new InsetValue();
            }
        }

        @Override
        void onDensityChanged(int sourceDensity, int targetDensity) {
            super.onDensityChanged(sourceDensity, targetDensity);
            this.applyDensityScaling(sourceDensity, targetDensity);
        }

        private void applyDensityScaling(int sourceDensity, int targetDensity) {
            this.mInsetLeft.scaleFromDensity(sourceDensity, targetDensity);
            this.mInsetTop.scaleFromDensity(sourceDensity, targetDensity);
            this.mInsetRight.scaleFromDensity(sourceDensity, targetDensity);
            this.mInsetBottom.scaleFromDensity(sourceDensity, targetDensity);
        }

        @Override
        @NonNull
        public Drawable newDrawable(@Nullable Resources res) {
            InsetState state;
            if (res != null) {
                int density;
                int densityDpi = res.getDisplayMetrics().densityDpi;
                int n2 = density = densityDpi == 0 ? 72 : densityDpi;
                state = density != this.mDensity ? new InsetState(this, res) : this;
            } else {
                state = this;
            }
            return new InsetDrawable(state, res);
        }
    }

    static final class InsetValue {
        final float mFraction;
        int mDimension;

        public InsetValue() {
            this(0.0f, 0);
        }

        public InsetValue(float fraction, int dimension) {
            this.mFraction = fraction;
            this.mDimension = dimension;
        }

        int getDimension(int boundSize) {
            return (int)((float)boundSize * this.mFraction) + this.mDimension;
        }

        void scaleFromDensity(int sourceDensity, int targetDensity) {
            if (this.mDimension != 0) {
                this.mDimension = Image.scaleFromDensity(this.mDimension, sourceDensity, targetDensity);
            }
        }

        @NonNull
        public InsetValue copy() {
            return new InsetValue(this.mFraction, this.mDimension);
        }
    }
}

