/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import java.util.Objects;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.BlendMode;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.util.ColorStateList;
import yslelf.cloudpick.graphics.view.Gravity;

public class LayerDrawable
extends Drawable
implements Drawable.Callback {
    public static final Marker MARKER = MarkerManager.getMarker((String)"LayerDrawable");
    public static final int PADDING_MODE_NEST = 0;
    public static final int PADDING_MODE_STACK = 1;
    public static final int INSET_UNDEFINED = Integer.MIN_VALUE;
    @NonNull
    LayerState mLayerState;
    private int[] mPaddingL;
    private int[] mPaddingT;
    private int[] mPaddingR;
    private int[] mPaddingB;
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpOutRect = new Rect();
    private final Rect mTmpContainer = new Rect();
    private Rect mHotspotBounds;
    private boolean mMutated;
    private boolean mSuspendChildInvalidation;
    private boolean mChildRequestedInvalidation;

    public LayerDrawable(Drawable ... layers) {
        this(layers, (LayerState)null);
    }

    LayerDrawable(@NonNull Drawable[] layers, @Nullable LayerState state) {
        this(state, null);
        Objects.requireNonNull(layers, "layers must be non-null");
        int length = layers.length;
        ChildDrawable[] r = new ChildDrawable[length];
        for (int i = 0; i < length; ++i) {
            Drawable child;
            r[i] = new ChildDrawable(this.mLayerState.mDensity);
            r[i].mDrawable = child = layers[i];
            if (child == null) continue;
            child.setCallback(this);
            this.mLayerState.mChildrenChangingConfigurations |= child.getChangingConfigurations();
        }
        this.mLayerState.mNumChildren = length;
        this.mLayerState.mChildren = r;
        this.ensurePadding();
        this.refreshPadding();
    }

    LayerDrawable() {
        this((LayerState)null, null);
    }

    LayerDrawable(@Nullable LayerState state, @Nullable Resources res) {
        this.mLayerState = this.createConstantState(state, res);
        if (this.mLayerState.mNumChildren > 0) {
            this.ensurePadding();
            this.refreshPadding();
        }
    }

    LayerState createConstantState(@Nullable LayerState state, @Nullable Resources res) {
        return new LayerState(state, this, res);
    }

    @Override
    public boolean canApplyTheme() {
        return this.mLayerState.canApplyTheme() || super.canApplyTheme();
    }

    int addLayer(@NonNull ChildDrawable layer) {
        LayerState st = this.mLayerState;
        int i = st.mNumChildren;
        int N = st.mChildren != null ? st.mChildren.length : 0;
        if (i >= N) {
            ChildDrawable[] nu = new ChildDrawable[N + 10];
            if (i > 0) {
                assert (st.mChildren != null);
                System.arraycopy(st.mChildren, 0, nu, 0, i);
            }
            st.mChildren = nu;
        }
        assert (st.mChildren != null);
        st.mChildren[i] = layer;
        ++st.mNumChildren;
        st.invalidateCache();
        return i;
    }

    ChildDrawable addLayer(Drawable dr, int[] themeAttrs, int id2, int left, int top, int right, int bottom) {
        ChildDrawable childDrawable = this.createLayer(dr);
        childDrawable.mId = id2;
        childDrawable.mThemeAttrs = themeAttrs;
        childDrawable.mDrawable.setAutoMirrored(this.isAutoMirrored());
        childDrawable.mInsetL = left;
        childDrawable.mInsetT = top;
        childDrawable.mInsetR = right;
        childDrawable.mInsetB = bottom;
        this.addLayer(childDrawable);
        this.mLayerState.mChildrenChangingConfigurations |= dr.getChangingConfigurations();
        dr.setCallback(this);
        return childDrawable;
    }

    private ChildDrawable createLayer(Drawable dr) {
        ChildDrawable layer = new ChildDrawable(this.mLayerState.mDensity);
        layer.mDrawable = dr;
        return layer;
    }

    public int addLayer(Drawable dr) {
        ChildDrawable layer = this.createLayer(dr);
        int index = this.addLayer(layer);
        this.ensurePadding();
        this.refreshChildPadding(index, layer);
        return index;
    }

    public Drawable findDrawableByLayerId(int id2) {
        ChildDrawable[] layers = this.mLayerState.mChildren;
        for (int i = this.mLayerState.mNumChildren - 1; i >= 0; --i) {
            if (layers[i].mId != id2) continue;
            return layers[i].mDrawable;
        }
        return null;
    }

    public void setId(int index, int id2) {
        this.mLayerState.mChildren[index].mId = id2;
    }

    public int getId(int index) {
        if (index >= this.mLayerState.mNumChildren) {
            throw new IndexOutOfBoundsException();
        }
        return this.mLayerState.mChildren[index].mId;
    }

    public int getNumberOfLayers() {
        return this.mLayerState.mNumChildren;
    }

    public boolean setDrawableByLayerId(int id2, Drawable drawable) {
        int index = this.findIndexByLayerId(id2);
        if (index < 0) {
            return false;
        }
        this.setDrawable(index, drawable);
        return true;
    }

    public int findIndexByLayerId(int id2) {
        ChildDrawable[] layers = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            ChildDrawable childDrawable = layers[i];
            if (childDrawable.mId != id2) continue;
            return i;
        }
        return -1;
    }

    public void setDrawable(int index, Drawable drawable) {
        if (index >= this.mLayerState.mNumChildren) {
            throw new IndexOutOfBoundsException();
        }
        ChildDrawable[] layers = this.mLayerState.mChildren;
        ChildDrawable childDrawable = layers[index];
        if (childDrawable.mDrawable != null) {
            if (drawable != null) {
                Rect bounds = childDrawable.mDrawable.getBounds();
                drawable.setBounds(bounds);
            }
            childDrawable.mDrawable.setCallback(null);
        }
        if (drawable != null) {
            drawable.setCallback(this);
        }
        childDrawable.mDrawable = drawable;
        this.mLayerState.invalidateCache();
        this.refreshChildPadding(index, childDrawable);
    }

    public Drawable getDrawable(int index) {
        if (index >= this.mLayerState.mNumChildren) {
            throw new IndexOutOfBoundsException();
        }
        return this.mLayerState.mChildren[index].mDrawable;
    }

    public void setLayerSize(int index, int w, int h2) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mWidth = w;
        childDrawable.mHeight = h2;
    }

    public void setLayerWidth(int index, int w) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mWidth = w;
    }

    public int getLayerWidth(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mWidth;
    }

    public void setLayerHeight(int index, int h2) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mHeight = h2;
    }

    public int getLayerHeight(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mHeight;
    }

    public void setLayerGravity(int index, int gravity) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mGravity = gravity;
    }

    public int getLayerGravity(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mGravity;
    }

    public void setLayerInset(int index, int l2, int t2, int r, int b) {
        this.setLayerInsetInternal(index, l2, t2, r, b, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public void setLayerInsetRelative(int index, int s, int t2, int e, int b) {
        this.setLayerInsetInternal(index, 0, t2, 0, b, s, e);
    }

    public void setLayerInsetLeft(int index, int l2) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetL = l2;
    }

    public int getLayerInsetLeft(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetL;
    }

    public void setLayerInsetRight(int index, int r) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetR = r;
    }

    public int getLayerInsetRight(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetR;
    }

    public void setLayerInsetTop(int index, int t2) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetT = t2;
    }

    public int getLayerInsetTop(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetT;
    }

    public void setLayerInsetBottom(int index, int b) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetB = b;
    }

    public int getLayerInsetBottom(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetB;
    }

    public void setLayerInsetStart(int index, int s) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetS = s;
    }

    public int getLayerInsetStart(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetS;
    }

    public void setLayerInsetEnd(int index, int e) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetE = e;
    }

    public int getLayerInsetEnd(int index) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        return childDrawable.mInsetE;
    }

    private void setLayerInsetInternal(int index, int l2, int t2, int r, int b, int s, int e) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetL = l2;
        childDrawable.mInsetT = t2;
        childDrawable.mInsetR = r;
        childDrawable.mInsetB = b;
        childDrawable.mInsetS = s;
        childDrawable.mInsetE = e;
    }

    public void setPaddingMode(int mode) {
        if (this.mLayerState.mPaddingMode != mode) {
            this.mLayerState.mPaddingMode = mode;
        }
    }

    public int getPaddingMode() {
        return this.mLayerState.mPaddingMode;
    }

    private void suspendChildInvalidation() {
        this.mSuspendChildInvalidation = true;
    }

    private void resumeChildInvalidation() {
        this.mSuspendChildInvalidation = false;
        if (this.mChildRequestedInvalidation) {
            this.mChildRequestedInvalidation = false;
            this.invalidateSelf();
        }
    }

    @Override
    public void invalidateDrawable(@NonNull Drawable who) {
        if (this.mSuspendChildInvalidation) {
            this.mChildRequestedInvalidation = true;
        } else {
            this.mLayerState.invalidateCache();
            this.invalidateSelf();
        }
    }

    @Override
    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    @Override
    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        this.unscheduleSelf(what);
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.draw(canvas);
        }
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mLayerState.getChangingConfigurations();
    }

    @Override
    public boolean getPadding(@NonNull Rect padding) {
        int paddingR;
        LayerState layerState = this.mLayerState;
        if (layerState.mPaddingMode == 0) {
            this.computeNestedPadding(padding);
        } else {
            this.computeStackedPadding(padding);
        }
        int paddingT = layerState.mPaddingTop;
        int paddingB = layerState.mPaddingBottom;
        boolean isLayoutRtl = this.getLayoutDirection() == 1;
        int paddingRtlL = isLayoutRtl ? layerState.mPaddingEnd : layerState.mPaddingStart;
        int paddingRtlR = isLayoutRtl ? layerState.mPaddingStart : layerState.mPaddingEnd;
        int paddingL = paddingRtlL >= 0 ? paddingRtlL : layerState.mPaddingLeft;
        int n2 = paddingR = paddingRtlR >= 0 ? paddingRtlR : layerState.mPaddingRight;
        if (paddingL >= 0) {
            padding.left = paddingL;
        }
        if (paddingT >= 0) {
            padding.top = paddingT;
        }
        if (paddingR >= 0) {
            padding.right = paddingR;
        }
        if (paddingB >= 0) {
            padding.bottom = paddingB;
        }
        return padding.left != 0 || padding.top != 0 || padding.right != 0 || padding.bottom != 0;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        LayerState layerState = this.mLayerState;
        layerState.mPaddingLeft = left;
        layerState.mPaddingTop = top;
        layerState.mPaddingRight = right;
        layerState.mPaddingBottom = bottom;
        layerState.mPaddingStart = -1;
        layerState.mPaddingEnd = -1;
    }

    public void setPaddingRelative(int start, int top, int end, int bottom) {
        LayerState layerState = this.mLayerState;
        layerState.mPaddingStart = start;
        layerState.mPaddingTop = top;
        layerState.mPaddingEnd = end;
        layerState.mPaddingBottom = bottom;
        layerState.mPaddingLeft = -1;
        layerState.mPaddingRight = -1;
    }

    public int getLeftPadding() {
        return this.mLayerState.mPaddingLeft;
    }

    public int getRightPadding() {
        return this.mLayerState.mPaddingRight;
    }

    public int getStartPadding() {
        return this.mLayerState.mPaddingStart;
    }

    public int getEndPadding() {
        return this.mLayerState.mPaddingEnd;
    }

    public int getTopPadding() {
        return this.mLayerState.mPaddingTop;
    }

    public int getBottomPadding() {
        return this.mLayerState.mPaddingBottom;
    }

    private void computeNestedPadding(Rect padding) {
        padding.left = 0;
        padding.top = 0;
        padding.right = 0;
        padding.bottom = 0;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array[i]);
            padding.left += this.mPaddingL[i];
            padding.top += this.mPaddingT[i];
            padding.right += this.mPaddingR[i];
            padding.bottom += this.mPaddingB[i];
        }
    }

    private void computeStackedPadding(Rect padding) {
        padding.left = 0;
        padding.top = 0;
        padding.right = 0;
        padding.bottom = 0;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array[i]);
            padding.left = Math.max(padding.left, this.mPaddingL[i]);
            padding.top = Math.max(padding.top, this.mPaddingT[i]);
            padding.right = Math.max(padding.right, this.mPaddingR[i]);
            padding.bottom = Math.max(padding.bottom, this.mPaddingB[i]);
        }
    }

    @Override
    public void setHotspot(float x, float y) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setHotspot(x, y);
        }
    }

    @Override
    public void setHotspotBounds(int left, int top, int right, int bottom) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setHotspotBounds(left, top, right, bottom);
        }
        if (this.mHotspotBounds == null) {
            this.mHotspotBounds = new Rect(left, top, right, bottom);
        } else {
            this.mHotspotBounds.set(left, top, right, bottom);
        }
    }

    @Override
    public void getHotspotBounds(@NonNull Rect outRect) {
        if (this.mHotspotBounds != null) {
            outRect.set(this.mHotspotBounds);
        } else {
            super.getHotspotBounds(outRect);
        }
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setVisible(visible, restart);
        }
        return changed;
    }

    @Override
    public void setAlpha(int alpha) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setAlpha(alpha);
        }
    }

    @Override
    public int getAlpha() {
        Drawable dr = this.getFirstNonNullDrawable();
        if (dr != null) {
            return dr.getAlpha();
        }
        return super.getAlpha();
    }

    @Override
    public void setTintList(ColorStateList tint) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setTintList(tint);
        }
    }

    @Override
    public void setTintBlendMode(@NonNull BlendMode blendMode) {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setTintBlendMode(blendMode);
        }
    }

    private Drawable getFirstNonNullDrawable() {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            return dr;
        }
        return null;
    }

    @Override
    public void setAutoMirrored(boolean mirrored) {
        this.mLayerState.mAutoMirrored = mirrored;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.setAutoMirrored(mirrored);
        }
    }

    @Override
    public boolean isAutoMirrored() {
        return this.mLayerState.mAutoMirrored;
    }

    @Override
    public void jumpToCurrentState() {
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.jumpToCurrentState();
        }
    }

    @Override
    public boolean isStateful() {
        return this.mLayerState.isStateful();
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return this.mLayerState.hasFocusStateSpecified();
    }

    @Override
    protected boolean onStateChange(@NonNull int[] state) {
        boolean changed = false;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null || !dr.isStateful() || !dr.setState(state)) continue;
            this.refreshChildPadding(i, array[i]);
            changed = true;
        }
        if (changed) {
            this.updateLayerBounds(this.getBounds());
        }
        return changed;
    }

    @Override
    protected boolean onLevelChange(int level) {
        boolean changed = false;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null || !dr.setLevel(level)) continue;
            this.refreshChildPadding(i, array[i]);
            changed = true;
        }
        if (changed) {
            this.updateLayerBounds(this.getBounds());
        }
        return changed;
    }

    @Override
    protected void onBoundsChange(@NonNull Rect bounds) {
        this.updateLayerBounds(bounds);
    }

    private void updateLayerBounds(Rect bounds) {
        try {
            this.suspendChildInvalidation();
            this.updateLayerBoundsInternal(bounds);
        }
        finally {
            this.resumeChildInvalidation();
        }
    }

    private void updateLayerBoundsInternal(Rect bounds) {
        int paddingL = 0;
        int paddingT = 0;
        int paddingR = 0;
        int paddingB = 0;
        Rect outRect = this.mTmpOutRect;
        int layoutDirection = this.getLayoutDirection();
        boolean isLayoutRtl = layoutDirection == 1;
        boolean isPaddingNested = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int count = this.mLayerState.mNumChildren;
        for (int i = 0; i < count; ++i) {
            ChildDrawable r = array[i];
            Drawable d2 = r.mDrawable;
            if (d2 == null) continue;
            int insetT = r.mInsetT;
            int insetB = r.mInsetB;
            int insetRtlL = isLayoutRtl ? r.mInsetE : r.mInsetS;
            int insetRtlR = isLayoutRtl ? r.mInsetS : r.mInsetE;
            int insetL = insetRtlL == Integer.MIN_VALUE ? r.mInsetL : insetRtlL;
            int insetR = insetRtlR == Integer.MIN_VALUE ? r.mInsetR : insetRtlR;
            Rect container = this.mTmpContainer;
            container.set(bounds.left + insetL + paddingL, bounds.top + insetT + paddingT, bounds.right - insetR - paddingR, bounds.bottom - insetB - paddingB);
            int intrinsicW = d2.getIntrinsicWidth();
            int intrinsicH = d2.getIntrinsicHeight();
            int layerW = r.mWidth;
            int layerH = r.mHeight;
            int gravity = LayerDrawable.resolveGravity(r.mGravity, layerW, layerH, intrinsicW, intrinsicH);
            int resolvedW = layerW < 0 ? intrinsicW : layerW;
            int resolvedH = layerH < 0 ? intrinsicH : layerH;
            Gravity.apply(gravity, resolvedW, resolvedH, container, outRect, layoutDirection);
            d2.setBounds(outRect);
            if (!isPaddingNested) continue;
            paddingL += this.mPaddingL[i];
            paddingR += this.mPaddingR[i];
            paddingT += this.mPaddingT[i];
            paddingB += this.mPaddingB[i];
        }
    }

    private static int resolveGravity(int gravity, int width, int height, int intrinsicWidth, int intrinsicHeight) {
        if (!Gravity.isHorizontal(gravity)) {
            gravity = width < 0 ? (gravity |= 7) : (gravity |= 0x800003);
        }
        if (!Gravity.isVertical(gravity)) {
            gravity = height < 0 ? (gravity |= 0x70) : (gravity |= 0x30);
        }
        if (width < 0 && intrinsicWidth < 0) {
            gravity |= 7;
        }
        if (height < 0 && intrinsicHeight < 0) {
            gravity |= 0x70;
        }
        return gravity;
    }

    @Override
    public int getIntrinsicWidth() {
        int width = -1;
        int padL = 0;
        int padR = 0;
        boolean nest = this.mLayerState.mPaddingMode == 0;
        boolean isLayoutRtl = this.getLayoutDirection() == 1;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            int w;
            ChildDrawable r = array[i];
            if (r.mDrawable == null) continue;
            int insetRtlL = isLayoutRtl ? r.mInsetE : r.mInsetS;
            int insetRtlR = isLayoutRtl ? r.mInsetS : r.mInsetE;
            int insetL = insetRtlL == Integer.MIN_VALUE ? r.mInsetL : insetRtlL;
            int insetR = insetRtlR == Integer.MIN_VALUE ? r.mInsetR : insetRtlR;
            int minWidth = r.mWidth < 0 ? r.mDrawable.getIntrinsicWidth() : r.mWidth;
            int n2 = w = minWidth < 0 ? -1 : minWidth + insetL + insetR + padL + padR;
            if (w > width) {
                width = w;
            }
            if (!nest) continue;
            padL += this.mPaddingL[i];
            padR += this.mPaddingR[i];
        }
        return width;
    }

    @Override
    public int getIntrinsicHeight() {
        int height = -1;
        int padT = 0;
        int padB = 0;
        boolean nest = this.mLayerState.mPaddingMode == 0;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            int h2;
            ChildDrawable r = array[i];
            if (r.mDrawable == null) continue;
            int minHeight = r.mHeight < 0 ? r.mDrawable.getIntrinsicHeight() : r.mHeight;
            int n2 = h2 = minHeight < 0 ? -1 : minHeight + r.mInsetT + r.mInsetB + padT + padB;
            if (h2 > height) {
                height = h2;
            }
            if (!nest) continue;
            padT += this.mPaddingT[i];
            padB += this.mPaddingB[i];
        }
        return height;
    }

    private boolean refreshChildPadding(int i, ChildDrawable r) {
        if (r.mDrawable != null) {
            Rect rect = this.mTmpRect;
            r.mDrawable.getPadding(rect);
            if (rect.left != this.mPaddingL[i] || rect.top != this.mPaddingT[i] || rect.right != this.mPaddingR[i] || rect.bottom != this.mPaddingB[i]) {
                this.mPaddingL[i] = rect.left;
                this.mPaddingT[i] = rect.top;
                this.mPaddingR[i] = rect.right;
                this.mPaddingB[i] = rect.bottom;
                return true;
            }
        }
        return false;
    }

    void ensurePadding() {
        int N = this.mLayerState.mNumChildren;
        if (this.mPaddingL != null && this.mPaddingL.length >= N) {
            return;
        }
        this.mPaddingL = new int[N];
        this.mPaddingT = new int[N];
        this.mPaddingR = new int[N];
        this.mPaddingB = new int[N];
    }

    void refreshPadding() {
        int N = this.mLayerState.mNumChildren;
        ChildDrawable[] array = this.mLayerState.mChildren;
        for (int i = 0; i < N; ++i) {
            this.refreshChildPadding(i, array[i]);
        }
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mLayerState.canConstantState()) {
            this.mLayerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mLayerState;
        }
        return null;
    }

    @Override
    @NonNull
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mLayerState = this.createConstantState(this.mLayerState, null);
            ChildDrawable[] array = this.mLayerState.mChildren;
            int N = this.mLayerState.mNumChildren;
            for (int i = 0; i < N; ++i) {
                Drawable dr = array[i].mDrawable;
                if (dr == null) continue;
                dr.mutate();
            }
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            dr.clearMutated();
        }
        this.mMutated = false;
    }

    @Override
    public boolean onLayoutDirectionChanged(int layoutDirection) {
        boolean changed = false;
        ChildDrawable[] array = this.mLayerState.mChildren;
        int N = this.mLayerState.mNumChildren;
        for (int i = 0; i < N; ++i) {
            Drawable dr = array[i].mDrawable;
            if (dr == null) continue;
            changed |= dr.setLayoutDirection(layoutDirection);
        }
        this.updateLayerBounds(this.getBounds());
        return changed;
    }

    static class LayerState
    extends Drawable.ConstantState {
        private int[] mThemeAttrs;
        int mNumChildren;
        ChildDrawable[] mChildren;
        int mDensity;
        int mPaddingTop = -1;
        int mPaddingBottom = -1;
        int mPaddingLeft = -1;
        int mPaddingRight = -1;
        int mPaddingStart = -1;
        int mPaddingEnd = -1;
        int mChangingConfigurations;
        int mChildrenChangingConfigurations;
        private boolean mCheckedOpacity;
        private int mOpacity;
        private boolean mCheckedStateful;
        private boolean mIsStateful;
        private boolean mAutoMirrored = false;
        private int mPaddingMode = 0;

        LayerState(@Nullable LayerState orig, @NonNull LayerDrawable owner, @Nullable Resources res) {
            this.mDensity = Drawable.resolveDensity(res, orig != null ? orig.mDensity : 0);
            if (orig != null) {
                int N;
                ChildDrawable[] origChildDrawable = orig.mChildren;
                this.mNumChildren = N = orig.mNumChildren;
                this.mChildren = new ChildDrawable[N];
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mChildrenChangingConfigurations = orig.mChildrenChangingConfigurations;
                for (int i = 0; i < N; ++i) {
                    ChildDrawable or = origChildDrawable[i];
                    this.mChildren[i] = new ChildDrawable(or, owner, res);
                }
                this.mCheckedOpacity = orig.mCheckedOpacity;
                this.mOpacity = orig.mOpacity;
                this.mCheckedStateful = orig.mCheckedStateful;
                this.mIsStateful = orig.mIsStateful;
                this.mAutoMirrored = orig.mAutoMirrored;
                this.mPaddingMode = orig.mPaddingMode;
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mPaddingTop = orig.mPaddingTop;
                this.mPaddingBottom = orig.mPaddingBottom;
                this.mPaddingLeft = orig.mPaddingLeft;
                this.mPaddingRight = orig.mPaddingRight;
                this.mPaddingStart = orig.mPaddingStart;
                this.mPaddingEnd = orig.mPaddingEnd;
                if (orig.mDensity != this.mDensity) {
                    this.applyDensityScaling(orig.mDensity, this.mDensity);
                }
            } else {
                this.mNumChildren = 0;
                this.mChildren = null;
            }
        }

        public final void setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                this.onDensityChanged(sourceDensity, targetDensity);
            }
        }

        protected void onDensityChanged(int sourceDensity, int targetDensity) {
            this.applyDensityScaling(sourceDensity, targetDensity);
        }

        private void applyDensityScaling(int sourceDensity, int targetDensity) {
            if (this.mPaddingLeft > 0) {
                this.mPaddingLeft = Drawable.scaleFromDensity(this.mPaddingLeft, sourceDensity, targetDensity, false);
            }
            if (this.mPaddingTop > 0) {
                this.mPaddingTop = Drawable.scaleFromDensity(this.mPaddingTop, sourceDensity, targetDensity, false);
            }
            if (this.mPaddingRight > 0) {
                this.mPaddingRight = Drawable.scaleFromDensity(this.mPaddingRight, sourceDensity, targetDensity, false);
            }
            if (this.mPaddingBottom > 0) {
                this.mPaddingBottom = Drawable.scaleFromDensity(this.mPaddingBottom, sourceDensity, targetDensity, false);
            }
            if (this.mPaddingStart > 0) {
                this.mPaddingStart = Drawable.scaleFromDensity(this.mPaddingStart, sourceDensity, targetDensity, false);
            }
            if (this.mPaddingEnd > 0) {
                this.mPaddingEnd = Drawable.scaleFromDensity(this.mPaddingEnd, sourceDensity, targetDensity, false);
            }
        }

        @Override
        public boolean canApplyTheme() {
            if (this.mThemeAttrs != null || super.canApplyTheme()) {
                return true;
            }
            ChildDrawable[] array = this.mChildren;
            int N = this.mNumChildren;
            for (int i = 0; i < N; ++i) {
                ChildDrawable layer = array[i];
                if (!layer.canApplyTheme()) continue;
                return true;
            }
            return false;
        }

        @Override
        @NonNull
        public Drawable newDrawable() {
            return new LayerDrawable(this, null);
        }

        @Override
        @NonNull
        public Drawable newDrawable(@Nullable Resources res) {
            return new LayerDrawable(this, res);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations | this.mChildrenChangingConfigurations;
        }

        public final boolean isStateful() {
            if (this.mCheckedStateful) {
                return this.mIsStateful;
            }
            int N = this.mNumChildren;
            ChildDrawable[] array = this.mChildren;
            boolean isStateful = false;
            for (int i = 0; i < N; ++i) {
                Drawable dr = array[i].mDrawable;
                if (dr == null || !dr.isStateful()) continue;
                isStateful = true;
                break;
            }
            this.mIsStateful = isStateful;
            this.mCheckedStateful = true;
            return isStateful;
        }

        public final boolean hasFocusStateSpecified() {
            int N = this.mNumChildren;
            ChildDrawable[] array = this.mChildren;
            for (int i = 0; i < N; ++i) {
                Drawable dr = array[i].mDrawable;
                if (dr == null || !dr.hasFocusStateSpecified()) continue;
                return true;
            }
            return false;
        }

        public final boolean canConstantState() {
            ChildDrawable[] array = this.mChildren;
            int N = this.mNumChildren;
            for (int i = 0; i < N; ++i) {
                Drawable dr = array[i].mDrawable;
                if (dr == null || dr.getConstantState() != null) continue;
                return false;
            }
            return true;
        }

        void invalidateCache() {
            this.mCheckedOpacity = false;
            this.mCheckedStateful = false;
        }
    }

    static class ChildDrawable {
        public Drawable mDrawable;
        public int[] mThemeAttrs;
        public int mDensity = 72;
        public int mInsetL;
        public int mInsetT;
        public int mInsetR;
        public int mInsetB;
        public int mInsetS = Integer.MIN_VALUE;
        public int mInsetE = Integer.MIN_VALUE;
        public int mWidth = -1;
        public int mHeight = -1;
        public int mGravity = 0;
        public int mId = -1;

        ChildDrawable(int density) {
            this.mDensity = density;
        }

        ChildDrawable(@NonNull ChildDrawable orig, @NonNull LayerDrawable owner, @Nullable Resources res) {
            Drawable clone;
            Drawable dr = orig.mDrawable;
            if (dr != null) {
                Drawable.ConstantState cs = dr.getConstantState();
                if (cs == null) {
                    clone = dr;
                    if (dr.getCallback() != null) {
                        CloudPick.LOGGER.warn(MARKER, "Invalid drawable added to LayerDrawable! Drawable already belongs to another owner but does not expose a constant state.", (Throwable)new RuntimeException());
                    }
                } else {
                    clone = res != null ? cs.newDrawable(res) : cs.newDrawable();
                }
                clone.setLayoutDirection(dr.getLayoutDirection());
                clone.setBounds(dr.getBounds());
                clone.setLevel(dr.getLevel());
                clone.setCallback(owner);
            } else {
                clone = null;
            }
            this.mDrawable = clone;
            this.mThemeAttrs = orig.mThemeAttrs;
            this.mInsetL = orig.mInsetL;
            this.mInsetT = orig.mInsetT;
            this.mInsetR = orig.mInsetR;
            this.mInsetB = orig.mInsetB;
            this.mInsetS = orig.mInsetS;
            this.mInsetE = orig.mInsetE;
            this.mWidth = orig.mWidth;
            this.mHeight = orig.mHeight;
            this.mGravity = orig.mGravity;
            this.mId = orig.mId;
            this.mDensity = Drawable.resolveDensity(res, orig.mDensity);
            if (orig.mDensity != this.mDensity) {
                this.applyDensityScaling(orig.mDensity, this.mDensity);
            }
        }

        public boolean canApplyTheme() {
            return this.mThemeAttrs != null || this.mDrawable != null && this.mDrawable.canApplyTheme();
        }

        public final void setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                this.applyDensityScaling(sourceDensity, targetDensity);
            }
        }

        private void applyDensityScaling(int sourceDensity, int targetDensity) {
            this.mInsetL = Drawable.scaleFromDensity(this.mInsetL, sourceDensity, targetDensity, false);
            this.mInsetT = Drawable.scaleFromDensity(this.mInsetT, sourceDensity, targetDensity, false);
            this.mInsetR = Drawable.scaleFromDensity(this.mInsetR, sourceDensity, targetDensity, false);
            this.mInsetB = Drawable.scaleFromDensity(this.mInsetB, sourceDensity, targetDensity, false);
            if (this.mInsetS != Integer.MIN_VALUE) {
                this.mInsetS = Drawable.scaleFromDensity(this.mInsetS, sourceDensity, targetDensity, false);
            }
            if (this.mInsetE != Integer.MIN_VALUE) {
                this.mInsetE = Drawable.scaleFromDensity(this.mInsetE, sourceDensity, targetDensity, false);
            }
            if (this.mWidth > 0) {
                this.mWidth = Drawable.scaleFromDensity(this.mWidth, sourceDensity, targetDensity, true);
            }
            if (this.mHeight > 0) {
                this.mHeight = Drawable.scaleFromDensity(this.mHeight, sourceDensity, targetDensity, true);
            }
        }
    }
}

