/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.graphics.drawable.DrawableContainer;
import yslelf.cloudpick.graphics.resources.Resources;

public class LevelListDrawable
extends DrawableContainer {
    private LevelListState mLevelListState;
    private boolean mMutated;

    public LevelListDrawable() {
        this(null, null);
    }

    public void addLevel(int low, int high, Drawable drawable) {
        if (drawable != null) {
            this.mLevelListState.addLevel(low, high, drawable);
            this.onLevelChange(this.getLevel());
        }
    }

    @Override
    protected boolean onLevelChange(int level) {
        int idx = this.mLevelListState.indexOfLevel(level);
        if (this.selectDrawable(idx)) {
            return true;
        }
        return super.onLevelChange(level);
    }

    @Override
    @NonNull
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mLevelListState.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    LevelListState cloneConstantState() {
        return new LevelListState(this.mLevelListState, this, null);
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    @Override
    protected void setConstantState(@NonNull DrawableContainer.DrawableContainerState state) {
        super.setConstantState(state);
        if (state instanceof LevelListState) {
            this.mLevelListState = (LevelListState)state;
        }
    }

    private LevelListDrawable(@Nullable LevelListState state, @Nullable Resources res) {
        LevelListState as = new LevelListState(state, this, res);
        this.setConstantState(as);
        this.onLevelChange(this.getLevel());
    }

    private static final class LevelListState
    extends DrawableContainer.DrawableContainerState {
        private int[] mLows;
        private int[] mHighs;

        LevelListState(LevelListState orig, LevelListDrawable owner, Resources res) {
            super(orig, owner, res);
            if (orig != null) {
                this.mLows = orig.mLows;
                this.mHighs = orig.mHighs;
            } else {
                this.mLows = new int[this.getCapacity()];
                this.mHighs = new int[this.getCapacity()];
            }
        }

        private void mutate() {
            this.mLows = (int[])this.mLows.clone();
            this.mHighs = (int[])this.mHighs.clone();
        }

        public void addLevel(int low, int high, Drawable drawable) {
            int pos = this.addChild(drawable);
            this.mLows[pos] = low;
            this.mHighs[pos] = high;
        }

        public int indexOfLevel(int level) {
            int[] lows = this.mLows;
            int[] highs = this.mHighs;
            int N = this.getChildCount();
            for (int i = 0; i < N; ++i) {
                if (level < lows[i] || level > highs[i]) continue;
                return i;
            }
            return -1;
        }

        @Override
        @NonNull
        public Drawable newDrawable() {
            return new LevelListDrawable(this, null);
        }

        @Override
        @NonNull
        public Drawable newDrawable(Resources res) {
            return new LevelListDrawable(this, res);
        }

        @Override
        public void growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[] newInts = new int[newSize];
            System.arraycopy(this.mLows, 0, newInts, 0, oldSize);
            this.mLows = newInts;
            newInts = new int[newSize];
            System.arraycopy(this.mHighs, 0, newInts, 0, oldSize);
            this.mHighs = newInts;
        }
    }
}

