/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import yslelf.cloudpick.graphics.animation.ObjectAnimator;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.RippleComponent;
import yslelf.cloudpick.graphics.graphics.drawable.RippleDrawable;
import yslelf.cloudpick.graphics.util.FloatProperty;

class RippleBackground
extends RippleComponent {
    static final int OPACITY_DURATION = 80;
    private ObjectAnimator mAnimator;
    private float mOpacity = 0.0f;
    private boolean mFocused = false;
    private boolean mHovered = false;
    private static final FloatProperty<RippleBackground> OPACITY = new FloatProperty<RippleBackground>("opacity"){

        @Override
        public void setValue(RippleBackground object, float value) {
            object.mOpacity = value;
            object.invalidateSelf();
        }

        @Override
        public Float get(RippleBackground object) {
            return Float.valueOf(object.mOpacity);
        }
    };

    RippleBackground(RippleDrawable owner, Rect bounds) {
        super(owner, bounds);
    }

    public boolean isVisible() {
        return this.mOpacity > 0.0f;
    }

    public void draw(Canvas c, Paint p2) {
        int origAlpha = p2.getAlpha();
        int alpha = Math.min((int)((float)origAlpha * this.mOpacity + 0.5f), 255);
        if (alpha > 0) {
            p2.setAlpha(alpha);
            c.drawCircle(0.0f, 0.0f, this.mTargetRadius, p2);
            p2.setAlpha(origAlpha);
        }
    }

    public void setState(boolean focused, boolean hovered, boolean pressed) {
        if (!this.mFocused) {
            boolean bl = focused = focused && !pressed;
        }
        if (!this.mHovered) {
            boolean bl = hovered = hovered && !pressed;
        }
        if (this.mHovered != hovered || this.mFocused != focused) {
            this.mHovered = hovered;
            this.mFocused = focused;
            this.onStateChanged();
        }
    }

    private void onStateChanged() {
        float newOpacity;
        float f2 = newOpacity = this.mFocused || this.mHovered ? 1.0f : 0.0f;
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
        this.mAnimator = ObjectAnimator.ofFloat(this, OPACITY, newOpacity);
        this.mAnimator.setDuration(80L);
        this.mAnimator.setInterpolator(TimeInterpolator.LINEAR);
        this.mAnimator.start();
    }

    public void end() {
        if (this.mAnimator != null) {
            this.mAnimator.end();
            this.mAnimator = null;
        }
    }
}

