/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.RippleDrawable;
import yslelf.cloudpick.render.core.Point;

abstract class RippleComponent {
    protected final RippleDrawable mOwner;
    protected final Rect mBounds;
    private boolean mHasMaxRadius;
    protected float mTargetRadius;
    protected float mDensityScale;

    public RippleComponent(RippleDrawable owner, Rect bounds) {
        this.mOwner = owner;
        this.mBounds = bounds;
    }

    public void onBoundsChange() {
        if (!this.mHasMaxRadius) {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
            this.onTargetRadiusChanged(this.mTargetRadius);
        }
    }

    public final void setup(float maxRadius, int densityDpi) {
        if (maxRadius >= 0.0f) {
            this.mHasMaxRadius = true;
            this.mTargetRadius = maxRadius;
        } else {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
        }
        this.mDensityScale = (float)densityDpi * 0.013888889f;
        this.onTargetRadiusChanged(this.mTargetRadius);
    }

    private static float getTargetRadius(Rect bounds) {
        return Point.length(bounds.width(), bounds.height()) * 0.5f;
    }

    public void getBounds(Rect bounds) {
        int r = (int)Math.ceil(this.mTargetRadius);
        bounds.set(-r, -r, r, r);
    }

    protected final void invalidateSelf() {
        this.mOwner.invalidateSelf(false);
    }

    protected final void onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            this.mTargetRadius = RippleComponent.getTargetRadius(this.mBounds);
            this.onTargetRadiusChanged(this.mTargetRadius);
        }
    }

    protected void onTargetRadiusChanged(float targetRadius) {
    }
}

