/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import java.util.Arrays;
import java.util.Objects;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.BlendModeColorFilter;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.graphics.drawable.LayerDrawable;
import yslelf.cloudpick.graphics.graphics.drawable.RippleBackground;
import yslelf.cloudpick.graphics.graphics.drawable.RippleForeground;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.util.ColorStateList;

public class RippleDrawable
extends LayerDrawable {
    public static final int RADIUS_AUTO = -1;
    public static final int STYLE_SOLID = 0;
    private static final int MAX_RIPPLES = 10;
    private static final int DEFAULT_EFFECT_COLOR = -1912602625;
    private final Rect mTempRect = new Rect();
    private final Rect mHotspotBounds = new Rect();
    private final Rect mDrawingBounds = new Rect();
    private final Rect mDirtyBounds = new Rect();
    private RippleState mState;
    private Drawable mMask;
    private RippleBackground mBackground;
    private BlendModeColorFilter mMaskColorFilter;
    private BlendModeColorFilter mFocusColorFilter;
    private boolean mHasValidMask;
    private RippleForeground mRipple;
    private boolean mRippleActive;
    private float mPendingX;
    private float mPendingY;
    private boolean mHasPending;
    private RippleForeground[] mExitingRipples;
    private int mExitingRipplesCount = 0;
    private Paint mRipplePaint;
    private int mDensity;
    private boolean mOverrideBounds;

    public RippleDrawable(@NonNull ColorStateList color, @Nullable Drawable content, @Nullable Drawable mask) {
        this(new RippleState(null, null, null), null);
        if (content != null) {
            this.addLayer(content, null, 0, 0, 0, 0, 0);
        }
        if (mask != null) {
            this.addLayer(mask, null, 16908334, 0, 0, 0, 0);
        }
        this.setColor(color);
        this.ensurePadding();
        this.refreshPadding();
        this.updateLocalState();
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mRipple != null) {
            this.mRipple.end();
        }
        if (this.mBackground != null) {
            this.mBackground.end();
        }
        this.cancelExitingRipples();
    }

    private void cancelExitingRipples() {
        int count = this.mExitingRipplesCount;
        Object[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].end();
        }
        if (ripples != null) {
            Arrays.fill(ripples, 0, count, null);
        }
        this.mExitingRipplesCount = 0;
        this.invalidateSelf(false);
    }

    @Override
    protected boolean onStateChange(@NonNull int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        boolean enabled = false;
        boolean pressed = false;
        boolean focused = false;
        boolean hovered = false;
        boolean windowFocused = false;
        for (int state : stateSet) {
            if (state == 16842910) {
                enabled = true;
                continue;
            }
            if (state == 16844130) {
                focused = true;
                continue;
            }
            if (state == 16842919) {
                pressed = true;
                continue;
            }
            if (state == 16843623) {
                hovered = true;
                continue;
            }
            if (state != 16842909) continue;
            windowFocused = true;
        }
        this.setRippleActive(enabled && pressed);
        this.setBackgroundActive(hovered, focused, pressed, windowFocused);
        return changed;
    }

    private void setRippleActive(boolean active) {
        if (this.mRippleActive != active) {
            this.mRippleActive = active;
            if (this.mState.mRippleStyle == 0) {
                if (active) {
                    this.tryRippleEnter();
                } else {
                    this.tryRippleExit();
                }
            }
        }
    }

    public void setBackgroundActive(boolean hovered, boolean focused, boolean pressed, boolean windowFocused) {
        if (this.mState.mRippleStyle == 0) {
            if (this.mBackground == null && (hovered || focused)) {
                this.mBackground = new RippleBackground(this, this.mHotspotBounds);
                this.mBackground.setup(this.mState.mMaxRadius, this.mDensity);
            }
            if (this.mBackground != null) {
                this.mBackground.setState(focused, hovered, pressed);
            }
        }
    }

    @Override
    protected void onBoundsChange(@NonNull Rect bounds) {
        super.onBoundsChange(bounds);
        if (!this.mOverrideBounds) {
            this.mHotspotBounds.set(bounds);
            this.onHotspotBoundsChanged();
        }
        int count = this.mExitingRipplesCount;
        RippleForeground[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].onBoundsChange();
        }
        if (this.mBackground != null) {
            this.mBackground.onBoundsChange();
        }
        if (this.mRipple != null) {
            this.mRipple.onBoundsChange();
        }
        this.invalidateSelf();
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (!visible) {
            this.clearHotspots();
        } else if (changed) {
            if (this.mRippleActive) {
                if (this.mState.mRippleStyle == 0) {
                    this.tryRippleEnter();
                } else {
                    this.invalidateSelf();
                }
            }
            this.jumpToCurrentState();
        }
        return changed;
    }

    private boolean isBounded() {
        return this.getNumberOfLayers() > 0;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return true;
    }

    public void setColor(@NonNull ColorStateList color) {
        this.mState.mColor = Objects.requireNonNull(color, "color cannot be null");
        this.invalidateSelf(false);
    }

    public void setEffectColor(@NonNull ColorStateList color) {
        this.mState.mEffectColor = Objects.requireNonNull(color, "color cannot be null");
        this.invalidateSelf(false);
    }

    @NonNull
    public ColorStateList getEffectColor() {
        return this.mState.mEffectColor;
    }

    public void setRadius(int radius) {
        this.mState.mMaxRadius = radius;
        this.invalidateSelf(false);
    }

    public int getRadius() {
        return this.mState.mMaxRadius;
    }

    @Override
    public boolean setDrawableByLayerId(int id2, Drawable drawable) {
        if (super.setDrawableByLayerId(id2, drawable)) {
            if (id2 == 16908334) {
                this.mMask = drawable;
                this.mHasValidMask = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canApplyTheme() {
        return this.mState != null && this.mState.canApplyTheme() || super.canApplyTheme();
    }

    @Override
    public void setHotspot(float x, float y) {
        this.mPendingX = x;
        this.mPendingY = y;
        if (this.mRipple == null || this.mBackground == null) {
            this.mHasPending = true;
        }
        if (this.mRipple != null) {
            this.mRipple.move(x, y);
        }
    }

    private void tryRippleEnter() {
        if (this.mExitingRipplesCount >= 10) {
            return;
        }
        if (this.mRipple == null) {
            float y;
            float x;
            if (this.mHasPending) {
                this.mHasPending = false;
                x = this.mPendingX;
                y = this.mPendingY;
            } else {
                x = this.mHotspotBounds.exactCenterX();
                y = this.mHotspotBounds.exactCenterY();
            }
            this.mRipple = new RippleForeground(this, this.mHotspotBounds, x, y);
        }
        this.mRipple.setup(this.mState.mMaxRadius, this.mDensity);
        this.mRipple.enter();
    }

    private void tryRippleExit() {
        if (this.mRipple != null) {
            if (this.mExitingRipples == null) {
                this.mExitingRipples = new RippleForeground[10];
            }
            this.mExitingRipples[this.mExitingRipplesCount++] = this.mRipple;
            this.mRipple.exit();
            this.mRipple = null;
        }
    }

    private void clearHotspots() {
        if (this.mRipple != null) {
            this.mRipple.end();
            this.mRipple = null;
            this.mRippleActive = false;
        }
        if (this.mBackground != null) {
            this.mBackground.setState(false, false, false);
        }
        this.cancelExitingRipples();
    }

    @Override
    public void setHotspotBounds(int left, int top, int right, int bottom) {
        this.mOverrideBounds = true;
        this.mHotspotBounds.set(left, top, right, bottom);
        this.onHotspotBoundsChanged();
    }

    @Override
    public void getHotspotBounds(Rect outRect) {
        outRect.set(this.mHotspotBounds);
    }

    private void onHotspotBoundsChanged() {
        int count = this.mExitingRipplesCount;
        RippleForeground[] ripples = this.mExitingRipples;
        for (int i = 0; i < count; ++i) {
            ripples[i].onHotspotBoundsChanged();
        }
        if (this.mRipple != null) {
            this.mRipple.onHotspotBoundsChanged();
        }
        if (this.mBackground != null) {
            this.mBackground.onHotspotBoundsChanged();
        }
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        if (this.mState.mRippleStyle == 0) {
            this.drawSolid(canvas);
        }
    }

    private void drawSolid(Canvas canvas) {
        this.pruneRipples();
        Rect bounds = this.getDirtyBounds();
        int saveCount = canvas.save();
        if (this.isBounded()) {
            canvas.clipRect(bounds);
        }
        this.drawContent(canvas);
        this.drawBackgroundAndRipples(canvas);
        canvas.restoreToCount(saveCount);
    }

    private void pruneRipples() {
        int i;
        int remaining = 0;
        RippleForeground[] ripples = this.mExitingRipples;
        int count = this.mExitingRipplesCount;
        for (i = 0; i < count; ++i) {
            if (ripples[i].hasFinishedExit()) continue;
            ripples[remaining++] = ripples[i];
        }
        for (i = remaining; i < count; ++i) {
            ripples[i] = null;
        }
        this.mExitingRipplesCount = remaining;
    }

    private void drawContent(Canvas canvas) {
        LayerDrawable.ChildDrawable[] array = this.mLayerState.mChildren;
        int count = this.mLayerState.mNumChildren;
        for (int i = 0; i < count; ++i) {
            if (array[i].mId == 16908334) continue;
            array[i].mDrawable.draw(canvas);
        }
    }

    private void drawBackgroundAndRipples(Canvas canvas) {
        RippleForeground active = this.mRipple;
        RippleBackground background = this.mBackground;
        int count = this.mExitingRipplesCount;
        if (!(active != null || count > 0 || background != null && background.isVisible())) {
            return;
        }
        float x = this.mHotspotBounds.exactCenterX();
        float y = this.mHotspotBounds.exactCenterY();
        canvas.translate(x, y);
        Paint p2 = this.updateRipplePaint();
        if (background != null && background.isVisible()) {
            background.draw(canvas, p2);
        }
        if (count > 0) {
            RippleForeground[] ripples = this.mExitingRipples;
            for (int i = 0; i < count; ++i) {
                ripples[i].draw(canvas, p2);
            }
        }
        if (active != null) {
            active.draw(canvas, p2);
        }
        canvas.translate(-x, -y);
    }

    Paint updateRipplePaint() {
        if (this.mRipplePaint == null) {
            this.mRipplePaint = new Paint();
            this.mRipplePaint.setAntiAlias(true);
            this.mRipplePaint.setStyle(Paint.Style.FILL);
        }
        float x = this.mHotspotBounds.exactCenterX();
        float y = this.mHotspotBounds.exactCenterY();
        int color = this.mState.mColor.getColorForState(this.getState(), -16777216);
        Paint p2 = this.mRipplePaint;
        p2.setColor(color);
        p2.setColorFilter(null);
        p2.setShader(null);
        return p2;
    }

    public Rect getDirtyBounds() {
        if (!this.isBounded()) {
            Rect drawingBounds = this.mDrawingBounds;
            Rect dirtyBounds = this.mDirtyBounds;
            dirtyBounds.set(drawingBounds);
            drawingBounds.setEmpty();
            int cX = (int)this.mHotspotBounds.exactCenterX();
            int cY = (int)this.mHotspotBounds.exactCenterY();
            Rect rippleBounds = this.mTempRect;
            RippleForeground[] activeRipples = this.mExitingRipples;
            int N = this.mExitingRipplesCount;
            for (int i = 0; i < N; ++i) {
                activeRipples[i].getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            RippleBackground background = this.mBackground;
            if (background != null) {
                background.getBounds(rippleBounds);
                rippleBounds.offset(cX, cY);
                drawingBounds.union(rippleBounds);
            }
            dirtyBounds.union(drawingBounds);
            dirtyBounds.union(this.getBounds());
            return dirtyBounds;
        }
        return this.getBounds();
    }

    @Override
    public void invalidateSelf() {
        this.invalidateSelf(true);
    }

    void invalidateSelf(boolean invalidateMask) {
        super.invalidateSelf();
        if (invalidateMask) {
            this.mHasValidMask = false;
        }
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return this.mState;
    }

    @Override
    public Drawable mutate() {
        super.mutate();
        this.mState = (RippleState)this.mLayerState;
        this.mMask = this.findDrawableByLayerId(16908334);
        return this;
    }

    @Override
    RippleState createConstantState(LayerDrawable.LayerState state, Resources res) {
        return new RippleState(state, this, res);
    }

    private RippleDrawable(RippleState state, Resources res) {
        this.mState = new RippleState((LayerDrawable.LayerState)state, this, res);
        this.mLayerState = this.mState;
        this.mDensity = Drawable.resolveDensity(res, this.mState.mDensity);
        if (this.mState.mNumChildren > 0) {
            this.ensurePadding();
            this.refreshPadding();
        }
        this.updateLocalState();
    }

    private void updateLocalState() {
        this.mMask = this.findDrawableByLayerId(16908334);
    }

    static class RippleState
    extends LayerDrawable.LayerState {
        int[] mTouchThemeAttrs;
        ColorStateList mColor = ColorStateList.valueOf(-65281);
        ColorStateList mEffectColor = ColorStateList.valueOf(-1912602625);
        int mMaxRadius = -1;
        int mRippleStyle = 0;

        public RippleState(LayerDrawable.LayerState orig, RippleDrawable owner, Resources res) {
            super(orig, owner, res);
            if (orig instanceof RippleState) {
                RippleState origs = (RippleState)orig;
                this.mTouchThemeAttrs = origs.mTouchThemeAttrs;
                this.mColor = origs.mColor;
                this.mMaxRadius = origs.mMaxRadius;
                this.mRippleStyle = origs.mRippleStyle;
                this.mEffectColor = origs.mEffectColor;
                if (origs.mDensity != this.mDensity) {
                    this.applyDensityScaling(orig.mDensity, this.mDensity);
                }
            }
        }

        @Override
        protected void onDensityChanged(int sourceDensity, int targetDensity) {
            super.onDensityChanged(sourceDensity, targetDensity);
            this.applyDensityScaling(sourceDensity, targetDensity);
        }

        private void applyDensityScaling(int sourceDensity, int targetDensity) {
            if (this.mMaxRadius != -1) {
                this.mMaxRadius = Drawable.scaleFromDensity(this.mMaxRadius, sourceDensity, targetDensity, true);
            }
        }

        @Override
        public boolean canApplyTheme() {
            return this.mTouchThemeAttrs != null || super.canApplyTheme();
        }

        @Override
        public Drawable newDrawable() {
            return new RippleDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new RippleDrawable(this, res);
        }

        @Override
        public int getChangingConfigurations() {
            return super.getChangingConfigurations();
        }
    }
}

