/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import java.util.ArrayList;
import yslelf.cloudpick.graphics.animation.AnimationUtils;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.AnimatorListener;
import yslelf.cloudpick.graphics.animation.ObjectAnimator;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.RippleComponent;
import yslelf.cloudpick.graphics.graphics.drawable.RippleDrawable;
import yslelf.cloudpick.graphics.util.FloatProperty;

class RippleForeground
extends RippleComponent {
    private static final int RIPPLE_ENTER_DURATION = 225;
    private static final int RIPPLE_ORIGIN_DURATION = 225;
    private static final int OPACITY_ENTER_DURATION = 75;
    private static final int OPACITY_EXIT_DURATION = 150;
    private static final int OPACITY_HOLD_DURATION = 225;
    private float mStartingX;
    private float mStartingY;
    private float mClampedStartingX;
    private float mClampedStartingY;
    private float mTargetX = 0.0f;
    private float mTargetY = 0.0f;
    private float mOpacity = 0.0f;
    private float mTweenRadius = 0.0f;
    private float mTweenX = 0.0f;
    private float mTweenY = 0.0f;
    private boolean mHasFinishedExit;
    private long mEnterStartedAtMillis;
    private final ArrayList<Animator> mRunningVtAnimators = new ArrayList();
    private final float mStartRadius;
    private final AnimatorListener mAnimationListener = new AnimatorListener(){

        @Override
        public void onAnimationEnd(@NonNull Animator animator) {
            RippleForeground.this.mHasFinishedExit = true;
            RippleForeground.this.pruneVtFinished();
        }
    };
    private static final FloatProperty<RippleForeground> TWEEN_RADIUS = new FloatProperty<RippleForeground>("tweenRadius"){

        @Override
        public void setValue(RippleForeground object, float value) {
            object.mTweenRadius = value;
            object.onAnimationPropertyChanged();
        }

        @Override
        public Float get(RippleForeground object) {
            return Float.valueOf(object.mTweenRadius);
        }
    };
    private static final FloatProperty<RippleForeground> TWEEN_ORIGIN = new FloatProperty<RippleForeground>("tweenOrigin"){

        @Override
        public void setValue(RippleForeground object, float value) {
            object.mTweenX = value;
            object.mTweenY = value;
            object.onAnimationPropertyChanged();
        }

        @Override
        public Float get(RippleForeground object) {
            return Float.valueOf(object.mTweenX);
        }
    };
    private static final FloatProperty<RippleForeground> OPACITY = new FloatProperty<RippleForeground>("opacity"){

        @Override
        public void setValue(RippleForeground object, float value) {
            object.mOpacity = value;
            object.onAnimationPropertyChanged();
        }

        @Override
        public Float get(RippleForeground object) {
            return Float.valueOf(object.mOpacity);
        }
    };

    RippleForeground(RippleDrawable owner, Rect bounds, float startingX, float startingY) {
        super(owner, bounds);
        this.mStartingX = startingX;
        this.mStartingY = startingY;
        this.mStartRadius = (float)Math.max(bounds.width(), bounds.height()) * 0.2f;
        this.clampStartingPosition();
    }

    @Override
    protected void onTargetRadiusChanged(float targetRadius) {
        this.clampStartingPosition();
        this.invalidateSelf();
    }

    private void pruneVtFinished() {
        if (!this.mRunningVtAnimators.isEmpty()) {
            for (int i = this.mRunningVtAnimators.size() - 1; i >= 0; --i) {
                if (this.mRunningVtAnimators.get(i).isRunning()) continue;
                this.mRunningVtAnimators.remove(i);
            }
        }
    }

    @Override
    public void getBounds(Rect bounds) {
        int outerX = (int)this.mTargetX;
        int outerY = (int)this.mTargetY;
        int r = (int)this.mTargetRadius + 1;
        bounds.set(outerX - r, outerY - r, outerX + r, outerY + r);
    }

    public void move(float x, float y) {
        this.mStartingX = x;
        this.mStartingY = y;
        this.clampStartingPosition();
    }

    public boolean hasFinishedExit() {
        return this.mHasFinishedExit;
    }

    private long computeFadeOutDelay() {
        long timeSinceEnter = AnimationUtils.currentAnimationTimeMillis() - this.mEnterStartedAtMillis;
        if (timeSinceEnter > 0L && timeSinceEnter < 225L) {
            return 225L - timeSinceEnter;
        }
        return 0L;
    }

    public final void enter() {
        this.mEnterStartedAtMillis = AnimationUtils.currentAnimationTimeMillis();
        for (int i = 0; i < this.mRunningVtAnimators.size(); ++i) {
            this.mRunningVtAnimators.get(i).cancel();
        }
        this.mRunningVtAnimators.clear();
        ObjectAnimator tweenRadius = ObjectAnimator.ofFloat(this, TWEEN_RADIUS, 1.0f);
        tweenRadius.setDuration(225L);
        tweenRadius.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        tweenRadius.start();
        this.mRunningVtAnimators.add(tweenRadius);
        ObjectAnimator tweenOrigin = ObjectAnimator.ofFloat(this, TWEEN_ORIGIN, 1.0f);
        tweenOrigin.setDuration(225L);
        tweenOrigin.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        tweenOrigin.start();
        this.mRunningVtAnimators.add(tweenOrigin);
        ObjectAnimator opacity = ObjectAnimator.ofFloat(this, OPACITY, 1.0f);
        opacity.setDuration(75L);
        opacity.setInterpolator(TimeInterpolator.LINEAR);
        opacity.start();
        this.mRunningVtAnimators.add(opacity);
    }

    public final void exit() {
        ObjectAnimator opacity = ObjectAnimator.ofFloat(this, OPACITY, 0.0f);
        opacity.setDuration(150L);
        opacity.setInterpolator(TimeInterpolator.LINEAR);
        opacity.addListener(this.mAnimationListener);
        opacity.setStartDelay(this.computeFadeOutDelay());
        opacity.start();
        this.mRunningVtAnimators.add(opacity);
    }

    private float getCurrentX() {
        return MathUtil.lerp(this.mClampedStartingX - this.mBounds.exactCenterX(), this.mTargetX, this.mTweenX);
    }

    private float getCurrentY() {
        return MathUtil.lerp(this.mClampedStartingY - this.mBounds.exactCenterY(), this.mTargetY, this.mTweenY);
    }

    private float getCurrentRadius() {
        return MathUtil.lerp(this.mStartRadius, this.mTargetRadius, this.mTweenRadius);
    }

    public void draw(Canvas c, Paint p2) {
        this.pruneVtFinished();
        int origAlpha = p2.getAlpha();
        int alpha = (int)((float)origAlpha * this.mOpacity + 0.5f);
        float radius = this.getCurrentRadius();
        if (alpha > 0 && radius > 0.0f) {
            float x = this.getCurrentX();
            float y = this.getCurrentY();
            p2.setAlpha(alpha);
            c.drawCircle(x, y, radius, p2);
            p2.setAlpha(origAlpha);
        }
    }

    private void clampStartingPosition() {
        float r;
        float cY;
        float dY;
        float cX = this.mBounds.exactCenterX();
        float dX = this.mStartingX - cX;
        if (dX * dX + (dY = this.mStartingY - (cY = this.mBounds.exactCenterY())) * dY > (r = this.mTargetRadius - this.mStartRadius) * r) {
            double angle = Math.atan2(dY, dX);
            this.mClampedStartingX = cX + (float)(Math.cos(angle) * (double)r);
            this.mClampedStartingY = cY + (float)(Math.sin(angle) * (double)r);
        } else {
            this.mClampedStartingX = this.mStartingX;
            this.mClampedStartingY = this.mStartingY;
        }
    }

    public void end() {
        for (int i = 0; i < this.mRunningVtAnimators.size(); ++i) {
            this.mRunningVtAnimators.get(i).end();
        }
        this.mRunningVtAnimators.clear();
    }

    private void onAnimationPropertyChanged() {
        this.invalidateSelf();
    }
}

