/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import java.io.InputStream;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.Bitmap;
import yslelf.cloudpick.graphics.graphics.BitmapFactory;
import yslelf.cloudpick.graphics.graphics.BlendMode;
import yslelf.cloudpick.graphics.graphics.BlendModeColorFilter;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.ColorFilter;
import yslelf.cloudpick.graphics.graphics.Image;
import yslelf.cloudpick.graphics.graphics.ImageShader;
import yslelf.cloudpick.graphics.graphics.Matrix;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.Shader;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.util.ColorStateList;
import yslelf.cloudpick.graphics.view.Gravity;

public class RoundedImageDrawable
extends Drawable {
    private final Paint mPaint = new Paint();
    private Image mImage;
    private ColorStateList mTint = null;
    private BlendMode mBlendMode = DEFAULT_BLEND_MODE;
    private int mGravity = 119;
    private int mTargetDensity = 72;
    private float mCornerRadius;
    private Rect mSrcRect;
    private final Rect mDstRect = new Rect();
    private BlendModeColorFilter mBlendModeFilter;
    private boolean mFullImage = true;
    private boolean mDstRectDirty = true;
    private boolean mIsCircular;

    public RoundedImageDrawable(Resources res, Image image) {
        this.mImage = image;
        this.mTargetDensity = RoundedImageDrawable.resolveDensity(res, this.mTargetDensity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoundedImageDrawable(Resources res, @NonNull InputStream stream) {
        Image image = null;
        try (Bitmap bitmap = BitmapFactory.decodeStream(stream);){
            image = Image.createTextureFromBitmap(bitmap);
        }
        catch (Exception e) {
            CloudPick.LOGGER.warn(MarkerManager.getMarker((String)"RoundedImageDrawable"), "Cannot create RoundedImageDrawable from {}", (Object)stream, (Object)e);
        }
        finally {
            this.mImage = image;
            this.mTargetDensity = RoundedImageDrawable.resolveDensity(res, this.mTargetDensity);
        }
    }

    @NonNull
    public final Paint getPaint() {
        return this.mPaint;
    }

    @Nullable
    public final Image getImage() {
        return this.mImage;
    }

    public void setImage(@Nullable Image image) {
        if (this.mImage != image) {
            this.mImage = image;
            if (this.mIsCircular) {
                this.updateCircularSubset();
            } else {
                if (this.mSrcRect != null && image != null) {
                    this.mSrcRect.set(0, 0, image.getWidth(), image.getWidth());
                }
                this.mFullImage = true;
            }
            this.mDstRectDirty = true;
            this.invalidateSelf();
        }
    }

    public void setTargetDensity(int density) {
        if (density == 0) {
            density = 72;
        }
        if (this.mTargetDensity != density) {
            this.mTargetDensity = density;
            this.mDstRectDirty = true;
            this.invalidateSelf();
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
            this.mDstRectDirty = true;
            this.invalidateSelf();
        }
    }

    public void setSubset(@Nullable Rect subset) {
        Image image = this.mImage;
        if (image == null) {
            return;
        }
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (subset == null || subset.contains(0, 0, imageWidth, imageHeight)) {
            if (!this.mFullImage) {
                this.mDstRectDirty = true;
                this.invalidateSelf();
            }
            this.mFullImage = true;
        } else {
            if (this.mSrcRect == null) {
                this.mSrcRect = new Rect(0, 0, imageWidth, imageHeight);
                if (!this.mSrcRect.intersect(subset)) {
                    this.mSrcRect.setEmpty();
                }
                this.mDstRectDirty = true;
                this.invalidateSelf();
            } else if (!this.mSrcRect.equals(subset)) {
                this.mSrcRect.set(0, 0, imageWidth, imageHeight);
                if (!this.mSrcRect.intersect(subset)) {
                    this.mSrcRect.setEmpty();
                }
                this.mDstRectDirty = true;
                this.invalidateSelf();
            }
            this.mFullImage = false;
        }
    }

    @ApiStatus.Experimental
    public void setMipmap(boolean mipmap) {
    }

    @ApiStatus.Experimental
    public boolean hasMipmap() {
        return true;
    }

    public void setAntiAlias(boolean aa) {
        this.mPaint.setAntiAlias(aa);
        this.invalidateSelf();
    }

    public boolean isAntiAlias() {
        return this.mPaint.isAntiAlias();
    }

    public void setDither(boolean dither) {
        this.mPaint.setDither(dither);
        this.invalidateSelf();
    }

    public boolean isDither() {
        return this.mPaint.isDither();
    }

    public void setFilter(boolean filter) {
        if (this.mPaint.isFilter() != filter) {
            this.mPaint.setFilter(filter);
            this.mDstRectDirty = true;
            this.invalidateSelf();
        }
    }

    public boolean isFilter() {
        return this.mPaint.isFilter();
    }

    @Override
    protected void onBoundsChange(@NonNull Rect bounds) {
        this.mDstRectDirty = true;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        boolean clearColorFilter;
        boolean useShader;
        boolean rebuildShader;
        Image image = this.mImage;
        if (image == null) {
            return;
        }
        Paint paint = this.mPaint;
        if (this.updateDstRect()) {
            if (!(this.mCornerRadius > 0.01f)) {
                paint.setShader(null);
                rebuildShader = false;
                useShader = false;
            } else {
                rebuildShader = true;
                useShader = true;
            }
        } else {
            rebuildShader = false;
            useShader = paint.hasShader();
        }
        if (this.mBlendModeFilter != null && paint.getColorFilter() == null) {
            paint.setColorFilter(this.mBlendModeFilter);
            clearColorFilter = true;
        } else {
            clearColorFilter = false;
        }
        if (!useShader) {
            canvas.drawImage(image, this.mFullImage ? null : this.mSrcRect, this.mDstRect, paint);
        } else {
            if (rebuildShader) {
                paint.setShader(new ImageShader(image, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP, paint.getFilterMode(), this.updateShaderMatrix(image)));
            }
            canvas.drawRoundRect(this.mDstRect.left, (float)this.mDstRect.top, (float)this.mDstRect.right, (float)this.mDstRect.bottom, this.mCornerRadius, paint);
        }
        if (clearColorFilter) {
            paint.setColorFilter(null);
        }
    }

    @NonNull
    private Matrix updateShaderMatrix(@NonNull Image image) {
        Matrix matrix = new Matrix();
        float srcLeft = this.mFullImage ? 0.0f : (float)this.mSrcRect.left;
        float srcTop = this.mFullImage ? 0.0f : (float)this.mSrcRect.top;
        float srcWidth = this.mFullImage ? (float)image.getWidth() : (float)this.mSrcRect.width();
        float srcHeight = this.mFullImage ? (float)image.getHeight() : (float)this.mSrcRect.height();
        float sx = (float)this.mDstRect.width() / srcWidth;
        float sy = (float)this.mDstRect.height() / srcHeight;
        float tx = (float)this.mDstRect.left - srcLeft * sx;
        float ty = (float)this.mDstRect.top - srcTop * sy;
        matrix.setScaleTranslate(sx, sy, tx, ty);
        return matrix;
    }

    private boolean updateDstRect() {
        if (this.mDstRectDirty) {
            if (this.mIsCircular) {
                int minDimen = Math.min(this.getIntrinsicWidth(), this.getIntrinsicHeight());
                int layoutDirection = this.getLayoutDirection();
                Gravity.apply(this.mGravity, minDimen, minDimen, this.getBounds(), this.mDstRect, layoutDirection);
                int minDrawDimen = Math.min(this.mDstRect.width(), this.mDstRect.height());
                int insetX = Math.max(0, (this.mDstRect.width() - minDrawDimen) / 2);
                int insetY = Math.max(0, (this.mDstRect.height() - minDrawDimen) / 2);
                this.mDstRect.inset(insetX, insetY);
                this.mCornerRadius = 0.5f * (float)minDrawDimen;
            } else {
                int layoutDirection = this.getLayoutDirection();
                Gravity.apply(this.mGravity, this.getIntrinsicWidth(), this.getIntrinsicHeight(), this.getBounds(), this.mDstRect, layoutDirection);
            }
            this.mDstRectDirty = false;
            return true;
        }
        return false;
    }

    @Override
    public void setAlpha(int alpha) {
        int oldAlpha = this.mPaint.getAlpha();
        if (alpha != oldAlpha) {
            this.mPaint.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    @Override
    public int getAlpha() {
        return this.mPaint.getAlpha();
    }

    @Override
    public void setTintList(@Nullable ColorStateList tint) {
        if (this.mTint != tint) {
            this.mTint = tint;
            this.mBlendModeFilter = this.updateBlendModeFilter(this.mBlendModeFilter, tint, this.mBlendMode);
            this.invalidateSelf();
        }
    }

    @Override
    public void setTintBlendMode(@NonNull BlendMode blendMode) {
        if (this.mBlendMode != blendMode) {
            this.mBlendMode = blendMode;
            this.mBlendModeFilter = this.updateBlendModeFilter(this.mBlendModeFilter, this.mTint, blendMode);
            this.invalidateSelf();
        }
    }

    @Override
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    @Override
    @Nullable
    public ColorFilter getColorFilter() {
        return this.mPaint.getColorFilter();
    }

    @Override
    protected boolean onStateChange(@NonNull int[] stateSet) {
        if (this.mTint != null && this.mBlendMode != null) {
            this.mBlendModeFilter = this.updateBlendModeFilter(this.mBlendModeFilter, this.mTint, this.mBlendMode);
            return true;
        }
        return false;
    }

    @Override
    public boolean isStateful() {
        return this.mTint != null && this.mTint.isStateful() || super.isStateful();
    }

    @Override
    public boolean hasFocusStateSpecified() {
        return this.mTint != null && this.mTint.hasFocusStateSpecified();
    }

    private void updateCircularSubset() {
        Image image = this.mImage;
        if (image == null) {
            return;
        }
        if (this.mSrcRect == null) {
            this.mSrcRect = new Rect(0, 0, image.getWidth(), image.getHeight());
        }
        int minDrawDimen = Math.min(this.mSrcRect.width(), this.mSrcRect.height());
        int insetX = Math.max(0, (this.mSrcRect.width() - minDrawDimen) / 2);
        int insetY = Math.max(0, (this.mSrcRect.height() - minDrawDimen) / 2);
        this.mSrcRect.inset(insetX, insetY);
        this.mFullImage = false;
    }

    public void setCircular(boolean circular) {
        this.mIsCircular = circular;
        if (circular) {
            this.updateCircularSubset();
            this.mDstRectDirty = true;
            this.invalidateSelf();
        } else {
            this.setCornerRadius(0.0f);
        }
    }

    public boolean isCircular() {
        return this.mIsCircular;
    }

    public void setCornerRadius(float cornerRadius) {
        if (this.mCornerRadius == cornerRadius) {
            return;
        }
        this.mIsCircular = false;
        this.mDstRectDirty = true;
        this.mCornerRadius = cornerRadius;
        this.invalidateSelf();
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    @Override
    public int getIntrinsicWidth() {
        Image image = this.mImage;
        if (image == null) {
            return super.getIntrinsicWidth();
        }
        int width = this.mFullImage ? image.getWidth() : Math.min(this.mSrcRect.width(), image.getWidth());
        return Image.scaleFromDensity(width, image.getDensity(), this.mTargetDensity);
    }

    @Override
    public int getIntrinsicHeight() {
        Image image = this.mImage;
        if (image == null) {
            return super.getIntrinsicHeight();
        }
        int height = this.mFullImage ? image.getHeight() : Math.min(this.mSrcRect.height(), image.getHeight());
        return Image.scaleFromDensity(height, image.getDensity(), this.mTargetDensity);
    }
}

