/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.drawable;

import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.graphics.drawable.DrawableWrapper;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.view.Gravity;

public class ScaleDrawable
extends DrawableWrapper {
    private final Rect mTmpRect = new Rect();
    private ScaleState mState;

    ScaleDrawable() {
        this(new ScaleState(null, null), null);
    }

    public ScaleDrawable(Drawable drawable, int gravity, float scaleWidth, float scaleHeight) {
        this(new ScaleState(null, null), null);
        this.mState.mGravity = gravity;
        this.mState.mScaleWidth = scaleWidth;
        this.mState.mScaleHeight = scaleHeight;
        this.setDrawable(drawable);
    }

    public void setGravity(int gravity) {
        this.mState.mGravity = gravity;
        this.invalidateSelf();
    }

    public void setScaleWidth(float scaleWidth) {
        this.mState.mScaleWidth = scaleWidth;
        this.invalidateSelf();
    }

    public void setScaleHeight(float scaleHeight) {
        this.mState.mScaleHeight = scaleHeight;
        this.invalidateSelf();
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        Drawable d2 = this.getDrawable();
        if (d2 != null && d2.getLevel() != 0) {
            d2.draw(canvas);
        }
    }

    @Override
    protected boolean onLevelChange(int level) {
        super.onLevelChange(level);
        this.onBoundsChange(this.getBounds());
        this.invalidateSelf();
        return true;
    }

    @Override
    protected void onBoundsChange(@NonNull Rect bounds) {
        Drawable d2 = this.getDrawable();
        if (d2 == null) {
            return;
        }
        Rect r = this.mTmpRect;
        boolean min = this.mState.mUseIntrinsicSizeAsMin;
        int level = this.getLevel();
        int w = bounds.width();
        if (this.mState.mScaleWidth > 0.0f) {
            int iw = min ? d2.getIntrinsicWidth() : 0;
            w -= (int)((float)((w - iw) * (10000 - level)) * this.mState.mScaleWidth / 10000.0f);
        }
        int h2 = bounds.height();
        if (this.mState.mScaleHeight > 0.0f) {
            int ih = min ? d2.getIntrinsicHeight() : 0;
            h2 -= (int)((float)((h2 - ih) * (10000 - level)) * this.mState.mScaleHeight / 10000.0f);
        }
        int layoutDirection = this.getLayoutDirection();
        Gravity.apply(this.mState.mGravity, w, h2, bounds, r, layoutDirection);
        if (w > 0 && h2 > 0) {
            d2.setBounds(r.left, r.top, r.right, r.bottom);
        }
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        this.mState = new ScaleState(this.mState, null);
        return this.mState;
    }

    private ScaleDrawable(ScaleState state, Resources res) {
        super(state, res);
        this.mState = state;
        this.updateLocalState();
    }

    private void updateLocalState() {
        this.setLevel(this.mState.mInitialLevel);
    }

    static final class ScaleState
    extends DrawableWrapper.DrawableWrapperState {
        private static final float DO_NOT_SCALE = -1.0f;
        float mScaleWidth = -1.0f;
        float mScaleHeight = -1.0f;
        int mGravity = 3;
        boolean mUseIntrinsicSizeAsMin = false;
        int mInitialLevel = 0;

        ScaleState(ScaleState orig, Resources res) {
            super(orig, res);
            if (orig != null) {
                this.mScaleWidth = orig.mScaleWidth;
                this.mScaleHeight = orig.mScaleHeight;
                this.mGravity = orig.mGravity;
                this.mUseIntrinsicSizeAsMin = orig.mUseIntrinsicSizeAsMin;
                this.mInitialLevel = orig.mInitialLevel;
            }
        }

        @Override
        @NonNull
        public Drawable newDrawable(Resources res) {
            return new ScaleDrawable(this, res);
        }
    }
}

