/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.text;

import com.ibm.icu.text.BreakIterator;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.text.CharacterIterator;
import java.util.List;
import java.util.Locale;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.text.CharArrayIterator;
import yslelf.cloudpick.graphics.graphics.text.CharSequenceBuilder;
import yslelf.cloudpick.graphics.graphics.text.Font;
import yslelf.cloudpick.graphics.graphics.text.FontMetricsInt;
import yslelf.cloudpick.graphics.graphics.text.FontPaint;
import yslelf.cloudpick.render.core.Typeface;

public final class EmojiFont
implements Font {
    private final String mName;
    private final IntSet mCoverage;
    private final float mBaseSize;
    private final float mBaseAscent;
    private final float mBaseDescent;
    private final float mBaseSpacing;
    private final Object2IntMap<CharSequence> mMap;
    private final List<String> mFiles;
    private final CharSequenceBuilder mLookupKey = new CharSequenceBuilder();

    public EmojiFont(String name, IntSet coverage, int size, int ascent, int spacing, int base, Object2IntMap<CharSequence> map, List<String> files) {
        this.mName = name;
        this.mCoverage = coverage;
        this.mBaseSize = (float)size / (float)base;
        this.mBaseAscent = (float)ascent / (float)base;
        this.mBaseDescent = (float)(size - ascent) / (float)base;
        this.mBaseSpacing = (float)spacing / (float)base;
        this.mMap = map;
        this.mFiles = files;
    }

    public String getFileName(int glyphId) {
        return this.mFiles.get(glyphId - 1);
    }

    @Override
    public int getStyle() {
        return 0;
    }

    @Override
    public String getFullName(@NonNull Locale locale) {
        return this.mName;
    }

    @Override
    public String getFamilyName(@NonNull Locale locale) {
        return this.mName;
    }

    @Override
    public int getMetrics(@NonNull FontPaint paint, @Nullable FontMetricsInt fm) {
        float size = paint.getFontSize();
        int ascent = (int)(0.95 + (double)(this.mBaseAscent * size));
        int descent = (int)(0.95 + (double)(this.mBaseDescent * size));
        if (fm != null) {
            fm.extendBy(-ascent, descent);
        }
        return ascent + descent;
    }

    @Override
    public boolean hasGlyph(int ch, int vs) {
        return this.mCoverage.contains(ch);
    }

    @Override
    public int calcGlyphScore(char[] buf, int start, int limit) {
        int currPos;
        BreakIterator breaker = BreakIterator.getCharacterInstance((Locale)Locale.ROOT);
        CharArrayIterator iterator = new CharArrayIterator(buf, start, limit);
        breaker.setText((CharacterIterator)iterator);
        int prevPos = start;
        while ((currPos = breaker.following(prevPos)) != -1) {
            int glyphId = this.find(buf, prevPos, currPos);
            if (glyphId == 0) {
                return prevPos;
            }
            prevPos = currPos;
        }
        return prevPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int find(char[] buf, int start, int limit) {
        char vs;
        int glyphId;
        CharSequenceBuilder charSequenceBuilder = this.mLookupKey;
        synchronized (charSequenceBuilder) {
            glyphId = this.mMap.getInt((Object)this.mLookupKey.updateChars(buf, start, limit));
        }
        if (glyphId == 0 && (vs = buf[limit - 1]) == '\ufe0f') {
            CharSequenceBuilder charSequenceBuilder2 = this.mLookupKey;
            synchronized (charSequenceBuilder2) {
                glyphId = this.mMap.getInt((Object)this.mLookupKey.updateChars(buf, start, limit - 1));
            }
        }
        return glyphId;
    }

    @Override
    public float doSimpleLayout(char[] buf, int start, int limit, FontPaint paint, IntArrayList glyphs, FloatArrayList positions, float x, float y) {
        return 0.0f;
    }

    @Override
    public float doComplexLayout(char[] buf, int contextStart, int contextLimit, int layoutStart, int layoutLimit, boolean isRtl, FontPaint paint, IntArrayList glyphs, FloatArrayList positions, float[] advances, int advanceOffset, Rect bounds, float x, float y) {
        int currPos;
        BreakIterator breaker = BreakIterator.getCharacterInstance((Locale)Locale.ROOT);
        CharArrayIterator iterator = new CharArrayIterator(buf, layoutStart, layoutLimit);
        breaker.setText((CharacterIterator)iterator);
        boolean hint = !paint.isLinearMetrics();
        float sz = paint.getFontSize();
        float add = this.mBaseSpacing * sz;
        if (hint) {
            add = Math.max(1, (int)(0.95 + (double)add));
        }
        sz = this.mBaseSize * sz;
        if (hint) {
            sz = (int)(0.95 + (double)sz);
        }
        float adv = sz + add * 2.0f;
        if (hint) {
            x = (int)x;
            y = (int)y;
        }
        int prevPos = isRtl ? layoutLimit : layoutStart;
        float currAdvance = 0.0f;
        while ((currPos = isRtl ? breaker.preceding(prevPos) : breaker.following(prevPos)) != -1) {
            int pieceLimit;
            int pieceStart = Math.min(prevPos, currPos);
            int glyphId = this.find(buf, pieceStart, pieceLimit = Math.max(prevPos, currPos));
            if (glyphId != 0) {
                if (advances != null) {
                    advances[pieceStart - advanceOffset] = adv;
                }
                if (glyphs != null) {
                    glyphs.add(glyphId);
                }
                if (positions != null) {
                    positions.add(x + currAdvance + add);
                    positions.add(y);
                }
                currAdvance += adv;
            }
            prevPos = currPos;
        }
        if (bounds != null) {
            float s = paint.getFontSize();
            bounds.union((int)x, (int)((double)(y - this.mBaseAscent * s) - 0.05), (int)((double)(x + currAdvance) + 0.95), (int)((double)(y + this.mBaseDescent * s) + 0.95));
        }
        return currAdvance;
    }

    @Override
    public Typeface getNativeTypeface() {
        return null;
    }
}

