/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.text;

import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.text.Emoji;
import yslelf.cloudpick.graphics.graphics.text.Font;
import yslelf.cloudpick.graphics.graphics.text.FontFamily;

@ApiStatus.Internal
public class FontCollection {
    public static final int GC_M_MASK = UCharacterProperty.getMask((int)8) | UCharacterProperty.getMask((int)7) | UCharacterProperty.getMask((int)6);
    public static final int REPLACEMENT_CHARACTER = 65533;
    @NonNull
    private final List<FontFamily> mFamilies;
    private final BitSet mExclusiveEastAsianBits;
    public static final int UNSUPPORTED_FONT_SCORE = 0;

    public static boolean doesNotNeedFontSupport(int c) {
        return c == 173 || c == 847 || c == 1564 || 8204 <= c && c <= 8207 || 8234 <= c && c <= 8238 || 8294 <= c && c <= 8297 || c == 65279 || FontCollection.isVariationSelector(c);
    }

    public static boolean isStickyWhitelisted(int c) {
        return switch (c) {
            case 33, 44, 45, 46, 58, 59, 63, 160, 8208, 8209, 8239, 9792, 9794, 9877 -> true;
            default -> false;
        };
    }

    public static boolean isCombining(int c) {
        return (UCharacterProperty.getMask((int)UCharacter.getType((int)c)) & GC_M_MASK) != 0;
    }

    public static boolean isVariationSelector(int c) {
        return UCharacter.hasBinaryProperty((int)c, (int)36);
    }

    public static boolean isEmojiBreak(int prevCh, int ch) {
        return !Emoji.isEmojiModifier(ch) && (!Emoji.isRegionalIndicatorSymbol(prevCh) || !Emoji.isRegionalIndicatorSymbol(ch)) && ch != 8419 && !Emoji.isTagSpecChar(ch) && ch != 8205 && prevCh != 8205;
    }

    public FontCollection(FontFamily ... families) {
        this(families, (BitSet)null);
    }

    @ApiStatus.Internal
    public FontCollection(@NonNull FontFamily[] families, @Nullable BitSet exclusiveEastAsianBits) {
        if (families.length == 0) {
            throw new IllegalArgumentException("families cannot be empty");
        }
        this.mFamilies = List.of(families);
        this.mExclusiveEastAsianBits = exclusiveEastAsianBits;
    }

    @NonNull
    public List<Run> itemize(@NonNull char[] text, int offset, int limit) {
        return this.itemize(text, offset, limit, limit - offset);
    }

    @NonNull
    public List<Run> itemize(@NonNull char[] text, int offset, int limit, int runLimit) {
        int nextCh;
        char _c2;
        if (offset < 0 || offset > limit || limit > text.length || runLimit < 0) {
            throw new IllegalArgumentException();
        }
        if (offset == limit) {
            return Collections.emptyList();
        }
        ArrayList<Run> result = new ArrayList<Run>();
        Run lastRun = null;
        List<FontFamily> lastFamilies = null;
        int prevCh = 0;
        int next = offset;
        int index = offset;
        int _c1 = text[index];
        if (Character.isHighSurrogate((char)_c1) && index + 1 < limit) {
            _c2 = text[index + 1];
            if (Character.isLowSurrogate(_c2)) {
                nextCh = Character.toCodePoint((char)_c1, _c2);
                ++index;
            } else {
                nextCh = 65533;
            }
        } else {
            nextCh = Character.isSurrogate((char)_c1) ? 65533 : _c1;
        }
        ++index;
        boolean running = true;
        do {
            int ch = nextCh;
            int pos = next;
            next = index;
            if (index < limit) {
                _c1 = text[index];
                if (Character.isHighSurrogate((char)_c1) && index + 1 < limit) {
                    _c2 = text[index + 1];
                    if (Character.isLowSurrogate(_c2)) {
                        nextCh = Character.toCodePoint((char)_c1, _c2);
                        ++index;
                    } else {
                        nextCh = 65533;
                    }
                } else {
                    nextCh = Character.isSurrogate((char)_c1) ? 65533 : _c1;
                }
                ++index;
            } else {
                running = false;
            }
            boolean shouldContinueRun = false;
            if (FontCollection.doesNotNeedFontSupport(ch)) {
                shouldContinueRun = true;
            } else if (lastFamilies != null && !lastFamilies.isEmpty() && (FontCollection.isStickyWhitelisted(ch) || FontCollection.isCombining(ch))) {
                if (((FontFamily)lastFamilies.get(0)).isColorEmojiFamily()) {
                    for (FontFamily family : lastFamilies) {
                        shouldContinueRun |= family.hasGlyph(ch);
                    }
                } else {
                    shouldContinueRun = ((FontFamily)lastFamilies.get(0)).hasGlyph(ch);
                }
            }
            if (!shouldContinueRun) {
                boolean breakRun;
                List<FontFamily> families = this.getFamilyForChar(ch, running && FontCollection.isVariationSelector(nextCh) ? nextCh : 0);
                if (pos == 0 || lastFamilies == null || lastFamilies.isEmpty()) {
                    breakRun = true;
                } else if (((FontFamily)lastFamilies.get(0)).isColorEmojiFamily()) {
                    ArrayList<FontFamily> intersection = new ArrayList<FontFamily>(families);
                    intersection.retainAll(lastFamilies);
                    if (intersection.isEmpty()) {
                        breakRun = true;
                    } else {
                        breakRun = FontCollection.isEmojiBreak(prevCh, ch);
                        if (!breakRun) {
                            families = intersection;
                            lastFamilies = intersection;
                            lastRun.families = intersection;
                        }
                    }
                } else {
                    boolean bl = breakRun = families.get(0) != lastFamilies.get(0);
                }
                if (breakRun) {
                    int start = pos;
                    if (pos != 0 && (FontCollection.isCombining(ch) || Emoji.isEmojiModifier(ch) && Emoji.isEmojiModifierBase(prevCh))) {
                        for (FontFamily family : families) {
                            if (!family.hasGlyph(prevCh)) continue;
                            int prevLength = Character.charCount(prevCh);
                            if (lastRun != null) {
                                lastRun.limit -= prevLength;
                                if (lastRun.start == lastRun.limit) {
                                    result.remove(lastRun);
                                }
                            }
                            start -= prevLength;
                            break;
                        }
                    }
                    if (lastFamilies == null || lastFamilies.isEmpty()) {
                        start = offset;
                    }
                    Run run = new Run(families, start, 0);
                    result.add(run);
                    lastRun = run;
                    lastFamilies = families;
                }
            }
            prevCh = ch;
            if (lastRun == null) continue;
            lastRun.limit = next;
        } while ((result.size() < 2 || runLimit != result.size() - 2) && running);
        if (lastFamilies == null || lastFamilies.isEmpty()) {
            result.add(new Run(List.of(this.mFamilies.get(0)), offset, limit));
        }
        return result;
    }

    @NonNull
    public @Unmodifiable List<FontFamily> getFamilies() {
        return this.mFamilies;
    }

    private int calcCoverageScore(int ch, int vs, @NonNull FontFamily family, boolean isExclusiveEastAsianFamily) {
        boolean colorEmojiRequest;
        int script;
        if (isExclusiveEastAsianFamily && (script = UScript.getScript((int)ch)) > 1) {
            switch (script) {
                case 5: 
                case 17: 
                case 18: 
                case 20: 
                case 22: 
                case 41: 
                case 92: 
                case 131: 
                case 150: 
                case 154: 
                case 191: {
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        if (!family.hasGlyph(ch, vs)) {
            return 0;
        }
        switch (vs) {
            case 65039: {
                colorEmojiRequest = true;
                break;
            }
            case 65038: {
                colorEmojiRequest = false;
                break;
            }
            default: {
                return 1;
            }
        }
        return colorEmojiRequest == family.isColorEmojiFamily() ? 2 : 1;
    }

    @NonNull
    private List<FontFamily> getFamilyForChar(int ch, int vs) {
        ArrayList<FontFamily> families = null;
        int bestScore = 0;
        int e = this.mFamilies.size();
        for (int i = 0; i < e; ++i) {
            FontFamily family = this.mFamilies.get(i);
            int score = this.calcCoverageScore(ch, vs, family, this.mExclusiveEastAsianBits != null && this.mExclusiveEastAsianBits.get(i));
            if (score == 0 || score < bestScore) continue;
            if (families == null) {
                families = new ArrayList<FontFamily>(2);
            }
            if (score > bestScore) {
                families.clear();
                bestScore = score;
            }
            if (families.size() >= 2) continue;
            families.add(family);
        }
        if (families != null && !((FontFamily)families.get(0)).isColorEmojiFamily()) {
            return families;
        }
        for (FontFamily family : FontFamily.getSystemFontMap().values()) {
            int score = this.calcCoverageScore(ch, vs, family, false);
            if (score == 0 || score < bestScore) continue;
            if (families == null) {
                families = new ArrayList(8);
            }
            if (score > bestScore) {
                families.clear();
                bestScore = score;
            }
            if (families.size() >= 8) continue;
            families.add(family);
        }
        if (families != null) {
            return families;
        }
        return List.of(this.mFamilies.get(0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontCollection that = (FontCollection)o;
        return this.mFamilies.equals(that.mFamilies);
    }

    public int hashCode() {
        return this.mFamilies.hashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder("FontCollection");
        s.append('{').append("mFamilies").append('=').append('[');
        int e = this.mFamilies.size();
        for (int i = 0; i < e; ++i) {
            if (i > 0) {
                s.append(',').append(' ');
            }
            s.append(this.mFamilies.get(i).getFamilyName());
        }
        return s.append(']').append(',').append(' ').append("mExclusiveEastAsianBits").append('=').append(this.mExclusiveEastAsianBits).append('}').toString();
    }

    public static final class Run {
        List<FontFamily> families;
        int start;
        int limit;

        Run(List<FontFamily> families, int start, int limit) {
            this.families = families;
            this.start = start;
            this.limit = limit;
        }

        public Font getBestFont(char[] text, int style2) {
            int bestIndex = 0;
            int bestScore = 0;
            if (this.families.get(0).isColorEmojiFamily() && this.families.size() > 1) {
                for (int i = 0; i < this.families.size(); ++i) {
                    Font font = this.families.get(i).getClosestMatch(0);
                    int score = font.calcGlyphScore(text, this.start, this.limit);
                    if (score <= bestScore) continue;
                    bestIndex = i;
                    bestScore = score;
                }
            }
            return this.families.get(bestIndex).getClosestMatch(style2);
        }

        public int start() {
            return this.start;
        }

        public int limit() {
            return this.limit;
        }
    }
}

