/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.text;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.graphics.text.Font;
import yslelf.cloudpick.graphics.graphics.text.FontCollection;
import yslelf.cloudpick.graphics.graphics.text.FontFamily;
import yslelf.cloudpick.graphics.graphics.text.FontMetricsInt;

public class FontPaint {
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int BOLD_ITALIC = 3;
    public static final int FONT_STYLE_MASK = 3;
    public static final float INV_FONT_SIZE_GRANULARITY = 3.0f;
    private static final int RENDER_FLAG_ANTI_ALIAS = 16;
    private static final int RENDER_FLAG_LINEAR_METRICS = 32;
    FontCollection mFont;
    Locale mLocale;
    int mFlags;
    private float mSize;

    @ApiStatus.Internal
    public FontPaint() {
    }

    @ApiStatus.Internal
    public FontPaint(@Nonnull FontPaint paint) {
        this.mFont = paint.mFont;
        this.mLocale = paint.mLocale;
        this.mFlags = paint.mFlags;
        this.mSize = paint.mSize;
    }

    public void set(@Nonnull FontPaint paint) {
        this.mFont = paint.mFont;
        this.mLocale = paint.mLocale;
        this.mFlags = paint.mFlags;
        this.mSize = paint.mSize;
    }

    public void setFont(@Nonnull FontCollection font) {
        this.mFont = font;
    }

    public FontCollection getFont() {
        return this.mFont;
    }

    public void setLocale(@Nonnull Locale locale) {
        this.mLocale = locale;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public void setFontStyle(int fontStyle) {
        this.mFlags = this.mFlags & 0xFFFFFFFC | fontStyle & 3;
    }

    public int getFontStyle() {
        return this.mFlags & 3;
    }

    public void setFontSize(float fontSize) {
        this.mSize = MathUtil.pin(FontPaint.getCanonicalFontSize(fontSize), 1.0f, 2184.0f);
    }

    public float getFontSize() {
        return this.mSize;
    }

    public void setAntiAlias(boolean aa) {
        this.mFlags = aa ? (this.mFlags |= 0x10) : (this.mFlags &= 0xFFFFFFEF);
    }

    public boolean isAntiAlias() {
        return (this.mFlags & 0x10) != 0;
    }

    public void setLinearMetrics(boolean linearMetrics) {
        this.mFlags = linearMetrics ? (this.mFlags |= 0x20) : (this.mFlags &= 0xFFFFFFDF);
    }

    public boolean isLinearMetrics() {
        return (this.mFlags & 0x20) != 0;
    }

    public boolean isMetricAffecting(@Nonnull FontPaint paint) {
        if (this.mSize != paint.mSize) {
            return true;
        }
        if (this.mFlags != paint.mFlags) {
            return true;
        }
        if (!this.mFont.equals(paint.mFont)) {
            return true;
        }
        return !this.mLocale.equals(paint.mLocale);
    }

    public int getFontMetricsInt(@Nullable FontMetricsInt fm) {
        int height = 0;
        for (FontFamily family : this.getFont().getFamilies()) {
            Font font = family.getClosestMatch(this.getFontStyle());
            height = Math.max(height, font.getMetrics(this, fm));
        }
        return height;
    }

    @ApiStatus.Internal
    public void getNativeFont(@NonNull yslelf.cloudpick.render.core.Font nativeFont) {
        nativeFont.setSize(this.getFontSize());
        nativeFont.setEdging(this.isAntiAlias() ? 1 : 0);
        nativeFont.setLinearMetrics(this.isLinearMetrics());
    }

    public static float getCanonicalFontSize(float fontSize) {
        assert (fontSize >= 0.0f);
        return (float)((int)(fontSize * 3.0f + 0.5f)) / 3.0f;
    }

    public int hashCode() {
        int h2 = this.mFont.hashCode();
        h2 = 31 * h2 + this.mLocale.hashCode();
        h2 = 31 * h2 + this.mFlags;
        h2 = 31 * h2 + Float.floatToIntBits(this.mSize);
        return h2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontPaint that = (FontPaint)o;
        if (this.mFlags != that.mFlags) {
            return false;
        }
        if (this.mSize != that.mSize) {
            return false;
        }
        if (!this.mFont.equals(that.mFont)) {
            return false;
        }
        return this.mLocale.equals(that.mLocale);
    }

    public String toString() {
        return "FontPaint{font=" + this.mFont + ", locale=" + this.mLocale + ", flags=0x" + Integer.toHexString(this.mFlags) + ", size=" + this.mSize + "}";
    }
}

