/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.text;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.graphics.text.FontCollection;
import yslelf.cloudpick.graphics.graphics.text.FontPaint;
import yslelf.cloudpick.graphics.graphics.text.LayoutPiece;
import yslelf.cloudpick.graphics.util.Pools;

@ThreadSafe
public final class LayoutCache {
    public static final int MAX_PIECE_LENGTH = 128;
    public static final int COMPUTE_CLUSTER_ADVANCES = 1;
    public static final int COMPUTE_GLYPHS_PIXEL_BOUNDS = 2;
    private static final int MAX_ENTRIES = 5000;
    private static final Pools.Pool<LookupKey> sLookupKeys = Pools.newSynchronizedPool(3);
    @GuardedBy(value="itself")
    private static final LinkedHashMap<Key, LayoutPiece> sCache = new LinkedHashMap<Key, LayoutPiece>(6666, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Key, LayoutPiece> eldest) {
            return this.size() > 5000;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static LayoutPiece getOrCreate(@NonNull char[] buf, int contextStart, int contextLimit, int start, int limit, boolean isRtl, @NonNull FontPaint paint, int computeFlags) {
        LayoutPiece piece;
        if (contextStart < 0 || contextStart >= contextLimit || buf.length == 0 || contextLimit > buf.length || start < contextStart || limit > contextLimit) {
            throw new IndexOutOfBoundsException();
        }
        if (limit - start > 128) {
            return new LayoutPiece(buf, contextStart, contextLimit, start, limit, isRtl, paint, null, computeFlags);
        }
        LookupKey key = sLookupKeys.acquire();
        if (key == null) {
            key = new LookupKey();
        }
        key.update(buf, contextStart, contextLimit, start, limit, paint, isRtl);
        LinkedHashMap<Key, LayoutPiece> linkedHashMap = sCache;
        synchronized (linkedHashMap) {
            piece = sCache.get(key);
        }
        if (piece == null) {
            Key k = key.copy();
            key.clear();
            sLookupKeys.release(key);
            piece = new LayoutPiece(buf, contextStart, contextLimit, start, limit, isRtl, paint, null, computeFlags);
            LinkedHashMap<Key, LayoutPiece> linkedHashMap2 = sCache;
            synchronized (linkedHashMap2) {
                sCache.put(k, piece);
            }
        } else {
            int currFlags = piece.mComputeFlags & computeFlags;
            if (currFlags != computeFlags) {
                Key k = key.copy();
                key.clear();
                sLookupKeys.release(key);
                piece = new LayoutPiece(buf, contextStart, contextLimit, start, limit, isRtl, paint, piece, currFlags ^ computeFlags);
                LinkedHashMap<Key, LayoutPiece> linkedHashMap3 = sCache;
                synchronized (linkedHashMap3) {
                    sCache.put(k, piece);
                }
            } else {
                key.clear();
                sLookupKeys.release(key);
            }
        }
        return piece;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSize() {
        int size;
        LinkedHashMap<Key, LayoutPiece> linkedHashMap = sCache;
        synchronized (linkedHashMap) {
            size = sCache.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMemoryUsage() {
        int size = 0;
        LinkedHashMap<Key, LayoutPiece> linkedHashMap = sCache;
        synchronized (linkedHashMap) {
            for (Map.Entry<Key, LayoutPiece> entry : sCache.entrySet()) {
                size += entry.getKey().getMemoryUsage();
                size += entry.getValue().getMemoryUsage();
                size += 56;
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        LinkedHashMap<Key, LayoutPiece> linkedHashMap = sCache;
        synchronized (linkedHashMap) {
            sCache.clear();
        }
    }

    private static class LookupKey
    extends Key {
        private int mContextStart;
        private int mContextLimit;

        public void update(@NonNull char[] text, int contextStart, int contextLimit, int start, int limit, @NonNull FontPaint paint, boolean dir) {
            this.mChars = text;
            this.mContextStart = contextStart;
            this.mContextLimit = contextLimit;
            this.mStart = start - contextStart;
            this.mLimit = limit - contextStart;
            this.mFont = paint.mFont;
            this.mFlags = paint.mFlags;
            this.mSize = paint.getFontSize();
            this.mLocale = paint.mLocale;
            this.mIsRtl = dir;
            int h2 = 1;
            for (int i = this.mContextStart; i < this.mContextLimit; ++i) {
                h2 = 31 * h2 + this.mChars[i];
            }
            h2 = 31 * h2 + this.mFont.hashCode();
            h2 = 31 * h2 + this.mFlags;
            h2 = 31 * h2 + Float.floatToIntBits(this.mSize);
            h2 = 31 * h2 + this.mStart;
            h2 = 31 * h2 + this.mLimit;
            h2 = 31 * h2 + this.mLocale.hashCode();
            this.mHash = h2 = 31 * h2 + (this.mIsRtl ? 1 : 0);
        }

        public void clear() {
            this.mChars = null;
            this.mFont = null;
            this.mLocale = null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o.getClass() != Key.class) {
                throw new IllegalStateException();
            }
            Key key = (Key)o;
            if (this.mStart != key.mStart) {
                return false;
            }
            if (this.mLimit != key.mLimit) {
                return false;
            }
            if (this.mFlags != key.mFlags) {
                return false;
            }
            if (this.mSize != key.mSize) {
                return false;
            }
            if (this.mIsRtl != key.mIsRtl) {
                return false;
            }
            if (!Arrays.equals(this.mChars, this.mContextStart, this.mContextLimit, key.mChars, 0, key.mChars.length)) {
                return false;
            }
            if (!this.mFont.equals(key.mFont)) {
                return false;
            }
            return this.mLocale.equals(key.mLocale);
        }

        @NonNull
        public Key copy() {
            return new Key(this);
        }
    }

    private static class Key {
        char[] mChars;
        int mStart;
        int mLimit;
        FontCollection mFont;
        int mFlags;
        float mSize;
        Locale mLocale;
        boolean mIsRtl;
        transient int mHash;

        private Key() {
        }

        private Key(@NonNull LookupKey key) {
            this.mChars = new char[key.mContextLimit - key.mContextStart];
            System.arraycopy(key.mChars, key.mContextStart, this.mChars, 0, this.mChars.length);
            this.mStart = key.mStart;
            this.mLimit = key.mLimit;
            this.mFont = key.mFont;
            this.mFlags = key.mFlags;
            this.mSize = key.mSize;
            this.mLocale = key.mLocale;
            this.mIsRtl = key.mIsRtl;
            this.mHash = key.mHash;
            assert (this.mHash == this.computeHash());
        }

        public int hashCode() {
            return this.mHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o.getClass() != Key.class) {
                throw new IllegalStateException();
            }
            Key key = (Key)o;
            if (this.mStart != key.mStart) {
                return false;
            }
            if (this.mLimit != key.mLimit) {
                return false;
            }
            if (this.mFlags != key.mFlags) {
                return false;
            }
            if (this.mSize != key.mSize) {
                return false;
            }
            if (this.mIsRtl != key.mIsRtl) {
                return false;
            }
            if (!Arrays.equals(this.mChars, key.mChars)) {
                return false;
            }
            if (!this.mFont.equals(key.mFont)) {
                return false;
            }
            return this.mLocale.equals(key.mLocale);
        }

        private int getMemoryUsage() {
            return 80 + MathUtil.align8(this.mChars.length << 1);
        }

        private int computeHash() {
            int h2 = 1;
            for (char c : this.mChars) {
                h2 = 31 * h2 + c;
            }
            h2 = 31 * h2 + this.mFont.hashCode();
            h2 = 31 * h2 + this.mFlags;
            h2 = 31 * h2 + Float.floatToIntBits(this.mSize);
            h2 = 31 * h2 + this.mStart;
            h2 = 31 * h2 + this.mLimit;
            h2 = 31 * h2 + this.mLocale.hashCode();
            h2 = 31 * h2 + (this.mIsRtl ? 1 : 0);
            return h2;
        }
    }
}

