/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.text;

public class LayoutUtils {
    public static boolean isStretchableSpace(char c) {
        return c == ' ';
    }

    public static boolean isWordBreakAfter(char c) {
        if (c == ' ' || '\u2000' <= c && c <= '\u200a' || c == '\u3000') {
            return true;
        }
        return '\u2066' <= c && c <= '\u2069' || '\u202a' <= c && c <= '\u202e' || c == '\u200e' || c == '\u200f';
    }

    public static boolean isWordBreakBefore(char c) {
        return LayoutUtils.isWordBreakAfter(c) || '\u3400' <= c && c <= '\u9fff';
    }

    public static int getPrevWordBreakForCache(char[] buf, int start, int end, int offset) {
        if (offset <= start) {
            return start;
        }
        if (offset > end) {
            offset = end;
        }
        if (LayoutUtils.isWordBreakBefore(buf[offset - 1])) {
            return offset - 1;
        }
        for (int i = offset - 1; i > start; --i) {
            if (!LayoutUtils.isWordBreakBefore(buf[i]) && !LayoutUtils.isWordBreakAfter(buf[i - 1])) continue;
            return i;
        }
        return start;
    }

    public static int getNextWordBreakForCache(char[] buf, int start, int end, int offset) {
        if (offset >= end) {
            return end;
        }
        if (offset < start) {
            offset = start;
        }
        if (LayoutUtils.isWordBreakAfter(buf[offset])) {
            return offset + 1;
        }
        for (int i = offset + 1; i < end; ++i) {
            if (!LayoutUtils.isWordBreakBefore(buf[i])) continue;
            return i;
        }
        return end;
    }
}

