/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.text;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;

public final class LineBreakConfig {
    public static final int LINE_BREAK_STYLE_NONE = 0;
    public static final int LINE_BREAK_STYLE_LOOSE = 1;
    public static final int LINE_BREAK_STYLE_NORMAL = 2;
    public static final int LINE_BREAK_STYLE_STRICT = 3;
    public static final int LINE_BREAK_WORD_STYLE_NONE = 0;
    public static final int LINE_BREAK_WORD_STYLE_PHRASE = 1;
    public static final int LINE_BREAK_WORD_STYLE_NORMAL = 2;
    public static final int LINE_BREAK_WORD_STYLE_BREAK_ALL = 3;
    public static final int LINE_BREAK_WORD_STYLE_KEEP_ALL = 4;
    @ApiStatus.Internal
    public static final LineBreakConfig NONE = new LineBreakConfig(0, 0);
    private final int mLineBreakStyle;
    private final int mLineBreakWordStyle;

    @ApiStatus.Internal
    @NonNull
    public static LineBreakConfig getLineBreakConfig(int lineBreakStyle, int lineBreakWordStyle) {
        if (lineBreakStyle == 0 && lineBreakWordStyle == 0) {
            return NONE;
        }
        return new LineBreakConfig(lineBreakStyle, lineBreakWordStyle);
    }

    private LineBreakConfig(int lineBreakStyle, int lineBreakWordStyle) {
        this.mLineBreakStyle = lineBreakStyle;
        this.mLineBreakWordStyle = lineBreakWordStyle;
    }

    public int getLineBreakStyle() {
        return this.mLineBreakStyle;
    }

    public int getLineBreakWordStyle() {
        return this.mLineBreakWordStyle;
    }

    public int hashCode() {
        int result = this.mLineBreakStyle;
        result = 31 * result + this.mLineBreakWordStyle;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineBreakConfig)) {
            return false;
        }
        LineBreakConfig that = (LineBreakConfig)o;
        return this.mLineBreakStyle == that.mLineBreakStyle && this.mLineBreakWordStyle == that.mLineBreakWordStyle;
    }

    public static final class Builder {
        private int mLineBreakStyle = 0;
        private int mLineBreakWordStyle = 0;

        @NonNull
        public Builder setLineBreakStyle(int lineBreakStyle) {
            this.mLineBreakStyle = lineBreakStyle;
            return this;
        }

        @NonNull
        public Builder setLineBreakWordStyle(int lineBreakWordStyle) {
            this.mLineBreakWordStyle = lineBreakWordStyle;
            return this;
        }

        @NonNull
        public LineBreakConfig build() {
            return new LineBreakConfig(this.mLineBreakStyle, this.mLineBreakWordStyle);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @ApiStatus.Internal
    public static @interface LineBreakWordStyle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @ApiStatus.Internal
    public static @interface LineBreakStyle {
    }
}

