/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.text;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.ULocale;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.text.CharArrayIterator;
import yslelf.cloudpick.graphics.graphics.text.FontMetricsInt;
import yslelf.cloudpick.graphics.graphics.text.MeasuredText;
import yslelf.cloudpick.graphics.text.TabStops;

public class LineBreaker {
    private static final int NOWHERE = -1;
    private static final BreakIterator sBreaker = BreakIterator.getLineInstance((Locale)Locale.ROOT);
    @Nonnull
    private final char[] mTextBuf;
    @Nonnull
    private final MeasuredText mMeasuredText;
    @Nonnull
    private final LineWidth mLineWidthLimits;
    @Nonnull
    private final TabStops mTabStops;
    private int mLineNum = 0;
    private float mLineWidth = 0.0f;
    private float mCharsAdvance = 0.0f;
    private float mLineWidthLimit;
    private int mPrevBoundaryOffset = -1;
    private float mLineWidthAtPrevBoundary = 0.0f;
    private float mCharsAdvanceAtPrevBoundary = 0.0f;
    private final List<BreakPoint> mBreakPoints = new ArrayList<BreakPoint>();

    public static boolean isLineEndSpace(char c) {
        return c == '\n' || c == ' ' || c == '\t' || c == '\u1680' || '\u2000' <= c && c <= '\u200a' && c != '\u2007' || c == '\u205f' || c == '\u3000';
    }

    public LineBreaker(@Nonnull char[] textBuf, @Nonnull MeasuredText measuredText, @Nonnull LineWidth lineWidthLimits, @Nonnull TabStops tabStops) {
        this.mTextBuf = textBuf;
        this.mMeasuredText = measuredText;
        this.mLineWidthLimits = lineWidthLimits;
        this.mTabStops = tabStops;
        this.mLineWidthLimit = lineWidthLimits.getAt(0);
    }

    @Nonnull
    public static Result computeLineBreaks(@Nullable MeasuredText measuredText, @Nonnull ParagraphConstraints constraints, @Nullable int[] indents, int lineNumber) {
        if (measuredText == null || measuredText.getTextBuf().length == 0) {
            return new Result();
        }
        DefaultLineWidth lineWidth = new DefaultLineWidth(constraints.mFirstWidth, constraints.mWidth, indents, lineNumber);
        TabStops tabStops = new TabStops(constraints.mVariableTabStops, constraints.mDefaultTabStop);
        LineBreaker breaker = new LineBreaker(measuredText.getTextBuf(), measuredText, lineWidth, tabStops);
        breaker.process();
        return breaker.getResult();
    }

    @NonNull
    public static ULocale getLocaleWithLineBreakOption(@NonNull Locale locale, int lbStyle, int lbWordStyle) {
        if (lbStyle == 0 && lbWordStyle == 0) {
            return ULocale.forLocale((Locale)locale);
        }
        ULocale.Builder builder = new ULocale.Builder().setLocale(ULocale.forLocale((Locale)locale));
        ULocale.Builder builder2 = builder.setUnicodeLocaleKeyword("lb", switch (lbStyle) {
            case 1 -> "loose";
            case 2 -> "normal";
            case 3 -> "strict";
            default -> null;
        });
        return builder2.setUnicodeLocaleKeyword("lw", switch (lbWordStyle) {
            case 1 -> "phrase";
            case 2 -> "normal";
            case 3 -> "breakall";
            case 4 -> "keepall";
            default -> null;
        }).build();
    }

    private void process() {
        BreakIterator breaker = sBreaker;
        CharArrayIterator iterator = new CharArrayIterator(this.mTextBuf);
        Locale locale = null;
        int lbStyle = 0;
        int lbWordStyle = 0;
        int nextLineBoundary = 0;
        for (MeasuredText.Run run : this.mMeasuredText.getRuns()) {
            Locale newLocale = run.getLocale();
            if (locale != newLocale || lbStyle != run.getLineBreakStyle() || lbWordStyle != run.getLineBreakWordStyle()) {
                locale = newLocale;
                lbStyle = run.getLineBreakStyle();
                lbWordStyle = run.getLineBreakWordStyle();
                breaker = BreakIterator.getLineInstance((ULocale)LineBreaker.getLocaleWithLineBreakOption(locale, lbStyle, lbWordStyle));
                breaker.setText((CharacterIterator)iterator);
                nextLineBoundary = breaker.following(run.mStart);
            }
            for (int i = run.mStart; i < run.mEnd; ++i) {
                this.updateLineWidth(this.mTextBuf[i], this.mMeasuredText.getAdvance(i));
                if (i + 1 != nextLineBoundary) continue;
                if (run.canBreak() || nextLineBoundary == run.mEnd) {
                    this.processLineBreak(i + 1);
                }
                if ((nextLineBoundary = breaker.next()) != -1) continue;
                nextLineBoundary = this.mTextBuf.length;
            }
        }
        if (this.getPrevLineBreakOffset() != this.mTextBuf.length && this.mPrevBoundaryOffset != -1) {
            this.breakLineAt(this.mPrevBoundaryOffset, this.mLineWidth, 0.0f, 0.0f);
        }
    }

    private void processLineBreak(int offset) {
        while (this.mLineWidth > this.mLineWidthLimit) {
            int start = this.getPrevLineBreakOffset();
            if (this.tryLineBreak() || !this.doLineBreakWithGraphemeBounds(start, offset)) continue;
            return;
        }
        if (this.mPrevBoundaryOffset != -1) {
            // empty if block
        }
        this.mPrevBoundaryOffset = offset;
        this.mLineWidthAtPrevBoundary = this.mLineWidth;
        this.mCharsAdvanceAtPrevBoundary = this.mCharsAdvance;
    }

    private boolean tryLineBreak() {
        if (this.mPrevBoundaryOffset == -1) {
            return false;
        }
        this.breakLineAt(this.mPrevBoundaryOffset, this.mLineWidthAtPrevBoundary, this.mLineWidth - this.mCharsAdvanceAtPrevBoundary, this.mCharsAdvance - this.mCharsAdvanceAtPrevBoundary);
        return true;
    }

    private boolean doLineBreakWithGraphemeBounds(int start, int end) {
        float width = this.mMeasuredText.getAdvance(start);
        for (int i = start + 1; i < end; ++i) {
            float w = this.mMeasuredText.getAdvance(i);
            if (w == 0.0f) continue;
            if (width + w > this.mLineWidthLimit) {
                this.breakLineAt(i, width, this.mLineWidth - width, this.mCharsAdvance - width);
                return false;
            }
            width += w;
        }
        this.breakLineAt(end, this.mLineWidth, 0.0f, 0.0f);
        return true;
    }

    private void breakLineAt(int offset, float lineWidth, float remainingNextLineWidth, float remainingNextCharsAdvance) {
        this.mBreakPoints.add(new BreakPoint(offset, lineWidth));
        this.mLineWidthLimit = this.mLineWidthLimits.getAt(++this.mLineNum);
        this.mLineWidth = remainingNextLineWidth;
        this.mCharsAdvance = remainingNextCharsAdvance;
        this.mPrevBoundaryOffset = -1;
        this.mLineWidthAtPrevBoundary = 0.0f;
        this.mCharsAdvanceAtPrevBoundary = 0.0f;
    }

    private void updateLineWidth(char c, float adv) {
        if (c == '\t') {
            this.mLineWidth = this.mCharsAdvance = this.mTabStops.nextTab(this.mCharsAdvance);
        } else {
            this.mCharsAdvance += adv;
            if (!LineBreaker.isLineEndSpace(c)) {
                this.mLineWidth = this.mCharsAdvance;
            }
        }
    }

    private int getPrevLineBreakOffset() {
        return this.mBreakPoints.isEmpty() ? 0 : this.mBreakPoints.get((int)(this.mBreakPoints.size() - 1)).mOffset;
    }

    @Nonnull
    private Result getResult() {
        int prevBreakOffset = 0;
        int size = this.mBreakPoints.size();
        int[] ascents = new int[size];
        int[] descents = new int[size];
        FontMetricsInt fm = new FontMetricsInt();
        for (int i = 0; i < size; ++i) {
            BreakPoint breakPoint = this.mBreakPoints.get(i);
            for (int j = prevBreakOffset; j < breakPoint.mOffset; ++j) {
                if (this.mTextBuf[j] != '\t') continue;
                breakPoint.mHasTabChar = true;
                break;
            }
            fm.reset();
            this.mMeasuredText.getExtent(prevBreakOffset, breakPoint.mOffset, fm);
            ascents[i] = fm.ascent;
            descents[i] = fm.descent;
            prevBreakOffset = breakPoint.mOffset;
        }
        return new Result(this.mBreakPoints.toArray(new BreakPoint[0]), ascents, descents);
    }

    public static interface LineWidth {
        default public float getAt(int line) {
            return 0.0f;
        }

        default public float getMin() {
            return 0.0f;
        }
    }

    public static class Result {
        private static final BreakPoint[] EMPTY_ARRAY = new BreakPoint[0];
        @Nonnull
        private final BreakPoint[] mBreakPoints;
        private final int[] mAscents;
        private final int[] mDescents;

        private Result() {
            this.mBreakPoints = EMPTY_ARRAY;
            this.mAscents = IntArrays.EMPTY_ARRAY;
            this.mDescents = IntArrays.EMPTY_ARRAY;
        }

        private Result(@Nonnull BreakPoint[] breakPoints, int[] ascents, int[] descents) {
            this.mBreakPoints = breakPoints;
            this.mAscents = ascents;
            this.mDescents = descents;
        }

        public int getLineCount() {
            return this.mBreakPoints.length;
        }

        public int getLineBreakOffset(int lineIndex) {
            return this.mBreakPoints[lineIndex].mOffset;
        }

        public float getLineWidth(int lineIndex) {
            return this.mBreakPoints[lineIndex].mLineWidth;
        }

        public float getLineAscent(int lineIndex) {
            return this.mAscents[lineIndex];
        }

        public float getLineDescent(int lineIndex) {
            return this.mDescents[lineIndex];
        }

        public boolean hasLineTab(int lineIndex) {
            return this.mBreakPoints[lineIndex].mHasTabChar;
        }
    }

    private static class DefaultLineWidth
    implements LineWidth {
        private final float mFirstWidth;
        private final float mRestWidth;
        @Nullable
        private final int[] mIndents;
        private final int mOffset;

        public DefaultLineWidth(float firstWidth, float restWidth, @Nullable int[] indents, int offset) {
            this.mFirstWidth = firstWidth;
            this.mRestWidth = restWidth;
            this.mIndents = indents;
            this.mOffset = offset;
        }

        @Override
        public float getAt(int line) {
            float width = line < 1 ? this.mFirstWidth : this.mRestWidth;
            return Math.max(0.0f, width - this.getIndent(this.mIndents, line));
        }

        @Override
        public float getMin() {
            float minWidth = Math.min(this.getAt(0), this.getAt(1));
            if (this.mIndents != null) {
                int end = this.mIndents.length - this.mOffset;
                for (int line = 1; line < end; ++line) {
                    minWidth = Math.min(minWidth, this.getAt(line));
                }
            }
            return minWidth;
        }

        private float getIndent(@Nullable int[] indents, int line) {
            if (indents == null || indents.length == 0) {
                return 0.0f;
            }
            int index = line + this.mOffset;
            if (index < indents.length) {
                return indents[index];
            }
            return indents[indents.length - 1];
        }
    }

    public static class ParagraphConstraints {
        private float mWidth = 0.0f;
        private float mFirstWidth = 0.0f;
        @Nullable
        private float[] mVariableTabStops = null;
        private float mDefaultTabStop = 0.0f;

        public void setWidth(float width) {
            this.mWidth = width;
        }

        public void setIndent(float firstWidth) {
            this.mFirstWidth = firstWidth;
        }

        public void setTabStops(@Nullable float[] tabStops, float defaultTabStop) {
            this.mVariableTabStops = tabStops;
            this.mDefaultTabStop = defaultTabStop;
        }

        public float getWidth() {
            return this.mWidth;
        }

        public float getFirstWidth() {
            return this.mFirstWidth;
        }

        @Nullable
        public float[] getTabStops() {
            return this.mVariableTabStops;
        }

        public float getDefaultTabStop() {
            return this.mDefaultTabStop;
        }
    }

    private static final class BreakPoint {
        private final int mOffset;
        private final float mLineWidth;
        private boolean mHasTabChar = false;

        public BreakPoint(int offset, float lineWidth) {
            this.mOffset = offset;
            this.mLineWidth = lineWidth;
        }
    }
}

