/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.text;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.text.Font;
import yslelf.cloudpick.graphics.graphics.text.FontMetricsInt;
import yslelf.cloudpick.graphics.graphics.text.FontPaint;
import yslelf.cloudpick.graphics.graphics.text.GraphemeBreak;
import yslelf.cloudpick.graphics.util.SparseArray;
import yslelf.cloudpick.render.core.Typeface;
import yslelf.cloudpick.render.core.j2d.Typeface_JDK;

public final class OutlineFont
implements Font {
    static final Graphics2D[] sGraphics = new Graphics2D[4];
    private static final String[] LOGICAL_FONT_NAMES;
    private final java.awt.Font mFont;
    private final Typeface_JDK mTypeface;
    private final SparseArray<java.awt.Font> mFonts = new SparseArray();
    private final boolean mIsLogicalFont;

    public OutlineFont(java.awt.Font font) {
        this.mFont = Objects.requireNonNull(font);
        this.mTypeface = new Typeface_JDK(this.mFont);
        this.mIsLogicalFont = Arrays.stream(LOGICAL_FONT_NAMES).anyMatch(s -> s.equalsIgnoreCase(font.getName()));
    }

    private static Graphics2D getGraphics(@NonNull FontPaint paint) {
        return sGraphics[(paint.isAntiAlias() ? 1 : 0) | (paint.isLinearMetrics() ? 2 : 0)];
    }

    public static FontRenderContext getFontRenderContext(@NonNull Paint paint) {
        return sGraphics[(paint.isTextAntiAlias() ? 1 : 0) | (paint.isLinearText() ? 2 : 0)].getFontRenderContext();
    }

    @Override
    public int getStyle() {
        return this.mFont.getStyle();
    }

    @Override
    public String getFullName(@NonNull Locale locale) {
        return this.mFont.getFontName(locale);
    }

    @Override
    public String getFamilyName(@NonNull Locale locale) {
        return this.mFont.getFamily(locale);
    }

    @NonNull
    private java.awt.Font chooseFont(float size) {
        if (size <= 1.0f) {
            return this.mFont;
        }
        if (size <= 96.0f) {
            int key = (int)(size * 3.0f + 0.5f);
            java.awt.Font value = this.mFonts.get(key);
            if (value != null) {
                return value;
            }
            value = this.mFont.deriveFont((float)key / 3.0f);
            this.mFonts.put(key, value);
            return value;
        }
        return this.mFont.deriveFont(size);
    }

    @NonNull
    public java.awt.Font chooseFont(int size) {
        return this.chooseFont((float)size);
    }

    @NonNull
    public java.awt.Font chooseFont(@NonNull Paint paint) {
        return this.chooseFont(FontPaint.getCanonicalFontSize(paint.getTextSize()));
    }

    @Override
    public int getMetrics(@NonNull FontPaint paint, @Nullable FontMetricsInt fm) {
        int leading;
        int descent;
        int ascent;
        if (paint.getFontStyle() != this.getStyle()) {
            throw new IllegalArgumentException();
        }
        java.awt.Font font = this.chooseFont(paint.getFontSize());
        Graphics2D g = OutlineFont.getGraphics(paint);
        try {
            FontMetrics metrics = g.getFontMetrics(font);
            ascent = metrics.getAscent();
            descent = metrics.getDescent();
            leading = metrics.getLeading();
        }
        catch (HeadlessException e) {
            LineMetrics metrics = font.getLineMetrics("M", g.getFontRenderContext());
            ascent = (int)(0.95f + metrics.getAscent());
            descent = (int)(0.95f + metrics.getDescent());
            leading = (int)(0.95f + metrics.getDescent() + metrics.getLeading()) - descent;
        }
        if (fm != null) {
            fm.extendBy(-ascent, descent, leading);
        }
        return ascent + descent + leading;
    }

    @Override
    public boolean hasGlyph(int ch, int vs) {
        return this.mFont.canDisplay(ch);
    }

    @Override
    public int calcGlyphScore(char[] buf, int start, int limit) {
        int offset = this.mFont.canDisplayUpTo(buf, start, limit);
        return (offset == -1 ? limit : offset) + (this.mIsLogicalFont ? -1 : 0);
    }

    @Override
    public float doSimpleLayout(char[] buf, int start, int limit, FontPaint paint, IntArrayList glyphs, FloatArrayList positions, float x, float y) {
        int style2 = paint.getFontStyle();
        if (style2 != this.getStyle()) {
            throw new IllegalArgumentException();
        }
        if (start != 0 || limit != buf.length) {
            buf = Arrays.copyOfRange(buf, start, limit);
        }
        FontRenderContext frc = OutlineFont.getGraphics(paint).getFontRenderContext();
        GlyphVector vector = this.chooseFont(paint.getFontSize()).createGlyphVector(frc, buf);
        int nGlyphs = vector.getNumGlyphs();
        if (glyphs != null || positions != null) {
            for (int i = 0; i < nGlyphs; ++i) {
                if (glyphs != null) {
                    glyphs.add(vector.getGlyphCode(i));
                }
                if (positions == null) continue;
                Point2D point = vector.getGlyphPosition(i);
                positions.add((float)point.getX() + x);
                positions.add((float)point.getY() + y);
            }
        }
        return (float)vector.getGlyphPosition(nGlyphs).getX();
    }

    @Override
    public float doComplexLayout(char[] buf, int contextStart, int contextLimit, int layoutStart, int layoutLimit, boolean isRtl, FontPaint paint, IntArrayList glyphs, FloatArrayList positions, float[] advances, int advanceOffset, Rect bounds, float x, float y) {
        int layoutFlags;
        int style2 = paint.getFontStyle();
        if (style2 != this.getStyle()) {
            throw new IllegalArgumentException();
        }
        int n2 = layoutFlags = isRtl ? 1 : 0;
        if (layoutStart == contextStart) {
            layoutFlags |= 2;
        }
        if (layoutLimit == contextLimit) {
            layoutFlags |= 4;
        }
        java.awt.Font face = this.chooseFont(paint.getFontSize());
        FontRenderContext frc = OutlineFont.getGraphics(paint).getFontRenderContext();
        GlyphVector vector = face.layoutGlyphVector(frc, buf, layoutStart, layoutLimit, layoutFlags);
        int nGlyphs = vector.getNumGlyphs();
        if (advances != null) {
            int baseFlags = isRtl ? 1 : 0;
            GraphemeBreak.forTextRun(buf, paint.mLocale, layoutStart, layoutLimit, (clusterStart, clusterLimit) -> {
                int flags = baseFlags;
                if (clusterStart == contextStart) {
                    flags |= 2;
                }
                if (clusterLimit == contextLimit) {
                    flags |= 4;
                }
                GlyphVector vec = face.layoutGlyphVector(frc, buf, clusterStart, clusterLimit, flags);
                advances[clusterStart - advanceOffset] = (float)vec.getGlyphPosition(vec.getNumGlyphs()).getX();
            });
        }
        if (glyphs != null || positions != null) {
            for (int i = 0; i < nGlyphs; ++i) {
                if (glyphs != null) {
                    glyphs.add(vector.getGlyphCode(i));
                }
                if (positions == null) continue;
                Point2D point = vector.getGlyphPosition(i);
                positions.add((float)point.getX() + x);
                positions.add((float)point.getY() + y);
            }
        }
        if (bounds != null) {
            Rectangle r = vector.getPixelBounds(null, x, y);
            bounds.union(r.x, r.y, r.x + r.width, r.y + r.height);
        }
        return (float)vector.getGlyphPosition(nGlyphs).getX();
    }

    @Override
    public Typeface getNativeTypeface() {
        return this.mTypeface;
    }

    static {
        BufferedImage image = new BufferedImage(1, 1, 2);
        for (int mask = 0; mask < 4; ++mask) {
            Graphics2D graphics = image.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, (mask & 1) != 0 ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, (mask & 2) != 0 ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            OutlineFont.sGraphics[mask] = graphics;
        }
        LOGICAL_FONT_NAMES = new String[]{"Dialog", "SansSerif", "Serif", "Monospaced"};
    }
}

