/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.graphics.text;

import com.ibm.icu.text.Bidi;
import com.ibm.icu.text.BidiRun;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.graphics.text.Font;
import yslelf.cloudpick.graphics.graphics.text.FontMetricsInt;
import yslelf.cloudpick.graphics.graphics.text.FontPaint;
import yslelf.cloudpick.graphics.graphics.text.LayoutCache;
import yslelf.cloudpick.graphics.graphics.text.LayoutPiece;
import yslelf.cloudpick.graphics.graphics.text.LayoutUtils;
import yslelf.cloudpick.render.core.TextBlob;

@Immutable
public class ShapedText {
    public static final int BIDI_LTR = 0;
    public static final int BIDI_RTL = 1;
    public static final int BIDI_DEFAULT_LTR = 2;
    public static final int BIDI_DEFAULT_RTL = 3;
    public static final int BIDI_OVERRIDE_LTR = 4;
    public static final int BIDI_OVERRIDE_RTL = 5;
    private final int[] mGlyphs;
    private final float[] mPositions;
    private final byte[] mFontIndices;
    private final Font[] mFonts;
    private final float[] mAdvances;
    private final int mAscent;
    private final int mDescent;
    private final float mAdvance;
    private final TextBlob mTextBlob;

    public int getGlyphCount() {
        return this.mGlyphs.length;
    }

    public @Unmodifiable int[] getGlyphs() {
        return this.mGlyphs;
    }

    public int getGlyph(int i) {
        return this.mGlyphs[i];
    }

    public @Unmodifiable float[] getPositions() {
        return this.mPositions;
    }

    public float getX(int i) {
        return this.mPositions[i << 1];
    }

    public float getY(int i) {
        return this.mPositions[i << 1 | 1];
    }

    public Font getFont(int i) {
        if (this.mFontIndices != null) {
            return this.mFonts[this.mFontIndices[i] & 0xFF];
        }
        return this.mFonts[0];
    }

    @ApiStatus.Internal
    public int getCharCount() {
        return this.mAdvances.length;
    }

    @ApiStatus.Internal
    public float[] getAdvances() {
        return this.mAdvances;
    }

    @ApiStatus.Internal
    public float getAdvance(int i) {
        if (i == this.mAdvances.length) {
            return this.mAdvance;
        }
        return this.mAdvances[i];
    }

    public int getAscent() {
        return this.mAscent;
    }

    public int getDescent() {
        return this.mDescent;
    }

    public float getAdvance() {
        return this.mAdvance;
    }

    @ApiStatus.Experimental
    public TextBlob getTextBlob() {
        return this.mTextBlob;
    }

    @ApiStatus.Internal
    public int getMemoryUsage() {
        int m = 48;
        m += 16 + MathUtil.align8(this.mGlyphs.length << 2);
        m += 16 + MathUtil.align8(this.mPositions.length << 2);
        if (this.mFontIndices != null) {
            m += 16 + MathUtil.align8(this.mFontIndices.length);
        }
        m += 16 + MathUtil.align8(this.mFonts.length << 2);
        if (this.mAdvances != null) {
            m += 16 + MathUtil.align8(this.mAdvances.length << 2);
        }
        return m;
    }

    public String toString() {
        return "ShapedText{mGlyphs=" + Arrays.toString(this.mGlyphs) + ", mPositions=" + Arrays.toString(this.mPositions) + ", mFonts=" + Arrays.toString(this.mFonts) + ", mFontIndices=" + Arrays.toString(this.mFontIndices) + ", mAdvances=" + Arrays.toString(this.mAdvances) + ", mAscent=" + this.mAscent + ", mDescent=" + this.mDescent + ", mAdvance=" + this.mAdvance + "}";
    }

    public ShapedText(@NonNull char[] text, int contextStart, int contextLimit, int start, int limit, int bidiFlags, @NonNull FontPaint paint) {
        boolean isOverride;
        int length = text.length;
        Objects.checkFromToIndex(contextStart, contextLimit, length);
        if (contextStart > start || contextLimit < limit) {
            throw new IndexOutOfBoundsException(String.format("context range [%d,%d) must be no smaller than layout range [%d,%d)", contextStart, contextLimit, start, limit));
        }
        if (bidiFlags < 0 || bidiFlags > 7) {
            throw new IllegalArgumentException();
        }
        boolean bl = isOverride = (bidiFlags & 4) != 0;
        if (!(isOverride || contextStart == 0 && contextLimit == length)) {
            throw new IllegalArgumentException(String.format("text array [0,%d) must be context range [%d,%d) for non-override bidi flags 0x%X", length, contextStart, contextLimit, bidiFlags));
        }
        int count = limit - start;
        if (count == 0) {
            this.mAdvances = null;
            this.mGlyphs = IntArrays.EMPTY_ARRAY;
            this.mPositions = FloatArrays.EMPTY_ARRAY;
            this.mFontIndices = null;
            this.mFonts = null;
            this.mAscent = 0;
            this.mDescent = 0;
            this.mAdvance = 0.0f;
            this.mTextBlob = null;
            return;
        }
        this.mAdvances = null;
        FontMetricsInt extent = new FontMetricsInt();
        ByteArrayList fontIndices = new ByteArrayList(count);
        IntArrayList glyphs = new IntArrayList(count);
        FloatArrayList positions = new FloatArrayList(count * 2);
        ArrayList fontVec = new ArrayList();
        HashMap fontMap = new HashMap();
        Function<Font, Byte> nextID = font -> {
            fontVec.add(font);
            return (byte)fontMap.size();
        };
        Function<Font, Byte> idGet = font -> (Byte)fontMap.computeIfAbsent(font, nextID);
        float advance = 0.0f;
        if (isOverride) {
            boolean isRtl = (bidiFlags & 1) != 0;
            advance += ShapedText.doLayoutRun(text, contextStart, contextLimit, start, limit, isRtl, paint, start, this.mAdvances, advance, glyphs, positions, fontIndices, idGet, extent, null);
        } else {
            byte paraLevel = switch (bidiFlags) {
                case 0 -> 0;
                case 1 -> 1;
                case 2 -> 126;
                case 3 -> 127;
                default -> throw new AssertionError();
            };
            Bidi bidi = new Bidi(length, 0);
            bidi.setPara(text, paraLevel, null);
            if (bidi.isRightToLeft()) {
                advance += ShapedText.doLayoutRun(text, 0, length, start, limit, true, paint, start, this.mAdvances, advance, glyphs, positions, fontIndices, idGet, extent, null);
            } else if (bidi.isLeftToRight()) {
                advance += ShapedText.doLayoutRun(text, 0, length, start, limit, false, paint, start, this.mAdvances, advance, glyphs, positions, fontIndices, idGet, extent, null);
            } else {
                int runCount = bidi.getRunCount();
                for (int visualIndex = 0; visualIndex < runCount; ++visualIndex) {
                    BidiRun run = bidi.getVisualRun(visualIndex);
                    int runStart = Math.max(run.getStart(), start);
                    int runEnd = Math.min(run.getLimit(), limit);
                    advance += ShapedText.doLayoutRun(text, 0, length, runStart, runEnd, run.isOddRun(), paint, start, this.mAdvances, advance, glyphs, positions, fontIndices, idGet, extent, null);
                }
            }
        }
        this.mAdvance = advance;
        this.mGlyphs = glyphs.toIntArray();
        this.mPositions = positions.toFloatArray();
        this.mFontIndices = (byte[])(fontVec.size() > 1 ? fontIndices.toByteArray() : null);
        this.mFonts = fontVec.toArray(new Font[0]);
        this.mAscent = extent.ascent;
        this.mDescent = extent.descent;
        assert (this.mGlyphs.length * 2 == this.mPositions.length);
        assert (this.mFontIndices == null || this.mFontIndices.length == this.mGlyphs.length);
        int nGlyphs = this.mGlyphs.length;
        if (nGlyphs == 0) {
            this.mTextBlob = null;
        } else if (this.mFontIndices == null) {
            yslelf.cloudpick.render.core.Font nativeFont = new yslelf.cloudpick.render.core.Font();
            paint.getNativeFont(nativeFont);
            nativeFont.setTypeface(this.mFonts[0].getNativeTypeface());
            this.mTextBlob = nativeFont.getTypeface() != null ? TextBlob.makeNoCopy(this.mGlyphs, this.mPositions, nativeFont, null) : null;
        } else {
            TextBlob.Builder builder = new TextBlob.Builder();
            yslelf.cloudpick.render.core.Font nativeFont = new yslelf.cloudpick.render.core.Font();
            paint.getNativeFont(nativeFont);
            Font lastFont = this.getFont(0);
            int lastPos = 0;
            for (int currPos = 1; currPos <= nGlyphs; ++currPos) {
                Font currFont;
                Font font2 = currFont = currPos == nGlyphs ? null : this.getFont(currPos);
                if (lastFont == currFont) continue;
                nativeFont.setTypeface(lastFont.getNativeTypeface());
                if (nativeFont.getTypeface() != null) {
                    int runCount = currPos - lastPos;
                    TextBlob.Builder.RunBuffer runBuffer = builder.allocRunPos(nativeFont, runCount, null);
                    runBuffer.addGlyphs(this.mGlyphs, lastPos, runCount);
                    runBuffer.addPositions(this.mPositions, lastPos << 1, runCount);
                }
                lastFont = currFont;
                lastPos = currPos;
            }
            this.mTextBlob = builder.build();
        }
    }

    @ApiStatus.Internal
    public static float doLayoutRun(char[] text, int contextStart, int contextLimit, int start, int limit, boolean isRtl, FontPaint paint, FontMetricsInt extent, RunConsumer consumer) {
        return ShapedText.doLayoutRun(text, contextStart, contextLimit, start, limit, isRtl, paint, start, null, 0.0f, null, null, null, null, extent, consumer);
    }

    @ApiStatus.Internal
    public static float doLayoutRun(char[] text, int contextStart, int contextLimit, int start, int limit, boolean isRtl, FontPaint paint, int layoutStart, float[] advances, float curAdvance, IntArrayList glyphs, FloatArrayList positions, ByteArrayList fontIndices, Function<Font, Byte> idGet, FontMetricsInt extent, RunConsumer consumer) {
        float advance = 0.0f;
        if (isRtl) {
            int pos = limit;
            while (true) {
                int itPieceEnd;
                int itContextStart = LayoutUtils.getPrevWordBreakForCache(text, contextStart, contextLimit, pos);
                int itContextEnd = LayoutUtils.getNextWordBreakForCache(text, contextStart, contextLimit, pos == 0 ? 0 : pos - 1);
                int itPieceStart = Math.max(itContextStart, start);
                if (itPieceStart != (itPieceEnd = pos)) {
                    advance += ShapedText.doLayoutWord(text, itContextStart, itContextEnd, itPieceStart, itPieceEnd, true, paint, itPieceStart - layoutStart, advances, curAdvance + advance, glyphs, positions, fontIndices, idGet, extent, consumer);
                    pos = itPieceStart;
                    continue;
                }
                break;
            }
        } else {
            int pos = start;
            while (true) {
                int itContextStart = LayoutUtils.getPrevWordBreakForCache(text, contextStart, contextLimit, pos == limit ? pos : pos + 1);
                int itPieceStart = pos;
                int itContextEnd = LayoutUtils.getNextWordBreakForCache(text, contextStart, contextLimit, pos);
                int itPieceEnd = Math.min(itContextEnd, limit);
                if (itPieceStart == itPieceEnd) break;
                advance += ShapedText.doLayoutWord(text, itContextStart, itContextEnd, itPieceStart, itPieceEnd, false, paint, itPieceStart - layoutStart, advances, curAdvance + advance, glyphs, positions, fontIndices, idGet, extent, consumer);
                pos = itPieceEnd;
            }
        }
        return advance;
    }

    private static float doLayoutWord(char[] buf, int contextStart, int contextEnd, int start, int end, boolean isRtl, FontPaint paint, int advanceOffset, float[] advances, float curAdvance, IntArrayList glyphs, FloatArrayList positions, ByteArrayList fontIndices, Function<Font, Byte> idGet, FontMetricsInt extent, RunConsumer consumer) {
        LayoutPiece src = LayoutCache.getOrCreate(buf, contextStart, contextEnd, start, end, isRtl, paint, advances != null ? 1 : 0);
        if (consumer == null) {
            for (int i = 0; i < src.getGlyphCount(); ++i) {
                fontIndices.add(idGet.apply(src.getFont(i)).byteValue());
            }
            glyphs.addElements(glyphs.size(), src.getGlyphs());
            int posStart = positions.size();
            positions.addElements(posStart, src.getPositions());
            int posEnd = positions.size();
            for (int posIndex = posStart; posIndex < posEnd; posIndex += 2) {
                float[] fArray = positions.elements();
                int n2 = posIndex;
                fArray[n2] = fArray[n2] + curAdvance;
            }
            if (advances != null) {
                float[] srcAdvances = src.getAdvances();
                System.arraycopy(srcAdvances, 0, advances, advanceOffset, srcAdvances.length);
            }
        } else {
            consumer.accept(src, curAdvance, paint);
        }
        if (extent != null) {
            extent.extendBy(src.getAscent(), src.getDescent());
        }
        return src.getAdvance();
    }

    @FunctionalInterface
    public static interface RunConsumer {
        public void accept(LayoutPiece var1, float var2, FontPaint var3);
    }
}

