/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.lifecycle;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.annotation.CallSuper;
import yslelf.cloudpick.graphics.annotation.UiThread;
import yslelf.cloudpick.graphics.lifecycle.LiveData;
import yslelf.cloudpick.graphics.lifecycle.MutableLiveData;
import yslelf.cloudpick.graphics.lifecycle.Observer;
import yslelf.cloudpick.graphics.lifecycle.SafeLinkedList;

public class MediatorLiveData<T>
extends MutableLiveData<T> {
    private final SafeLinkedList<LiveData<?>, Source<?>> mSources = new SafeLinkedList();

    @UiThread
    public <S> void addSource(@Nonnull LiveData<S> source, @Nonnull Observer<? super S> onChanged) {
        Source<S> e = new Source<S>(source, onChanged);
        Source<? super S> existing = this.mSources.putIfAbsent(e);
        if (existing != null && existing.mObserver != onChanged) {
            throw new IllegalArgumentException("This source was already added with the different observer");
        }
        if (existing != null) {
            return;
        }
        if (this.hasActiveObservers()) {
            e.plug();
        }
    }

    @UiThread
    public <S> void removeSource(@Nonnull LiveData<S> toRemote) {
        Source<?> source = this.mSources.remove(toRemote);
        if (source != null) {
            source.unplug();
        }
    }

    @Override
    @CallSuper
    protected void onActive() {
        for (Source<?> source : this.mSources) {
            source.plug();
        }
    }

    @Override
    @CallSuper
    protected void onInactive() {
        for (Source<?> source : this.mSources) {
            source.unplug();
        }
    }

    private static class Source<V>
    implements Observer<V>,
    Supplier<LiveData<?>> {
        final LiveData<V> mLiveData;
        final Observer<? super V> mObserver;
        int mVersion = -1;

        Source(LiveData<V> liveData, Observer<? super V> observer) {
            this.mLiveData = liveData;
            this.mObserver = observer;
        }

        @Override
        public LiveData<?> get() {
            return this.mLiveData;
        }

        void plug() {
            this.mLiveData.observeForever(this);
        }

        void unplug() {
            this.mLiveData.removeObserver(this);
        }

        @Override
        public void onChanged(@Nullable V v) {
            if (this.mVersion != this.mLiveData.getVersion()) {
                this.mVersion = this.mLiveData.getVersion();
                this.mObserver.onChanged(v);
            }
        }
    }
}

