/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.lifecycle;

import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SafeLinkedList<T, E extends Supplier<T>>
implements Iterable<E> {
    private Node<E> mHead;
    private Node<E> mTail;
    private final WeakHashMap<SafeRemove<E>, Boolean> mIterators = new WeakHashMap();
    private int mSize = 0;

    @Nullable
    protected Node<E> find(T token) {
        Node<E> n2 = this.mHead;
        while (n2 != null) {
            if (((Supplier)n2.mElement).get().equals(token)) {
                return n2;
            }
            n2 = n2.mNext;
        }
        return null;
    }

    public E putIfAbsent(@Nonnull E e) {
        Node<E> node = this.find(e.get());
        if (node != null) {
            return (E)((Supplier)node.mElement);
        }
        this.put(e);
        return null;
    }

    protected Node<E> put(@Nonnull E e) {
        Node<E> l2 = this.mTail;
        Node<E> node = new Node<E>(l2, e, null);
        this.mTail = node;
        if (l2 == null) {
            this.mHead = node;
        } else {
            l2.mNext = node;
        }
        ++this.mSize;
        return node;
    }

    @Nullable
    public E remove(@Nonnull T key) {
        Node<E> n2 = this.find(key);
        if (n2 == null) {
            return null;
        }
        --this.mSize;
        if (!this.mIterators.isEmpty()) {
            for (SafeRemove<E> iter : this.mIterators.keySet()) {
                iter.remove(n2);
            }
        }
        if (n2.mPrev != null) {
            n2.mPrev.mNext = n2.mNext;
        } else {
            this.mHead = n2.mNext;
        }
        if (n2.mNext != null) {
            n2.mNext.mPrev = n2.mPrev;
        } else {
            this.mTail = n2.mPrev;
        }
        n2.mNext = null;
        n2.mPrev = null;
        return (E)((Supplier)n2.mElement);
    }

    public int size() {
        return this.mSize;
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        AscendingIterator<E> iterator = new AscendingIterator<E>(this.mHead, this.mTail);
        this.mIterators.put(iterator, Boolean.FALSE);
        return iterator;
    }

    @Nonnull
    public Iterator<E> descendingIterator() {
        DescendingIterator<E> iterator = new DescendingIterator<E>(this.mTail, this.mHead);
        this.mIterators.put(iterator, Boolean.FALSE);
        return iterator;
    }

    @Nonnull
    public Iterator<E> iteratorWithAdditions() {
        IteratorWithAdditions iterator = new IteratorWithAdditions();
        this.mIterators.put(iterator, Boolean.FALSE);
        return iterator;
    }

    public E head() {
        return (E)(this.mHead == null ? null : (Supplier)this.mHead.mElement);
    }

    public E tail() {
        return (E)(this.mTail == null ? null : (Supplier)this.mTail.mElement);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SafeLinkedList)) {
            return false;
        }
        SafeLinkedList map = (SafeLinkedList)obj;
        if (this.size() != map.size()) {
            return false;
        }
        Iterator<E> iterator1 = this.iterator();
        Iterator<E> iterator2 = map.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Supplier next1 = (Supplier)iterator1.next();
            E next2 = iterator2.next();
            if ((next1 != null || next2 == null) && (next1 == null || next1.equals(next2))) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public int hashCode() {
        int h2 = 0;
        for (Supplier e : this) {
            h2 += e.hashCode();
        }
        return h2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            builder.append(((Supplier)iterator.next()).toString());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    static class Node<E> {
        E mElement;
        Node<E> mNext;
        Node<E> mPrev;

        Node(Node<E> prev, E element, Node<E> next) {
            this.mElement = element;
            this.mNext = next;
            this.mPrev = prev;
        }
    }

    static interface SafeRemove<V> {
        public void remove(@Nonnull Node<V> var1);
    }

    static class AscendingIterator<E>
    extends SafeIterator<E> {
        AscendingIterator(Node<E> start, Node<E> expectedEnd) {
            super(start, expectedEnd);
        }

        @Override
        Node<E> forward(@Nonnull Node<E> node) {
            return node.mNext;
        }

        @Override
        Node<E> backward(@Nonnull Node<E> node) {
            return node.mPrev;
        }
    }

    private static class DescendingIterator<E>
    extends SafeIterator<E> {
        DescendingIterator(Node<E> start, Node<E> expectedEnd) {
            super(start, expectedEnd);
        }

        @Override
        Node<E> forward(@Nonnull Node<E> node) {
            return node.mPrev;
        }

        @Override
        Node<E> backward(@Nonnull Node<E> node) {
            return node.mNext;
        }
    }

    private class IteratorWithAdditions
    implements Iterator<E>,
    SafeRemove<E> {
        private Node<E> mCurrent;
        private boolean mBeforeHead = true;

        IteratorWithAdditions() {
        }

        @Override
        public void remove(@Nonnull Node<E> node) {
            if (node == this.mCurrent) {
                this.mCurrent = this.mCurrent.mPrev;
                this.mBeforeHead = this.mCurrent == null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.mBeforeHead) {
                return SafeLinkedList.this.mHead != null;
            }
            return this.mCurrent != null && this.mCurrent.mNext != null;
        }

        @Override
        public E next() {
            if (this.mBeforeHead) {
                this.mBeforeHead = false;
                this.mCurrent = SafeLinkedList.this.mHead;
            } else {
                this.mCurrent = this.mCurrent.mNext;
            }
            return (Supplier)this.mCurrent.mElement;
        }
    }

    private static abstract class SafeIterator<E>
    implements Iterator<E>,
    SafeRemove<E> {
        Node<E> mExpectedEnd;
        Node<E> mNext;

        SafeIterator(Node<E> start, Node<E> expectedEnd) {
            this.mExpectedEnd = expectedEnd;
            this.mNext = start;
        }

        @Override
        public void remove(@Nonnull Node<E> node) {
            if (this.mExpectedEnd == node && node == this.mNext) {
                this.mNext = null;
                this.mExpectedEnd = null;
            }
            if (this.mExpectedEnd == node) {
                this.mExpectedEnd = this.backward(this.mExpectedEnd);
            }
            if (this.mNext == node) {
                this.mNext = this.nextNode();
            }
        }

        @Nullable
        private Node<E> nextNode() {
            if (this.mNext == this.mExpectedEnd || this.mExpectedEnd == null) {
                return null;
            }
            return this.forward(this.mNext);
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        @Override
        public E next() {
            Object result = this.mNext.mElement;
            this.mNext = this.nextNode();
            return result;
        }

        abstract Node<E> forward(@Nonnull Node<E> var1);

        abstract Node<E> backward(@Nonnull Node<E> var1);
    }
}

