/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.lifecycle;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.annotation.UiThread;
import yslelf.cloudpick.graphics.lifecycle.LiveData;
import yslelf.cloudpick.graphics.lifecycle.MediatorLiveData;
import yslelf.cloudpick.graphics.lifecycle.Observer;

public final class Transformations {
    private Transformations() {
    }

    @Nonnull
    @UiThread
    public static <X, Y> LiveData<Y> map(@Nonnull LiveData<X> source, @Nonnull Function<? super X, ? extends Y> mapFunction) {
        MediatorLiveData result = new MediatorLiveData();
        result.addSource(source, x -> result.setValue(mapFunction.apply((Object)x)));
        return result;
    }

    @Nonnull
    @UiThread
    public static <X, Y> LiveData<Y> switchMap(@Nonnull LiveData<X> source, final @Nonnull Function<? super X, ? extends LiveData<? extends Y>> switchMapFunction) {
        final MediatorLiveData result = new MediatorLiveData();
        result.addSource(source, new Observer<X>(){
            private LiveData<? extends Y> mSource;

            @Override
            public void onChanged(@Nullable X x) {
                LiveData newLiveData = (LiveData)switchMapFunction.apply(x);
                if (this.mSource == newLiveData) {
                    return;
                }
                if (this.mSource != null) {
                    result.removeSource(this.mSource);
                }
                this.mSource = newLiveData;
                if (this.mSource != null) {
                    result.addSource(this.mSource, result::setValue);
                }
            }
        });
        return result;
    }

    @Nonnull
    @UiThread
    public static <X> LiveData<X> distinctUntilChanged(@Nonnull LiveData<X> source) {
        final MediatorLiveData result = new MediatorLiveData();
        result.addSource(source, new Observer<X>(){
            private boolean mFirstChanged;

            @Override
            public void onChanged(X currentValue) {
                Object previousValue = result.getValue();
                if (!this.mFirstChanged || !Objects.equals(previousValue, currentValue)) {
                    this.mFirstChanged = true;
                    result.setValue(currentValue);
                }
            }
        });
        return result;
    }
}

