/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.lifecycle;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import javax.annotation.Nonnull;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.annotation.UiThread;
import yslelf.cloudpick.graphics.lifecycle.ViewModel;
import yslelf.cloudpick.graphics.lifecycle.ViewModelStore;
import yslelf.cloudpick.graphics.lifecycle.ViewModelStoreOwner;

public class ViewModelProvider {
    private static final String DEFAULT_KEY = "ViewModelProvider.DefaultKey";
    private final Factory mFactory;
    private final ViewModelStore mViewModelStore;

    public ViewModelProvider(@Nonnull ViewModelStoreOwner owner) {
        this(owner.getViewModelStore(), Objects.requireNonNullElseGet(owner.getDefaultViewModelProviderFactory(), NewInstanceFactory::getInstance));
    }

    public ViewModelProvider(@Nonnull ViewModelStoreOwner owner, @Nonnull Factory factory) {
        this(owner.getViewModelStore(), factory);
    }

    public ViewModelProvider(@Nonnull ViewModelStore store, @Nonnull Factory factory) {
        this.mFactory = factory;
        this.mViewModelStore = store;
    }

    @Nonnull
    @UiThread
    public <T extends ViewModel> T get(@Nonnull Class<T> modelClass) {
        String canonicalName = modelClass.getCanonicalName();
        if (canonicalName == null) {
            throw new IllegalArgumentException("Local and anonymous classes can not be ViewModels");
        }
        return this.get("ViewModelProvider.DefaultKey:" + canonicalName, modelClass);
    }

    @Nonnull
    @UiThread
    public <T extends ViewModel> T get(@Nonnull String key, @Nonnull Class<T> modelClass) {
        ViewModel viewModel = this.mViewModelStore.get(key);
        if (modelClass.isInstance(viewModel)) {
            if (this.mFactory instanceof OnRequeryFactory) {
                ((OnRequeryFactory)((Object)this.mFactory)).onRequery(viewModel);
            }
            return (T)viewModel;
        }
        if (viewModel != null) {
            CloudPick.LOGGER.warn(ViewModel.MARKER, "Mismatched model class {} with an existing instance {}", modelClass, (Object)viewModel);
        }
        viewModel = this.mFactory instanceof KeyedFactory ? ((KeyedFactory)this.mFactory).create(key, modelClass) : this.mFactory.create(modelClass);
        this.mViewModelStore.put(key, viewModel);
        return (T)viewModel;
    }

    @FunctionalInterface
    public static interface Factory {
        @Nonnull
        public <T extends ViewModel> T create(@Nonnull Class<T> var1);
    }

    static class OnRequeryFactory {
        OnRequeryFactory() {
        }

        void onRequery(@Nonnull ViewModel viewModel) {
        }
    }

    static abstract class KeyedFactory
    extends OnRequeryFactory
    implements Factory {
        KeyedFactory() {
        }

        @Nonnull
        public abstract <T extends ViewModel> T create(@Nonnull String var1, @Nonnull Class<T> var2);

        @Override
        @Nonnull
        public final <T extends ViewModel> T create(@Nonnull Class<T> modelClass) {
            throw new UnsupportedOperationException("create(String, Class<?>) must be called on implementations of KeyedFactory");
        }
    }

    public static class NewInstanceFactory
    implements Factory {
        private static NewInstanceFactory sInstance;

        @Nonnull
        static NewInstanceFactory getInstance() {
            if (sInstance == null) {
                sInstance = new NewInstanceFactory();
            }
            return sInstance;
        }

        @Override
        @Nonnull
        public <T extends ViewModel> T create(@Nonnull Class<T> modelClass) {
            try {
                return (T)((ViewModel)modelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Cannot create an instance of " + modelClass, e);
            }
        }
    }
}

