/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.material.drawable;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.drawable.Animatable;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;

@ApiStatus.Internal
public abstract class BaseIndeterminateDrawable
extends Drawable
implements Animatable {
    protected int mIndicatorColor = -1;
    protected int mTrackColor = -1;
    protected int mAlpha = 255;
    protected Animator mAnimator;

    public void setIndicatorColor(int indicatorColor) {
        if (this.mIndicatorColor != indicatorColor) {
            this.mIndicatorColor = indicatorColor;
            this.invalidateSelf();
        }
    }

    public void setTrackColor(int trackColor) {
        if (this.mTrackColor != trackColor) {
            this.mTrackColor = trackColor;
            this.invalidateSelf();
        }
    }

    public int getIndicatorColor() {
        return this.mIndicatorColor;
    }

    public int getTrackColor() {
        return this.mTrackColor;
    }

    @Override
    public void setAlpha(int alpha) {
        if (this.mAlpha != alpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    @Override
    public int getAlpha() {
        return this.mAlpha;
    }

    @Override
    public void start() {
        if (this.mAnimator == null) {
            this.mAnimator = this.createAnimator();
        }
        this.mAnimator.start();
    }

    @Override
    public void stop() {
        if (this.mAnimator != null) {
            this.mAnimator.end();
        }
    }

    @Override
    public boolean isRunning() {
        return this.mAnimator != null && this.mAnimator.isRunning();
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        if (this.mAnimator != null && this.mAnimator.isStarted()) {
            if (visible) {
                this.mAnimator.resume();
            } else {
                this.mAnimator.pause();
            }
        }
        return super.setVisible(visible, restart);
    }

    @NonNull
    protected abstract Animator createAnimator();
}

