/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.material.drawable;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.AnimatorSet;
import yslelf.cloudpick.graphics.animation.BezierInterpolator;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.animation.ValueAnimator;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.ShapeDrawable;
import yslelf.cloudpick.graphics.material.drawable.BaseIndeterminateDrawable;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.resources.TypedValue;

@ApiStatus.Internal
public class CircularIndeterminateDrawable
extends BaseIndeterminateDrawable {
    private static final TimeInterpolator TRIM_START_INTERPOLATOR = BezierInterpolator.createTwoCubic(0.5f, 0.0f, 0.5f, 0.0f, 0.5f, 0.0f, 0.7f, 0.0f, 0.6f, 1.0f);
    private static final TimeInterpolator TRIM_END_INTERPOLATOR = BezierInterpolator.createTwoCubic(0.2f, 0.0f, 0.1f, 1.0f, 0.5f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    private final int mTotalSize;
    private final float mRadius;
    private final float mThickness;
    private float mTrimPathStart;
    private float mTrimPathEnd;
    private float mTrimPathOffset;
    private float mRotation;

    public CircularIndeterminateDrawable(Resources res, int size, int inset, float thickness) {
        int totalSize = size + inset * 2;
        this.mTotalSize = Math.round(TypedValue.applyDimension(1, totalSize, res.getDisplayMetrics()));
        float scale = (float)this.mTotalSize / (float)totalSize;
        this.mRadius = (float)(size - inset) * 0.5f * scale;
        this.mThickness = thickness * scale;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        Paint paint = Paint.obtain();
        if (this.mAlpha != 0) {
            Rect r = this.getBounds();
            paint.setStyle(1);
            paint.setStrokeWidth(this.mThickness);
            paint.setColor(this.mIndicatorColor);
            paint.setAlpha(ShapeDrawable.modulateAlpha(paint.getAlpha(), this.mAlpha));
            if (ValueAnimator.areAnimatorsEnabled()) {
                canvas.save();
                canvas.translate(r.exactCenterX(), r.exactCenterY());
                canvas.rotate(this.mRotation);
                canvas.drawArc(0.0f, 0.0f, this.mRadius, (this.mTrimPathStart + this.mTrimPathOffset) * 360.0f - 90.0f, (this.mTrimPathEnd - this.mTrimPathStart) * 360.0f, paint);
                canvas.restore();
            } else {
                canvas.drawCircle(r.exactCenterX(), r.exactCenterY(), this.mRadius, paint);
            }
        }
        paint.recycle();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mTotalSize;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mTotalSize;
    }

    @Override
    @NonNull
    protected Animator createAnimator() {
        ValueAnimator anim1 = new ValueAnimator();
        anim1.setDuration(1333L);
        anim1.setRepeatCount(-1);
        anim1.setInterpolator(null);
        anim1.addUpdateListener(animation -> {
            float fraction = animation.getAnimatedFraction();
            this.mTrimPathStart = MathUtil.lerp(0.0f, 0.75f, TRIM_START_INTERPOLATOR.getInterpolation(fraction));
            this.mTrimPathEnd = MathUtil.lerp(0.0f, 0.75f, TRIM_END_INTERPOLATOR.getInterpolation(fraction));
            this.mTrimPathOffset = MathUtil.lerp(0.0f, 0.25f, fraction);
        });
        ValueAnimator anim2 = new ValueAnimator();
        anim2.setDuration(4444L);
        anim2.setRepeatCount(-1);
        anim2.setInterpolator(null);
        anim2.addUpdateListener(animation -> {
            this.mRotation = MathUtil.lerp(0.0f, 720.0f, animation.getAnimatedFraction());
            this.invalidateSelf();
        });
        AnimatorSet set = new AnimatorSet();
        set.playTogether(anim1, anim2);
        return set;
    }
}

