/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.material.drawable;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.BezierInterpolator;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.animation.ValueAnimator;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.ShapeDrawable;
import yslelf.cloudpick.graphics.material.drawable.BaseIndeterminateDrawable;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.resources.TypedValue;

@ApiStatus.Internal
public class LinearIndeterminateDrawable
extends BaseIndeterminateDrawable {
    private static final int TOTAL_DURATION_IN_MS = 1800;
    private static final int[] DURATION_TO_MOVE_SEGMENT_ENDS = new int[]{533, 567, 850, 750};
    private static final int[] DELAY_TO_MOVE_SEGMENT_ENDS = new int[]{1267, 1000, 333, 0};
    private static final TimeInterpolator[] INTERPOLATOR_ARRAY = new TimeInterpolator[]{new BezierInterpolator(0.2f, 0.0f, 0.8f, 1.0f), new BezierInterpolator(0.4f, 0.0f, 1.0f, 1.0f), new BezierInterpolator(0.0f, 0.0f, 0.65f, 1.0f), new BezierInterpolator(0.1f, 0.0f, 0.45f, 1.0f)};
    private static final int SHORT_SIZE = 10;
    private static final int LONG_SIZE = 360;
    private final int mShortSize;
    private final int mLongSize;
    private final boolean mVertical;
    private float mStartFraction1;
    private float mEndFraction1;
    private float mStartFraction2;
    private float mEndFraction2;

    public LinearIndeterminateDrawable(Resources res, boolean vertical) {
        this.mShortSize = Math.round(TypedValue.applyDimension(1, 10.0f, res.getDisplayMetrics()));
        this.mLongSize = Math.round(TypedValue.applyDimension(1, 360.0f, res.getDisplayMetrics()));
        this.mVertical = vertical;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        Paint paint = Paint.obtain();
        if (this.mAlpha != 0) {
            float end;
            float start;
            Rect r = this.getBounds();
            float thickness = (float)(4 * this.mLongSize) * 0.0027777778f;
            paint.setStyle(1);
            paint.setStrokeWidth(thickness);
            paint.setColor(this.mTrackColor);
            paint.setAlpha(ShapeDrawable.modulateAlpha(paint.getAlpha(), this.mAlpha));
            if (this.mVertical) {
                start = (float)r.bottom - thickness * 0.5f;
                end = (float)r.top + thickness * 0.5f;
                canvas.drawLine(r.exactCenterX(), start, r.exactCenterX(), end, paint);
            } else {
                start = (float)r.left + thickness * 0.5f;
                end = (float)r.right - thickness * 0.5f;
                canvas.drawLine(start, r.exactCenterY(), end, r.exactCenterY(), paint);
            }
            paint.setColor(this.mIndicatorColor);
            paint.setAlpha(ShapeDrawable.modulateAlpha(paint.getAlpha(), this.mAlpha));
            if (this.mVertical) {
                if (this.mStartFraction1 != this.mEndFraction1) {
                    canvas.drawLine(r.exactCenterX(), MathUtil.lerp(start, end, this.mStartFraction1), r.exactCenterX(), MathUtil.lerp(start, end, this.mEndFraction1), paint);
                }
                if (this.mStartFraction2 != this.mEndFraction2) {
                    canvas.drawLine(r.exactCenterX(), MathUtil.lerp(start, end, this.mStartFraction2), r.exactCenterX(), MathUtil.lerp(start, end, this.mEndFraction2), paint);
                }
            } else {
                if (this.mStartFraction1 != this.mEndFraction1) {
                    canvas.drawLine(MathUtil.lerp(start, end, this.mStartFraction1), r.exactCenterY(), MathUtil.lerp(start, end, this.mEndFraction1), r.exactCenterY(), paint);
                }
                if (this.mStartFraction2 != this.mEndFraction2) {
                    canvas.drawLine(MathUtil.lerp(start, end, this.mStartFraction2), r.exactCenterY(), MathUtil.lerp(start, end, this.mEndFraction2), r.exactCenterY(), paint);
                }
            }
        }
        paint.recycle();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mVertical ? this.mShortSize : this.mLongSize;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mVertical ? this.mLongSize : this.mShortSize;
    }

    @Override
    @NonNull
    protected Animator createAnimator() {
        ValueAnimator anim = new ValueAnimator();
        anim.setDuration(1800L);
        anim.setRepeatCount(-1);
        anim.setInterpolator(null);
        anim.addUpdateListener(animation -> {
            float fraction = animation.getAnimatedFraction();
            int playtime = (int)(fraction * 1800.0f + 0.5f);
            this.updateSegmentPositions(playtime);
            this.invalidateSelf();
        });
        return anim;
    }

    private void updateSegmentPositions(int playtime) {
        float fraction = LinearIndeterminateDrawable.getFractionInRange(playtime, DELAY_TO_MOVE_SEGMENT_ENDS[0], DURATION_TO_MOVE_SEGMENT_ENDS[0]);
        this.mStartFraction1 = MathUtil.clamp(INTERPOLATOR_ARRAY[0].getInterpolation(fraction), 0.0f, 1.0f);
        fraction = LinearIndeterminateDrawable.getFractionInRange(playtime, DELAY_TO_MOVE_SEGMENT_ENDS[1], DURATION_TO_MOVE_SEGMENT_ENDS[1]);
        this.mEndFraction1 = MathUtil.clamp(INTERPOLATOR_ARRAY[1].getInterpolation(fraction), 0.0f, 1.0f);
        fraction = LinearIndeterminateDrawable.getFractionInRange(playtime, DELAY_TO_MOVE_SEGMENT_ENDS[2], DURATION_TO_MOVE_SEGMENT_ENDS[2]);
        this.mStartFraction2 = MathUtil.clamp(INTERPOLATOR_ARRAY[2].getInterpolation(fraction), 0.0f, 1.0f);
        fraction = LinearIndeterminateDrawable.getFractionInRange(playtime, DELAY_TO_MOVE_SEGMENT_ENDS[3], DURATION_TO_MOVE_SEGMENT_ENDS[3]);
        this.mEndFraction2 = MathUtil.clamp(INTERPOLATOR_ARRAY[3].getInterpolation(fraction), 0.0f, 1.0f);
    }

    protected static float getFractionInRange(int playtime, int start, int duration) {
        return (float)(playtime - start) / (float)duration;
    }
}

