/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.material.drawable;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.AnimatorSet;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.animation.ValueAnimator;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.ShapeDrawable;
import yslelf.cloudpick.graphics.material.MaterialDrawable;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.resources.TypedValue;

@ApiStatus.Internal
public class RadioButtonDrawable
extends MaterialDrawable {
    private static final float SIZE = 24.0f;
    private final int mSize;
    private boolean mAnimated;
    private boolean mLargeSize;
    private boolean mHasOuterRing;
    private float mRingOuterScale = 1.0f;
    private float mRingOuterStrokeWidth = 2.0f;
    private float mDotGroupScale = 1.0f;
    private int mCurState = -1;
    private int mTransitionToState = -1;
    private Animator mTransition;

    public RadioButtonDrawable(Resources res, boolean animated, boolean largeSize, boolean hasOuterRing) {
        this.mSize = Math.round(TypedValue.applyDimension(1, 24.0f, res.getDisplayMetrics()));
        this.mAnimated = animated;
        this.mLargeSize = largeSize;
        this.mHasOuterRing = hasOuterRing;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        Paint paint = Paint.obtain();
        paint.setColor(this.mColor);
        paint.setAlpha(ShapeDrawable.modulateAlpha(paint.getAlpha(), this.mAlpha));
        if (paint.getAlpha() != 0) {
            boolean doSave;
            Rect r = this.getBounds();
            canvas.save();
            canvas.translate(r.exactCenterX(), r.exactCenterY());
            if (this.mHasOuterRing) {
                boolean bl = doSave = this.mRingOuterScale != 1.0f;
                if (doSave) {
                    canvas.save();
                    canvas.scale(this.mRingOuterScale, this.mRingOuterScale);
                }
                paint.setStyle(1);
                paint.setStrokeWidth(this.mRingOuterStrokeWidth * (float)this.mSize * 0.041666668f);
                canvas.drawCircle(0.0f, 0.0f, (float)this.mSize * 0.33333334f, paint);
                if (doSave) {
                    canvas.restore();
                }
            }
            if (this.mDotGroupScale > 0.0f) {
                boolean bl = doSave = this.mDotGroupScale != 1.0f;
                if (doSave) {
                    canvas.save();
                    canvas.scale(this.mDotGroupScale, this.mDotGroupScale);
                }
                paint.setStyle(0);
                canvas.drawCircle(0.0f, 0.0f, (float)this.mSize * 0.1875f, paint);
                if (doSave) {
                    canvas.restore();
                }
            }
            canvas.restore();
        }
        paint.recycle();
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    protected boolean onStateChange(@NonNull int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        int toState = 0;
        for (int state : stateSet) {
            if (state != 0x10100A0) continue;
            toState = 1;
            break;
        }
        return changed |= this.mAnimated && this.selectTransition(toState) || this.selectDrawable(toState);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (this.mTransition != null && (changed || restart)) {
            if (visible) {
                this.mTransition.start();
            } else {
                this.jumpToCurrentState();
            }
        }
        return changed;
    }

    private boolean selectTransition(int toState) {
        int fromState;
        if (this.mTransition != null) {
            if (toState == this.mTransitionToState) {
                return true;
            }
            this.mTransition.cancel();
            fromState = this.mTransitionToState;
        } else {
            fromState = this.mCurState;
        }
        this.mTransition = null;
        this.mTransitionToState = -1;
        if (fromState == -1) {
            return false;
        }
        if (fromState == toState) {
            return false;
        }
        Animator transition = toState == 1 ? this.createOffToOnAnimator() : this.createOnToOffAnimator();
        transition.start();
        this.mTransition = transition;
        this.mTransitionToState = toState;
        return true;
    }

    private boolean selectDrawable(int toState) {
        if (this.mCurState == toState) {
            return false;
        }
        this.mCurState = toState;
        this.mDotGroupScale = toState == 1 ? 1.0f : 0.0f;
        this.invalidateSelf();
        return true;
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mTransition != null) {
            this.mTransition.cancel();
            this.mTransition = null;
            this.selectDrawable(this.mTransitionToState);
        }
    }

    private Animator createOffToOnAnimator() {
        ValueAnimator step1 = new ValueAnimator();
        step1.setDuration(166L);
        step1.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        step1.addUpdateListener(animation -> {
            this.mRingOuterScale = MathUtil.lerp(1.0f, 0.5f, animation.getAnimatedFraction());
            this.mRingOuterStrokeWidth = MathUtil.lerp(2.0f, 16.0f, animation.getAnimatedFraction());
            this.mDotGroupScale = 0.0f;
            this.invalidateSelf();
        });
        ValueAnimator step2 = new ValueAnimator();
        step2.setDuration(16L);
        step2.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        step2.addUpdateListener(animation -> {
            this.mRingOuterScale = MathUtil.lerp(0.5f, 0.9f, animation.getAnimatedFraction());
            this.mRingOuterStrokeWidth = MathUtil.lerp(16.0f, 2.0f, animation.getAnimatedFraction());
            this.mDotGroupScale = MathUtil.lerp(0.0f, 1.5f, animation.getAnimatedFraction());
            this.invalidateSelf();
        });
        ValueAnimator step3 = new ValueAnimator();
        step3.setDuration(316L);
        step3.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        step3.addUpdateListener(animation -> {
            this.mRingOuterScale = MathUtil.lerp(0.9f, 1.0f, animation.getAnimatedFraction());
            this.mRingOuterStrokeWidth = 2.0f;
            this.mDotGroupScale = MathUtil.lerp(1.5f, 1.0f, animation.getAnimatedFraction());
            this.invalidateSelf();
        });
        AnimatorSet set = new AnimatorSet();
        set.playSequentially(step1, step2, step3);
        return set;
    }

    private Animator createOnToOffAnimator() {
        ValueAnimator step1 = new ValueAnimator();
        step1.setDuration(183L);
        step1.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        step1.addUpdateListener(animation -> {
            this.mRingOuterScale = MathUtil.lerp(1.0f, 0.9f, animation.getAnimatedFraction());
            this.mRingOuterStrokeWidth = 2.0f;
            this.mDotGroupScale = MathUtil.lerp(1.0f, 1.4f, animation.getAnimatedFraction());
            this.invalidateSelf();
        });
        ValueAnimator step2 = new ValueAnimator();
        step2.setDuration(16L);
        step2.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        step2.addUpdateListener(animation -> {
            this.mRingOuterScale = MathUtil.lerp(0.9f, 0.5f, animation.getAnimatedFraction());
            this.mRingOuterStrokeWidth = MathUtil.lerp(2.0f, 16.0f, animation.getAnimatedFraction());
            this.mDotGroupScale = MathUtil.lerp(1.4f, 0.0f, animation.getAnimatedFraction());
            this.invalidateSelf();
        });
        ValueAnimator step3 = new ValueAnimator();
        step3.setDuration(300L);
        step3.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        step3.addUpdateListener(animation -> {
            this.mRingOuterScale = MathUtil.lerp(0.5f, 1.0f, animation.getAnimatedFraction());
            this.mRingOuterStrokeWidth = MathUtil.lerp(16.0f, 2.0f, animation.getAnimatedFraction());
            this.mDotGroupScale = 0.0f;
            this.invalidateSelf();
        });
        AnimatorSet set = new AnimatorSet();
        set.playSequentially(step1, step2, step3);
        return set;
    }

    @Override
    public int getIntrinsicWidth() {
        if (this.mLargeSize) {
            return this.mSize * 4 / 3;
        }
        return this.mSize;
    }

    @Override
    public int getIntrinsicHeight() {
        if (this.mLargeSize) {
            return this.mSize * 4 / 3;
        }
        return this.mSize;
    }
}

