/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.material.drawable;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.animation.ValueAnimator;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.ShapeDrawable;
import yslelf.cloudpick.graphics.material.MaterialDrawable;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.resources.TypedValue;

@ApiStatus.Internal
public class SeekbarThumbDrawable
extends MaterialDrawable {
    private final int mWidth;
    private final int mHeight;
    private float mThickness = 0.5f;
    private int mCurState = -1;
    private int mTransitionToState = -1;
    private Animator mTransition;

    public SeekbarThumbDrawable(Resources res) {
        this.mWidth = Math.round(TypedValue.applyDimension(1, 4.0f, res.getDisplayMetrics()));
        this.mHeight = Math.round(TypedValue.applyDimension(1, 28.0f, res.getDisplayMetrics()));
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        Paint paint = Paint.obtain();
        paint.setColor(this.mColor);
        paint.setAlpha(ShapeDrawable.modulateAlpha(paint.getAlpha(), this.mAlpha));
        if (paint.getAlpha() != 0) {
            Rect r = this.getBounds();
            float cx = r.exactCenterX();
            float thick = (float)this.mWidth * this.mThickness;
            canvas.drawRoundRect(cx - thick, (float)r.top, cx + thick, (float)r.bottom, thick, paint);
        }
        paint.recycle();
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    protected boolean onStateChange(@NonNull int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        int toState = 0;
        for (int state : stateSet) {
            if (state != 16842919 && state != 16844130) continue;
            toState = 1;
            break;
        }
        return changed |= this.selectTransition(toState) || this.selectDrawable(toState);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (this.mTransition != null && (changed || restart)) {
            if (visible) {
                this.mTransition.start();
            } else {
                this.jumpToCurrentState();
            }
        }
        return changed;
    }

    private boolean selectTransition(int toState) {
        int fromState;
        if (this.mTransition != null) {
            if (toState == this.mTransitionToState) {
                return true;
            }
            this.mTransition.cancel();
            fromState = this.mTransitionToState;
        } else {
            fromState = this.mCurState;
        }
        this.mTransition = null;
        this.mTransitionToState = -1;
        if (fromState == -1) {
            return false;
        }
        if (fromState == toState) {
            return false;
        }
        Animator transition = toState == 1 ? this.createUnpressedToPressedAnimator() : this.createPressedToUnpressedAnimator();
        transition.start();
        this.mTransition = transition;
        this.mTransitionToState = toState;
        return true;
    }

    private boolean selectDrawable(int toState) {
        if (this.mCurState == toState) {
            return false;
        }
        this.mCurState = toState;
        this.mThickness = toState == 1 ? 0.25f : 0.5f;
        this.invalidateSelf();
        return true;
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mTransition != null) {
            this.mTransition.cancel();
            this.mTransition = null;
            this.selectDrawable(this.mTransitionToState);
        }
    }

    private Animator createUnpressedToPressedAnimator() {
        ValueAnimator anim = new ValueAnimator();
        anim.setDuration(133L);
        anim.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        anim.addUpdateListener(animation -> {
            this.mThickness = MathUtil.lerp(0.5f, 0.25f, animation.getAnimatedFraction());
            this.invalidateSelf();
        });
        return anim;
    }

    private Animator createPressedToUnpressedAnimator() {
        ValueAnimator anim = new ValueAnimator();
        anim.setDuration(133L);
        anim.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        anim.addUpdateListener(animation -> {
            this.mThickness = MathUtil.lerp(0.25f, 0.5f, animation.getAnimatedFraction());
            this.invalidateSelf();
        });
        return anim;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mWidth;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mHeight;
    }
}

