/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.material.drawable;

import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.animation.Animator;
import yslelf.cloudpick.graphics.animation.AnimatorSet;
import yslelf.cloudpick.graphics.animation.ObjectAnimator;
import yslelf.cloudpick.graphics.animation.PropertyValuesHolder;
import yslelf.cloudpick.graphics.animation.TimeInterpolator;
import yslelf.cloudpick.graphics.animation.ValueAnimator;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.Canvas;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.graphics.Paint;
import yslelf.cloudpick.graphics.graphics.Rect;
import yslelf.cloudpick.graphics.graphics.drawable.ShapeDrawable;
import yslelf.cloudpick.graphics.material.MaterialDrawable;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.resources.TypedValue;
import yslelf.cloudpick.graphics.util.FloatProperty;

@ApiStatus.Internal
public class SwitchThumbDrawable
extends MaterialDrawable {
    private static final float SIZE = 32.0f;
    private final int mSize;
    private boolean mAnimated;
    private boolean mUsePressState;
    private float mCircleWidth;
    private float mCircleHeight;
    private int mCurState = -1;
    private int mTransitionToState = -1;
    private Animator mTransition;
    private static final FloatProperty<SwitchThumbDrawable> CIRCLE_WIDTH = new FloatProperty<SwitchThumbDrawable>("circleWidth"){

        @Override
        public void setValue(SwitchThumbDrawable object, float value) {
            object.mCircleWidth = value;
            object.invalidateSelf();
        }

        @Override
        public Float get(SwitchThumbDrawable object) {
            return Float.valueOf(object.mCircleWidth);
        }
    };
    private static final FloatProperty<SwitchThumbDrawable> CIRCLE_HEIGHT = new FloatProperty<SwitchThumbDrawable>("circleHeight"){

        @Override
        public void setValue(SwitchThumbDrawable object, float value) {
            object.mCircleHeight = value;
        }

        @Override
        public Float get(SwitchThumbDrawable object) {
            return Float.valueOf(object.mCircleHeight);
        }
    };

    public SwitchThumbDrawable(Resources res, boolean animated, boolean usePressState) {
        this.mSize = Math.round(TypedValue.applyDimension(1, 32.0f, res.getDisplayMetrics()));
        this.mAnimated = animated;
        this.mUsePressState = usePressState;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        Paint paint = Paint.obtain();
        paint.setColor(this.mColor);
        paint.setAlpha(ShapeDrawable.modulateAlpha(paint.getAlpha(), this.mAlpha));
        if (paint.getAlpha() != 0) {
            Rect r = this.getBounds();
            float cx = r.exactCenterX();
            float cy = r.exactCenterY();
            float extentX = this.mCircleWidth * (float)this.mSize * 0.015625f;
            float extentY = this.mCircleHeight * (float)this.mSize * 0.015625f;
            float rad = Math.min(extentX, extentY);
            canvas.drawRoundRect(cx - extentX, cy - extentY, cx + extentX, cy + extentY, rad, paint);
        }
        paint.recycle();
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    protected boolean onStateChange(@NonNull int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        int toState = 0;
        for (int state : stateSet) {
            if (this.mUsePressState && state == 16842919) {
                toState = 2;
                break;
            }
            if (state != 0x10100A0) continue;
            toState = 1;
        }
        return changed |= this.mAnimated && this.selectTransition(toState) || this.selectDrawable(toState);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (this.mTransition != null && (changed || restart)) {
            if (visible) {
                this.mTransition.start();
            } else {
                this.jumpToCurrentState();
            }
        }
        return changed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean selectTransition(int toState) {
        Animator transition;
        int fromState;
        if (this.mTransition != null) {
            if (toState == this.mTransitionToState) {
                return true;
            }
            this.mTransition.cancel();
            fromState = this.mTransitionToState;
        } else {
            fromState = this.mCurState;
        }
        this.mTransition = null;
        this.mTransitionToState = -1;
        if (fromState == -1) {
            return false;
        }
        if (fromState == toState) {
            return false;
        }
        if (fromState == 0) {
            if (toState == 1) {
                transition = this.createUncheckedToCheckedAnimator();
            } else {
                if (toState != 2) return false;
                transition = this.createAnyToPressedAnimator();
            }
        } else if (fromState == 1) {
            if (toState == 2) {
                transition = this.createAnyToPressedAnimator();
            } else {
                if (toState != 0) return false;
                transition = this.createCheckedToUncheckedAnimator();
            }
        } else {
            if (fromState != 2) return false;
            transition = toState == 1 ? this.createPressedToCheckedAnimator() : this.createPressedToUncheckedAnimator();
        }
        transition.start();
        this.mTransition = transition;
        this.mTransitionToState = toState;
        return true;
    }

    private boolean selectDrawable(int toState) {
        if (this.mCurState == toState) {
            return false;
        }
        this.mCurState = toState;
        if (toState == 2) {
            this.mCircleHeight = 28.0f;
            this.mCircleWidth = 28.0f;
        } else if (toState == 1) {
            this.mCircleHeight = 24.0f;
            this.mCircleWidth = 24.0f;
        } else {
            this.mCircleHeight = 16.0f;
            this.mCircleWidth = 16.0f;
        }
        this.invalidateSelf();
        return true;
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mTransition != null) {
            this.mTransition.cancel();
            this.mTransition = null;
            this.selectDrawable(this.mTransitionToState);
        }
    }

    private Animator createPressedToCheckedAnimator() {
        PropertyValuesHolder pvh1 = PropertyValuesHolder.ofFloat(CIRCLE_WIDTH, 24.0f);
        PropertyValuesHolder pvh2 = PropertyValuesHolder.ofFloat(CIRCLE_HEIGHT, 24.0f);
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder(this, pvh1, pvh2);
        anim.setDuration(150L);
        anim.setInterpolator(TimeInterpolator.MOTION_EASING_STANDARD);
        return anim;
    }

    private Animator createPressedToUncheckedAnimator() {
        PropertyValuesHolder pvh1 = PropertyValuesHolder.ofFloat(CIRCLE_WIDTH, 16.0f);
        PropertyValuesHolder pvh2 = PropertyValuesHolder.ofFloat(CIRCLE_HEIGHT, 16.0f);
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder(this, pvh1, pvh2);
        anim.setDuration(150L);
        anim.setInterpolator(TimeInterpolator.MOTION_EASING_STANDARD);
        return anim;
    }

    private Animator createAnyToPressedAnimator() {
        PropertyValuesHolder pvh1 = PropertyValuesHolder.ofFloat(CIRCLE_WIDTH, 28.0f);
        PropertyValuesHolder pvh2 = PropertyValuesHolder.ofFloat(CIRCLE_HEIGHT, 28.0f);
        ObjectAnimator anim = ObjectAnimator.ofPropertyValuesHolder(this, pvh1, pvh2);
        anim.setDuration(150L);
        anim.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        return anim;
    }

    private Animator createUncheckedToCheckedAnimator() {
        ValueAnimator step1 = new ValueAnimator();
        step1.setDuration(150L);
        step1.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        step1.addUpdateListener(animation -> {
            this.mCircleWidth = MathUtil.lerp(16.0f, 32.0f, animation.getAnimatedFraction());
            this.mCircleHeight = MathUtil.lerp(16.0f, 22.0f, animation.getAnimatedFraction());
            this.invalidateSelf();
        });
        ValueAnimator step2 = new ValueAnimator();
        step2.setDuration(100L);
        step2.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        step2.addUpdateListener(animation -> {
            this.mCircleWidth = MathUtil.lerp(32.0f, 24.0f, animation.getAnimatedFraction());
            this.mCircleHeight = MathUtil.lerp(22.0f, 24.0f, animation.getAnimatedFraction());
            this.invalidateSelf();
        });
        AnimatorSet set = new AnimatorSet();
        set.playSequentially(step1, step2);
        return set;
    }

    private Animator createCheckedToUncheckedAnimator() {
        ValueAnimator step1 = new ValueAnimator();
        step1.setDuration(100L);
        step1.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        step1.addUpdateListener(animation -> {
            this.mCircleWidth = MathUtil.lerp(24.0f, 32.0f, animation.getAnimatedFraction());
            this.mCircleHeight = MathUtil.lerp(24.0f, 22.0f, animation.getAnimatedFraction());
            this.invalidateSelf();
        });
        ValueAnimator step2 = new ValueAnimator();
        step2.setDuration(150L);
        step2.setInterpolator(TimeInterpolator.FAST_OUT_SLOW_IN);
        step2.addUpdateListener(animation -> {
            this.mCircleWidth = MathUtil.lerp(32.0f, 16.0f, animation.getAnimatedFraction());
            this.mCircleHeight = MathUtil.lerp(22.0f, 16.0f, animation.getAnimatedFraction());
            this.invalidateSelf();
        });
        AnimatorSet set = new AnimatorSet();
        set.playSequentially(step1, step2);
        return set;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mSize;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mSize;
    }
}

