/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.resources;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.resources.LoadedPackage;
import yslelf.cloudpick.graphics.resources.PackAssets;

@ApiStatus.Internal
public class AssetManager {
    public static final int kInvalidCookie = -1;
    public static final int kMaxIterations = 20;
    private PackAssets[] packAssets;
    private final HashMap<String, PackageGroup> packageGroups = new HashMap();

    @Nullable
    private FindEntryResult findEntry(String namespace, String typeString, String entryString) {
        if (namespace == null || namespace.isEmpty() || typeString == null || typeString.isEmpty() || entryString == null || entryString.isEmpty()) {
            return null;
        }
        PackageGroup packageGroup = this.packageGroups.get(namespace);
        if (packageGroup == null) {
            return null;
        }
        return this.findEntryInternal(packageGroup, typeString, entryString);
    }

    @Nullable
    private FindEntryResult findEntryInternal(@NonNull PackageGroup packageGroup, @NonNull String typeString, @NonNull String entryString) {
        int bestCookie = -1;
        LoadedPackage bestPackage = null;
        long bestType = 0L;
        int bestOffset = 0;
        int packageCount = packageGroup.packages.size();
        block0: for (int pi = 0; pi < packageCount; ++pi) {
            LoadedPackage loadedPackage = packageGroup.packages.get(pi);
            int cookie = packageGroup.cookies.getInt(pi);
            int typeIndex = loadedPackage.getTypeStringTable().indexOfString(typeString);
            int entryIndex = loadedPackage.getKeyStringTable().indexOfString(entryString);
            LoadedPackage.TypeSpec typeSpec = loadedPackage.getTypeSpecByTypeIndex(typeIndex);
            if (typeSpec == null) continue;
            for (LoadedPackage.TypeSpec.TypeEntry typeEntry : typeSpec.typeEntries) {
                long type = typeEntry.type;
                int offset = loadedPackage.getEntryOffset(type, entryIndex);
                if (offset == -1) continue;
                bestCookie = cookie;
                bestPackage = loadedPackage;
                bestType = type;
                bestOffset = offset;
                continue block0;
            }
        }
        if (bestCookie == -1) {
            return null;
        }
        long bestEntry = bestPackage.getEntryFromOffset(bestType, bestOffset);
        if (bestEntry == 0L) {
            return null;
        }
        return new FindEntryResult(bestCookie, bestEntry, 0);
    }

    public PackAssets getPackAssets(int cookie) {
        if (cookie < 0 || cookie >= this.packAssets.length) {
            return null;
        }
        return this.packAssets[cookie];
    }

    public static class PackageGroup {
        public final ArrayList<LoadedPackage> packages = new ArrayList();
        public final ArrayList<ArrayList<LoadedPackage.TypeSpec.TypeEntry>[]> filteredConfigs = new ArrayList();
        public final IntArrayList cookies = new IntArrayList();
    }

    public static class FindEntryResult {
        public int cookie;
        public long entry;
        public int typeFlags;

        public FindEntryResult(int cookie, long entry, int typeFlags) {
            this.cookie = cookie;
            this.entry = entry;
            this.typeFlags = typeFlags;
        }

        public void set(FindEntryResult o) {
            this.cookie = o.cookie;
            this.entry = o.entry;
            this.typeFlags = o.typeFlags;
        }
    }

    public static class ResolvedBag {
        public static final int COLUMN_TYPE = 0;
        public static final int COLUMN_DATA = 1;
        public static final int COLUMN_COOKIE = 2;
        public static final int VALUE_COLUMNS = 3;
        public int typeSpecFlags;
        public String[] keys;
        public int[] values;

        public String namespace(int index) {
            return this.keys[index << 1];
        }

        public String attribute(int index) {
            return this.keys[(index << 1) + 1];
        }

        public int type(int index) {
            return this.values[index * 3 + 0];
        }

        public int data(int index) {
            return this.values[index * 3 + 1];
        }

        public int cookie(int index) {
            return this.values[index * 3 + 2];
        }

        public int getEntryCount() {
            assert (this.values == null || this.values.length / 3 == this.keys.length >> 1);
            return this.keys != null ? this.keys.length >> 1 : 0;
        }
    }
}

