/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.resources;

import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.resources.ResourceId;

public abstract class AttributeFinder {
    protected String haystackNamespace;
    protected String haystackAttribute;
    private int start;
    private int end;
    private int current;

    protected abstract void onGetAttribute(int var1);

    public void reset(int start, int end) {
        this.start = start;
        this.end = end;
        this.current = start;
        if (start < end) {
            this.onGetAttribute(start);
        }
    }

    public void clear() {
        this.haystackNamespace = null;
        this.haystackAttribute = null;
    }

    public int find(@NonNull String namespace, @NonNull String attribute) {
        int compare;
        if (this.start >= this.end) {
            return -1;
        }
        assert (this.haystackNamespace != null);
        assert (this.haystackAttribute != null);
        while (this.current != this.end && (compare = ResourceId.comparePair(this.haystackNamespace, this.haystackAttribute, namespace, attribute)) <= 0) {
            ++this.current;
            if (this.current != this.end) {
                this.onGetAttribute(this.current);
            }
            if (compare != 0) continue;
            return this.current - 1;
        }
        return -1;
    }
}

