/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.resources;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import org.lwjgl.system.MemoryUtil;
import yslelf.cloudpick.graphics.resources.ResStringTable;
import yslelf.cloudpick.graphics.resources.ResourceTypes;

public class LoadedPackage {
    ResStringTable typeStringTable;
    ResStringTable keyStringTable;
    Int2ObjectOpenHashMap<TypeSpec> typeSpecs;

    public ResStringTable getTypeStringTable() {
        return this.typeStringTable;
    }

    public ResStringTable getKeyStringTable() {
        return this.keyStringTable;
    }

    public TypeSpec getTypeSpecByTypeIndex(int typeIndex) {
        return (TypeSpec)this.typeSpecs.get(typeIndex + 1);
    }

    public int getEntryOffset(long typeChunk, int entryIndex) {
        int entryCount = ResourceTypes.ResTable_type.entryCount(typeChunk);
        long offsets = typeChunk + (long)ResourceTypes.ResTable_type.headerSize(typeChunk);
        if ((ResourceTypes.ResTable_type.flags(typeChunk) & 1) != 0) {
            int low = 0;
            int high = entryCount - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                long entry = offsets + (long)mid * 8L;
                if (ResourceTypes.ResTable_sparseTypeEntry.index(entry) < entryIndex) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
            if (low == entryCount) {
                return -1;
            }
            long entry = offsets + (long)low * 8L;
            if (ResourceTypes.ResTable_sparseTypeEntry.index(entry) != entryIndex) {
                return -1;
            }
            return ResourceTypes.ResTable_sparseTypeEntry.offset(entry);
        }
        if (entryIndex >= entryCount) {
            return -1;
        }
        return MemoryUtil.memGetInt((long)(offsets + (long)entryIndex * 4L));
    }

    public long getEntryFromOffset(long typeChunk, int entryOffset) {
        long entry = typeChunk + (long)(entryOffset += ResourceTypes.ResTable_type.entriesStart(typeChunk));
        return entry;
    }

    public static class TypeSpec {
        public final long typeSpec;
        public final TypeEntry[] typeEntries;

        public TypeSpec(long typeSpec, List<TypeEntry> typeEntries) {
            this.typeEntries = typeEntries.toArray(new TypeEntry[0]);
            this.typeSpec = typeSpec;
        }

        public static class TypeEntry {
            public final long type;
            public final ResourceTypes.ResTable_config config;

            public TypeEntry(long type) {
                this.config = new ResourceTypes.ResTable_config(ResourceTypes.ResTable_type.pConfig(type));
                this.type = type;
            }
        }
    }
}

