/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.resources;

import it.unimi.dsi.fastutil.HashCommon;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.MathUtil;

public class ResStringTable {
    private String[] key;
    private int mask;
    private int maxFill;
    private int size;
    private static final float LOAD_FACTOR = 0.75f;

    public ResStringTable() {
        this(16);
    }

    public ResStringTable(int expected) {
        int n2 = HashCommon.arraySize((int)expected, (float)0.75f);
        this.mask = n2 - 1;
        this.maxFill = HashCommon.maxFill((int)n2, (float)0.75f);
        this.key = new String[n2];
    }

    private ResStringTable(@NonNull String[] key, int size) {
        int n2 = key.length;
        this.mask = n2 - 1;
        this.maxFill = HashCommon.maxFill((int)n2, (float)0.75f);
        this.key = key;
        this.size = size;
    }

    @NonNull
    public static ResStringTable wrap(@NonNull String[] key, int size) {
        if (!MathUtil.isPow2(key.length)) {
            throw new IllegalArgumentException();
        }
        return new ResStringTable(key, size);
    }

    public String addOrGet(@NonNull String k) {
        String[] key = this.key;
        int pos = HashCommon.mix((int)k.hashCode()) & this.mask;
        String curr = key[pos];
        if (curr != null) {
            if (curr.equals(k)) {
                return curr;
            }
            while ((curr = key[pos = pos + 1 & this.mask]) != null) {
                if (!curr.equals(k)) continue;
                return curr;
            }
        }
        key[pos] = k;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize((int)(this.size + 1), (float)0.75f));
        }
        return k;
    }

    public int indexOfString(@NonNull CharSequence k) {
        String[] key = this.key;
        int pos = HashCommon.mix((int)k.hashCode()) & this.mask;
        String curr = key[pos];
        if (curr == null) {
            return -1;
        }
        if (k.equals(curr)) {
            return pos;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != null) continue;
            return -1;
        } while (!k.equals(curr));
        return pos;
    }

    public String stringAt(int pos) {
        return this.key[pos];
    }

    private void rehash(int newN) {
        String[] key = this.key;
        int mask = newN - 1;
        String[] newKey = new String[newN];
        int i = key.length;
        int j = this.size;
        while (j-- != 0) {
            while (key[--i] == null) {
            }
            int pos = HashCommon.mix((int)key[i].hashCode()) & mask;
            if (newKey[pos] != null) {
                while (newKey[pos = pos + 1 & mask] != null) {
                }
            }
            newKey[pos] = key[i];
        }
        this.mask = mask;
        this.maxFill = HashCommon.maxFill((int)newN, (float)0.75f);
        this.key = newKey;
    }
}

