/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.resources;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.Contract;
import yslelf.cloudpick.graphics.annotation.NonNull;

@Immutable
public record ResourceId(@NonNull String namespace, @NonNull String type, @NonNull String entry) implements Comparable<ResourceId>
{
    public ResourceId(@NonNull String namespace, @NonNull String type, @NonNull String entry) {
        this.namespace = Objects.requireNonNull(namespace);
        this.type = Objects.requireNonNull(type);
        this.entry = Objects.requireNonNull(entry);
    }

    @NonNull
    @Contract(value="_ -> new")
    public static ResourceId parse(@NonNull String name) {
        return ResourceId.parse(name, "", "");
    }

    @NonNull
    @Contract(value="_, _, _ -> new")
    public static ResourceId parse(@NonNull String name, @NonNull String fallbackType, @NonNull String fallbackNamespace) {
        String namespace = null;
        String type = null;
        int start = 0;
        int end = name.length();
        if (start != end && name.charAt(start) == '@') {
            ++start;
        }
        for (int current = start; current != end; ++current) {
            char c = name.charAt(current);
            if (type == null && c == '/') {
                type = name.substring(start, current);
                start = current + 1;
                continue;
            }
            if (namespace != null || c != ':') continue;
            namespace = name.substring(start, current);
            start = current + 1;
        }
        if (type == null) {
            type = fallbackType;
        }
        if (namespace == null) {
            namespace = fallbackNamespace;
        }
        return new ResourceId(namespace, type, name.substring(start, end));
    }

    @NonNull
    @Contract(value="_, _ -> new")
    public static ResourceId attr(@NonNull String namespace, @NonNull String name) {
        return new ResourceId(namespace, "attr", name);
    }

    @Override
    @NonNull
    @Contract(pure=true)
    public String toString() {
        return this.namespace.isEmpty() ? this.type + "/" + this.entry : this.namespace + ":" + this.type + "/" + this.entry;
    }

    @NonNull
    @Contract(pure=true)
    public static String toString(@NonNull String namespace, @NonNull String type, @NonNull String entry) {
        return namespace.isEmpty() ? type + "/" + entry : namespace + ":" + type + "/" + entry;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ResourceId) {
            ResourceId that = (ResourceId)object;
            return this.type.equals(that.type) && this.entry.equals(that.entry) && this.namespace.equals(that.namespace);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.entry.hashCode();
        return result;
    }

    @Override
    public int compareTo(@NonNull ResourceId o) {
        int result = this.namespace.compareTo(o.namespace);
        if (result == 0) {
            result = this.type.compareTo(o.type);
        }
        if (result == 0) {
            result = this.entry.compareTo(o.entry);
        }
        return result;
    }

    public static int comparePair(@NonNull String lhsNamespace, @NonNull String lhsName, @NonNull String rhsNamespace, @NonNull String rhsName) {
        int res = lhsNamespace == rhsNamespace ? 0 : lhsNamespace.compareTo(rhsNamespace);
        return res != 0 ? res : lhsName.compareTo(rhsName);
    }
}

