/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.resources;

import javax.xml.stream.XMLStreamReader;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.resources.Resource;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.resources.ResourceValues;

public class ResourceUtils {
    @Nullable
    public static String findAttribute(@NonNull XMLStreamReader reader, @NonNull String name) {
        String res = reader.getAttributeValue(null, name);
        if (res != null) {
            return res.trim();
        }
        return null;
    }

    @Nullable
    public static String findNonEmptyAttribute(@NonNull XMLStreamReader reader, @NonNull String name) {
        String trim;
        String res = reader.getAttributeValue(null, name);
        if (res != null && !(trim = res.trim()).isEmpty()) {
            return trim;
        }
        return null;
    }

    @NonNull
    public static ResourceValues.Reference parseXmlAttributeName(@NonNull String s) {
        String entry;
        String namespace;
        int i;
        String name = s.trim();
        int start = 0;
        ResourceValues.Reference ref = new ResourceValues.Reference();
        if (!name.isEmpty() && name.charAt(0) == '*') {
            ref.private_reference = true;
            ++start;
        }
        if ((i = name.indexOf(58, start)) >= 0) {
            namespace = name.substring(0, i);
            entry = name.substring(i + 1);
        } else {
            namespace = "";
            entry = name.substring(start);
        }
        ref.name = new ResourceId(namespace, Resource.getTypeName(0), entry);
        return ref;
    }

    public static int indexOfAttribute(@NonNull String[] keys, @NonNull String namespace, @NonNull String attribute) {
        assert ((keys.length & 1) == 0);
        int low = 0;
        int high = (keys.length >> 1) - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = ResourceId.comparePair(keys[mid << 1], keys[(mid << 1) + 1], namespace, attribute);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }
}

