/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.resources;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.resources.AssetManager;
import yslelf.cloudpick.graphics.resources.BagAttributeFinder;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.resources.TypedArray;
import yslelf.cloudpick.graphics.resources.TypedValue;
import yslelf.cloudpick.graphics.util.AttributeSet;
import yslelf.cloudpick.graphics.util.ColorStateList;
import yslelf.cloudpick.graphics.util.DisplayMetrics;
import yslelf.cloudpick.graphics.util.Pools;

@ApiStatus.Experimental
public class Resources {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Resources");
    public static final String DEFAULT_NAMESPACE = "modernui";
    private final DisplayMetrics mMetrics = new DisplayMetrics();
    final Pools.SynchronizedPool<TypedArray> mTypedArrayPool = new Pools.SynchronizedPool(5);
    String[] mNamespaces = new String[]{"modernui"};
    String[] mTypeStrings;
    String[] mKeyStrings;
    Object[] mGlobalObjects;
    String[] mStyleKeys;
    int[] mStyleOffsets;
    static final int MAP_ENTRY_HEADER_COLUMNS = 2;
    static final int MAP_COLUMNS = 3;
    static final int MAP_ENTRY_PARENT = 0;
    static final int MAP_ENTRY_COUNT = 1;
    static final int MAP_ENTRY_ENTRIES = 2;
    static final int MAP_NAME = 0;
    static final int MAP_DATA_TYPE = 1;
    static final int MAP_DATA = 2;
    int[] mData;
    Object2ObjectOpenHashMap<String, AssetManager.ResolvedBag> mCachedBags = new Object2ObjectOpenHashMap();

    public Resources() {
        this.mMetrics.setToDefaults();
    }

    @ApiStatus.Internal
    public void updateMetrics(DisplayMetrics metrics) {
        if (metrics != null) {
            this.mMetrics.setTo(metrics);
        }
    }

    public final Theme newTheme() {
        return new Theme();
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mMetrics;
    }

    public void getValue(@NonNull ResourceId id2, @NonNull TypedValue outValue, boolean resolveRefs) {
        this.getValue(id2.namespace(), id2.type(), id2.entry(), outValue, resolveRefs);
    }

    void getValue(@NonNull CharSequence namespace, @NonNull CharSequence typeName, @NonNull CharSequence entryName, @NonNull TypedValue outValue, boolean resolveRefs) {
    }

    @Nullable
    CharSequence getPooledStringForCookie(int cookie, int id2) {
        if (cookie == 0 && id2 >= 0 && id2 < this.mGlobalObjects.length) {
            return (CharSequence)this.mGlobalObjects[id2];
        }
        return null;
    }

    @Nullable
    String getNamespaceForCookie(int cookie, int id2) {
        if (cookie == 0 && id2 >= 0 && id2 < this.mNamespaces.length) {
            return this.mNamespaces[id2];
        }
        return null;
    }

    @Nullable
    String getTypeStringForCookie(int cookie, int id2) {
        if (cookie == 0 && id2 >= 0 && id2 < this.mTypeStrings.length) {
            return this.mTypeStrings[id2];
        }
        return null;
    }

    @Nullable
    String getKeyStringForCookie(int cookie, int id2) {
        if (cookie == 0 && id2 >= 0 && id2 < this.mKeyStrings.length) {
            return this.mKeyStrings[id2];
        }
        return null;
    }

    @Nullable
    ResourceId getReferenceIdForCookie(int cookie, int typeId, int data) {
        assert (typeId > 0);
        String namespace = this.getNamespaceForCookie(cookie, data >>> 24);
        String typeName = this.getTypeStringForCookie(cookie, typeId - 1);
        String entryName = this.getKeyStringForCookie(cookie, data & 0xFFFFFF);
        if (namespace != null && typeName != null && entryName != null) {
            return new ResourceId(namespace, typeName, entryName);
        }
        return null;
    }

    @Nullable
    ResourceId getAttributeIdForCookie(int cookie, int data) {
        String namespace = this.getNamespaceForCookie(cookie, data >>> 24);
        String attribute = this.getKeyStringForCookie(cookie, data & 0xFFFFFF);
        if (namespace != null && attribute != null) {
            return ResourceId.attr(namespace, attribute);
        }
        return null;
    }

    @NonNull
    public ColorStateList getColorStateList(@NonNull ResourceId id2, @Nullable Theme theme) {
        TypedValue value = new TypedValue();
        this.getValue(id2, value, true);
        return this.loadColorStateList(value, id2, theme);
    }

    @NonNull
    public ColorStateList loadColorStateList(@NonNull TypedValue value, @Nullable Theme theme) {
        return this.loadColorStateList(value, null, theme);
    }

    ColorStateList loadColorStateList(@NonNull TypedValue value, @Nullable ResourceId id2, @Nullable Theme theme) {
        if (value.type >= 28 && value.type <= 31) {
            return ColorStateList.valueOf(value.data);
        }
        if (value.type == 15) {
            Object object = this.mGlobalObjects[value.data];
            if (object instanceof BiFunction && (object = ((BiFunction)object).apply(this, theme)) instanceof ColorStateList) {
                return (ColorStateList)object;
            }
            throw new NotFoundException("Resource is not a color: " + value);
        }
        String name = id2 != null ? id2.toString() : "(missing name)";
        throw new NotFoundException("Can't find ColorStateList from drawable " + name);
    }

    Drawable loadDrawable(@NonNull TypedValue value, @Nullable ResourceId id2, @Nullable Theme theme) {
        try {
            if (value.type == 15) {
                Object object = this.mGlobalObjects[value.data];
                if (object instanceof BiFunction) {
                    if ((object = ((BiFunction)object).apply(this, theme)) == null) {
                        return null;
                    }
                    if (object instanceof Drawable) {
                        return (Drawable)object;
                    }
                }
                throw new NotFoundException("Resource is not a drawable: " + value);
            }
            return null;
        }
        catch (Exception e) {
            String name = id2 != null ? id2.toString() : "(missing name)";
            NotFoundException nfe = new NotFoundException("Drawable " + name, e);
            nfe.setStackTrace(new StackTraceElement[0]);
            throw nfe;
        }
    }

    AssetManager.ResolvedBag getBag(@NonNull ResourceId resId) {
        return this.getBag(resId.entry());
    }

    AssetManager.ResolvedBag getBag(@NonNull String style2) {
        AssetManager.ResolvedBag cached = (AssetManager.ResolvedBag)this.mCachedBags.get((Object)style2);
        if (cached != null) {
            return cached;
        }
        int entryIndex = Arrays.binarySearch(this.mStyleKeys, style2);
        if (entryIndex < 0) {
            return null;
        }
        int offset = this.mStyleOffsets[entryIndex];
        int[] data = this.mData;
        int parentId = data[offset + 0];
        int entryCount = data[offset + 1];
        offset += 2;
        if (parentId == -1) {
            AssetManager.ResolvedBag bag = new AssetManager.ResolvedBag();
            if (entryCount > 0) {
                String[] keys = new String[entryCount * 2];
                int[] values = new int[entryCount * 3];
                for (int i = 0; i < entryCount; ++i) {
                    keys[i * 2 + 0] = DEFAULT_NAMESPACE;
                    keys[i * 2 + 1] = this.mKeyStrings[data[offset + 0]];
                    values[i * 3 + 0] = data[offset + 1];
                    values[i * 3 + 1] = data[offset + 2];
                    offset += 3;
                }
                bag.keys = keys;
                bag.values = values;
            }
            this.mCachedBags.put((Object)style2, (Object)bag);
            return bag;
        }
        AssetManager.ResolvedBag parentBag = this.getBag(this.mKeyStrings[parentId]);
        if (parentBag == null) {
            CloudPick.LOGGER.error(MARKER, "Failed to find parent '{}' of bag '{}'", (Object)this.mKeyStrings[parentId], (Object)style2);
            return null;
        }
        AssetManager.ResolvedBag newBag = new AssetManager.ResolvedBag();
        int parentCount = parentBag.getEntryCount();
        int maxCount = parentCount + entryCount;
        if (maxCount > 0) {
            String childKey;
            String[] newKeys = new String[maxCount * 2];
            int[] newValues = new int[maxCount * 3];
            int newIndex = 0;
            String[] parentKeys = parentBag.keys;
            int[] parentValues = parentBag.values;
            int childIndex = 0;
            int childOffset = offset;
            int parentIndex = 0;
            while (childIndex < entryCount && parentIndex < parentCount) {
                childKey = this.mKeyStrings[data[childOffset + 0]];
                String parentKey = parentKeys[parentIndex * 2 + 1];
                int keyCompare = childKey.compareTo(parentKey);
                if (keyCompare <= 0) {
                    newKeys[newIndex * 2 + 0] = DEFAULT_NAMESPACE;
                    newKeys[newIndex * 2 + 1] = childKey;
                    newValues[newIndex * 3 + 0] = data[childOffset + 1];
                    newValues[newIndex * 3 + 1] = data[childOffset + 2];
                    ++childIndex;
                    childOffset += 3;
                } else {
                    newKeys[newIndex * 2 + 0] = DEFAULT_NAMESPACE;
                    newKeys[newIndex * 2 + 1] = parentKey;
                    System.arraycopy(parentValues, parentIndex * 3, newValues, newIndex * 3, 3);
                }
                assert (newIndex == 0 || newKeys[newIndex * 2 + 1].compareTo(newKeys[(newIndex - 1) * 2 + 1]) >= 0);
                if (keyCompare >= 0) {
                    ++parentIndex;
                }
                ++newIndex;
            }
            while (childIndex < entryCount) {
                childKey = this.mKeyStrings[data[childOffset + 0]];
                newKeys[newIndex * 2 + 0] = DEFAULT_NAMESPACE;
                newKeys[newIndex * 2 + 1] = childKey;
                newValues[newIndex * 3 + 0] = data[childOffset + 1];
                newValues[newIndex * 3 + 1] = data[childOffset + 2];
                ++childIndex;
                childOffset += 3;
                ++newIndex;
            }
            if (parentIndex < parentCount) {
                int numToCopy = parentCount - parentIndex;
                System.arraycopy(parentValues, parentIndex * 3, newValues, newIndex * 3, numToCopy * 3);
                for (int i = 0; i < numToCopy; ++i) {
                    String parentKey = parentKeys[parentIndex * 2 + 1];
                    newKeys[newIndex * 2 + 0] = DEFAULT_NAMESPACE;
                    newKeys[newIndex * 2 + 1] = parentKey;
                    ++parentIndex;
                    ++newIndex;
                }
            }
            assert (newIndex <= maxCount);
            if (newIndex < maxCount) {
                newKeys = Arrays.copyOf(newKeys, newIndex * 2);
                newValues = Arrays.copyOf(newValues, newIndex * 3);
            }
            newBag.keys = newKeys;
            newBag.values = newValues;
        }
        this.mCachedBags.put((Object)style2, (Object)newBag);
        return newBag;
    }

    public final class Theme {
        private final Object mLock = new Object();
        private final ThemeKey mKey = new ThemeKey();
        private ThemeKey mKeyCopy = this.mKey.clone();
        Object2ObjectOpenHashMap<String, Object2ObjectOpenHashMap<String, Entry>> mEntries;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyStyle(@NonNull ResourceId resId, boolean force) {
            Object object = this.mLock;
            synchronized (object) {
                boolean result = this.applyStyleInternal(resId, force);
                if (!result) {
                    throw new IllegalArgumentException("Failed to apply style " + resId + " to theme");
                }
                this.mKey.append(resId, force);
                this.mKeyCopy = this.mKey.clone();
            }
        }

        private boolean applyStyleInternal(@NonNull ResourceId resId, boolean force) {
            AssetManager.ResolvedBag bag = Resources.this.getBag(resId);
            if (bag == null) {
                return false;
            }
            int entryCount = bag.getEntryCount();
            if (entryCount == 0) {
                return true;
            }
            boolean initial = this.mEntries == null;
            Object2ObjectOpenHashMap newEntries = new Object2ObjectOpenHashMap();
            for (int i = 0; i < entryCount; ++i) {
                Entry existing;
                Object2ObjectOpenHashMap group;
                boolean isUndefined = Theme.isUndefined(bag.type(i), bag.data(i));
                if (!force && isUndefined) continue;
                String namespace = bag.namespace(i);
                String attribute = bag.attribute(i);
                if (!initial && (group = (Object2ObjectOpenHashMap)this.mEntries.get((Object)namespace)) != null && (existing = (Entry)group.get((Object)attribute)) != null) {
                    if (!force && !Theme.isUndefined(existing.type, existing.data)) continue;
                    existing.set(bag, i);
                    continue;
                }
                if (isUndefined) continue;
                Entry entry = new Entry();
                entry.set(bag, i);
                ((Object2ObjectOpenHashMap)newEntries.computeIfAbsent((Object)namespace, Theme::newHashMap)).put((Object)attribute, (Object)entry);
            }
            if (initial) {
                this.mEntries = newEntries;
            } else {
                ObjectIterator it = newEntries.object2ObjectEntrySet().fastIterator();
                while (it.hasNext()) {
                    Object2ObjectMap.Entry group = (Object2ObjectMap.Entry)it.next();
                    ((Object2ObjectOpenHashMap)this.mEntries.computeIfAbsent((Object)((String)group.getKey()), Theme::newHashMap)).putAll((Map)group.getValue());
                }
            }
            return true;
        }

        private static <K, V, X> Object2ObjectOpenHashMap<K, V> newHashMap(X __) {
            return new Object2ObjectOpenHashMap();
        }

        @NonNull
        public TypedArray obtainStyledAttributes(@NonNull String[] attrs) {
            return this.obtainStyledAttributes(null, null, null, attrs);
        }

        @NonNull
        public TypedArray obtainStyledAttributes(@Nullable ResourceId resId, @NonNull String[] attrs) {
            return this.obtainStyledAttributes(null, null, resId, attrs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public TypedArray obtainStyledAttributes(@Nullable AttributeSet set, @Nullable ResourceId defStyleAttr, @Nullable ResourceId defStyleRes, @NonNull String[] attrs) {
            assert (defStyleAttr == null || defStyleAttr.type().equals("attr"));
            assert ((attrs.length & 1) == 0);
            int len = attrs.length >> 1;
            TypedArray array = TypedArray.obtain(this.getResources(), len);
            Object object = this.mLock;
            synchronized (object) {
                this.applyStyle(set, defStyleAttr, defStyleRes, attrs, array.mData, array.mIndices, array.mValue, array.mDefStyleAttrFinder);
            }
            array.mDefStyleAttrFinder.clear();
            array.mTheme = this;
            return array;
        }

        public boolean resolveAttribute(@NonNull ResourceId resId, @NonNull TypedValue outValue, boolean resolveRefs) {
            assert (resId.type().equals("attr"));
            return this.resolveAttribute(resId.namespace(), resId.entry(), outValue, resolveRefs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean resolveAttribute(@NonNull String namespace, @NonNull String attribute, @NonNull TypedValue outValue, boolean resolveRefs) {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.getAttribute(namespace, attribute, outValue)) {
                    return false;
                }
                int cookie = outValue.cookie;
                assert (cookie >= 0);
                if (resolveRefs) {
                    // empty if block
                }
                switch (outValue.type & 0xFF) {
                    case 3: {
                        outValue.object = Resources.this.getPooledStringForCookie(outValue.cookie, outValue.data);
                        if (outValue.object != null) break;
                        return false;
                    }
                    case 1: {
                        int typeId = outValue.type >>> 8;
                        if (typeId != 0) {
                            outValue.type = 1;
                            outValue.object = Resources.this.getReferenceIdForCookie(cookie, typeId, outValue.data);
                            if (outValue.object != null) break;
                            return false;
                        }
                        outValue.object = null;
                        break;
                    }
                    case 2: {
                        outValue.object = Resources.this.getAttributeIdForCookie(outValue.cookie, outValue.data);
                        if (outValue.object != null) break;
                        return false;
                    }
                    default: {
                        outValue.object = null;
                    }
                }
                return true;
            }
        }

        static boolean isUndefined(int type, int data) {
            return type == 0 && data != 1;
        }

        boolean getAttribute(@NonNull String namespace, @NonNull String attribute, @NonNull TypedValue outValue) {
            if (this.mEntries == null) {
                return false;
            }
            int typeSpecFlags = 0;
            for (int __ = 0; __ < 20; ++__) {
                Entry e;
                Object2ObjectOpenHashMap group = (Object2ObjectOpenHashMap)this.mEntries.get((Object)namespace);
                if (group == null || (e = (Entry)group.get((Object)attribute)) == null) {
                    return false;
                }
                if (Theme.isUndefined(e.type, e.data)) {
                    return false;
                }
                typeSpecFlags |= e.typeSpecFlags;
                if (e.type != 2) {
                    outValue.cookie = e.cookie;
                    outValue.flags = typeSpecFlags;
                    outValue.type = e.type;
                    outValue.data = e.data;
                    return true;
                }
                namespace = Resources.this.mNamespaces[e.data >>> 24];
                attribute = Resources.this.mKeyStrings[e.data & 0xFFFFFF];
            }
            return false;
        }

        boolean resolveAttributeReference(@NonNull TypedValue value) {
            if (value.type != 2) {
                return true;
            }
            int flags = value.flags;
            String namespace = Resources.this.mNamespaces[value.data >>> 24];
            String attribute = Resources.this.mKeyStrings[value.data & 0xFFFFFF];
            if (!this.getAttribute(namespace, attribute, value)) {
                return false;
            }
            value.flags |= flags;
            return true;
        }

        void applyStyle(@Nullable AttributeSet set, @Nullable ResourceId defStyleAttr, @Nullable ResourceId defStyleRes, @NonNull String[] attrs, @NonNull int[] outValues, @NonNull int[] outIndices, @NonNull TypedValue value, @NonNull BagAttributeFinder defStyleAttrFinder) {
            AssetManager.ResolvedBag defStyleBag = null;
            if (defStyleAttr != null && this.getAttribute(defStyleAttr.namespace(), defStyleAttr.entry(), value)) {
                defStyleBag = Resources.this.getBag(Resources.this.mKeyStrings[value.data]);
            }
            if (defStyleBag == null && defStyleRes != null) {
                defStyleBag = Resources.this.getBag(defStyleRes);
            }
            defStyleAttrFinder.reset(defStyleBag);
            int valuesIdx = 0;
            int indicesIdx = 0;
            for (int ii = 0; ii < attrs.length; ii += 2) {
                String curNs = attrs[ii];
                String curAttr = attrs[ii + 1];
                value.reset();
                int defAttrIdx = defStyleAttrFinder.find(curNs, curAttr);
                if (defAttrIdx != -1) {
                    assert (defStyleBag != null);
                    value.setTo(defStyleBag, defAttrIdx);
                }
                if (value.type != 0) {
                    this.resolveAttributeReference(value);
                } else if (value.data == 1 || this.getAttribute(curNs, curAttr, value)) {
                    // empty if block
                }
                outValues[valuesIdx + 0] = value.type;
                outValues[valuesIdx + 1] = value.data;
                outValues[valuesIdx + 2] = value.cookie;
                outValues[valuesIdx + 3] = value.flags;
                if (value.type != 0 || value.data == 1) {
                    outIndices[++indicesIdx] = ii >> 1;
                }
                valuesIdx += 4;
            }
            outIndices[0] = indicesIdx;
        }

        public Resources getResources() {
            return Resources.this;
        }

        @NonNull
        @Contract(pure=true)
        @ApiStatus.Internal
        public String[] getTheme() {
            ThemeKey key = this.getKey();
            int n2 = key.mForce != null ? key.mForce.length : 0;
            String[] themes = new String[n2 * 2];
            int i = 0;
            int j = n2 - 1;
            while (i < themes.length) {
                themes[i] = key.mResId[j].toString();
                themes[i + 1] = key.mForce[j] ? "forced" : "not forced";
                i += 2;
                --j;
            }
            return themes;
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Theme other = (Theme)o;
            return this.getKey().equals(other.getKey());
        }

        @NonNull
        public String toString() {
            return "{Themes=" + Arrays.deepToString(this.getTheme()) + "}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ThemeKey getKey() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mKeyCopy;
            }
        }

        static class Entry {
            int type;
            int data;
            int cookie;
            int typeSpecFlags;

            Entry() {
            }

            void set(@NonNull AssetManager.ResolvedBag bag, int index) {
                int offset = index * 3;
                this.type = bag.values[offset + 0];
                this.data = bag.values[offset + 1];
                this.cookie = bag.values[offset + 2];
                this.typeSpecFlags = bag.typeSpecFlags;
            }
        }
    }

    public static class NotFoundException
    extends RuntimeException {
        public NotFoundException() {
        }

        public NotFoundException(String message) {
            super(message);
        }

        public NotFoundException(String message, Exception cause) {
            super(message, cause);
        }
    }

    static final class ThemeKey
    implements Cloneable {
        Object[] mResId;
        boolean[] mForce;
        private transient int mHashCode = 0;

        ThemeKey() {
        }

        private int findValue(@NonNull ResourceId resId, boolean force) {
            int count = this.mForce != null ? this.mForce.length : 0;
            for (int i = 0; i < count; ++i) {
                if (this.mForce[i] != force || !resId.equals(this.mResId[i])) continue;
                return i;
            }
            return -1;
        }

        private void moveToLast(int index) {
            int count = this.mForce.length;
            if (index < 0 || index >= count - 1) {
                return;
            }
            Object resId = this.mResId[index];
            boolean force = this.mForce[index];
            Object[] newResId = new Object[count];
            System.arraycopy(this.mResId, 0, newResId, 0, index);
            System.arraycopy(this.mResId, index + 1, newResId, index, count - index - 1);
            newResId[count - 1] = resId;
            this.mResId = newResId;
            boolean[] newForce = new boolean[count];
            System.arraycopy(this.mForce, 0, newForce, 0, index);
            System.arraycopy(this.mForce, index + 1, newForce, index, count - index - 1);
            newForce[count - 1] = force;
            this.mForce = newForce;
            this.mHashCode = 0;
            for (int i = 0; i < count; ++i) {
                this.mHashCode = 31 * this.mHashCode + newResId[i].hashCode();
                this.mHashCode = 31 * this.mHashCode + (newForce[i] ? 1 : 0);
            }
        }

        public void append(@NonNull ResourceId resId, boolean force) {
            int index = this.findValue(resId, force);
            if (index >= 0) {
                this.moveToLast(index);
            } else {
                int newCount = this.mForce != null ? this.mForce.length + 1 : 1;
                Object[] newResId = this.mResId == null ? new Object[newCount] : Arrays.copyOf(this.mResId, newCount);
                newResId[newCount - 1] = resId;
                this.mResId = newResId;
                boolean[] newForce = this.mForce == null ? new boolean[newCount] : Arrays.copyOf(this.mForce, newCount);
                newForce[newCount - 1] = force;
                this.mForce = newForce;
                this.mHashCode = 31 * this.mHashCode + resId.hashCode();
                this.mHashCode = 31 * this.mHashCode + (force ? 1 : 0);
            }
        }

        public void setTo(@NonNull ThemeKey other) {
            this.mResId = other.mResId;
            this.mForce = other.mForce;
            this.mHashCode = other.mHashCode;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThemeKey t2 = (ThemeKey)o;
            if (!Arrays.equals(this.mForce, t2.mForce)) {
                return false;
            }
            return Arrays.equals(this.mResId, t2.mResId);
        }

        public ThemeKey clone() {
            try {
                return (ThemeKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

