/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.resources;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.resources.TypedValue;
import yslelf.cloudpick.graphics.util.ColorStateList;
import yslelf.cloudpick.render.engine.TopologicalSort;

@ApiStatus.Internal
public class ResourcesBuilder {
    Object2IntOpenHashMap<String> mTypeStringTable = new Object2IntOpenHashMap();
    ArrayList<String> mTypeStringArray = new ArrayList();
    ToIntFunction<String> mTypeStringMapper = k -> {
        int index = this.mTypeStringArray.size();
        this.mTypeStringArray.add((String)k);
        return index;
    };
    Object2IntOpenHashMap<String> mKeyStringTable = new Object2IntOpenHashMap();
    ArrayList<String> mKeyStringArray = new ArrayList();
    ToIntFunction<String> mKeyStringMapper = k -> {
        int index = this.mKeyStringArray.size();
        this.mKeyStringArray.add((String)k);
        return index;
    };
    Object2IntOpenHashMap<Object> mGlobalObjectTable = new Object2IntOpenHashMap();
    ArrayList<Object> mGlobalObjectArray = new ArrayList();
    ToIntFunction<Object> mGlobalObjectMapper = k -> {
        int index = this.mGlobalObjectArray.size();
        this.mGlobalObjectArray.add(k);
        return index;
    };
    HashMap<String, Style> mStyleTable = new HashMap();
    Object2IntOpenHashMap<String> mStyleToOffset = new Object2IntOpenHashMap();

    public ResourcesBuilder() {
        this.mTypeStringTable.defaultReturnValue(-1);
        this.mKeyStringTable.defaultReturnValue(-1);
        this.mGlobalObjectTable.defaultReturnValue(-1);
        this.mStyleToOffset.defaultReturnValue(-1);
    }

    int storeTypeString(String type) {
        return this.mTypeStringTable.computeIfAbsent((Object)type, this.mTypeStringMapper);
    }

    int storeKeyString(String key) {
        return this.mKeyStringTable.computeIfAbsent((Object)key, this.mKeyStringMapper);
    }

    String dedupKeyString(String key) {
        return this.mKeyStringArray.get(this.storeKeyString(key));
    }

    int storeGlobalObject(Object o) {
        return this.mGlobalObjectTable.computeIfAbsent(o, this.mGlobalObjectMapper);
    }

    public Style newStyle(@NonNull String name, @NonNull String parent) {
        Style builder;
        if (name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        name = this.dedupKeyString(name);
        if (!parent.isEmpty()) {
            parent = this.dedupKeyString(parent);
        }
        if (this.mStyleTable.putIfAbsent(name, builder = new Style(name, parent)) == null) {
            return builder;
        }
        throw new IllegalStateException("style is already defined");
    }

    public Resources build() {
        Resources resources = new Resources();
        resources.mTypeStrings = this.mTypeStringArray.toArray(new String[0]);
        this.mTypeStringArray = null;
        resources.mKeyStrings = this.mKeyStringArray.toArray(new String[0]);
        this.mKeyStringArray = null;
        this.mGlobalObjectTable = null;
        resources.mGlobalObjects = this.mGlobalObjectArray.toArray();
        this.mGlobalObjectArray = null;
        ArrayList<Style> styles = new ArrayList<Style>(this.mStyleTable.values());
        TopologicalSort.topologicalSort(styles, Style.TOPOSORT_TRAIT);
        int dataCount = 0;
        for (int i = 0; i < styles.size(); ++i) {
            Style style2 = styles.get(i);
            if (!style2.mParent.isEmpty() && this.mStyleTable.get(style2.mParent) == null) {
                throw new IllegalStateException("parent style not found");
            }
            style2.mEntries.sort(Style.STYLE_ENTRY_COMPARATOR);
            dataCount += 2 + 3 * style2.mEntries.size();
        }
        this.mStyleTable = null;
        int[] data = new int[dataCount];
        int index = 0;
        for (int i = 0; i < styles.size(); ++i) {
            Style style3 = styles.get(i);
            this.mStyleToOffset.put((Object)style3.mName, index);
            data[index + 0] = !style3.mParent.isEmpty() ? this.mKeyStringTable.getInt((Object)style3.mParent) : -1;
            data[index + 1] = style3.mEntries.size();
            index += 2;
            ArrayList<Style.Entry> entries = style3.mEntries;
            for (int j = 0; j < entries.size(); ++j) {
                Style.Entry entry = entries.get(j);
                data[index + 0] = this.mKeyStringTable.getInt((Object)entry.attr);
                data[index + 1] = entry.dataType;
                data[index + 2] = entry.data;
                index += 3;
            }
        }
        assert (index == dataCount);
        resources.mData = data;
        this.mKeyStringTable = null;
        Object2IntMap.Entry[] entries = (Object2IntMap.Entry[])this.mStyleToOffset.object2IntEntrySet().toArray((Object[])new Object2IntMap.Entry[0]);
        Arrays.sort(entries, Map.Entry.comparingByKey());
        String[] styleKeys = new String[entries.length];
        int[] styleOffsets = new int[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            styleKeys[i] = (String)entries[i].getKey();
            styleOffsets[i] = entries[i].getIntValue();
        }
        resources.mStyleKeys = styleKeys;
        resources.mStyleOffsets = styleOffsets;
        this.mStyleToOffset = null;
        return resources;
    }

    public class Style {
        static final TopologicalSort.Access<Style> TOPOSORT_TRAIT = new TopologicalSort.Access<Style>(){

            @Override
            public void setIndex(Style node, int index) {
                node.mIndex = index;
            }

            @Override
            public int getIndex(Style node) {
                return node.mIndex;
            }

            @Override
            public void setTempMarked(Style node, boolean marked) {
                node.mTmpMarked = marked;
            }

            @Override
            public boolean isTempMarked(Style node) {
                return node.mTmpMarked;
            }

            @Override
            public Collection<Style> getIncomingEdges(Style node) {
                Style parent;
                if (!node.mParent.isEmpty() && (parent = node.getThemeBuilder().mStyleTable.get(node.mParent)) != null) {
                    return List.of(parent);
                }
                return List.of();
            }
        };
        String mName;
        String mParent;
        final ArrayList<Entry> mEntries = new ArrayList();
        static final Comparator<Entry> STYLE_ENTRY_COMPARATOR = Comparator.comparing(Entry::attr);
        int mIndex = -1;
        boolean mTmpMarked;

        Style(String name, String parent) {
            this.mName = name;
            this.mParent = parent;
        }

        public void addDimension(String attr2, float value, int units) {
            attr2 = ResourcesBuilder.this.dedupKeyString(attr2);
            this.mEntries.add(new Entry(attr2, 5, TypedValue.createComplexDimension(value, units)));
        }

        public void addAttribute(String attr2, @NonNull String target) {
            attr2 = ResourcesBuilder.this.dedupKeyString(attr2);
            this.mEntries.add(new Entry(attr2, 2, ResourcesBuilder.this.storeKeyString(target)));
        }

        public void addReference(String attr2, @Nullable ResourceId target) {
            assert (target == null || target.namespace().equals("modernui"));
            attr2 = ResourcesBuilder.this.dedupKeyString(attr2);
            int typeId = target == null ? 0 : ResourcesBuilder.this.storeTypeString(target.type()) + 1;
            this.mEntries.add(new Entry(attr2, 1 | typeId << 8, target == null ? 0 : ResourcesBuilder.this.storeKeyString(target.entry())));
        }

        public void addBoolean(String attr2, boolean v) {
            attr2 = ResourcesBuilder.this.dedupKeyString(attr2);
            this.mEntries.add(new Entry(attr2, 18, v ? 1 : 0));
        }

        public void addColor(String attr2, int argb) {
            attr2 = ResourcesBuilder.this.dedupKeyString(attr2);
            this.mEntries.add(new Entry(attr2, 28, argb));
        }

        public void addInteger(String attr2, int v) {
            attr2 = ResourcesBuilder.this.dedupKeyString(attr2);
            this.mEntries.add(new Entry(attr2, 16, v));
        }

        public void addEnum(String attr2, int ord) {
            attr2 = ResourcesBuilder.this.dedupKeyString(attr2);
            this.mEntries.add(new Entry(attr2, 16, ord));
        }

        public void addFlags(String attr2, int flags) {
            attr2 = ResourcesBuilder.this.dedupKeyString(attr2);
            this.mEntries.add(new Entry(attr2, 17, flags));
        }

        public void addColor(String attr2, @NonNull BiFunction<Resources, Resources.Theme, ColorStateList> factory) {
            attr2 = ResourcesBuilder.this.dedupKeyString(attr2);
            this.mEntries.add(new Entry(attr2, 15, ResourcesBuilder.this.storeGlobalObject(factory)));
        }

        public void addDrawable(String attr2, @NonNull BiFunction<Resources, Resources.Theme, Drawable> factory) {
            attr2 = ResourcesBuilder.this.dedupKeyString(attr2);
            this.mEntries.add(new Entry(attr2, 15, ResourcesBuilder.this.storeGlobalObject(factory)));
        }

        ResourcesBuilder getThemeBuilder() {
            return ResourcesBuilder.this;
        }

        record Entry(String attr, int dataType, int data) {
        }
    }
}

