/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.resources;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.R;
import yslelf.cloudpick.graphics.graphics.drawable.ColorDrawable;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.graphics.drawable.LayerDrawable;
import yslelf.cloudpick.graphics.graphics.drawable.RippleDrawable;
import yslelf.cloudpick.graphics.graphics.drawable.ScaleDrawable;
import yslelf.cloudpick.graphics.graphics.drawable.ShapeDrawable;
import yslelf.cloudpick.graphics.material.drawable.CircularIndeterminateDrawable;
import yslelf.cloudpick.graphics.material.drawable.LinearIndeterminateDrawable;
import yslelf.cloudpick.graphics.material.drawable.RadioButtonDrawable;
import yslelf.cloudpick.graphics.material.drawable.SeekbarThumbDrawable;
import yslelf.cloudpick.graphics.material.drawable.SwitchThumbDrawable;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.resources.ResourcesBuilder;
import yslelf.cloudpick.graphics.resources.TypedValue;
import yslelf.cloudpick.graphics.util.ColorStateList;
import yslelf.cloudpick.graphics.util.SparseArray;
import yslelf.cloudpick.graphics.util.StateSet;

@ApiStatus.Internal
public class SystemTheme {
    private static final float material_emphasis_disabled = 0.38f;
    private static final float material_emphasis_disabled_background = 0.12f;
    public int colorPrimary;
    public int colorOnPrimary;
    public int colorPrimaryInverse;
    public int colorPrimaryContainer;
    public int colorOnPrimaryContainer;
    public int colorPrimaryFixed;
    public int colorPrimaryFixedDim;
    public int colorOnPrimaryFixed;
    public int colorOnPrimaryFixedVariant;
    public int colorSecondary;
    public int colorOnSecondary;
    public int colorSecondaryContainer;
    public int colorOnSecondaryContainer;
    public int colorSecondaryFixed;
    public int colorSecondaryFixedDim;
    public int colorOnSecondaryFixed;
    public int colorOnSecondaryFixedVariant;
    public int colorTertiary;
    public int colorOnTertiary;
    public int colorTertiaryContainer;
    public int colorOnTertiaryContainer;
    public int colorTertiaryFixed;
    public int colorTertiaryFixedDim;
    public int colorOnTertiaryFixed;
    public int colorOnTertiaryFixedVariant;
    public int colorBackground;
    public int colorOnBackground;
    public int colorSurface;
    public int colorOnSurface;
    public int colorSurfaceVariant;
    public int colorOnSurfaceVariant;
    public int colorSurfaceInverse;
    public int colorOnSurfaceInverse;
    public int colorSurfaceBright;
    public int colorSurfaceDim;
    public int colorSurfaceContainer;
    public int colorSurfaceContainerLow;
    public int colorSurfaceContainerHigh;
    public int colorSurfaceContainerLowest;
    public int colorSurfaceContainerHighest;
    public int colorOutline;
    public int colorOutlineVariant;
    public int colorError;
    public int colorOnError;
    public int colorErrorContainer;
    public int colorOnErrorContainer;
    public ColorStateList textColorPrimary;
    public ColorStateList textColorPrimaryInverse;
    public ColorStateList textColorSecondary;
    public ColorStateList textColorSecondaryInverse;
    public ColorStateList textColorTertiary;
    public ColorStateList textColorTertiaryInverse;
    public ColorStateList textColorPrimaryDisableOnly;
    public ColorStateList textColorPrimaryInverseDisableOnly;
    public ColorStateList textColorHint;
    public ColorStateList textColorHintInverse;
    public int textColorHighlight;
    public int textColorHighlightInverse;
    public ColorStateList textColorLink;
    public ColorStateList textColorLinkInverse;
    public ColorStateList textColorAlertDialogListItem;
    public boolean isDark;
    @GuardedBy(value="self")
    static final Object2ObjectOpenHashMap<Resources.ThemeKey, ThemedCache> gCache = new Object2ObjectOpenHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T fromCache(Resources.Theme theme, Function<ThemedCache, T> fn) {
        Object2ObjectOpenHashMap<Resources.ThemeKey, ThemedCache> object2ObjectOpenHashMap = gCache;
        synchronized (object2ObjectOpenHashMap) {
            ThemedCache cache = (ThemedCache)gCache.get((Object)theme.getKey());
            if (cache == null) {
                cache = new ThemedCache(theme);
                gCache.put((Object)theme.getKey(), (Object)cache);
            }
            return fn.apply(cache);
        }
    }

    static int dp(float value, Resources resources) {
        float f2 = TypedValue.applyDimension(1, value, resources.getDisplayMetrics());
        int res = (int)(f2 >= 0.0f ? f2 + 0.5f : f2 - 0.5f);
        if (res != 0) {
            return res;
        }
        if (value == 0.0f) {
            return 0;
        }
        if (value > 0.0f) {
            return 1;
        }
        return -1;
    }

    public static void addToResources(ResourcesBuilder b) {
        SystemTheme.addStylesToResources(b);
        SystemTheme t2 = SystemTheme.createMaterial(true);
        ResourcesBuilder.Style style2 = b.newStyle(R.style.Theme_Material3_Dark.entry(), "");
        style2.addBoolean("isLightTheme", false);
        SystemTheme.addColorsToTheme(t2, style2);
        style2.addReference("textAppearanceDisplayLarge", R.style.TextAppearance_Material3_DisplayLarge);
        style2.addReference("textAppearanceDisplayMedium", R.style.TextAppearance_Material3_DisplayMedium);
        style2.addReference("textAppearanceDisplaySmall", R.style.TextAppearance_Material3_DisplaySmall);
        style2.addReference("textAppearanceHeadlineLarge", R.style.TextAppearance_Material3_HeadlineLarge);
        style2.addReference("textAppearanceHeadlineMedium", R.style.TextAppearance_Material3_HeadlineMedium);
        style2.addReference("textAppearanceHeadlineSmall", R.style.TextAppearance_Material3_HeadlineSmall);
        style2.addReference("textAppearanceTitleLarge", R.style.TextAppearance_Material3_TitleLarge);
        style2.addReference("textAppearanceTitleMedium", R.style.TextAppearance_Material3_TitleMedium);
        style2.addReference("textAppearanceTitleSmall", R.style.TextAppearance_Material3_TitleSmall);
        style2.addReference("textAppearanceBodyLarge", R.style.TextAppearance_Material3_BodyLarge);
        style2.addReference("textAppearanceBodyMedium", R.style.TextAppearance_Material3_BodyMedium);
        style2.addReference("textAppearanceBodySmall", R.style.TextAppearance_Material3_BodySmall);
        style2.addReference("textAppearanceLabelLarge", R.style.TextAppearance_Material3_LabelLarge);
        style2.addReference("textAppearanceLabelMedium", R.style.TextAppearance_Material3_LabelMedium);
        style2.addReference("textAppearanceLabelSmall", R.style.TextAppearance_Material3_LabelSmall);
        style2.addAttribute("colorEdgeEffect", "colorPrimary");
        style2.addReference("textAppearance", R.style.TextAppearance);
        style2.addReference("textAppearanceInverse", R.style.TextAppearance_Inverse);
        style2.addReference("buttonStyle", R.style.Widget_Material3_Button);
        style2.addReference("radioButtonStyle", R.style.Widget_Material3_CompoundButton_RadioButton);
        style2.addReference("radioButtonStyleMenuItem", R.style.Widget_Material3_CompoundButton_RadioButton_MenuItem);
        style2.addReference("switchStyle", R.style.Widget_Material3_CompoundButton_Switch);
        style2.addReference("progressBarStyle", R.style.Widget_Material3_ProgressBar);
        style2.addReference("progressBarStyleSmall", R.style.Widget_Material3_ProgressBar_Small);
        style2.addReference("progressBarStyleHorizontal", R.style.Widget_Material3_ProgressBar_Horizontal);
        style2.addReference("progressBarStyleVertical", R.style.Widget_Material3_ProgressBar_Vertical);
        style2.addReference("seekBarStyle", R.style.Widget_Material3_SeekBar);
        style2.addReference("popupMenuStyle", R.style.Widget_Material3_PopupMenu);
        style2.addReference("contextPopupMenuStyle", R.style.Widget_Material3_PopupMenu_ContextMenu);
        style2.addReference("listPopupWindowStyle", R.style.Widget_Material3_PopupMenu_ListPopupWindow);
        style2.addReference("spinnerStyle", R.style.Widget_Material3_Spinner);
        t2 = SystemTheme.createMaterial(false);
        style2 = b.newStyle(R.style.Theme_Material3_Light.entry(), "");
        style2.addBoolean("isLightTheme", true);
        SystemTheme.addColorsToTheme(t2, style2);
        style2.addReference("textAppearanceDisplayLarge", R.style.TextAppearance_Material3_DisplayLarge);
        style2.addReference("textAppearanceDisplayMedium", R.style.TextAppearance_Material3_DisplayMedium);
        style2.addReference("textAppearanceDisplaySmall", R.style.TextAppearance_Material3_DisplaySmall);
        style2.addReference("textAppearanceHeadlineLarge", R.style.TextAppearance_Material3_HeadlineLarge);
        style2.addReference("textAppearanceHeadlineMedium", R.style.TextAppearance_Material3_HeadlineMedium);
        style2.addReference("textAppearanceHeadlineSmall", R.style.TextAppearance_Material3_HeadlineSmall);
        style2.addReference("textAppearanceTitleLarge", R.style.TextAppearance_Material3_TitleLarge);
        style2.addReference("textAppearanceTitleMedium", R.style.TextAppearance_Material3_TitleMedium);
        style2.addReference("textAppearanceTitleSmall", R.style.TextAppearance_Material3_TitleSmall);
        style2.addReference("textAppearanceBodyLarge", R.style.TextAppearance_Material3_BodyLarge);
        style2.addReference("textAppearanceBodyMedium", R.style.TextAppearance_Material3_BodyMedium);
        style2.addReference("textAppearanceBodySmall", R.style.TextAppearance_Material3_BodySmall);
        style2.addReference("textAppearanceLabelLarge", R.style.TextAppearance_Material3_LabelLarge);
        style2.addReference("textAppearanceLabelMedium", R.style.TextAppearance_Material3_LabelMedium);
        style2.addReference("textAppearanceLabelSmall", R.style.TextAppearance_Material3_LabelSmall);
        style2.addAttribute("colorEdgeEffect", "colorPrimary");
        style2.addReference("textAppearance", R.style.TextAppearance);
        style2.addReference("textAppearanceInverse", R.style.TextAppearance_Inverse);
        style2.addReference("buttonStyle", R.style.Widget_Material3_Button);
        style2.addReference("radioButtonStyle", R.style.Widget_Material3_CompoundButton_RadioButton);
        style2.addReference("radioButtonStyleMenuItem", R.style.Widget_Material3_CompoundButton_RadioButton_MenuItem);
        style2.addReference("switchStyle", R.style.Widget_Material3_CompoundButton_Switch);
        style2.addReference("progressBarStyle", R.style.Widget_Material3_ProgressBar);
        style2.addReference("progressBarStyleSmall", R.style.Widget_Material3_ProgressBar_Small);
        style2.addReference("progressBarStyleHorizontal", R.style.Widget_Material3_ProgressBar_Horizontal);
        style2.addReference("progressBarStyleVertical", R.style.Widget_Material3_ProgressBar_Vertical);
        style2.addReference("seekBarStyle", R.style.Widget_Material3_SeekBar);
        style2.addReference("popupMenuStyle", R.style.Widget_Material3_PopupMenu);
        style2.addReference("contextPopupMenuStyle", R.style.Widget_Material3_PopupMenu_ContextMenu);
        style2.addReference("listPopupWindowStyle", R.style.Widget_Material3_PopupMenu_ListPopupWindow);
        style2.addReference("spinnerStyle", R.style.Widget_Material3_Spinner);
        t2 = SystemTheme.createDefault(true, 2);
        style2 = b.newStyle(R.style.ThemeOverlay_Material3_Dark_Rust.entry(), "");
        SystemTheme.addColorsToTheme(t2, style2);
        t2 = SystemTheme.createDefault(false, 0);
        style2 = b.newStyle(R.style.ThemeOverlay_Material3_Light_Rust.entry(), "");
        SystemTheme.addColorsToTheme(t2, style2);
    }

    private static void addColorsToTheme(SystemTheme t2, ResourcesBuilder.Style style2) {
        style2.addColor("colorPrimary", t2.colorPrimary);
        style2.addColor("colorOnPrimary", t2.colorOnPrimary);
        style2.addColor("colorPrimaryInverse", t2.colorPrimaryInverse);
        style2.addColor("colorPrimaryContainer", t2.colorPrimaryContainer);
        style2.addColor("colorOnPrimaryContainer", t2.colorOnPrimaryContainer);
        style2.addColor("colorPrimaryFixed", t2.colorPrimaryFixed);
        style2.addColor("colorPrimaryFixedDim", t2.colorPrimaryFixedDim);
        style2.addColor("colorOnPrimaryFixed", t2.colorOnPrimaryFixed);
        style2.addColor("colorOnPrimaryFixedVariant", t2.colorOnPrimaryFixedVariant);
        style2.addColor("colorSecondary", t2.colorSecondary);
        style2.addColor("colorOnSecondary", t2.colorOnSecondary);
        style2.addColor("colorSecondaryContainer", t2.colorSecondaryContainer);
        style2.addColor("colorOnSecondaryContainer", t2.colorOnSecondaryContainer);
        style2.addColor("colorSecondaryFixed", t2.colorSecondaryFixed);
        style2.addColor("colorSecondaryFixedDim", t2.colorSecondaryFixedDim);
        style2.addColor("colorOnSecondaryFixed", t2.colorOnSecondaryFixed);
        style2.addColor("colorOnSecondaryFixedVariant", t2.colorOnSecondaryFixedVariant);
        style2.addColor("colorTertiary", t2.colorTertiary);
        style2.addColor("colorOnTertiary", t2.colorOnTertiary);
        style2.addColor("colorTertiaryContainer", t2.colorTertiaryContainer);
        style2.addColor("colorOnTertiaryContainer", t2.colorOnTertiaryContainer);
        style2.addColor("colorTertiaryFixed", t2.colorTertiaryFixed);
        style2.addColor("colorTertiaryFixedDim", t2.colorTertiaryFixedDim);
        style2.addColor("colorOnTertiaryFixed", t2.colorOnTertiaryFixed);
        style2.addColor("colorOnTertiaryFixedVariant", t2.colorOnTertiaryFixedVariant);
        style2.addColor("colorBackground", t2.colorBackground);
        style2.addColor("colorOnBackground", t2.colorOnBackground);
        style2.addColor("colorSurface", t2.colorSurface);
        style2.addColor("colorOnSurface", t2.colorOnSurface);
        style2.addColor("colorSurfaceVariant", t2.colorSurfaceVariant);
        style2.addColor("colorOnSurfaceVariant", t2.colorOnSurfaceVariant);
        style2.addColor("colorSurfaceInverse", t2.colorSurfaceInverse);
        style2.addColor("colorOnSurfaceInverse", t2.colorOnSurfaceInverse);
        style2.addColor("colorSurfaceBright", t2.colorSurfaceBright);
        style2.addColor("colorSurfaceDim", t2.colorSurfaceDim);
        style2.addColor("colorSurfaceContainer", t2.colorSurfaceContainer);
        style2.addColor("colorSurfaceContainerLow", t2.colorSurfaceContainerLow);
        style2.addColor("colorSurfaceContainerHigh", t2.colorSurfaceContainerHigh);
        style2.addColor("colorSurfaceContainerLowest", t2.colorSurfaceContainerLowest);
        style2.addColor("colorSurfaceContainerHighest", t2.colorSurfaceContainerHighest);
        style2.addColor("colorOutline", t2.colorOutline);
        style2.addColor("colorOutlineVariant", t2.colorOutlineVariant);
        style2.addColor("colorError", t2.colorError);
        style2.addColor("colorOnError", t2.colorOnError);
        style2.addColor("colorErrorContainer", t2.colorErrorContainer);
        style2.addColor("colorOnErrorContainer", t2.colorOnErrorContainer);
        style2.addColor("textColorPrimary", (resources, theme) -> t2.textColorPrimary);
        style2.addColor("textColorPrimaryInverse", (resources, theme) -> t2.textColorPrimaryInverse);
        style2.addColor("textColorSecondary", (resources, theme) -> t2.textColorSecondary);
        style2.addColor("textColorSecondaryInverse", (resources, theme) -> t2.textColorSecondaryInverse);
        style2.addColor("textColorPrimaryDisableOnly", (resources, theme) -> t2.textColorPrimaryDisableOnly);
        style2.addColor("textColorPrimaryInverseDisableOnly", (resources, theme) -> t2.textColorPrimaryInverseDisableOnly);
        style2.addColor("textColorHighlight", t2.textColorHighlight);
        style2.addColor("textColorHighlightInverse", t2.textColorHighlightInverse);
        style2.addColor("textColorHint", (resources, theme) -> t2.textColorHint);
        style2.addColor("textColorHintInverse", (resources, theme) -> t2.textColorHintInverse);
        style2.addColor("textColorLink", (resources, theme) -> t2.textColorLink);
        style2.addColor("textColorLinkInverse", (resources, theme) -> t2.textColorLinkInverse);
        style2.addColor("colorControlNormal", t2.colorOnSurfaceVariant);
        style2.addColor("colorControlActivated", t2.colorPrimaryContainer);
        style2.addColor("colorControlHighlight", t2.isDark ? 0x33FFFFFF : 0x1F000000);
    }

    private static void addStylesToResources(ResourcesBuilder b) {
        ResourcesBuilder.Style style2 = b.newStyle(R.style.TextAppearance.entry(), "");
        style2.addAttribute("textColor", "textColorPrimary");
        style2.addAttribute("textColorHint", "textColorHint");
        style2.addAttribute("textColorHighlight", "textColorHighlight");
        style2.addAttribute("textColorLink", "textColorLink");
        style2.addDimension("textSize", 16.0f, 2);
        style2 = b.newStyle(R.style.TextAppearance_Inverse.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorPrimaryInverse");
        style2.addAttribute("textColorHint", "textColorHintInverse");
        style2.addAttribute("textColorHighlight", "textColorHighlightInverse");
        style2.addAttribute("textColorLink", "textColorLinkInverse");
        style2 = b.newStyle(R.style.TextAppearance_Material3_DisplayLarge.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorSecondary");
        style2.addDimension("textSize", 57.0f, 2);
        style2 = b.newStyle(R.style.TextAppearance_Material3_DisplayMedium.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorSecondary");
        style2.addDimension("textSize", 45.0f, 2);
        style2 = b.newStyle(R.style.TextAppearance_Material3_DisplaySmall.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorSecondary");
        style2.addDimension("textSize", 36.0f, 2);
        style2 = b.newStyle(R.style.TextAppearance_Material3_HeadlineLarge.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorSecondary");
        style2.addDimension("textSize", 32.0f, 2);
        style2 = b.newStyle(R.style.TextAppearance_Material3_HeadlineMedium.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorPrimary");
        style2.addDimension("textSize", 28.0f, 2);
        style2 = b.newStyle(R.style.TextAppearance_Material3_HeadlineSmall.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorPrimary");
        style2.addDimension("textSize", 24.0f, 2);
        style2 = b.newStyle(R.style.TextAppearance_Material3_TitleLarge.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorPrimary");
        style2.addDimension("textSize", 22.0f, 2);
        style2 = b.newStyle(R.style.TextAppearance_Material3_TitleMedium.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorPrimary");
        style2.addDimension("textSize", 16.0f, 2);
        style2.addInteger("textFontWeight", 500);
        style2 = b.newStyle(R.style.TextAppearance_Material3_TitleSmall.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorPrimary");
        style2.addDimension("textSize", 14.0f, 2);
        style2.addInteger("textFontWeight", 500);
        style2 = b.newStyle(R.style.TextAppearance_Material3_BodyLarge.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorPrimary");
        style2.addDimension("textSize", 16.0f, 2);
        style2 = b.newStyle(R.style.TextAppearance_Material3_BodyMedium.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorPrimary");
        style2.addDimension("textSize", 14.0f, 2);
        style2 = b.newStyle(R.style.TextAppearance_Material3_BodySmall.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorSecondary");
        style2.addDimension("textSize", 12.0f, 2);
        style2 = b.newStyle(R.style.TextAppearance_Material3_LabelLarge.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorPrimary");
        style2.addDimension("textSize", 14.0f, 2);
        style2.addInteger("textFontWeight", 500);
        style2 = b.newStyle(R.style.TextAppearance_Material3_LabelMedium.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorSecondary");
        style2.addDimension("textSize", 12.0f, 2);
        style2.addInteger("textFontWeight", 500);
        style2 = b.newStyle(R.style.TextAppearance_Material3_LabelSmall.entry(), R.style.TextAppearance.entry());
        style2.addAttribute("textColor", "textColorSecondary");
        style2.addDimension("textSize", 11.0f, 2);
        style2.addInteger("textFontWeight", 500);
        style2 = b.newStyle(R.style.Widget_Material3_Button.entry(), "");
        style2.addDimension("minHeight", 32.0f, 1);
        style2.addDimension("minWidth", 80.0f, 1);
        style2.addBoolean("focusable", true);
        style2.addBoolean("clickable", true);
        style2.addFlags("gravity", 17);
        style2.addDimension("maxWidth", 320.0f, 1);
        style2.addDimension("paddingLeft", 20.0f, 1);
        style2.addDimension("paddingRight", 20.0f, 1);
        style2.addDimension("paddingTop", 2.0f, 1);
        style2.addDimension("paddingBottom", 2.0f, 1);
        style2.addAttribute("textAppearance", "textAppearanceLabelLarge");
        style2.addColor("textColor", (resources, theme) -> SystemTheme.fromCache(theme, cache -> cache.button_foreground_color_selector(cache.colorOnPrimary)));
        style2.addDrawable("background", (resources, theme) -> {
            ColorStateList backgroundTint = SystemTheme.fromCache(theme, cache -> cache.button_background_color_selector(cache.colorPrimary));
            ColorStateList rippleColor = SystemTheme.fromCache(theme, cache -> cache.button_ripple_color_selector(cache.colorOnPrimary));
            ShapeDrawable background = new ShapeDrawable();
            background.setCornerRadius(1000.0f);
            background.setColor(backgroundTint);
            return new RippleDrawable(rippleColor, (Drawable)background, null);
        });
        style2 = b.newStyle(R.style.Widget_Material3_Button_TonalButton.entry(), R.style.Widget_Material3_Button.entry());
        style2.addColor("textColor", (resources, theme) -> SystemTheme.fromCache(theme, cache -> cache.button_foreground_color_selector(cache.colorOnSecondaryContainer)));
        style2.addDrawable("background", (resources, theme) -> {
            ColorStateList backgroundTint = SystemTheme.fromCache(theme, cache -> cache.button_background_color_selector(cache.colorSecondaryContainer));
            ColorStateList rippleColor = SystemTheme.fromCache(theme, cache -> cache.button_ripple_color_selector(cache.colorOnSecondaryContainer));
            ShapeDrawable background = new ShapeDrawable();
            background.setCornerRadius(1000.0f);
            background.setColor(backgroundTint);
            return new RippleDrawable(rippleColor, (Drawable)background, null);
        });
        style2 = b.newStyle(R.style.Widget_Material3_Button_TextButton.entry(), R.style.Widget_Material3_Button.entry());
        style2.addDimension("paddingLeft", 8.0f, 1);
        style2.addDimension("paddingRight", 8.0f, 1);
        style2.addColor("textColor", (resources, theme) -> SystemTheme.fromCache(theme, cache -> cache.text_button_foreground_color_selector(cache.colorPrimary)));
        style2.addDrawable("background", (resources, theme) -> {
            ColorStateList backgroundTint = SystemTheme.fromCache(theme, cache -> cache.text_button_background_color_selector(0));
            ColorStateList rippleColor = SystemTheme.fromCache(theme, cache -> cache.text_button_ripple_color_selector(cache.colorPrimary));
            ShapeDrawable background = new ShapeDrawable();
            background.setCornerRadius(1000.0f);
            background.setColor(backgroundTint);
            return new RippleDrawable(rippleColor, (Drawable)background, null);
        });
        style2 = b.newStyle(R.style.Widget_Material3_Button_OutlinedButton.entry(), R.style.Widget_Material3_Button.entry());
        style2.addColor("textColor", (resources, theme) -> SystemTheme.fromCache(theme, cache -> cache.text_button_foreground_color_selector(cache.colorPrimary)));
        style2.addDrawable("background", (resources, theme) -> {
            ColorStateList backgroundTint = SystemTheme.fromCache(theme, cache -> cache.text_button_background_color_selector(0));
            ColorStateList rippleColor = SystemTheme.fromCache(theme, cache -> cache.text_button_ripple_color_selector(cache.colorPrimary));
            int strokeWidth = SystemTheme.dp(1.0f, resources);
            ColorStateList strokeColor = SystemTheme.fromCache(theme, ThemedCache::button_outline_color_selector);
            ShapeDrawable background = new ShapeDrawable();
            background.setCornerRadius(1000.0f);
            background.setColor(backgroundTint);
            background.setStroke(strokeWidth, strokeColor);
            return new RippleDrawable(rippleColor, (Drawable)background, null);
        });
        style2 = b.newStyle(R.style.Widget_CompoundButton.entry(), "");
        style2.addBoolean("focusable", true);
        style2.addBoolean("clickable", true);
        style2.addFlags("gravity", 8388627);
        style2.addAttribute("textColor", "textColorPrimaryDisableOnly");
        style2 = b.newStyle(R.style.Widget_Material3_CompoundButton_RadioButton.entry(), R.style.Widget_CompoundButton.entry());
        style2.addAttribute("textAppearance", "textAppearanceBodyMedium");
        style2.addDrawable("button", (resources, theme) -> {
            ColorStateList buttonTint = SystemTheme.fromCache(theme, ThemedCache::radio_button_tint);
            RadioButtonDrawable button = new RadioButtonDrawable((Resources)resources, true, true, true);
            button.setTintList(buttonTint);
            return button;
        });
        style2.addDrawable("background", (resources, theme) -> {
            ColorStateList rippleTint = SystemTheme.fromCache(theme, ThemedCache::radio_button_ripple_tint);
            RippleDrawable ripple = new RippleDrawable(rippleTint, null, null);
            int radius = SystemTheme.dp(16.0f, resources);
            ripple.setRadius(radius);
            return ripple;
        });
        style2 = b.newStyle(R.style.Widget_Material3_CompoundButton_RadioButton_MenuItem.entry(), R.style.Widget_CompoundButton.entry());
        style2.addAttribute("textAppearance", "textAppearanceBodyMedium");
        style2.addDrawable("button", (resources, theme) -> {
            ColorStateList buttonTint = SystemTheme.fromCache(theme, ThemedCache::radio_button_tint);
            RadioButtonDrawable button = new RadioButtonDrawable((Resources)resources, false, false, false);
            button.setTintList(buttonTint);
            return button;
        });
        style2 = b.newStyle(R.style.Widget_Material3_CompoundButton_Switch.entry(), R.style.Widget_CompoundButton.entry());
        style2.addAttribute("textAppearance", "textAppearanceBodyMedium");
        style2.addDimension("switchMinWidth", 52.0f, 1);
        style2.addDimension("switchPadding", 16.0f, 1);
        style2.addDrawable("track", (resources, theme) -> {
            ColorStateList tint = SystemTheme.fromCache(theme, ThemedCache::switch_track_tint);
            ColorStateList decorationTint = SystemTheme.fromCache(theme, ThemedCache::switch_track_decoration_tint);
            ShapeDrawable track = new ShapeDrawable();
            track.setShape(0);
            track.setSize(SystemTheme.dp(52.0f, resources), SystemTheme.dp(32.0f, resources));
            track.setCornerRadius(SystemTheme.dp(16.0f, resources));
            track.setColor(tint);
            track.setStroke(SystemTheme.dp(2.0f, resources), decorationTint);
            return track;
        });
        style2.addDrawable("thumb", (resources, theme) -> {
            ColorStateList tint = SystemTheme.fromCache(theme, ThemedCache::switch_thumb_tint);
            SwitchThumbDrawable thumb = new SwitchThumbDrawable((Resources)resources, true, true);
            thumb.setTintList(tint);
            return thumb;
        });
        style2 = b.newStyle(R.style.Widget_Material3_ProgressBar.entry(), "");
        style2.addDimension("minWidth", 48.0f, 1);
        style2.addDimension("minHeight", 48.0f, 1);
        style2.addDrawable("indeterminateDrawable", (resources, theme) -> {
            CircularIndeterminateDrawable drawable = new CircularIndeterminateDrawable((Resources)resources, 40, 4, 4.0f);
            drawable.setIndicatorColor(SystemTheme.fromCache(theme, cache -> cache.colorPrimary));
            drawable.setTrackColor(SystemTheme.fromCache(theme, cache -> cache.colorSecondaryContainer));
            return drawable;
        });
        style2.addDrawable("progressDrawable", (resources, theme) -> SystemTheme.circular_progress_drawable(resources, theme, 40, 4, 4.0f));
        style2 = b.newStyle(R.style.Widget_Material3_ProgressBar_Small.entry(), "");
        style2.addDimension("minWidth", 36.0f, 1);
        style2.addDimension("minHeight", 36.0f, 1);
        style2.addDrawable("indeterminateDrawable", (resources, theme) -> {
            CircularIndeterminateDrawable drawable = new CircularIndeterminateDrawable((Resources)resources, 28, 4, 3.0f);
            drawable.setIndicatorColor(SystemTheme.fromCache(theme, cache -> cache.colorPrimary));
            drawable.setTrackColor(SystemTheme.fromCache(theme, cache -> cache.colorSecondaryContainer));
            return drawable;
        });
        style2.addDrawable("progressDrawable", (resources, theme) -> SystemTheme.circular_progress_drawable(resources, theme, 28, 4, 3.0f));
        style2 = b.newStyle(R.style.Widget_Material3_ProgressBar_ExtraSmall.entry(), "");
        style2.addDimension("minWidth", 24.0f, 1);
        style2.addDimension("minHeight", 24.0f, 1);
        style2.addDrawable("indeterminateDrawable", (resources, theme) -> {
            CircularIndeterminateDrawable drawable = new CircularIndeterminateDrawable((Resources)resources, 20, 2, 2.5f);
            drawable.setIndicatorColor(SystemTheme.fromCache(theme, cache -> cache.colorPrimary));
            drawable.setTrackColor(SystemTheme.fromCache(theme, cache -> cache.colorSecondaryContainer));
            return drawable;
        });
        style2.addDrawable("progressDrawable", (resources, theme) -> SystemTheme.circular_progress_drawable(resources, theme, 20, 2, 2.5f));
        style2 = b.newStyle(R.style.Widget_Material3_ProgressBar_Horizontal.entry(), "");
        style2.addDrawable("indeterminateDrawable", (resources, theme) -> {
            LinearIndeterminateDrawable drawable = new LinearIndeterminateDrawable((Resources)resources, false);
            drawable.setIndicatorColor(SystemTheme.fromCache(theme, cache -> cache.colorPrimary));
            drawable.setTrackColor(SystemTheme.fromCache(theme, cache -> cache.colorSecondaryContainer));
            return drawable;
        });
        style2.addDrawable("progressDrawable", (resources, theme) -> SystemTheme.linear_progress_drawable(resources, theme, false));
        style2.addBoolean("mirrorForRtl", true);
        style2 = b.newStyle(R.style.Widget_Material3_ProgressBar_Vertical.entry(), "");
        style2.addDrawable("indeterminateDrawable", (resources, theme) -> {
            LinearIndeterminateDrawable drawable = new LinearIndeterminateDrawable((Resources)resources, true);
            drawable.setIndicatorColor(SystemTheme.fromCache(theme, cache -> cache.colorPrimary));
            drawable.setTrackColor(SystemTheme.fromCache(theme, cache -> cache.colorSecondaryContainer));
            return drawable;
        });
        style2.addDrawable("progressDrawable", (resources, theme) -> SystemTheme.linear_progress_drawable(resources, theme, true));
        style2 = b.newStyle(R.style.Widget_Material3_SeekBar.entry(), "");
        style2.addDrawable("progressDrawable", (resources, theme) -> {
            ShapeDrawable background = new ShapeDrawable();
            background.setShape(3);
            background.setSize(-1, SystemTheme.dp(10.0f, resources));
            background.setCornerRadius(SystemTheme.dp(5.0f, resources));
            background.setColor(SystemTheme.fromCache(theme, ThemedCache::slider_track_color_inactive));
            ShapeDrawable progress = new ShapeDrawable();
            progress.setShape(3);
            progress.setSize(-1, SystemTheme.dp(10.0f, resources));
            progress.setCornerRadius(SystemTheme.dp(5.0f, resources));
            progress.setColor(SystemTheme.fromCache(theme, ThemedCache::slider_track_color_active));
            ScaleDrawable scaledProgress = new ScaleDrawable(progress, 3, 1.0f, -1.0f);
            LayerDrawable track = new LayerDrawable(background, scaledProgress);
            track.setId(0, 0x1020000);
            track.setId(1, 16908301);
            track.setLayerGravity(0, 23);
            track.setLayerGravity(1, 23);
            return track;
        });
        style2.addBoolean("splitTrack", true);
        style2.addBoolean("mirrorForRtl", true);
        style2.addBoolean("focusable", true);
        style2.addDrawable("thumb", (resources, theme) -> {
            SeekbarThumbDrawable thumb = new SeekbarThumbDrawable((Resources)resources);
            thumb.setTintList(SystemTheme.fromCache(theme, ThemedCache::slider_track_color_active));
            return thumb;
        });
        style2.addDimension("paddingLeft", 16.0f, 1);
        style2.addDimension("paddingRight", 16.0f, 1);
        style2 = b.newStyle(R.style.Widget_Material3_SeekBar_Discrete.entry(), R.style.Widget_Material3_SeekBar.entry());
        style2.addDrawable("tickMark", (resources, theme) -> {
            ShapeDrawable tick = new ShapeDrawable();
            tick.setShape(1);
            int size = SystemTheme.dp(4.0f, resources);
            tick.setSize(size, size);
            tick.setColor(SystemTheme.fromCache(theme, ThemedCache::slider_track_color_inactive));
            tick.setUseLevelForShape(false);
            return tick;
        });
        style2 = b.newStyle(R.style.Widget_Material3_PopupMenu.entry(), "");
        style2.addDimension("popupElevation", 3.0f, 1);
        style2.addDrawable("popupBackground", (resources, theme) -> {
            ShapeDrawable popupBackground = new ShapeDrawable();
            popupBackground.setShape(0);
            popupBackground.setCornerRadius(SystemTheme.dp(4.0f, resources));
            int color = SystemTheme.fromCache(theme, cache -> cache.colorSurfaceContainer);
            popupBackground.setColor(color);
            int pad = SystemTheme.dp(2.0f, resources);
            popupBackground.setPadding(pad, pad, pad, pad);
            return popupBackground;
        });
        style2 = b.newStyle(R.style.Widget_Material3_PopupMenu_ContextMenu.entry(), R.style.Widget_Material3_PopupMenu.entry());
        style2.addBoolean("overlapAnchor", true);
        style2 = b.newStyle(R.style.Widget_Material3_PopupMenu_ListPopupWindow.entry(), R.style.Widget_Material3_PopupMenu.entry());
        style2 = b.newStyle(R.style.Widget_Material3_Spinner.entry(), R.style.Widget_Material3_PopupMenu_ListPopupWindow.entry());
        style2.addBoolean("clickable", true);
        style2.addDrawable("dropDownSelector", (resources, theme) -> {
            TypedValue value = new TypedValue();
            theme.resolveAttribute("modernui", "colorControlHighlight", value, true);
            return new RippleDrawable(ColorStateList.valueOf(value.data), null, (Drawable)new ColorDrawable(-1));
        });
    }

    private static Drawable circular_progress_drawable(Resources resources, Resources.Theme theme, int size, int inset, float thickness) {
        ShapeDrawable background = new ShapeDrawable();
        background.setShape(2);
        background.setInnerRadius(SystemTheme.dp((float)(size - inset - inset) * 0.5f, resources));
        background.setThickness(SystemTheme.dp(thickness, resources));
        background.setColor(SystemTheme.fromCache(theme, ThemedCache::slider_track_color_inactive));
        background.setUseLevelForShape(false);
        ShapeDrawable progress = new ShapeDrawable();
        progress.setShape(2);
        progress.setInnerRadius(SystemTheme.dp((float)(size - inset - inset) * 0.5f, resources));
        progress.setThickness(SystemTheme.dp(thickness, resources));
        progress.setCornerRadius(1.0f);
        progress.setColor(SystemTheme.fromCache(theme, ThemedCache::slider_track_color_active));
        LayerDrawable track = new LayerDrawable(background, progress);
        track.setId(0, 0x1020000);
        track.setId(1, 16908301);
        track.setLayerGravity(0, 17);
        track.setLayerGravity(1, 17);
        return track;
    }

    private static Drawable linear_progress_drawable(Resources resources, Resources.Theme theme, boolean vertical) {
        LayerDrawable track;
        if (vertical) {
            ShapeDrawable background = new ShapeDrawable();
            background.setShape(4);
            background.setSize(SystemTheme.dp(4.0f, resources), -1);
            background.setCornerRadius(1.0f);
            background.setStroke(SystemTheme.dp(4.0f, resources), SystemTheme.fromCache(theme, ThemedCache::slider_track_color_inactive));
            ShapeDrawable secondaryProgress = new ShapeDrawable();
            secondaryProgress.setShape(4);
            secondaryProgress.setSize(SystemTheme.dp(4.0f, resources), -1);
            secondaryProgress.setCornerRadius(1.0f);
            secondaryProgress.setStroke(SystemTheme.dp(4.0f, resources), SystemTheme.fromCache(theme, ThemedCache::secondary_progress_tint));
            ShapeDrawable progress = new ShapeDrawable();
            progress.setShape(4);
            progress.setSize(SystemTheme.dp(4.0f, resources), -1);
            progress.setCornerRadius(1.0f);
            progress.setStroke(SystemTheme.dp(4.0f, resources), SystemTheme.fromCache(theme, ThemedCache::slider_track_color_active));
            ScaleDrawable scaledSecondaryProgress = new ScaleDrawable(secondaryProgress, 80, 1.0f, -1.0f);
            ScaleDrawable scaledProgress = new ScaleDrawable(progress, 80, 1.0f, -1.0f);
            track = new LayerDrawable(background, scaledSecondaryProgress, scaledProgress);
            track.setLayerGravity(0, 113);
            track.setLayerGravity(1, 113);
            track.setLayerGravity(2, 113);
        } else {
            ShapeDrawable background = new ShapeDrawable();
            background.setShape(3);
            background.setSize(-1, SystemTheme.dp(4.0f, resources));
            background.setCornerRadius(1.0f);
            background.setStroke(SystemTheme.dp(4.0f, resources), SystemTheme.fromCache(theme, ThemedCache::slider_track_color_inactive));
            ShapeDrawable secondaryProgress = new ShapeDrawable();
            secondaryProgress.setShape(3);
            secondaryProgress.setSize(-1, SystemTheme.dp(4.0f, resources));
            secondaryProgress.setCornerRadius(1.0f);
            secondaryProgress.setStroke(SystemTheme.dp(4.0f, resources), SystemTheme.fromCache(theme, ThemedCache::secondary_progress_tint));
            ShapeDrawable progress = new ShapeDrawable();
            progress.setShape(3);
            progress.setSize(-1, SystemTheme.dp(4.0f, resources));
            progress.setCornerRadius(1.0f);
            progress.setStroke(SystemTheme.dp(4.0f, resources), SystemTheme.fromCache(theme, ThemedCache::slider_track_color_active));
            ScaleDrawable scaledSecondaryProgress = new ScaleDrawable(secondaryProgress, 3, 1.0f, -1.0f);
            ScaleDrawable scaledProgress = new ScaleDrawable(progress, 3, 1.0f, -1.0f);
            track = new LayerDrawable(background, scaledSecondaryProgress, scaledProgress);
            track.setLayerGravity(0, 23);
            track.setLayerGravity(1, 23);
            track.setLayerGravity(2, 23);
        }
        track.setId(0, 0x1020000);
        track.setId(1, 16908303);
        track.setId(2, 16908301);
        return track;
    }

    public static SystemTheme createDefault(boolean isDark, int subclass) {
        int colorTextHintInverse;
        int colorTextPrimaryInverseDisableOnly;
        int colorTextSecondaryAndTertiaryInverseDisabled;
        int colorTextSecondaryAndTertiaryInverse;
        int colorTextPrimaryInverse;
        SystemTheme t2 = new SystemTheme();
        if (subclass == 0) {
            if (isDark) {
                t2.colorSurface = -15068913;
                t2.colorSurfaceDim = -15068913;
                t2.colorSurfaceBright = -12437708;
                t2.colorSurfaceContainerLowest = -15463414;
                t2.colorSurfaceContainerLow = -14477033;
                t2.colorSurfaceContainer = -14213861;
                t2.colorSurfaceContainerHigh = -13490139;
                t2.colorSurfaceContainerHighest = -12766672;
                t2.colorOnSurface = -925734;
                t2.colorSurfaceVariant = -11320513;
                t2.colorOnSurfaceVariant = -2571588;
                t2.colorSurfaceInverse = -925734;
                t2.colorOnSurfaceInverse = -13029845;
                t2.colorOutline = -6255481;
                t2.colorOutlineVariant = -11320513;
                t2.colorPrimary = -19039;
                t2.colorOnPrimary = -11133168;
                t2.colorPrimaryContainer = -9292509;
                t2.colorOnPrimaryContainer = -9263;
                t2.colorPrimaryInverse = -7386311;
                t2.colorSecondary = -1589838;
                t2.colorOnSecondary = -12309981;
                t2.colorSecondaryContainer = -10665928;
                t2.colorOnSecondaryContainer = -9263;
                t2.colorTertiary = -2505331;
                t2.colorOnTertiary = -12898555;
                t2.colorTertiaryContainer = -11319783;
                t2.colorOnTertiaryContainer = -597594;
                t2.colorError = -19285;
                t2.colorOnError = -9895931;
                t2.colorErrorContainer = -7143414;
                t2.colorOnErrorContainer = -9514;
                colorTextPrimaryInverse = -14477033;
                colorTextSecondaryAndTertiaryInverse = -11320513;
                colorTextSecondaryAndTertiaryInverseDisabled = -14477033;
                colorTextPrimaryInverseDisableOnly = -14477033;
                colorTextHintInverse = -14477033;
            } else {
                t2.colorSurface = -1802;
                t2.colorSurfaceDim = -1517870;
                t2.colorSurfaceBright = -1802;
                t2.colorSurfaceContainerLowest = -1;
                t2.colorSurfaceContainerLow = -3603;
                t2.colorSurfaceContainer = -202011;
                t2.colorSurfaceContainerHigh = -531232;
                t2.colorSurfaceContainerHighest = -925734;
                t2.colorOnSurface = -14477033;
                t2.colorSurfaceVariant = -663848;
                t2.colorOnSurfaceVariant = -11320513;
                t2.colorSurfaceInverse = -13029845;
                t2.colorOnSurfaceInverse = -4632;
                t2.colorOutline = -8031378;
                t2.colorOutlineVariant = -2571588;
                t2.colorPrimary = -7386311;
                t2.colorOnPrimary = -1;
                t2.colorPrimaryContainer = -9263;
                t2.colorOnPrimaryContainer = -9292509;
                t2.colorPrimaryInverse = -19039;
                t2.colorSecondary = -8956082;
                t2.colorOnSecondary = -1;
                t2.colorSecondaryContainer = -9263;
                t2.colorOnSecondaryContainer = -10665928;
                t2.colorTertiary = -9675473;
                t2.colorOnTertiary = -1;
                t2.colorTertiaryContainer = -597594;
                t2.colorOnTertiaryContainer = -11319783;
                t2.colorError = -4580838;
                t2.colorOnError = -1;
                t2.colorErrorContainer = -9514;
                t2.colorOnErrorContainer = -7143414;
                colorTextPrimaryInverse = -925734;
                colorTextSecondaryAndTertiaryInverse = -2571588;
                colorTextSecondaryAndTertiaryInverseDisabled = -925734;
                colorTextPrimaryInverseDisableOnly = -925734;
                colorTextHintInverse = -925734;
            }
            t2.colorPrimaryFixed = -9263;
            t2.colorPrimaryFixedDim = -19039;
            t2.colorOnPrimaryFixed = -12973311;
            t2.colorOnPrimaryFixedVariant = -9292509;
            t2.colorSecondaryFixed = -9263;
            t2.colorSecondaryFixedDim = -1589838;
            t2.colorOnSecondaryFixed = -13888241;
            t2.colorOnSecondaryFixedVariant = -10665928;
            t2.colorTertiaryFixed = -597594;
            t2.colorTertiaryFixedDim = -2505331;
            t2.colorOnTertiaryFixed = -14476544;
            t2.colorOnTertiaryFixedVariant = -11319783;
        } else if (subclass == 1) {
            if (isDark) {
                t2.colorSurface = -15330542;
                t2.colorSurfaceDim = -15330542;
                t2.colorSurfaceBright = -12765129;
                t2.colorSurfaceContainerLowest = -15659763;
                t2.colorSurfaceContainerLow = -14804198;
                t2.colorSurfaceContainer = -14541026;
                t2.colorSurfaceContainerHigh = -13817560;
                t2.colorSurfaceContainerHighest = -13093837;
                t2.colorOnSurface = -1449505;
                t2.colorSurfaceVariant = -11516863;
                t2.colorOnSurfaceVariant = -2833474;
                t2.colorSurfaceInverse = -1449505;
                t2.colorOnSurfaceInverse = -13357266;
                t2.colorOutline = -6451830;
                t2.colorOutlineVariant = -11516863;
                t2.colorPrimary = -1392974;
                t2.colorOnPrimary = -12244702;
                t2.colorPrimaryContainer = -3300456;
                t2.colorOnPrimaryContainer = -11060943;
                t2.colorPrimaryInverse = -8890803;
                t2.colorSecondary = -2506308;
                t2.colorOnSecondary = -12833495;
                t2.colorSecondaryContainer = -11123391;
                t2.colorOnSecondaryContainer = -3492690;
                t2.colorTertiary = -2701664;
                t2.colorOnTertiary = -13029612;
                t2.colorTertiaryContainer = -4543610;
                t2.colorOnTertiaryContainer = -11911390;
                t2.colorError = -19285;
                t2.colorOnError = -9895931;
                t2.colorErrorContainer = -7143414;
                t2.colorOnErrorContainer = -9514;
                colorTextPrimaryInverse = -14804198;
                colorTextSecondaryAndTertiaryInverse = -11516863;
                colorTextPrimaryInverseDisableOnly = -14804198;
                colorTextSecondaryAndTertiaryInverseDisabled = -14804198;
                colorTextHintInverse = -14804198;
            } else {
                t2.colorSurface = -1802;
                t2.colorSurfaceDim = -2041642;
                t2.colorSurfaceBright = -1802;
                t2.colorSurfaceContainerLowest = -1;
                t2.colorSurfaceContainerLow = -265488;
                t2.colorSurfaceContainer = -660246;
                t2.colorSurfaceContainerHigh = -1055004;
                t2.colorSurfaceContainerHighest = -1449505;
                t2.colorOnSurface = -14804198;
                t2.colorSurfaceVariant = -925734;
                t2.colorOnSurfaceVariant = -11516863;
                t2.colorSurfaceInverse = -13357266;
                t2.colorOnSurfaceInverse = -462867;
                t2.colorOutline = -8227728;
                t2.colorOutlineVariant = -2833474;
                t2.colorPrimary = -8890803;
                t2.colorOnPrimary = -1;
                t2.colorPrimaryContainer = -3300456;
                t2.colorOnPrimaryContainer = -11060943;
                t2.colorPrimaryInverse = -1458767;
                t2.colorSecondary = -9676202;
                t2.colorOnSecondary = -1;
                t2.colorSecondaryContainer = -598569;
                t2.colorOnSecondaryContainer = -9215908;
                t2.colorTertiary = -9872066;
                t2.colorOnTertiary = -1;
                t2.colorTertiaryContainer = -4543610;
                t2.colorOnTertiaryContainer = -11911390;
                t2.colorError = -4580838;
                t2.colorOnError = -1;
                t2.colorErrorContainer = -9514;
                t2.colorOnErrorContainer = -7143414;
                colorTextPrimaryInverse = -1449505;
                colorTextSecondaryAndTertiaryInverse = -2833474;
                colorTextPrimaryInverseDisableOnly = -1449505;
                colorTextSecondaryAndTertiaryInverseDisabled = -1449505;
                colorTextHintInverse = -1449505;
            }
            t2.colorPrimaryFixed = -9263;
            t2.colorPrimaryFixedDim = -1458767;
            t2.colorOnPrimaryFixed = -13822706;
            t2.colorOnPrimaryFixedVariant = -10600649;
            t2.colorSecondaryFixed = -598569;
            t2.colorSecondaryFixedDim = -2506308;
            t2.colorOnSecondaryFixed = -14345963;
            t2.colorOnSecondaryFixedVariant = -11320513;
            t2.colorTertiaryFixed = -859719;
            t2.colorTertiaryFixedDim = -2767457;
            t2.colorOnTertiaryFixed = -14476541;
            t2.colorOnTertiaryFixedVariant = -11516376;
        } else if (subclass == 2) {
            if (isDark) {
                t2.colorSurface = -15330542;
                t2.colorSurfaceDim = -15330542;
                t2.colorSurfaceBright = -12830665;
                t2.colorSurfaceContainerLowest = -15725043;
                t2.colorSurfaceContainerLow = -14804198;
                t2.colorSurfaceContainer = -14541026;
                t2.colorSurfaceContainerHigh = -13817560;
                t2.colorSurfaceContainerHighest = -13093837;
                t2.colorOnSurface = -1449505;
                t2.colorSurfaceVariant = -11909563;
                t2.colorOnSurfaceVariant = -3357245;
                t2.colorSurfaceInverse = -1449505;
                t2.colorOnSurfaceInverse = -13422801;
                t2.colorOutline = -6910066;
                t2.colorOutlineVariant = -11909563;
                t2.colorPrimary = -2048073;
                t2.colorOnPrimary = -12571610;
                t2.colorPrimaryContainer = -10993349;
                t2.colorOnPrimaryContainer = -140333;
                t2.colorPrimaryInverse = -9348782;
                t2.colorSecondary = -2571588;
                t2.colorOnSecondary = -12899030;
                t2.colorSecondaryContainer = -11320513;
                t2.colorOnSecondaryContainer = -663848;
                t2.colorTertiary = -1589838;
                t2.colorOnTertiary = -12309981;
                t2.colorTertiaryContainer = -10665928;
                t2.colorOnTertiaryContainer = -9263;
                t2.colorError = -19285;
                t2.colorOnError = -9895931;
                t2.colorErrorContainer = -7143414;
                t2.colorOnErrorContainer = -9514;
                colorTextPrimaryInverse = -14804198;
                colorTextSecondaryAndTertiaryInverse = -11909563;
                colorTextPrimaryInverseDisableOnly = -14804198;
                colorTextSecondaryAndTertiaryInverseDisabled = -14804198;
                colorTextHintInverse = -14804198;
            } else {
                t2.colorSurface = -1802;
                t2.colorSurfaceDim = -2041642;
                t2.colorSurfaceBright = -1802;
                t2.colorSurfaceContainerLowest = -1;
                t2.colorSurfaceContainerLow = -331024;
                t2.colorSurfaceContainer = -725782;
                t2.colorSurfaceContainerHigh = -1055004;
                t2.colorSurfaceContainerHighest = -1449505;
                t2.colorOnSurface = -14804198;
                t2.colorSurfaceVariant = -1449505;
                t2.colorOnSurfaceVariant = -11909563;
                t2.colorSurfaceInverse = -13422801;
                t2.colorOnSurfaceInverse = -528403;
                t2.colorOutline = -8620428;
                t2.colorOutlineVariant = -3357245;
                t2.colorPrimary = -9348782;
                t2.colorOnPrimary = -1;
                t2.colorPrimaryContainer = -140333;
                t2.colorOnPrimaryContainer = -10993349;
                t2.colorPrimaryInverse = -2048073;
                t2.colorSecondary = -9675946;
                t2.colorOnSecondary = -1;
                t2.colorSecondaryContainer = -663848;
                t2.colorOnSecondaryContainer = -11320513;
                t2.colorTertiary = -8956082;
                t2.colorOnTertiary = -1;
                t2.colorTertiaryContainer = -9263;
                t2.colorOnTertiaryContainer = -10665928;
                t2.colorError = -4580838;
                t2.colorOnError = -1;
                t2.colorErrorContainer = -9514;
                t2.colorOnErrorContainer = -7143414;
                colorTextPrimaryInverse = -1449505;
                colorTextSecondaryAndTertiaryInverse = -3357245;
                colorTextPrimaryInverseDisableOnly = -1449505;
                colorTextSecondaryAndTertiaryInverseDisabled = -1449505;
                colorTextHintInverse = -1449505;
            }
            t2.colorPrimaryFixed = -140333;
            t2.colorPrimaryFixedDim = -2048073;
            t2.colorOnPrimaryFixed = -14084334;
            t2.colorOnPrimaryFixedVariant = -10993349;
            t2.colorSecondaryFixed = -663848;
            t2.colorSecondaryFixedDim = -2571588;
            t2.colorOnSecondaryFixed = -14345963;
            t2.colorOnSecondaryFixedVariant = -11320513;
            t2.colorTertiaryFixed = -9263;
            t2.colorTertiaryFixedDim = -1589838;
            t2.colorOnTertiaryFixed = -13888241;
            t2.colorOnTertiaryFixedVariant = -10665928;
        } else {
            if (isDark) {
                t2.colorSurface = -15527149;
                t2.colorSurfaceDim = -15527149;
                t2.colorSurfaceBright = -13027015;
                t2.colorSurfaceContainerLowest = -15856114;
                t2.colorSurfaceContainerLow = -15000805;
                t2.colorSurfaceContainer = -14737633;
                t2.colorSurfaceContainerHigh = -14013910;
                t2.colorSurfaceContainerHighest = -13290187;
                t2.colorOnSurface = -1907998;
                t2.colorSurfaceVariant = -12105913;
                t2.colorOnSurfaceVariant = -3750202;
                t2.colorSurfaceInverse = -1907998;
                t2.colorOnSurfaceInverse = -13619152;
                t2.colorOutline = -7237231;
                t2.colorOutlineVariant = -12105913;
                t2.colorPrimary = -1;
                t2.colorOnPrimary = -15000805;
                t2.colorPrimaryContainer = -2829100;
                t2.colorOnPrimaryContainer = -16777216;
                t2.colorPrimaryInverse = -10592674;
                t2.colorSecondary = -3750202;
                t2.colorOnSecondary = -15000805;
                t2.colorSecondaryContainer = -12105913;
                t2.colorOnSecondaryContainer = -1907998;
                t2.colorTertiary = -1907998;
                t2.colorOnTertiary = -15000805;
                t2.colorTertiaryContainer = -7237231;
                t2.colorOnTertiaryContainer = -16777216;
                t2.colorError = -19285;
                t2.colorOnError = -9895931;
                t2.colorErrorContainer = -7143414;
                t2.colorOnErrorContainer = -9514;
                colorTextPrimaryInverse = -15000805;
                colorTextSecondaryAndTertiaryInverse = -12105913;
                colorTextPrimaryInverseDisableOnly = -15000805;
                colorTextSecondaryAndTertiaryInverseDisabled = -15000805;
                colorTextHintInverse = -15000805;
            } else {
                t2.colorSurface = -394759;
                t2.colorSurfaceDim = -2434342;
                t2.colorSurfaceBright = -394759;
                t2.colorSurfaceContainerLowest = -1;
                t2.colorSurfaceContainerLow = -789517;
                t2.colorSurfaceContainer = -1118482;
                t2.colorSurfaceContainerHigh = -1513240;
                t2.colorSurfaceContainerHighest = -1907998;
                t2.colorOnSurface = -15000805;
                t2.colorSurfaceVariant = -1907998;
                t2.colorOnSurfaceVariant = -12105913;
                t2.colorSurfaceInverse = -13619152;
                t2.colorOnSurfaceInverse = -921103;
                t2.colorOutline = -8947849;
                t2.colorOutlineVariant = -3750202;
                t2.colorPrimary = -16777216;
                t2.colorOnPrimary = -1907998;
                t2.colorPrimaryContainer = -12895429;
                t2.colorOnPrimaryContainer = -1;
                t2.colorPrimaryInverse = -3750202;
                t2.colorSecondary = -10592674;
                t2.colorOnSecondary = -1;
                t2.colorSecondaryContainer = -2829100;
                t2.colorOnSecondaryContainer = -15000805;
                t2.colorTertiary = -12895429;
                t2.colorOnTertiary = -1907998;
                t2.colorTertiaryContainer = -9145228;
                t2.colorOnTertiaryContainer = -1;
                t2.colorError = -4580838;
                t2.colorOnError = -1;
                t2.colorErrorContainer = -9514;
                t2.colorOnErrorContainer = -12517374;
                colorTextPrimaryInverse = -1907998;
                colorTextSecondaryAndTertiaryInverse = -3750202;
                colorTextPrimaryInverseDisableOnly = -1907998;
                colorTextSecondaryAndTertiaryInverseDisabled = -1907998;
                colorTextHintInverse = -1907998;
            }
            t2.colorPrimaryFixed = -10592674;
            t2.colorPrimaryFixedDim = -12105913;
            t2.colorOnPrimaryFixed = -1;
            t2.colorOnPrimaryFixedVariant = -1907998;
            t2.colorSecondaryFixed = -3750202;
            t2.colorSecondaryFixedDim = -5526613;
            t2.colorOnSecondaryFixed = -15000805;
            t2.colorOnSecondaryFixedVariant = -12895429;
            t2.colorTertiaryFixed = -10592674;
            t2.colorTertiaryFixedDim = -12105913;
            t2.colorOnTertiaryFixed = -1;
            t2.colorOnTertiaryFixedVariant = -1907998;
        }
        t2.colorBackground = t2.colorSurface;
        t2.colorOnBackground = t2.colorOnSurface;
        int[][] textStateSpec = new int[][]{{-16842910}, StateSet.WILD_CARD};
        t2.textColorPrimary = new ColorStateList(textStateSpec, new int[]{ColorStateList.modulateColor(t2.colorOnSurface, 0.38f), t2.colorOnSurface});
        t2.textColorPrimaryInverse = new ColorStateList(textStateSpec, new int[]{ColorStateList.modulateColor(colorTextPrimaryInverse, 0.38f), colorTextPrimaryInverse});
        t2.textColorSecondary = new ColorStateList(textStateSpec, new int[]{ColorStateList.modulateColor(t2.colorOnSurface, 0.38f), t2.colorOnSurfaceVariant});
        t2.textColorSecondaryInverse = new ColorStateList(textStateSpec, new int[]{ColorStateList.modulateColor(colorTextSecondaryAndTertiaryInverseDisabled, 0.38f), colorTextSecondaryAndTertiaryInverse});
        t2.textColorPrimaryDisableOnly = new ColorStateList(textStateSpec, new int[]{ColorStateList.modulateColor(t2.colorOnBackground, 0.6f), t2.colorOnBackground});
        t2.textColorPrimaryInverseDisableOnly = new ColorStateList(textStateSpec, new int[]{ColorStateList.modulateColor(colorTextPrimaryInverseDisableOnly, 0.6f), colorTextPrimaryInverseDisableOnly});
        int[][] hintStateSpec = new int[][]{{16842910, 16842919}, StateSet.WILD_CARD};
        t2.textColorHint = new ColorStateList(hintStateSpec, new int[]{ColorStateList.modulateColor(t2.colorOnBackground, 0.6f), ColorStateList.modulateColor(t2.colorOnBackground, 0.38f)});
        t2.textColorHintInverse = new ColorStateList(hintStateSpec, new int[]{ColorStateList.modulateColor(colorTextHintInverse, 0.87f), ColorStateList.modulateColor(colorTextHintInverse, 0.6f)});
        t2.textColorTertiary = t2.textColorSecondary;
        t2.textColorTertiaryInverse = t2.textColorSecondaryInverse;
        t2.textColorHighlight = ColorStateList.modulateColor(t2.colorPrimary, 0.6f);
        t2.textColorHighlightInverse = ColorStateList.modulateColor(t2.colorPrimaryInverse, 0.6f);
        t2.textColorLink = ColorStateList.valueOf(t2.colorPrimary);
        t2.textColorLinkInverse = ColorStateList.valueOf(t2.colorPrimaryInverse);
        t2.textColorAlertDialogListItem = t2.textColorPrimary;
        t2.isDark = isDark;
        return t2;
    }

    public static SystemTheme createMaterial(boolean isDark) {
        SystemTheme t2 = new SystemTheme();
        int palette_black = -16777216;
        int palette_error0 = -16777216;
        int palette_error10 = -12513781;
        int palette_error100 = -1;
        int palette_error20 = -10480624;
        int palette_error30 = -7594728;
        int palette_error40 = -5036514;
        int palette_error50 = -2345426;
        int palette_error60 = -1808030;
        int palette_error70 = -1273202;
        int palette_error80 = -870219;
        int palette_error90 = -401700;
        int palette_error95 = -200978;
        int palette_error99 = -1031;
        int palette_neutral0 = -16777216;
        int palette_neutral10 = -14869728;
        int palette_neutral100 = -1;
        int palette_neutral12 = -14606554;
        int palette_neutral17 = -13948624;
        int palette_neutral20 = -13488331;
        int palette_neutral22 = -13224901;
        int palette_neutral24 = -12896194;
        int palette_neutral30 = -12040628;
        int palette_neutral4 = -15790829;
        int palette_neutral40 = -10461852;
        int palette_neutral50 = -8817027;
        int palette_neutral6 = -15461864;
        int palette_neutral60 = -7106666;
        int palette_neutral70 = -5330511;
        int palette_neutral80 = -3488307;
        int palette_neutral87 = -2172703;
        int palette_neutral90 = -1646359;
        int palette_neutral92 = -1251600;
        int palette_neutral94 = -791049;
        int palette_neutral95 = -659465;
        int palette_neutral96 = -527622;
        int palette_neutral98 = -67585;
        int palette_neutral99 = -1025;
        int palette_neutral_variant0 = -16777216;
        int palette_neutral_variant10 = -14869982;
        int palette_neutral_variant100 = -1;
        int palette_neutral_variant20 = -13488329;
        int palette_neutral_variant30 = -11975345;
        int palette_neutral_variant40 = -10461850;
        int palette_neutral_variant50 = -8817538;
        int palette_neutral_variant60 = -7106663;
        int palette_neutral_variant70 = -5330508;
        int palette_neutral_variant80 = -3488560;
        int palette_neutral_variant90 = -1580820;
        int palette_neutral_variant95 = -659718;
        int palette_neutral_variant99 = -1026;
        int palette_primary0 = -16777216;
        int palette_primary10 = -14614435;
        int palette_primary100 = -1;
        int palette_primary20 = -13099406;
        int palette_primary30 = -11585653;
        int palette_primary40 = -10006364;
        int palette_primary50 = -8427586;
        int palette_primary60 = -6651173;
        int palette_primary70 = -4809224;
        int palette_primary80 = -3097345;
        int palette_primary90 = -1384961;
        int palette_primary95 = -594433;
        int palette_primary99 = -1026;
        int palette_secondary0 = -16777216;
        int palette_secondary10 = -14870229;
        int palette_secondary100 = -1;
        int palette_secondary20 = -13423295;
        int palette_secondary30 = -11910056;
        int palette_secondary40 = -10331279;
        int palette_secondary50 = -8752503;
        int palette_secondary60 = -6976091;
        int palette_secondary70 = -5199936;
        int palette_secondary80 = -3357988;
        int palette_secondary90 = -1515784;
        int palette_secondary95 = -594433;
        int palette_secondary99 = -1026;
        int palette_tertiary0 = -16777216;
        int palette_tertiary10 = -13561571;
        int palette_tertiary100 = -1;
        int palette_tertiary20 = -11983566;
        int palette_tertiary30 = -10273976;
        int palette_tertiary40 = -8564128;
        int palette_tertiary50 = -6788745;
        int palette_tertiary60 = -4881518;
        int palette_tertiary70 = -2974292;
        int palette_tertiary80 = -1066808;
        int palette_tertiary90 = -10012;
        int palette_tertiary95 = -4879;
        int palette_tertiary99 = -1030;
        int palette_white = -1;
        if (isDark) {
            t2.colorPrimary = -3097345;
            t2.colorOnPrimary = -13099406;
            t2.colorPrimaryInverse = -10006364;
            t2.colorPrimaryContainer = -11585653;
            t2.colorOnPrimaryContainer = -1384961;
            t2.colorSecondary = -3357988;
            t2.colorOnSecondary = -13423295;
            t2.colorSecondaryContainer = -11910056;
            t2.colorOnSecondaryContainer = -1515784;
            t2.colorTertiary = -1066808;
            t2.colorOnTertiary = -11983566;
            t2.colorTertiaryContainer = -10273976;
            t2.colorOnTertiaryContainer = -10012;
        } else {
            t2.colorPrimary = -10006364;
            t2.colorOnPrimary = -1;
            t2.colorPrimaryInverse = -3097345;
            t2.colorPrimaryContainer = -1384961;
            t2.colorOnPrimaryContainer = -14614435;
            t2.colorSecondary = -10331279;
            t2.colorOnSecondary = -1;
            t2.colorSecondaryContainer = -1515784;
            t2.colorOnSecondaryContainer = -14870229;
            t2.colorTertiary = -8564128;
            t2.colorOnTertiary = -1;
            t2.colorTertiaryContainer = -10012;
            t2.colorOnTertiaryContainer = -13561571;
        }
        t2.colorPrimaryFixed = -1384961;
        t2.colorPrimaryFixedDim = -3097345;
        t2.colorOnPrimaryFixed = -14614435;
        t2.colorOnPrimaryFixedVariant = -11585653;
        t2.colorSecondaryFixed = -1515784;
        t2.colorSecondaryFixedDim = -3357988;
        t2.colorOnSecondaryFixed = -14870229;
        t2.colorOnSecondaryFixedVariant = -11910056;
        t2.colorTertiaryFixed = -10012;
        t2.colorTertiaryFixedDim = -1066808;
        t2.colorOnTertiaryFixed = -13561571;
        t2.colorOnTertiaryFixedVariant = -10273976;
        if (isDark) {
            t2.colorSurface = -15461864;
            t2.colorOnSurface = -1646359;
            t2.colorSurfaceVariant = -11975345;
            t2.colorOnSurfaceVariant = -3488560;
            t2.colorSurfaceInverse = -1646359;
            t2.colorOnSurfaceInverse = -13488331;
            t2.colorSurfaceBright = -12896194;
            t2.colorSurfaceDim = -15461864;
            t2.colorSurfaceContainer = -14606554;
            t2.colorSurfaceContainerLow = -14869728;
            t2.colorSurfaceContainerHigh = -13948624;
            t2.colorSurfaceContainerLowest = -15790829;
            t2.colorSurfaceContainerHighest = -13224901;
            t2.colorOutline = -7106663;
            t2.colorOutlineVariant = -11975345;
            t2.colorError = -870219;
            t2.colorOnError = -10480624;
            t2.colorErrorContainer = -7594728;
            t2.colorOnErrorContainer = -401700;
        } else {
            t2.colorSurface = -67585;
            t2.colorOnSurface = -14869728;
            t2.colorSurfaceVariant = -1580820;
            t2.colorOnSurfaceVariant = -11975345;
            t2.colorSurfaceInverse = -13488331;
            t2.colorOnSurfaceInverse = -659465;
            t2.colorSurfaceBright = -67585;
            t2.colorSurfaceDim = -2172703;
            t2.colorSurfaceContainer = -791049;
            t2.colorSurfaceContainerLow = -527622;
            t2.colorSurfaceContainerHigh = -1251600;
            t2.colorSurfaceContainerLowest = -1;
            t2.colorSurfaceContainerHighest = -1646359;
            t2.colorOutline = -8817538;
            t2.colorOutlineVariant = -3488560;
            t2.colorError = -5036514;
            t2.colorOnError = -1;
            t2.colorErrorContainer = -401700;
            t2.colorOnErrorContainer = -12513781;
        }
        t2.colorBackground = t2.colorSurface;
        t2.colorOnBackground = t2.colorOnSurface;
        int[][] textStateSpec = new int[][]{{-16842910}, StateSet.WILD_CARD};
        ColorStateList colorPrimaryText = new ColorStateList(textStateSpec, new int[]{ColorStateList.modulateColor(-14869728, 0.38f), -14869728});
        ColorStateList darkColorPrimaryText = new ColorStateList(textStateSpec, new int[]{ColorStateList.modulateColor(-1646359, 0.38f), -1646359});
        ColorStateList colorSecondaryText = new ColorStateList(textStateSpec, new int[]{ColorStateList.modulateColor(-14869728, 0.38f), -11975345});
        ColorStateList darkColorSecondaryText = new ColorStateList(textStateSpec, new int[]{ColorStateList.modulateColor(-1646359, 0.38f), -3488560});
        ColorStateList textDisableOnly = new ColorStateList(textStateSpec, new int[]{ColorStateList.modulateColor(-14869728, 0.6f), -14869728});
        ColorStateList darkTextDisableOnly = new ColorStateList(textStateSpec, new int[]{ColorStateList.modulateColor(-1646359, 0.6f), -1646359});
        int[][] hintStateSpec = new int[][]{{16842910, 16842919}, StateSet.WILD_CARD};
        ColorStateList hintForeground = new ColorStateList(hintStateSpec, new int[]{ColorStateList.modulateColor(-14869728, 0.6f), ColorStateList.modulateColor(-14869728, 0.38f)});
        ColorStateList darkHintForeground = new ColorStateList(hintStateSpec, new int[]{ColorStateList.modulateColor(-1646359, 0.87f), ColorStateList.modulateColor(-1646359, 0.6f)});
        if (isDark) {
            t2.textColorPrimary = darkColorPrimaryText;
            t2.textColorPrimaryInverse = colorPrimaryText;
            t2.textColorSecondary = darkColorSecondaryText;
            t2.textColorSecondaryInverse = colorSecondaryText;
            t2.textColorPrimaryDisableOnly = darkTextDisableOnly;
            t2.textColorPrimaryInverseDisableOnly = textDisableOnly;
            t2.textColorHint = darkHintForeground;
            t2.textColorHintInverse = hintForeground;
        } else {
            t2.textColorPrimary = colorPrimaryText;
            t2.textColorPrimaryInverse = darkColorPrimaryText;
            t2.textColorSecondary = colorSecondaryText;
            t2.textColorSecondaryInverse = darkColorSecondaryText;
            t2.textColorPrimaryDisableOnly = textDisableOnly;
            t2.textColorPrimaryInverseDisableOnly = darkTextDisableOnly;
            t2.textColorHint = hintForeground;
            t2.textColorHintInverse = darkHintForeground;
        }
        t2.textColorTertiary = t2.textColorSecondary;
        t2.textColorTertiaryInverse = t2.textColorSecondaryInverse;
        t2.textColorHighlight = ColorStateList.modulateColor(t2.colorPrimary, 0.6f);
        t2.textColorHighlightInverse = ColorStateList.modulateColor(t2.colorPrimaryInverse, 0.6f);
        t2.textColorLink = ColorStateList.valueOf(t2.colorPrimary);
        t2.textColorLinkInverse = ColorStateList.valueOf(t2.colorPrimaryInverse);
        t2.textColorAlertDialogListItem = t2.textColorPrimary;
        t2.isDark = isDark;
        return t2;
    }

    static class ThemedCache {
        final int colorPrimary;
        final int colorOnPrimary;
        final int colorPrimaryInverse;
        final int colorPrimaryContainer;
        final int colorOnPrimaryContainer;
        final int colorPrimaryFixed;
        final int colorPrimaryFixedDim;
        final int colorOnPrimaryFixed;
        final int colorOnPrimaryFixedVariant;
        final int colorSecondary;
        final int colorOnSecondary;
        final int colorSecondaryContainer;
        final int colorOnSecondaryContainer;
        final int colorSecondaryFixed;
        final int colorSecondaryFixedDim;
        final int colorOnSecondaryFixed;
        final int colorOnSecondaryFixedVariant;
        final int colorTertiary;
        final int colorOnTertiary;
        final int colorTertiaryContainer;
        final int colorOnTertiaryContainer;
        final int colorTertiaryFixed;
        final int colorTertiaryFixedDim;
        final int colorOnTertiaryFixed;
        final int colorOnTertiaryFixedVariant;
        final int colorBackground;
        final int colorOnBackground;
        final int colorSurface;
        final int colorOnSurface;
        final int colorSurfaceVariant;
        final int colorOnSurfaceVariant;
        final int colorSurfaceInverse;
        final int colorOnSurfaceInverse;
        final int colorSurfaceBright;
        final int colorSurfaceDim;
        final int colorSurfaceContainer;
        final int colorSurfaceContainerLow;
        final int colorSurfaceContainerHigh;
        final int colorSurfaceContainerLowest;
        final int colorSurfaceContainerHighest;
        final int colorOutline;
        final int colorOutlineVariant;
        final int colorError;
        final int colorOnError;
        final int colorErrorContainer;
        final int colorOnErrorContainer;
        private SparseArray<ColorStateList> button_foreground_color_selector;
        private SparseArray<ColorStateList> button_background_color_selector;
        private SparseArray<ColorStateList> button_ripple_color_selector;
        private ColorStateList button_outline_color_selector;
        private SparseArray<ColorStateList> text_button_foreground_color_selector;
        private SparseArray<ColorStateList> text_button_background_color_selector;
        private SparseArray<ColorStateList> text_button_ripple_color_selector;
        private ColorStateList radio_button_tint;
        private ColorStateList radio_button_ripple_tint;
        private ColorStateList switch_track_tint;
        private ColorStateList switch_track_decoration_tint;
        private ColorStateList switch_thumb_tint;
        private ColorStateList slider_track_color_active;
        private ColorStateList slider_track_color_inactive;
        private ColorStateList secondary_progress_tint;

        ThemedCache(Resources.Theme theme) {
            TypedValue value = new TypedValue();
            theme.getAttribute("modernui", "colorPrimary", value);
            this.colorPrimary = value.data;
            theme.getAttribute("modernui", "colorOnPrimary", value);
            this.colorOnPrimary = value.data;
            theme.getAttribute("modernui", "colorPrimaryInverse", value);
            this.colorPrimaryInverse = value.data;
            theme.getAttribute("modernui", "colorPrimaryContainer", value);
            this.colorPrimaryContainer = value.data;
            theme.getAttribute("modernui", "colorOnPrimaryContainer", value);
            this.colorOnPrimaryContainer = value.data;
            theme.getAttribute("modernui", "colorPrimaryFixed", value);
            this.colorPrimaryFixed = value.data;
            theme.getAttribute("modernui", "colorPrimaryFixedDim", value);
            this.colorPrimaryFixedDim = value.data;
            theme.getAttribute("modernui", "colorOnPrimaryFixed", value);
            this.colorOnPrimaryFixed = value.data;
            theme.getAttribute("modernui", "colorOnPrimaryFixedVariant", value);
            this.colorOnPrimaryFixedVariant = value.data;
            theme.getAttribute("modernui", "colorSecondary", value);
            this.colorSecondary = value.data;
            theme.getAttribute("modernui", "colorOnSecondary", value);
            this.colorOnSecondary = value.data;
            theme.getAttribute("modernui", "colorSecondaryContainer", value);
            this.colorSecondaryContainer = value.data;
            theme.getAttribute("modernui", "colorOnSecondaryContainer", value);
            this.colorOnSecondaryContainer = value.data;
            theme.getAttribute("modernui", "colorSecondaryFixed", value);
            this.colorSecondaryFixed = value.data;
            theme.getAttribute("modernui", "colorSecondaryFixedDim", value);
            this.colorSecondaryFixedDim = value.data;
            theme.getAttribute("modernui", "colorOnSecondaryFixed", value);
            this.colorOnSecondaryFixed = value.data;
            theme.getAttribute("modernui", "colorOnSecondaryFixedVariant", value);
            this.colorOnSecondaryFixedVariant = value.data;
            theme.getAttribute("modernui", "colorTertiary", value);
            this.colorTertiary = value.data;
            theme.getAttribute("modernui", "colorOnTertiary", value);
            this.colorOnTertiary = value.data;
            theme.getAttribute("modernui", "colorTertiaryContainer", value);
            this.colorTertiaryContainer = value.data;
            theme.getAttribute("modernui", "colorOnTertiaryContainer", value);
            this.colorOnTertiaryContainer = value.data;
            theme.getAttribute("modernui", "colorTertiaryFixed", value);
            this.colorTertiaryFixed = value.data;
            theme.getAttribute("modernui", "colorTertiaryFixedDim", value);
            this.colorTertiaryFixedDim = value.data;
            theme.getAttribute("modernui", "colorOnTertiaryFixed", value);
            this.colorOnTertiaryFixed = value.data;
            theme.getAttribute("modernui", "colorOnTertiaryFixedVariant", value);
            this.colorOnTertiaryFixedVariant = value.data;
            theme.getAttribute("modernui", "colorBackground", value);
            this.colorBackground = value.data;
            theme.getAttribute("modernui", "colorOnBackground", value);
            this.colorOnBackground = value.data;
            theme.getAttribute("modernui", "colorSurface", value);
            this.colorSurface = value.data;
            theme.getAttribute("modernui", "colorOnSurface", value);
            this.colorOnSurface = value.data;
            theme.getAttribute("modernui", "colorSurfaceVariant", value);
            this.colorSurfaceVariant = value.data;
            theme.getAttribute("modernui", "colorOnSurfaceVariant", value);
            this.colorOnSurfaceVariant = value.data;
            theme.getAttribute("modernui", "colorSurfaceInverse", value);
            this.colorSurfaceInverse = value.data;
            theme.getAttribute("modernui", "colorOnSurfaceInverse", value);
            this.colorOnSurfaceInverse = value.data;
            theme.getAttribute("modernui", "colorSurfaceBright", value);
            this.colorSurfaceBright = value.data;
            theme.getAttribute("modernui", "colorSurfaceDim", value);
            this.colorSurfaceDim = value.data;
            theme.getAttribute("modernui", "colorSurfaceContainer", value);
            this.colorSurfaceContainer = value.data;
            theme.getAttribute("modernui", "colorSurfaceContainerLow", value);
            this.colorSurfaceContainerLow = value.data;
            theme.getAttribute("modernui", "colorSurfaceContainerHigh", value);
            this.colorSurfaceContainerHigh = value.data;
            theme.getAttribute("modernui", "colorSurfaceContainerLowest", value);
            this.colorSurfaceContainerLowest = value.data;
            theme.getAttribute("modernui", "colorSurfaceContainerHighest", value);
            this.colorSurfaceContainerHighest = value.data;
            theme.getAttribute("modernui", "colorOutline", value);
            this.colorOutline = value.data;
            theme.getAttribute("modernui", "colorOutlineVariant", value);
            this.colorOutlineVariant = value.data;
            theme.getAttribute("modernui", "colorError", value);
            this.colorError = value.data;
            theme.getAttribute("modernui", "colorOnError", value);
            this.colorOnError = value.data;
            theme.getAttribute("modernui", "colorErrorContainer", value);
            this.colorErrorContainer = value.data;
            theme.getAttribute("modernui", "colorOnErrorContainer", value);
            this.colorOnErrorContainer = value.data;
        }

        private ColorStateList button_foreground_color_selector(int colorOnContainer) {
            ColorStateList csl;
            if (this.button_foreground_color_selector == null) {
                this.button_foreground_color_selector = new SparseArray();
            }
            if ((csl = this.button_foreground_color_selector.get(colorOnContainer)) != null) {
                return csl;
            }
            csl = new ColorStateList(new int[][]{StateSet.get(8), StateSet.WILD_CARD}, new int[]{colorOnContainer, ColorStateList.modulateColor(this.colorOnSurface, 0.38f)});
            this.button_foreground_color_selector.put(colorOnContainer, csl);
            return csl;
        }

        private ColorStateList button_background_color_selector(int colorContainer) {
            ColorStateList csl;
            if (this.button_background_color_selector == null) {
                this.button_background_color_selector = new SparseArray();
            }
            if ((csl = this.button_background_color_selector.get(colorContainer)) != null) {
                return csl;
            }
            csl = new ColorStateList(new int[][]{StateSet.get(8), StateSet.WILD_CARD}, new int[]{colorContainer, ColorStateList.modulateColor(this.colorOnSurface, 0.12f)});
            this.button_background_color_selector.put(colorContainer, csl);
            return csl;
        }

        private ColorStateList button_ripple_color_selector(int colorOnContainer) {
            ColorStateList csl;
            if (this.button_ripple_color_selector == null) {
                this.button_ripple_color_selector = new SparseArray();
            }
            if ((csl = this.button_ripple_color_selector.get(colorOnContainer)) != null) {
                return csl;
            }
            csl = new ColorStateList(new int[][]{{16842919}, {16844130}, {16843623}, StateSet.WILD_CARD}, new int[]{ColorStateList.modulateColor(colorOnContainer, 0.1f), ColorStateList.modulateColor(colorOnContainer, 0.102f), ColorStateList.modulateColor(colorOnContainer, 0.08f), ColorStateList.modulateColor(colorOnContainer, 0.064f)});
            this.button_ripple_color_selector.put(colorOnContainer, csl);
            return csl;
        }

        private ColorStateList button_outline_color_selector() {
            if (this.button_outline_color_selector != null) {
                return this.button_outline_color_selector;
            }
            this.button_outline_color_selector = new ColorStateList(new int[][]{{-16842910}, StateSet.WILD_CARD}, new int[]{ColorStateList.modulateColor(this.colorOnSurface, 0.12f), this.colorOutline});
            return this.button_outline_color_selector;
        }

        private ColorStateList text_button_foreground_color_selector(int colorOnContainer) {
            ColorStateList csl;
            if (this.text_button_foreground_color_selector == null) {
                this.text_button_foreground_color_selector = new SparseArray();
            }
            if ((csl = this.text_button_foreground_color_selector.get(colorOnContainer)) != null) {
                return csl;
            }
            csl = new ColorStateList(new int[][]{{-16842910}, {-16842911}, {0x10100A0}, StateSet.WILD_CARD}, new int[]{ColorStateList.modulateColor(this.colorOnSurface, 0.38f), colorOnContainer, this.colorOnSecondaryContainer, this.colorOnSurface});
            this.text_button_foreground_color_selector.put(colorOnContainer, csl);
            return csl;
        }

        private ColorStateList text_button_background_color_selector(int colorContainer) {
            ColorStateList csl;
            if (this.text_button_background_color_selector == null) {
                this.text_button_background_color_selector = new SparseArray();
            }
            if ((csl = this.text_button_background_color_selector.get(colorContainer)) != null) {
                return csl;
            }
            csl = new ColorStateList(new int[][]{{16842910, 0x10100A0}, StateSet.WILD_CARD}, new int[]{this.colorSecondaryContainer, colorContainer});
            this.text_button_background_color_selector.put(colorContainer, csl);
            return csl;
        }

        private ColorStateList text_button_ripple_color_selector(int colorOnContainer) {
            ColorStateList csl;
            if (this.text_button_ripple_color_selector == null) {
                this.text_button_ripple_color_selector = new SparseArray();
            }
            if ((csl = this.text_button_ripple_color_selector.get(colorOnContainer)) != null) {
                return csl;
            }
            csl = new ColorStateList(new int[][]{{-16842911, 16842919}, {-16842911, 16844130}, {-16842911, 16843623}, {-16842911}, {0x10100A0, 16842919}, {0x10100A0, 16844130}, {0x10100A0, 16843623}, {0x10100A0}, {16842919}, {16844130}, {16843623}, StateSet.WILD_CARD}, new int[]{ColorStateList.modulateColor(colorOnContainer, 0.1f), ColorStateList.modulateColor(colorOnContainer, 0.102f), ColorStateList.modulateColor(colorOnContainer, 0.08f), ColorStateList.modulateColor(colorOnContainer, 0.064f), ColorStateList.modulateColor(this.colorOnSurface, 0.1f), ColorStateList.modulateColor(this.colorOnSecondaryContainer, 0.102f), ColorStateList.modulateColor(this.colorOnSecondaryContainer, 0.08f), ColorStateList.modulateColor(this.colorOnSecondaryContainer, 0.064f), ColorStateList.modulateColor(this.colorOnSecondaryContainer, 0.1f), ColorStateList.modulateColor(this.colorOnSurface, 0.102f), ColorStateList.modulateColor(this.colorOnSurface, 0.08f), ColorStateList.modulateColor(this.colorOnSurface, 0.064f)});
            this.text_button_ripple_color_selector.put(colorOnContainer, csl);
            return csl;
        }

        private ColorStateList radio_button_tint() {
            if (this.radio_button_tint != null) {
                return this.radio_button_tint;
            }
            this.radio_button_tint = new ColorStateList(new int[][]{{-16842910}, {0x10100A0}, StateSet.WILD_CARD}, new int[]{ColorStateList.modulateColor(this.colorOnSurface, 0.38f), this.colorPrimary, this.colorOnSurfaceVariant});
            return this.radio_button_tint;
        }

        private ColorStateList radio_button_ripple_tint() {
            if (this.radio_button_ripple_tint != null) {
                return this.radio_button_ripple_tint;
            }
            this.radio_button_ripple_tint = new ColorStateList(new int[][]{{0x10100A0, 16842919}, {0x10100A0, 16844130}, {0x10100A0, 16843623}, {0x10100A0}, {16842919}, {16844130}, {16843623}, StateSet.WILD_CARD}, new int[]{ColorStateList.modulateColor(this.colorOnSurface, 0.1f), ColorStateList.modulateColor(this.colorPrimary, 0.102f), ColorStateList.modulateColor(this.colorPrimary, 0.08f), ColorStateList.modulateColor(this.colorPrimary, 0.064f), ColorStateList.modulateColor(this.colorPrimary, 0.1f), ColorStateList.modulateColor(this.colorOnSurface, 0.102f), ColorStateList.modulateColor(this.colorOnSurface, 0.08f), ColorStateList.modulateColor(this.colorOnSurface, 0.064f)});
            return this.radio_button_ripple_tint;
        }

        private ColorStateList switch_track_tint() {
            if (this.switch_track_tint != null) {
                return this.switch_track_tint;
            }
            this.switch_track_tint = new ColorStateList(new int[][]{{-16842910, -16842912}, {-16842910, 0x10100A0}, {0x10100A0}, StateSet.WILD_CARD}, new int[]{ColorStateList.modulateColor(this.colorSurfaceContainerHighest, 0.12f), ColorStateList.modulateColor(this.colorOnSurface, 0.12f), this.colorPrimary, this.colorSurfaceContainerHighest});
            return this.switch_track_tint;
        }

        private ColorStateList switch_track_decoration_tint() {
            if (this.switch_track_decoration_tint != null) {
                return this.switch_track_decoration_tint;
            }
            this.switch_track_decoration_tint = new ColorStateList(new int[][]{{0x10100A0}, {-16842910}, StateSet.WILD_CARD}, new int[]{0, ColorStateList.modulateColor(this.colorOnSurface, 0.12f), this.colorOutline});
            return this.switch_track_decoration_tint;
        }

        private ColorStateList switch_thumb_tint() {
            if (this.switch_thumb_tint != null) {
                return this.switch_thumb_tint;
            }
            this.switch_thumb_tint = new ColorStateList(new int[][]{{-16842910, -16842912}, {-16842910, 0x10100A0}, {0x10100A0, 16842919}, {0x10100A0, 16843623}, {0x10100A0, 16844130}, {0x10100A0}, {16842919}, {16843623}, {16844130}, StateSet.WILD_CARD}, new int[]{ColorStateList.modulateColor(this.colorOnSurface, 0.38f), ColorStateList.modulateColor(this.colorSurface, 1.0f), this.colorPrimaryContainer, this.colorPrimaryContainer, this.colorPrimaryContainer, this.colorOnPrimary, this.colorOnSurfaceVariant, this.colorOnSurfaceVariant, this.colorOnSurfaceVariant, this.colorOutline});
            return this.switch_thumb_tint;
        }

        private ColorStateList slider_track_color_active() {
            if (this.slider_track_color_active != null) {
                return this.slider_track_color_active;
            }
            this.slider_track_color_active = new ColorStateList(new int[][]{StateSet.get(8), StateSet.WILD_CARD}, new int[]{this.colorPrimary, ColorStateList.modulateColor(this.colorOnSurface, 0.38f)});
            return this.slider_track_color_active;
        }

        private ColorStateList slider_track_color_inactive() {
            if (this.slider_track_color_inactive != null) {
                return this.slider_track_color_inactive;
            }
            this.slider_track_color_inactive = new ColorStateList(new int[][]{StateSet.get(8), StateSet.WILD_CARD}, new int[]{this.colorSecondaryContainer, ColorStateList.modulateColor(this.colorOnSurface, 0.12f)});
            return this.slider_track_color_inactive;
        }

        private ColorStateList secondary_progress_tint() {
            if (this.secondary_progress_tint != null) {
                return this.secondary_progress_tint;
            }
            this.secondary_progress_tint = new ColorStateList(new int[][]{StateSet.get(8), StateSet.WILD_CARD}, new int[]{this.colorPrimaryContainer, 0});
            return this.secondary_progress_tint;
        }
    }
}

