/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.resources;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.core.Context;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.resources.TypedArray;
import yslelf.cloudpick.graphics.text.Typeface;
import yslelf.cloudpick.graphics.util.ColorStateList;

@ApiStatus.Internal
public class TextAppearance {
    public int mTextColorHighlight = 0;
    public int mSearchResultHighlightColor = 0;
    public int mFocusedSearchResultHighlightColor = 0;
    @Nullable
    public ColorStateList mTextColor = null;
    @Nullable
    public ColorStateList mTextColorHint = null;
    @Nullable
    public ColorStateList mTextColorLink = null;
    public int mTextSize = -1;
    public int mTextSizeUnit = 0;
    public Locale mTextLocale = null;
    public String mFontFamily = null;
    public Typeface mFontTypeface = null;
    public boolean mFontFamilyExplicit = false;
    public int mTypefaceIndex = -1;
    public int mTextStyle = 0;
    public boolean mAllCaps = false;
    public int mShadowColor = 0;
    public float mShadowDx = 0.0f;
    public float mShadowDy = 0.0f;
    public float mShadowRadius = 0.0f;
    public boolean mHasElegant = false;
    public boolean mElegant = false;
    public boolean mHasFallbackLineSpacing = false;
    public boolean mFallbackLineSpacing = false;
    public boolean mHasLetterSpacing = false;
    public float mLetterSpacing = 0.0f;
    public String mFontFeatureSettings = null;
    public String mFontVariationSettings = null;
    public boolean mHasLineBreakStyle = false;
    public boolean mHasLineBreakWordStyle = false;
    public int mLineBreakStyle = 0;
    public int mLineBreakWordStyle = 0;
    public static final String[] STYLEABLE = new String[]{"modernui", "textColor", "modernui", "textColorHighlight", "modernui", "textColorHint", "modernui", "textColorLink", "modernui", "textFontWeight", "modernui", "textSize", "modernui", "textStyle"};

    public TextAppearance() {
    }

    public TextAppearance(@NonNull Context context, ResourceId resId) {
        TypedArray a = resId != null && resId.type().equals("attr") ? context.getTheme().obtainStyledAttributes(null, resId, null, STYLEABLE) : context.getTheme().obtainStyledAttributes(resId, STYLEABLE);
        this.read(a, null);
        a.recycle();
    }

    public void read(@NonNull TypedArray a, @Nullable Int2IntFunction indexMap) {
        int n2 = a.getIndexCount();
        block9: for (int i = 0; i < n2; ++i) {
            int attr2;
            int index = attr2 = a.getIndex(i);
            if (indexMap != null && (index = indexMap.get(attr2)) == -1) continue;
            switch (index) {
                case 0: {
                    this.mTextColor = a.getColorStateList(attr2);
                    continue block9;
                }
                case 1: {
                    this.mTextColorHighlight = a.getColor(attr2, this.mTextColorHighlight);
                    continue block9;
                }
                case 2: {
                    this.mTextColorHint = a.getColorStateList(attr2);
                    continue block9;
                }
                case 3: {
                    this.mTextColorLink = a.getColorStateList(attr2);
                    continue block9;
                }
                case 4: {
                    continue block9;
                }
                case 5: {
                    this.mTextSize = a.getDimensionPixelSize(attr2, this.mTextSize);
                    this.mTextSizeUnit = a.peekValue(attr2).getComplexUnit();
                    continue block9;
                }
                case 6: {
                    this.mTextStyle = a.getInt(attr2, this.mTextStyle);
                }
            }
        }
    }
}

