/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.resources;

import yslelf.cloudpick.graphics.annotation.ColorInt;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.drawable.Drawable;
import yslelf.cloudpick.graphics.resources.BagAttributeFinder;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.resources.Resources;
import yslelf.cloudpick.graphics.resources.TypedValue;
import yslelf.cloudpick.graphics.util.ColorStateList;
import yslelf.cloudpick.graphics.util.DisplayMetrics;

public class TypedArray {
    static final int STYLE_NUM_ENTRIES = 4;
    static final int STYLE_TYPE = 0;
    static final int STYLE_DATA = 1;
    static final int STYLE_COOKIE = 2;
    static final int STYLE_FLAGS = 3;
    private final Resources mResources;
    private DisplayMetrics mMetrics;
    private boolean mRecycled;
    Resources.Theme mTheme;
    int[] mData;
    int[] mIndices;
    int mLength;
    final TypedValue mValue = new TypedValue();
    final BagAttributeFinder mDefStyleAttrFinder = new BagAttributeFinder();

    static TypedArray obtain(Resources res, int len) {
        TypedArray attrs = res.mTypedArrayPool.acquire();
        if (attrs == null) {
            attrs = new TypedArray(res);
        }
        attrs.mRecycled = false;
        attrs.mMetrics = res.getDisplayMetrics();
        attrs.resize(len);
        return attrs;
    }

    private void resize(int len) {
        this.mLength = len;
        int dataLen = len * 4;
        int indicesLen = len + 1;
        if (this.mData == null || this.mData.length < dataLen) {
            this.mData = new int[dataLen];
            this.mIndices = new int[indicesLen];
        }
    }

    public int length() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mLength;
    }

    public int getIndexCount() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mIndices[0];
    }

    public int getIndex(int at) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mIndices[1 + at];
    }

    public Resources getResources() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mResources;
    }

    public boolean getBoolean(int index, boolean defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1] != 0;
        }
        throw new RuntimeException("getBoolean of bad type: 0x" + Integer.toHexString(type));
    }

    public int getInt(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        throw new RuntimeException("getInt of bad type: 0x" + Integer.toHexString(type));
    }

    public float getFloat(int index, float defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 4) {
            return Float.intBitsToFloat(data[index + 1]);
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        throw new RuntimeException("getFloat of bad type: 0x" + Integer.toHexString(type));
    }

    @ColorInt
    public int getColor(int index, @ColorInt int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 3) {
            TypedValue value = this.mValue;
            if (this.getValueAt(index, value)) {
                ColorStateList csl = this.mResources.loadColorStateList(value, this.mTheme);
                return csl.getDefaultColor();
            }
            return defValue;
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to color: type=0x" + Integer.toHexString(type) + ", theme=" + this.mTheme);
    }

    @Nullable
    public ColorStateList getColorStateList(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 4, value)) {
            if (value.type == 2) {
                throw new UnsupportedOperationException("Failed to resolve attribute at index " + index + ": " + value + ", theme=" + this.mTheme);
            }
            return this.mResources.loadColorStateList(value, this.mTheme);
        }
        return null;
    }

    public int getInteger(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to integer: type=0x" + Integer.toHexString(type) + ", theme=" + this.mTheme);
    }

    public float getDimension(int index, float defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 5) {
            return TypedValue.complexToDimension(data[index + 1], this.mMetrics);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to dimension: type=0x" + Integer.toHexString(type) + ", theme=" + this.mTheme);
    }

    public int getDimensionPixelOffset(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelOffset(data[index + 1], this.mMetrics);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to dimension: type=0x" + Integer.toHexString(type) + ", theme=" + this.mTheme);
    }

    public int getDimensionPixelSize(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelSize(data[index + 1], this.mMetrics);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to dimension: type=0x" + Integer.toHexString(type) + ", theme=" + this.mTheme);
    }

    public int getLayoutDimension(int index, int defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        if (type >= 16 && type <= 31) {
            return data[index + 1];
        }
        if (type == 5) {
            return TypedValue.complexToDimensionPixelSize(data[index + 1], this.mMetrics);
        }
        return defValue;
    }

    public float getFraction(int index, int base, int pbase, float defValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int attrIndex = index;
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        if (type == 0) {
            return defValue;
        }
        if (type == 6) {
            return TypedValue.complexToFraction(data[index + 1], base, pbase);
        }
        if (type == 2) {
            TypedValue value = this.mValue;
            this.getValueAt(index, value);
            throw new UnsupportedOperationException("Failed to resolve attribute at index " + attrIndex + ": " + value + ", theme=" + this.mTheme);
        }
        throw new UnsupportedOperationException("Can't convert value at index " + attrIndex + " to fraction: type=0x" + Integer.toHexString(type) + ", theme=" + this.mTheme);
    }

    @Nullable
    public ResourceId getResourceId(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        switch (type & 0xFF) {
            case 1: {
                int typeId = type >>> 8;
                if (typeId != 0) {
                    return this.mResources.getReferenceIdForCookie(data[index + 2], typeId, data[index + 1]);
                }
                return null;
            }
            case 2: {
                return this.mResources.getAttributeIdForCookie(data[index + 2], data[index + 1]);
            }
        }
        return null;
    }

    @Nullable
    public Drawable getDrawable(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 4, value)) {
            if (value.type == 2) {
                throw new UnsupportedOperationException("Failed to resolve attribute at index " + index + ": " + value + ", theme=" + this.mTheme);
            }
            return this.mResources.loadDrawable(value, null, this.mTheme);
        }
        return null;
    }

    public boolean getValue(int index, TypedValue outValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.getValueAt(index * 4, outValue);
    }

    public int getType(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mData[(index *= 4) + 0];
    }

    public boolean hasValue(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        return type != 0;
    }

    public boolean hasValueOrEmpty(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] data = this.mData;
        int type = data[(index *= 4) + 0];
        return type != 0 || data[index + 1] == 1;
    }

    @Nullable
    public TypedValue peekValue(int index) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue value = this.mValue;
        if (this.getValueAt(index * 4, value)) {
            return value;
        }
        return null;
    }

    public void recycle() {
        if (this.mRecycled) {
            throw new RuntimeException(this + " recycled twice!");
        }
        this.mRecycled = true;
        this.mTheme = null;
        this.mValue.object = null;
        this.mResources.mTypedArrayPool.release(this);
    }

    private boolean getValueAt(int offset, @NonNull TypedValue outValue) {
        int[] data = this.mData;
        int type = data[offset + 0];
        if (type == 0) {
            return false;
        }
        outValue.type = type;
        outValue.data = data[offset + 1];
        outValue.cookie = data[offset + 2];
        outValue.flags = data[offset + 3];
        switch (type & 0xFF) {
            case 3: {
                outValue.object = this.loadStringValueAt(offset);
                break;
            }
            case 1: {
                int typeId = type >>> 8;
                if (typeId != 0) {
                    outValue.type = 1;
                    outValue.object = this.mResources.getReferenceIdForCookie(outValue.cookie, typeId, outValue.data);
                    break;
                }
                outValue.object = null;
                break;
            }
            case 2: {
                outValue.object = this.mResources.getAttributeIdForCookie(outValue.cookie, outValue.data);
                break;
            }
            default: {
                outValue.object = null;
            }
        }
        return true;
    }

    @Nullable
    private CharSequence loadStringValueAt(int index) {
        int[] data = this.mData;
        int cookie = data[index + 2];
        CharSequence value = null;
        if (cookie >= 0) {
            value = this.mResources.getPooledStringForCookie(cookie, data[index + 1]);
        }
        return value;
    }

    protected TypedArray(Resources resources) {
        this.mResources = resources;
        this.mMetrics = this.mResources.getDisplayMetrics();
    }
}

