/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.resources;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.resources.AssetManager;
import yslelf.cloudpick.graphics.resources.ResourceId;
import yslelf.cloudpick.graphics.util.DisplayMetrics;

public class TypedValue {
    public static final int TYPE_NULL = 0;
    public static final int TYPE_REFERENCE = 1;
    public static final int TYPE_ATTRIBUTE = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DIMENSION = 5;
    public static final int TYPE_FRACTION = 6;
    @ApiStatus.Internal
    public static final int TYPE_FACTORY = 15;
    public static final int TYPE_FIRST_INT = 16;
    public static final int TYPE_INT_DEC = 16;
    public static final int TYPE_INT_HEX = 17;
    public static final int TYPE_INT_BOOLEAN = 18;
    public static final int TYPE_FIRST_COLOR_INT = 28;
    public static final int TYPE_INT_COLOR_ARGB8 = 28;
    public static final int TYPE_INT_COLOR_RGB8 = 29;
    public static final int TYPE_INT_COLOR_ARGB4 = 30;
    public static final int TYPE_INT_COLOR_RGB4 = 31;
    public static final int TYPE_LAST_COLOR_INT = 31;
    public static final int TYPE_LAST_INT = 31;
    public static final int COMPLEX_UNIT_SHIFT = 0;
    public static final int COMPLEX_UNIT_MASK = 15;
    public static final int COMPLEX_UNIT_PX = 0;
    public static final int COMPLEX_UNIT_DP = 1;
    public static final int COMPLEX_UNIT_SP = 2;
    public static final int COMPLEX_UNIT_PT = 3;
    public static final int COMPLEX_UNIT_IN = 4;
    public static final int COMPLEX_UNIT_MM = 5;
    public static final int COMPLEX_UNIT_FRACTION = 0;
    public static final int COMPLEX_UNIT_FRACTION_PARENT = 1;
    public static final int COMPLEX_RADIX_SHIFT = 4;
    public static final int COMPLEX_RADIX_MASK = 3;
    public static final int COMPLEX_RADIX_23p0 = 0;
    public static final int COMPLEX_RADIX_16p7 = 1;
    public static final int COMPLEX_RADIX_8p15 = 2;
    public static final int COMPLEX_RADIX_0p23 = 3;
    public static final int COMPLEX_MANTISSA_SHIFT = 8;
    public static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    public static final int DATA_NULL_UNDEFINED = 0;
    public static final int DATA_NULL_EMPTY = 1;
    public int type;
    @ApiStatus.Internal
    public Object object;
    public int data;
    public int cookie = -1;
    @ApiStatus.Internal
    public int flags = -1;
    private static final float MANTISSA_MULT = 0.00390625f;
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNIT_STRS = new String[]{"px", "dp", "sp", "pt", "in", "mm"};
    private static final String[] FRACTION_UNIT_STRS = new String[]{"%", "%p"};

    public final float getFloat() {
        return Float.intBitsToFloat(this.data);
    }

    public boolean isColorType() {
        return this.type >= 28 && this.type <= 31;
    }

    public static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }

    public static float complexToDimension(int data, DisplayMetrics metrics) {
        return TypedValue.applyDimension(data >> 0 & 0xF, TypedValue.complexToFloat(data), metrics);
    }

    public static int complexToDimensionPixelOffset(int data, DisplayMetrics metrics) {
        return (int)TypedValue.applyDimension(data >> 0 & 0xF, TypedValue.complexToFloat(data), metrics);
    }

    public static int complexToDimensionPixelSize(int data, DisplayMetrics metrics) {
        float value = TypedValue.complexToFloat(data);
        float f2 = TypedValue.applyDimension(data >> 0 & 0xF, value, metrics);
        int res = (int)(f2 >= 0.0f ? f2 + 0.5f : f2 - 0.5f);
        if (res != 0) {
            return res;
        }
        if (value == 0.0f) {
            return 0;
        }
        if (value > 0.0f) {
            return 1;
        }
        return -1;
    }

    public int getComplexUnit() {
        return TypedValue.getUnitFromComplexDimension(this.data);
    }

    public static int getUnitFromComplexDimension(int complexDimension) {
        return 0xF & complexDimension >> 0;
    }

    public static float applyDimension(int unit, float value, DisplayMetrics metrics) {
        return switch (unit) {
            case 0 -> value;
            case 1 -> value * metrics.density;
            case 2 -> value * metrics.scaledDensity;
            case 3 -> value * metrics.xdpi * 0.013888889f;
            case 4 -> value * metrics.xdpi;
            case 5 -> value * metrics.xdpi * 0.03937008f;
            default -> 0.0f;
        };
    }

    @ApiStatus.Internal
    public static int intToComplex(int value) {
        if (value < -8388608 || value >= 0x800000) {
            throw new IllegalArgumentException("Magnitude of the value is too large: " + value);
        }
        return 0 | value << 8;
    }

    @ApiStatus.Internal
    public static int floatToComplex(float value) {
        int shift;
        int radix;
        if (value < -8388608.0f || value >= 8388607.5f) {
            throw new IllegalArgumentException("Magnitude of the value is too large: " + value);
        }
        int bits = Float.floatToRawIntBits(value) + 0xB800000;
        long mag = (long)(Float.intBitsToFloat(bits & Integer.MAX_VALUE) + 0.5f);
        if ((mag & 0x7FFFFFL) == 0L) {
            radix = 0;
            shift = 23;
        } else if ((mag & 0x7FFFFFFFFF800000L) == 0L) {
            radix = 3;
            shift = 0;
        } else if ((mag & 0x7FFFFFFF80000000L) == 0L) {
            radix = 2;
            shift = 8;
        } else if ((mag & 0x7FFFFF8000000000L) == 0L) {
            radix = 1;
            shift = 16;
        } else {
            radix = 0;
            shift = 23;
        }
        int mantissa = (int)(mag >>> shift) & 0xFFFFFF;
        if ((bits & Integer.MIN_VALUE) != 0) {
            mantissa = -mantissa;
        }
        assert (mantissa >= -8388608 && mantissa < 0x800000);
        return radix << 4 | mantissa << 8;
    }

    @ApiStatus.Internal
    public static int createComplexDimension(int value, int units) {
        if (units < 0 || units > 5) {
            throw new IllegalArgumentException("Must be a valid COMPLEX_UNIT_*: " + units);
        }
        return TypedValue.intToComplex(value) | units;
    }

    @ApiStatus.Internal
    public static int createComplexDimension(float value, int units) {
        if (units < 0 || units > 5) {
            throw new IllegalArgumentException("Must be a valid COMPLEX_UNIT_*: " + units);
        }
        return TypedValue.floatToComplex(value) | units;
    }

    public static float complexToFraction(int data, float base, float pbase) {
        return switch (data >> 0 & 0xF) {
            case 0 -> TypedValue.complexToFloat(data) * base;
            case 1 -> TypedValue.complexToFloat(data) * pbase;
            default -> 0.0f;
        };
    }

    @Nullable
    public final ResourceId getResourceId() {
        if (this.type == 1 || this.type == 2) {
            return (ResourceId)this.object;
        }
        return null;
    }

    @ApiStatus.Experimental
    public final int getChangingConfigurations() {
        return this.flags;
    }

    public final CharSequence coerceToString() {
        int t2 = this.type;
        if (t2 == 3) {
            return (CharSequence)this.object;
        }
        if (t2 == 1) {
            return "@" + this.object;
        }
        if (t2 == 2) {
            return "?" + this.object;
        }
        return TypedValue.coerceToString(t2, this.data);
    }

    @Nullable
    public static String coerceToString(int type, int data) {
        switch (type) {
            case 0: {
                return null;
            }
            case 4: {
                return Float.toString(Float.intBitsToFloat(data));
            }
            case 5: {
                return TypedValue.complexToFloat(data) + DIMENSION_UNIT_STRS[data >> 0 & 0xF];
            }
            case 6: {
                return TypedValue.complexToFloat(data) * 100.0f + FRACTION_UNIT_STRS[data >> 0 & 0xF];
            }
            case 17: {
                return "0x" + Integer.toHexString(data);
            }
            case 18: {
                return data != 0 ? "true" : "false";
            }
        }
        if (type >= 28 && type <= 31) {
            return String.format(Locale.ROOT, "#%08X", data);
        }
        if (type >= 16 && type <= 31) {
            return Integer.toString(data);
        }
        return null;
    }

    @ApiStatus.Internal
    public void reset() {
        this.type = 0;
        this.data = 0;
        this.cookie = -1;
        this.flags = 0;
    }

    @ApiStatus.Internal
    public void setTo(@NonNull AssetManager.ResolvedBag bag, int index) {
        int offset = index * 3;
        this.type = bag.values[offset + 0];
        this.data = bag.values[offset + 1];
        this.cookie = bag.values[offset + 2];
        this.flags = bag.typeSpecFlags;
    }

    public void setTo(@NonNull TypedValue v) {
        this.type = v.type;
        this.object = v.object;
        this.data = v.data;
        this.cookie = v.cookie;
        this.flags = v.flags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TypedValue{t=0x").append(Integer.toHexString(this.type));
        sb.append("/d=0x").append(Integer.toHexString(this.data));
        if (this.type == 3 || this.type == 1 || this.type == 2) {
            sb.append(" \"").append(this.object != null ? this.object : "<null>").append("\"");
        }
        if (this.cookie != 0) {
            sb.append(" a=").append(this.cookie);
        }
        sb.append("}");
        return sb.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @ApiStatus.Internal
    public static @interface ComplexDimensionUnit {
    }
}

