/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import yslelf.cloudpick.graphics.annotation.FloatRange;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.graphics.text.FontMetricsInt;
import yslelf.cloudpick.graphics.graphics.text.LineBreakConfig;
import yslelf.cloudpick.graphics.text.Directions;
import yslelf.cloudpick.graphics.text.Editable;
import yslelf.cloudpick.graphics.text.Layout;
import yslelf.cloudpick.graphics.text.PackedIntVector;
import yslelf.cloudpick.graphics.text.PackedObjectVector;
import yslelf.cloudpick.graphics.text.SpanWatcher;
import yslelf.cloudpick.graphics.text.Spannable;
import yslelf.cloudpick.graphics.text.Spanned;
import yslelf.cloudpick.graphics.text.StaticLayout;
import yslelf.cloudpick.graphics.text.TextDirectionHeuristic;
import yslelf.cloudpick.graphics.text.TextDirectionHeuristics;
import yslelf.cloudpick.graphics.text.TextPaint;
import yslelf.cloudpick.graphics.text.TextUtils;
import yslelf.cloudpick.graphics.text.TextWatcher;
import yslelf.cloudpick.graphics.text.style.UpdateLayout;
import yslelf.cloudpick.graphics.text.style.WrapTogetherSpan;
import yslelf.cloudpick.graphics.util.GrowingArrayUtils;
import yslelf.cloudpick.graphics.util.Pools;

public class DynamicLayout
extends Layout {
    private static final Pools.Pool<Builder> sPool = Pools.newSynchronizedPool(2);
    private static StaticLayout sStaticLayout = null;
    private static StaticLayout.Builder sBuilder = null;
    private static final Object[] sLock = new Object[0];
    private static final int PRIORITY = 128;
    private static final int BLOCK_MINIMUM_CHARACTER_LENGTH = 400;
    private static final int START = 0;
    private static final int DIR = 0;
    private static final int TAB = 0;
    private static final int TOP = 1;
    private static final int DESCENT = 2;
    private static final int EXTRA = 3;
    private static final int COLUMNS_NORMAL = 4;
    private static final int ELLIPSIS_START = 4;
    private static final int ELLIPSIS_COUNT = 5;
    private static final int COLUMNS_ELLIPSIZE = 6;
    private static final int START_MASK = 0x1FFFFFFF;
    private static final int DIR_SHIFT = 30;
    private static final int TAB_MASK = 0x20000000;
    private static final int ELLIPSIS_UNDEFINED = Integer.MIN_VALUE;
    private CharSequence mBase;
    private final CharSequence mDisplay;
    private ChangeWatcher mWatcher;
    private final boolean mIncludePad;
    private boolean mFallbackLineSpacing;
    private boolean mEllipsize;
    private int mEllipsizedWidth;
    private TextUtils.TruncateAt mEllipsizeAt;
    private PackedIntVector mInts;
    private PackedObjectVector<Directions> mObjects;
    public static final int INVALID_BLOCK_INDEX = -1;
    private int[] mBlockEndLines;
    private int[] mBlockIndices;
    private IntArrayList mBlocksAlwaysNeedToBeRedrawn;
    private int mNumberOfBlocks;
    private int mIndexFirstChangedBlock;
    private int mTopPadding;
    private int mBottomPadding;

    @Nonnull
    public static Builder builder(@Nonnull CharSequence base, @Nonnull TextPaint paint, int width) {
        Builder b = sPool.acquire();
        if (b == null) {
            b = new Builder();
        }
        b.mBase = base;
        b.mDisplay = base;
        b.mPaint = paint;
        b.mWidth = width;
        b.mAlignment = Layout.Alignment.ALIGN_NORMAL;
        b.mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
        b.mSpacingMult = 1.0f;
        b.mSpacingAdd = 0.0f;
        b.mIncludePad = true;
        b.mFallbackLineSpacing = true;
        b.mEllipsizedWidth = width;
        b.mEllipsize = null;
        return b;
    }

    private DynamicLayout(@Nonnull Builder b) {
        super(DynamicLayout.createEllipsizer(b.mEllipsize, b.mDisplay), b.mPaint, b.mWidth, b.mAlignment, b.mTextDir, b.mSpacingMult, b.mSpacingAdd);
        this.mDisplay = b.mDisplay;
        this.mIncludePad = b.mIncludePad;
        this.generate(b);
    }

    @Nonnull
    private static CharSequence createEllipsizer(@Nullable TextUtils.TruncateAt ellipsize, @Nonnull CharSequence display) {
        if (ellipsize == null) {
            return display;
        }
        if (display instanceof Spanned) {
            return new Layout.SpannedEllipsizer(display);
        }
        return new Layout.Ellipsizer(display);
    }

    private void generate(@Nonnull Builder b) {
        int[] start;
        this.mBase = b.mBase;
        this.mFallbackLineSpacing = b.mFallbackLineSpacing;
        if (b.mEllipsize != null) {
            this.mInts = new PackedIntVector(6);
            this.mEllipsizedWidth = b.mEllipsizedWidth;
            this.mEllipsizeAt = b.mEllipsize;
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = b.mEllipsizedWidth;
            e.mMethod = b.mEllipsize;
            this.mEllipsize = true;
        } else {
            this.mInts = new PackedIntVector(4);
            this.mEllipsizedWidth = b.mWidth;
            this.mEllipsizeAt = null;
        }
        this.mObjects = new PackedObjectVector(1);
        if (b.mEllipsize != null) {
            start = new int[6];
            start[4] = Integer.MIN_VALUE;
        } else {
            start = new int[4];
        }
        Directions[] dirs = new Directions[]{Directions.ALL_LEFT_TO_RIGHT};
        FontMetricsInt fm = b.mFontMetricsInt;
        b.mPaint.getFontMetricsInt(fm);
        int asc = fm.ascent;
        int desc = fm.descent;
        start[0] = 0x40000000;
        start[1] = 0;
        start[2] = desc;
        this.mInts.insertAt(0, start);
        start[1] = desc - asc;
        this.mInts.insertAt(1, start);
        this.mObjects.insertAt(0, (Directions[])dirs);
        this.reflow(this.mBase, 0, 0, this.mDisplay.length());
        CharSequence charSequence = this.mBase;
        if (charSequence instanceof Spannable) {
            Spannable sp = (Spannable)charSequence;
            if (this.mWatcher == null) {
                this.mWatcher = new ChangeWatcher(this);
            }
            int baseLength = this.mBase.length();
            List<ChangeWatcher> spans = sp.getSpans(0, baseLength, ChangeWatcher.class);
            for (ChangeWatcher span : spans) {
                sp.removeSpan(span);
            }
            sp.setSpan(this.mWatcher, 0, baseLength, 8388626);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reflow(CharSequence s, int where, int before, int after) {
        if (s != this.mBase) {
            return;
        }
        CharSequence text = this.mDisplay;
        int len = text.length();
        int find = TextUtils.lastIndexOf(text, '\n', where - 1);
        find = find < 0 ? 0 : ++find;
        int diff = where - find;
        before += diff;
        int look = TextUtils.indexOf(text, '\n', (where -= diff) + (after += diff));
        look = look < 0 ? len : ++look;
        int change = look - (where + after);
        before += change;
        after += change;
        if (text instanceof Spanned) {
            boolean again;
            Spanned sp = (Spanned)text;
            do {
                again = false;
                List<WrapTogetherSpan> force = sp.getSpans(where, where + after, WrapTogetherSpan.class);
                for (WrapTogetherSpan span : force) {
                    int diff2;
                    int st = sp.getSpanStart(span);
                    int en = sp.getSpanEnd(span);
                    if (st < where) {
                        again = true;
                        diff2 = where - st;
                        before += diff2;
                        after += diff2;
                        where -= diff2;
                    }
                    if (en <= where + after) continue;
                    again = true;
                    diff2 = en - (where + after);
                    before += diff2;
                    after += diff2;
                }
            } while (again);
        }
        int startline = this.getLineForOffset(where);
        int startv = this.getLineTop(startline);
        int endline = this.getLineForOffset(where + before);
        if (where + after == len) {
            endline = this.getLineCount();
        }
        int endv = this.getLineTop(endline);
        boolean islast = endline == this.getLineCount();
        Object[] diff3 = sLock;
        synchronized (sLock) {
            int[] ints;
            StaticLayout reflowed = sStaticLayout;
            StaticLayout.Builder b = sBuilder;
            sStaticLayout = null;
            sBuilder = null;
            // ** MonitorExit[diff] (shouldn't be in output)
            if (reflowed == null) {
                reflowed = new StaticLayout(null);
                b = StaticLayout.builder(text, where, where + after, this.getPaint(), this.getWidth());
            }
            b.setText(text, where, where + after).setPaint(this.getPaint()).setWidth(this.getWidth()).setTextDirection(this.getTextDirectionHeuristic()).setLineSpacing(this.getSpacingAdd(), this.getSpacingMultiplier()).setFallbackLineSpacing(this.mFallbackLineSpacing).setEllipsizedWidth(this.mEllipsizedWidth).setEllipsize(this.mEllipsizeAt).setAddLastLineLineSpacing(!islast).setIncludePad(false);
            reflowed.generate(b, false, true);
            int n2 = reflowed.getLineCount();
            if (where + after != len && reflowed.getLineStart(n2 - 1) == where + after) {
                --n2;
            }
            this.mInts.deleteAt(startline, endline - startline);
            this.mObjects.deleteAt(startline, endline - startline);
            int ht = reflowed.getLineTop(n2);
            int toppad = 0;
            int botpad = 0;
            if (this.mIncludePad && startline == 0) {
                this.mTopPadding = toppad = reflowed.getTopPadding();
                ht -= toppad;
            }
            if (this.mIncludePad && islast) {
                this.mBottomPadding = botpad = reflowed.getBottomPadding();
                ht += botpad;
            }
            this.mInts.adjustValuesBelow(startline, 0, after - before);
            this.mInts.adjustValuesBelow(startline, 1, startv - endv + ht);
            if (this.mEllipsize) {
                ints = new int[6];
                ints[4] = Integer.MIN_VALUE;
            } else {
                ints = new int[4];
            }
            Directions[] objects = new Directions[1];
            for (int i = 0; i < n2; ++i) {
                int start;
                ints[0] = start = reflowed.getLineStart(i);
                ints[0] = ints[0] | reflowed.getParagraphDirection(i) << 30;
                ints[0] = ints[0] | (reflowed.getLineContainsTab(i) ? 0x20000000 : 0);
                int top = reflowed.getLineTop(i) + startv;
                if (i > 0) {
                    top -= toppad;
                }
                ints[1] = top;
                int desc = reflowed.getLineDescent(i);
                if (i == n2 - 1) {
                    desc += botpad;
                }
                ints[2] = desc;
                ints[3] = reflowed.getLineExtra(i);
                objects[0] = reflowed.getLineDirections(i);
                if (this.mEllipsize) {
                    ints[4] = reflowed.getEllipsisStart(i);
                    ints[5] = reflowed.getEllipsisCount(i);
                }
                this.mInts.insertAt(startline + i, ints);
                this.mObjects.insertAt(startline + i, (Directions[])objects);
            }
            this.updateBlocks(startline, endline - 1, n2);
            b.release();
            Object[] objectArray = sLock;
            synchronized (sLock) {
                sStaticLayout = reflowed;
                sBuilder = b;
                // ** MonitorExit[var23_33] (shouldn't be in output)
                return;
            }
        }
    }

    private void createBlocks() {
        int offset = 400;
        this.mNumberOfBlocks = 0;
        CharSequence text = this.mDisplay;
        while (true) {
            if ((offset = TextUtils.indexOf(text, '\n', offset)) < 0) break;
            this.addBlockAtOffset(offset);
            offset += 400;
        }
        this.addBlockAtOffset(text.length());
        this.mBlockIndices = new int[this.mBlockEndLines.length];
        for (int i = 0; i < this.mBlockEndLines.length; ++i) {
            this.mBlockIndices[i] = -1;
        }
    }

    @Nullable
    public IntArrayList getBlocksAlwaysNeedToBeRedrawn() {
        return this.mBlocksAlwaysNeedToBeRedrawn;
    }

    private void updateAlwaysNeedsToBeRedrawn(int blockIndex) {
        if (this.mBlocksAlwaysNeedToBeRedrawn == null) {
            this.mBlocksAlwaysNeedToBeRedrawn = new IntArrayList();
        }
        if (!this.mBlocksAlwaysNeedToBeRedrawn.contains(blockIndex)) {
            this.mBlocksAlwaysNeedToBeRedrawn.add(blockIndex);
        }
    }

    private void addBlockAtOffset(int offset) {
        int line = this.getLineForOffset(offset);
        if (this.mBlockEndLines == null) {
            this.mBlockEndLines = new int[1];
            this.mBlockEndLines[this.mNumberOfBlocks] = line;
            this.updateAlwaysNeedsToBeRedrawn(this.mNumberOfBlocks);
            ++this.mNumberOfBlocks;
            return;
        }
        int previousBlockEndLine = this.mBlockEndLines[this.mNumberOfBlocks - 1];
        if (line > previousBlockEndLine) {
            this.mBlockEndLines = GrowingArrayUtils.append(this.mBlockEndLines, this.mNumberOfBlocks, line);
            this.updateAlwaysNeedsToBeRedrawn(this.mNumberOfBlocks);
            ++this.mNumberOfBlocks;
        }
    }

    public void updateBlocks(int startLine, int endLine, int newLineCount) {
        int newFirstChangedBlock;
        int i;
        int numRemovedBlocks;
        int newNumberOfBlocks;
        int i2;
        if (this.mBlockEndLines == null) {
            this.createBlocks();
            return;
        }
        int firstBlock = -1;
        int lastBlock = -1;
        for (i2 = 0; i2 < this.mNumberOfBlocks; ++i2) {
            if (this.mBlockEndLines[i2] < startLine) continue;
            firstBlock = i2;
            break;
        }
        for (i2 = firstBlock; i2 < this.mNumberOfBlocks; ++i2) {
            if (this.mBlockEndLines[i2] < endLine) continue;
            lastBlock = i2;
            break;
        }
        int lastBlockEndLine = this.mBlockEndLines[lastBlock];
        boolean createBlockBefore = startLine > (firstBlock == 0 ? 0 : this.mBlockEndLines[firstBlock - 1] + 1);
        boolean createBlock = newLineCount > 0;
        boolean createBlockAfter = endLine < this.mBlockEndLines[lastBlock];
        int numAddedBlocks = 0;
        if (createBlockBefore) {
            ++numAddedBlocks;
        }
        if (createBlock) {
            ++numAddedBlocks;
        }
        if (createBlockAfter) {
            ++numAddedBlocks;
        }
        if ((newNumberOfBlocks = this.mNumberOfBlocks + numAddedBlocks - (numRemovedBlocks = lastBlock - firstBlock + 1)) == 0) {
            this.mBlockEndLines[0] = 0;
            this.mBlockIndices[0] = -1;
            this.mNumberOfBlocks = 1;
            return;
        }
        if (newNumberOfBlocks > this.mBlockEndLines.length) {
            int[] blockEndLines = new int[Math.max(this.mBlockEndLines.length * 2, newNumberOfBlocks)];
            int[] blockIndices = new int[blockEndLines.length];
            System.arraycopy(this.mBlockEndLines, 0, blockEndLines, 0, firstBlock);
            System.arraycopy(this.mBlockIndices, 0, blockIndices, 0, firstBlock);
            System.arraycopy(this.mBlockEndLines, lastBlock + 1, blockEndLines, firstBlock + numAddedBlocks, this.mNumberOfBlocks - lastBlock - 1);
            System.arraycopy(this.mBlockIndices, lastBlock + 1, blockIndices, firstBlock + numAddedBlocks, this.mNumberOfBlocks - lastBlock - 1);
            this.mBlockEndLines = blockEndLines;
            this.mBlockIndices = blockIndices;
        } else if (numAddedBlocks + numRemovedBlocks != 0) {
            System.arraycopy(this.mBlockEndLines, lastBlock + 1, this.mBlockEndLines, firstBlock + numAddedBlocks, this.mNumberOfBlocks - lastBlock - 1);
            System.arraycopy(this.mBlockIndices, lastBlock + 1, this.mBlockIndices, firstBlock + numAddedBlocks, this.mNumberOfBlocks - lastBlock - 1);
        }
        if (numAddedBlocks + numRemovedBlocks != 0 && this.mBlocksAlwaysNeedToBeRedrawn != null) {
            IntArrayList list = new IntArrayList();
            int changedBlockCount = numAddedBlocks - numRemovedBlocks;
            for (i = 0; i < this.mBlocksAlwaysNeedToBeRedrawn.size(); ++i) {
                int block = this.mBlocksAlwaysNeedToBeRedrawn.getInt(i);
                if (block < firstBlock && !list.contains(block)) {
                    list.add(block);
                }
                if (block <= lastBlock || list.contains(block += changedBlockCount)) continue;
                list.add(block);
            }
            this.mBlocksAlwaysNeedToBeRedrawn = list;
        }
        this.mNumberOfBlocks = newNumberOfBlocks;
        int deltaLines = newLineCount - (endLine - startLine + 1);
        if (deltaLines != 0) {
            i = newFirstChangedBlock = firstBlock + numAddedBlocks;
            while (i < this.mNumberOfBlocks) {
                int n2 = i++;
                this.mBlockEndLines[n2] = this.mBlockEndLines[n2] + deltaLines;
            }
        } else {
            newFirstChangedBlock = this.mNumberOfBlocks;
        }
        this.mIndexFirstChangedBlock = Math.min(this.mIndexFirstChangedBlock, newFirstChangedBlock);
        int blockIndex = firstBlock;
        if (createBlockBefore) {
            this.mBlockEndLines[blockIndex] = startLine - 1;
            this.updateAlwaysNeedsToBeRedrawn(blockIndex);
            this.mBlockIndices[blockIndex] = -1;
            ++blockIndex;
        }
        if (createBlock) {
            this.mBlockEndLines[blockIndex] = startLine + newLineCount - 1;
            this.updateAlwaysNeedsToBeRedrawn(blockIndex);
            this.mBlockIndices[blockIndex] = -1;
            ++blockIndex;
        }
        if (createBlockAfter) {
            this.mBlockEndLines[blockIndex] = lastBlockEndLine + deltaLines;
            this.updateAlwaysNeedsToBeRedrawn(blockIndex);
            this.mBlockIndices[blockIndex] = -1;
        }
    }

    public void setBlocksDataForTest(int[] blockEndLines, int[] blockIndices, int numberOfBlocks, int totalLines) {
        this.mBlockEndLines = new int[blockEndLines.length];
        this.mBlockIndices = new int[blockIndices.length];
        System.arraycopy(blockEndLines, 0, this.mBlockEndLines, 0, blockEndLines.length);
        System.arraycopy(blockIndices, 0, this.mBlockIndices, 0, blockIndices.length);
        this.mNumberOfBlocks = numberOfBlocks;
        while (this.mInts.size() < totalLines) {
            this.mInts.insertAt(this.mInts.size(), new int[4]);
        }
    }

    public int[] getBlockEndLines() {
        return this.mBlockEndLines;
    }

    public int[] getBlockIndices() {
        return this.mBlockIndices;
    }

    public int getBlockIndex(int index) {
        return this.mBlockIndices[index];
    }

    public void setBlockIndex(int index, int blockIndex) {
        this.mBlockIndices[index] = blockIndex;
    }

    public int getNumberOfBlocks() {
        return this.mNumberOfBlocks;
    }

    public int getIndexFirstChangedBlock() {
        return this.mIndexFirstChangedBlock;
    }

    public void setIndexFirstChangedBlock(int i) {
        this.mIndexFirstChangedBlock = i;
    }

    @Override
    public int getLineCount() {
        return this.mInts.size() - 1;
    }

    @Override
    public int getLineTop(int line) {
        return this.mInts.getValue(line, 1);
    }

    @Override
    public int getLineDescent(int line) {
        return this.mInts.getValue(line, 2);
    }

    @Override
    public int getLineExtra(int line) {
        return this.mInts.getValue(line, 3);
    }

    @Override
    public int getLineStart(int line) {
        return this.mInts.getValue(line, 0) & 0x1FFFFFFF;
    }

    @Override
    public boolean getLineContainsTab(int line) {
        return (this.mInts.getValue(line, 0) & 0x20000000) != 0;
    }

    @Override
    public int getParagraphDirection(int line) {
        return this.mInts.getValue(line, 0) >> 30;
    }

    @Override
    public final Directions getLineDirections(int line) {
        return this.mObjects.getValue(line, 0);
    }

    @Override
    public int getTopPadding() {
        return this.mTopPadding;
    }

    @Override
    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    @Override
    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    @Override
    public int getEllipsisStart(int line) {
        if (this.mEllipsizeAt == null) {
            return 0;
        }
        return this.mInts.getValue(line, 4);
    }

    @Override
    public int getEllipsisCount(int line) {
        if (this.mEllipsizeAt == null) {
            return 0;
        }
        return this.mInts.getValue(line, 5);
    }

    public static final class Builder {
        private final FontMetricsInt mFontMetricsInt = new FontMetricsInt();
        private CharSequence mBase;
        private CharSequence mDisplay;
        private TextPaint mPaint;
        private int mWidth;
        private Layout.Alignment mAlignment;
        private TextDirectionHeuristic mTextDir;
        private float mSpacingMult;
        private float mSpacingAdd;
        private boolean mIncludePad;
        private boolean mFallbackLineSpacing;
        private TextUtils.TruncateAt mEllipsize;
        private int mEllipsizedWidth;
        private LineBreakConfig mLineBreakConfig = LineBreakConfig.NONE;

        private Builder() {
        }

        private void recycle() {
            this.mBase = null;
            this.mDisplay = null;
            this.mPaint = null;
            sPool.release(this);
        }

        @Nonnull
        public Builder setDisplayText(@Nonnull CharSequence display) {
            this.mDisplay = display;
            return this;
        }

        @Nonnull
        public Builder setAlignment(@Nonnull Layout.Alignment alignment) {
            this.mAlignment = alignment;
            return this;
        }

        @Nonnull
        public Builder setTextDirection(@Nonnull TextDirectionHeuristic textDir) {
            this.mTextDir = textDir;
            return this;
        }

        @NonNull
        public Builder setLineSpacing(float spacingAdd, @FloatRange(from=0.0) float spacingMult) {
            this.mSpacingAdd = spacingAdd;
            this.mSpacingMult = spacingMult;
            return this;
        }

        @Nonnull
        public Builder setIncludePad(boolean includePad) {
            this.mIncludePad = includePad;
            return this;
        }

        @Nonnull
        public Builder setFallbackLineSpacing(boolean fallbackLineSpacing) {
            this.mFallbackLineSpacing = fallbackLineSpacing;
            return this;
        }

        @Nonnull
        public Builder setEllipsizedWidth(int ellipsizedWidth) {
            this.mEllipsizedWidth = ellipsizedWidth;
            return this;
        }

        public Builder setEllipsize(@Nullable TextUtils.TruncateAt ellipsize) {
            this.mEllipsize = ellipsize;
            return this;
        }

        @Nonnull
        public DynamicLayout build() {
            DynamicLayout result = new DynamicLayout(this);
            this.recycle();
            return result;
        }
    }

    private static class ChangeWatcher
    implements TextWatcher,
    SpanWatcher {
        private final WeakReference<DynamicLayout> mLayout;

        public ChangeWatcher(DynamicLayout layout) {
            this.mLayout = new WeakReference<DynamicLayout>(layout);
        }

        private void reflow(CharSequence s, int where, int before, int after) {
            DynamicLayout ml = (DynamicLayout)this.mLayout.get();
            if (ml != null) {
                ml.reflow(s, where, before, after);
            } else if (s instanceof Spannable) {
                ((Spannable)s).removeSpan(this);
            }
        }

        @Override
        public void beforeTextChanged(CharSequence s, int where, int before, int after) {
        }

        @Override
        public void onTextChanged(CharSequence s, int where, int before, int after) {
            this.reflow(s, where, before, after);
        }

        @Override
        public void afterTextChanged(Editable s) {
        }

        @Override
        public void onSpanAdded(Spannable s, Object o, int start, int end) {
            if (o instanceof UpdateLayout) {
                this.reflow(s, start, end - start, end - start);
            }
        }

        @Override
        public void onSpanRemoved(Spannable s, Object o, int start, int end) {
            if (o instanceof UpdateLayout) {
                this.reflow(s, start, end - start, end - start);
            }
        }

        @Override
        public void onSpanChanged(Spannable s, Object o, int start, int end, int nstart, int nend) {
            if (o instanceof UpdateLayout) {
                if (start > end) {
                    start = 0;
                }
                this.reflow(s, start, end - start, end - start);
                this.reflow(s, nstart, nend - nstart, nend - nstart);
            }
        }
    }
}

