/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Bidi;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import yslelf.cloudpick.graphics.annotation.IntRange;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.MathUtil;
import yslelf.cloudpick.graphics.graphics.text.FontMetricsInt;
import yslelf.cloudpick.graphics.graphics.text.FontPaint;
import yslelf.cloudpick.graphics.graphics.text.LineBreakConfig;
import yslelf.cloudpick.graphics.graphics.text.MeasuredText;
import yslelf.cloudpick.graphics.text.Directions;
import yslelf.cloudpick.graphics.text.Spanned;
import yslelf.cloudpick.graphics.text.TextDirectionHeuristic;
import yslelf.cloudpick.graphics.text.TextDirectionHeuristics;
import yslelf.cloudpick.graphics.text.TextPaint;
import yslelf.cloudpick.graphics.text.TextUtils;
import yslelf.cloudpick.graphics.text.style.MetricAffectingSpan;
import yslelf.cloudpick.graphics.text.style.ReplacementSpan;
import yslelf.cloudpick.graphics.util.Pools;

@NotThreadSafe
public class MeasuredParagraph {
    private static final Pools.Pool<MeasuredParagraph> sPool = Pools.newSynchronizedPool(2);
    @Nullable
    private Spanned mSpanned;
    private int mTextStart;
    private char[] mCopiedBuffer;
    @Nullable
    private Bidi mBidi;
    @NonNull
    private final IntArrayList mSpanEndCache = new IntArrayList();
    @NonNull
    private final IntArrayList mFontMetrics = new IntArrayList();
    @Nullable
    private MeasuredText mMeasuredText;
    @NonNull
    private final FontMetricsInt mCachedFm = new FontMetricsInt();

    private MeasuredParagraph() {
    }

    public void release() {
        this.reset();
        this.mSpanEndCache.trim();
        this.mFontMetrics.trim();
    }

    private void reset() {
        this.mSpanned = null;
        this.mCopiedBuffer = null;
        this.mBidi = null;
        this.mSpanEndCache.clear();
        this.mFontMetrics.clear();
        this.mMeasuredText = null;
    }

    public int getTextStart() {
        return this.mTextStart;
    }

    public int getTextLength() {
        return this.mCopiedBuffer.length;
    }

    @NonNull
    public char[] getChars() {
        return this.mCopiedBuffer;
    }

    public int getParagraphDir() {
        if (this.mBidi == null) {
            return 1;
        }
        return (this.mBidi.getParaLevel() & 1) == 0 ? 1 : -1;
    }

    @NonNull
    public Directions getDirections(int start, int end) {
        if (this.mBidi == null) {
            return Directions.ALL_LEFT_TO_RIGHT;
        }
        if (start == end) {
            if ((this.mBidi.getParaLevel() & 1) == 0) {
                return Directions.ALL_LEFT_TO_RIGHT;
            }
            return Directions.ALL_RIGHT_TO_LEFT;
        }
        Bidi bidi = this.mBidi.createLineBidi(start, end);
        if (bidi.getRunCount() == 1) {
            if (bidi.getRunLevel(0) == 1) {
                return Directions.ALL_RIGHT_TO_LEFT;
            }
            if (bidi.getRunLevel(0) == 0) {
                return Directions.ALL_LEFT_TO_RIGHT;
            }
            return new Directions(new int[]{0, bidi.getRunLevel(0) << 26 | end - start});
        }
        byte[] levels = new byte[bidi.getRunCount()];
        for (int i = 0; i < bidi.getRunCount(); ++i) {
            levels[i] = (byte)bidi.getRunLevel(i);
        }
        int[] visualOrders = Bidi.reorderVisual((byte[])levels);
        int[] dirs = new int[bidi.getRunCount() * 2];
        for (int i = 0; i < bidi.getRunCount(); ++i) {
            int vIndex = (this.mBidi.getBaseLevel() & 1) == 1 ? visualOrders[bidi.getRunCount() - i - 1] : visualOrders[i];
            dirs[i * 2] = bidi.getRunStart(vIndex);
            dirs[i * 2 + 1] = bidi.getRunLevel(vIndex) << 26 | bidi.getRunLimit(vIndex) - dirs[i * 2];
        }
        return new Directions(dirs);
    }

    @NonNull
    public IntArrayList getSpanEndCache() {
        return this.mSpanEndCache;
    }

    @NonNull
    public IntArrayList getFontMetrics() {
        return this.mFontMetrics;
    }

    @Nullable
    public MeasuredText getMeasuredText() {
        return this.mMeasuredText;
    }

    public float getAdvance(int offset) {
        if (this.mMeasuredText == null) {
            return 0.0f;
        }
        return this.mMeasuredText.getAdvance(offset);
    }

    public float getAdvance(int start, int end) {
        if (this.mMeasuredText == null) {
            return 0.0f;
        }
        return this.mMeasuredText.getAdvance(start, end);
    }

    public void getExtent(@IntRange(from=0L) int start, @IntRange(from=0L) int end, @NonNull FontMetricsInt fmi) {
        if (this.mMeasuredText != null) {
            this.mMeasuredText.getExtent(start, end, fmi);
        }
    }

    @NonNull
    private static MeasuredParagraph obtain() {
        MeasuredParagraph c = sPool.acquire();
        return c == null ? new MeasuredParagraph() : c;
    }

    @NonNull
    public static MeasuredParagraph buildForBidi(@NonNull CharSequence text, int start, int end, @NonNull TextDirectionHeuristic textDir, @Nullable MeasuredParagraph recycle) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IllegalArgumentException();
        }
        MeasuredParagraph c = recycle == null ? MeasuredParagraph.obtain() : recycle;
        c.resetAndAnalyzeBidi(text, start, end, textDir);
        return c;
    }

    @NonNull
    public static MeasuredParagraph buildForStaticLayout(@NonNull TextPaint paint, @Nullable LineBreakConfig lineBreakConfig, @NonNull CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @NonNull TextDirectionHeuristic textDir, boolean fullLayout, @Nullable MeasuredParagraph recycle) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IllegalArgumentException();
        }
        MeasuredParagraph c = recycle == null ? MeasuredParagraph.obtain() : recycle;
        c.resetAndAnalyzeBidi(text, start, end, textDir);
        if (end > start) {
            MeasuredText.Builder builder = new MeasuredText.Builder(c.mCopiedBuffer).setComputeLayout(fullLayout);
            if (c.mSpanned == null) {
                c.applyMetricsAffectingSpan(paint, lineBreakConfig, Collections.emptyList(), start, end, builder);
                c.mSpanEndCache.add(end);
            } else {
                int spanStart = start;
                while (spanStart < end) {
                    int spanEnd = c.mSpanned.nextSpanTransition(spanStart, end, MetricAffectingSpan.class);
                    List<MetricAffectingSpan> spans = c.mSpanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                    spans = TextUtils.removeEmptySpans(spans, c.mSpanned);
                    c.applyMetricsAffectingSpan(paint, lineBreakConfig, spans, spanStart, spanEnd, builder);
                    c.mSpanEndCache.add(spanEnd);
                    spanStart = spanEnd;
                }
            }
            c.mMeasuredText = builder.build();
        }
        return c;
    }

    private void resetAndAnalyzeBidi(@NonNull CharSequence text, int start, int end, @NonNull TextDirectionHeuristic dir) {
        int i;
        this.reset();
        this.mSpanned = text instanceof Spanned ? (Spanned)text : null;
        this.mTextStart = start;
        int length = end - start;
        if (this.mCopiedBuffer == null || this.mCopiedBuffer.length != length) {
            this.mCopiedBuffer = new char[length];
        }
        TextUtils.getChars(text, start, end, this.mCopiedBuffer, 0);
        if (this.mSpanned != null) {
            List<ReplacementSpan> spans = this.mSpanned.getSpans(start, end, ReplacementSpan.class);
            int e = spans.size();
            for (i = 0; i < e; ++i) {
                ReplacementSpan span = spans.get(i);
                int startInPara = this.mSpanned.getSpanStart(span) - start;
                int endInPara = this.mSpanned.getSpanEnd(span) - start;
                if (startInPara < 0) {
                    startInPara = 0;
                }
                if (endInPara > length) {
                    endInPara = length;
                }
                Arrays.fill(this.mCopiedBuffer, startInPara, endInPara, '\ufffc');
            }
        }
        if (!(dir != TextDirectionHeuristics.LTR && dir != TextDirectionHeuristics.FIRSTSTRONG_LTR && dir != TextDirectionHeuristics.ANYRTL_LTR || Bidi.requiresBidi((char[])this.mCopiedBuffer, (int)0, (int)length))) {
            this.mBidi = null;
        } else {
            boolean isRtl;
            byte paraLevel = dir == TextDirectionHeuristics.LTR ? (byte)0 : (dir == TextDirectionHeuristics.RTL ? (byte)1 : (dir == TextDirectionHeuristics.FIRSTSTRONG_LTR ? (byte)126 : (dir == TextDirectionHeuristics.FIRSTSTRONG_RTL ? (byte)127 : ((isRtl = dir.isRtl(this.mCopiedBuffer, 0, length)) ? (byte)1 : 0))));
            this.mBidi = new Bidi(length, 0);
            this.mBidi.setPara(this.mCopiedBuffer, paraLevel, null);
            if (length > 0 && this.mBidi.getParagraphIndex(length - 1) != 0) {
                for (i = 0; i < length; ++i) {
                    if (Character.isSurrogate(this.mCopiedBuffer[i]) || UCharacter.getDirection((int)this.mCopiedBuffer[i]) != 7) continue;
                    this.mCopiedBuffer[i] = 65532;
                }
                this.mBidi.setPara(this.mCopiedBuffer, paraLevel, null);
            }
        }
    }

    private void applyMetricsAffectingSpan(@NonNull TextPaint paint, @Nullable LineBreakConfig lineBreakConfig, @NonNull List<MetricAffectingSpan> spans, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @NonNull MeasuredText.Builder builder) {
        assert (start != end);
        TextPaint tp = TextPaint.obtain();
        tp.set(paint);
        tp.baselineShift = 0;
        ReplacementSpan replacement = null;
        int e = spans.size();
        for (int i = 0; i < e; ++i) {
            MetricAffectingSpan span = spans.get(i);
            if (span instanceof ReplacementSpan) {
                replacement = (ReplacementSpan)span;
                continue;
            }
            span.updateMeasureState(tp);
        }
        tp.getFontMetricsInt(this.mCachedFm);
        if (replacement != null) {
            float width = replacement.getSize(tp, this.mSpanned, start + this.mTextStart, end + this.mTextStart, this.mCachedFm);
            builder.addReplacementRun(tp.getTextLocale(), end - start, width);
        } else {
            int offset = this.mTextStart;
            FontPaint base = tp.createInternalPaint();
            this.applyStyleRun(base, start - offset, end - offset, lineBreakConfig, builder);
        }
        if (tp.baselineShift < 0) {
            this.mCachedFm.ascent += tp.baselineShift;
        } else {
            this.mCachedFm.descent += tp.baselineShift;
        }
        this.mFontMetrics.add(this.mCachedFm.ascent);
        this.mFontMetrics.add(this.mCachedFm.descent);
        tp.recycle();
    }

    private void applyStyleRun(@NonNull FontPaint paint, int start, int end, @Nullable LineBreakConfig config, @NonNull MeasuredText.Builder builder) {
        if (this.mBidi == null) {
            builder.addStyleRun(paint, config, end - start, false);
        } else {
            byte level = this.mBidi.getLevelAt(start);
            int levelStart = start;
            int levelEnd = start + 1;
            while (true) {
                if (levelEnd == end || this.mBidi.getLevelAt(levelEnd) != level) {
                    boolean isRtl = (level & 1) != 0;
                    builder.addStyleRun(paint, config, levelEnd - levelStart, isRtl);
                    if (levelEnd == end) break;
                    levelStart = levelEnd;
                    level = this.mBidi.getLevelAt(levelEnd);
                }
                ++levelEnd;
            }
        }
    }

    int breakText(int limit, boolean forwards, float width) {
        int i;
        MeasuredText mt = this.mMeasuredText;
        assert (mt != null);
        if (forwards) {
            int i2;
            for (i2 = 0; i2 < limit && !((width -= mt.getAdvance(i2)) < 0.0f); ++i2) {
            }
            while (i2 > 0 && this.mCopiedBuffer[i2 - 1] == ' ') {
                --i2;
            }
            return i2;
        }
        for (i = limit - 1; i >= 0 && !((width -= mt.getAdvance(i)) < 0.0f); --i) {
        }
        while (i < limit - 1 && (this.mCopiedBuffer[i + 1] == ' ' || mt.getAdvance(i + 1) == 0.0f)) {
            ++i;
        }
        return limit - i - 1;
    }

    public void recycle() {
        this.release();
        sPool.release(this);
    }

    public int getMemoryUsage() {
        return MathUtil.align8(32 + (this.mCopiedBuffer == null ? 0 : 16 + (this.mCopiedBuffer.length << 1)) + 4 + 16 + (this.mSpanEndCache.size() << 2) + 16 + (this.mFontMetrics.size() << 2) + 8) + (this.mMeasuredText == null ? 0 : this.mMeasuredText.getMemoryUsage());
    }
}

