/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import yslelf.cloudpick.graphics.annotation.FloatRange;
import yslelf.cloudpick.graphics.annotation.IntRange;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.text.FontMetricsInt;
import yslelf.cloudpick.graphics.graphics.text.LineBreakConfig;
import yslelf.cloudpick.graphics.text.MeasuredParagraph;
import yslelf.cloudpick.graphics.text.Spannable;
import yslelf.cloudpick.graphics.text.SpannableString;
import yslelf.cloudpick.graphics.text.TextDirectionHeuristic;
import yslelf.cloudpick.graphics.text.TextDirectionHeuristics;
import yslelf.cloudpick.graphics.text.TextPaint;
import yslelf.cloudpick.graphics.text.TextUtils;
import yslelf.cloudpick.graphics.text.style.MetricAffectingSpan;

public class PrecomputedText
implements Spannable {
    @NonNull
    private final SpannableString mText;
    @IntRange(from=0L)
    private final int mStart;
    @IntRange(from=0L)
    private final int mEnd;
    @NonNull
    private final Params mParams;
    @NonNull
    private final ParagraphInfo[] mParagraphInfo;

    public static PrecomputedText create(@NonNull CharSequence text, @NonNull Params params) {
        ParagraphInfo[] paraInfo = null;
        if (text instanceof PrecomputedText) {
            PrecomputedText hintPct = (PrecomputedText)text;
            Params hintParams = hintPct.getParams();
            int checkResult = hintParams.checkResultUsable(params.mPaint, params.mTextDir, params.mLineBreakConfig);
            switch (checkResult) {
                case 2: {
                    return hintPct;
                }
                case 1: {
                    paraInfo = PrecomputedText.createMeasuredParagraphsFromPrecomputedText(hintPct, params, true);
                    break;
                }
            }
        }
        if (paraInfo == null) {
            paraInfo = PrecomputedText.createMeasuredParagraphs(text, params, 0, text.length(), true);
        }
        return new PrecomputedText(text, 0, text.length(), params, paraInfo);
    }

    private static ParagraphInfo[] createMeasuredParagraphsFromPrecomputedText(@NonNull PrecomputedText pct, @NonNull Params params, boolean computeLayout) {
        ArrayList<ParagraphInfo> result = new ArrayList<ParagraphInfo>();
        for (int i = 0; i < pct.getParagraphCount(); ++i) {
            int paraStart = pct.getParagraphStart(i);
            int paraEnd = pct.getParagraphEnd(i);
            result.add(new ParagraphInfo(paraEnd, MeasuredParagraph.buildForStaticLayout(params.getTextPaint(), params.getLineBreakConfig(), pct, paraStart, paraEnd, params.getTextDirection(), computeLayout, null)));
        }
        return result.toArray(new ParagraphInfo[0]);
    }

    @ApiStatus.Internal
    public static ParagraphInfo[] createMeasuredParagraphs(@NonNull CharSequence text, @NonNull Params params, @IntRange(from=0L) int start, @IntRange(from=0L) int end, boolean computeLayout) {
        ArrayList<ParagraphInfo> result = new ArrayList<ParagraphInfo>();
        Objects.requireNonNull(text);
        Objects.requireNonNull(params);
        int paraStart = start;
        while (paraStart < end) {
            int paraEnd = TextUtils.indexOf(text, '\n', paraStart, end);
            paraEnd = paraEnd < 0 ? end : ++paraEnd;
            result.add(new ParagraphInfo(paraEnd, MeasuredParagraph.buildForStaticLayout(params.getTextPaint(), params.getLineBreakConfig(), text, paraStart, paraEnd, params.getTextDirection(), computeLayout, null)));
            paraStart = paraEnd;
        }
        return result.toArray(new ParagraphInfo[0]);
    }

    private PrecomputedText(@NonNull CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @NonNull Params params, @NonNull ParagraphInfo[] paraInfo) {
        this.mText = new SpannableString(text, true);
        this.mStart = start;
        this.mEnd = end;
        this.mParams = params;
        this.mParagraphInfo = paraInfo;
    }

    @ApiStatus.Internal
    @NonNull
    public CharSequence getText() {
        return this.mText;
    }

    @ApiStatus.Internal
    @IntRange(from=0L)
    public int getStart() {
        return this.mStart;
    }

    @ApiStatus.Internal
    @IntRange(from=0L)
    public int getEnd() {
        return this.mEnd;
    }

    @NonNull
    public Params getParams() {
        return this.mParams;
    }

    @IntRange(from=0L)
    public int getParagraphCount() {
        return this.mParagraphInfo.length;
    }

    @IntRange(from=0L)
    public int getParagraphStart(@IntRange(from=0L) int paraIndex) {
        Objects.checkIndex(paraIndex, this.getParagraphCount());
        return paraIndex == 0 ? this.mStart : this.getParagraphEnd(paraIndex - 1);
    }

    @IntRange(from=0L)
    public int getParagraphEnd(@IntRange(from=0L) int paraIndex) {
        Objects.checkIndex(paraIndex, this.getParagraphCount());
        return this.mParagraphInfo[paraIndex].paragraphEnd;
    }

    @ApiStatus.Internal
    @NonNull
    public MeasuredParagraph getMeasuredParagraph(@IntRange(from=0L) int paraIndex) {
        return this.mParagraphInfo[paraIndex].measured;
    }

    @ApiStatus.Internal
    @NonNull
    public ParagraphInfo[] getParagraphInfo() {
        return this.mParagraphInfo;
    }

    @ApiStatus.Internal
    public int checkResultUsable(@IntRange(from=0L) int start, @IntRange(from=0L) int end, @NonNull TextDirectionHeuristic textDir, @NonNull TextPaint paint, @NonNull LineBreakConfig lbConfig) {
        if (this.mStart != start || this.mEnd != end) {
            return 0;
        }
        return this.mParams.checkResultUsable(paint, textDir, lbConfig);
    }

    @ApiStatus.Internal
    public int findParaIndex(@IntRange(from=0L) int pos) {
        for (int i = 0; i < this.mParagraphInfo.length; ++i) {
            if (pos >= this.mParagraphInfo[i].paragraphEnd) continue;
            return i;
        }
        throw new IndexOutOfBoundsException("pos must be less than " + this.mParagraphInfo[this.mParagraphInfo.length - 1].paragraphEnd + ", gave " + pos);
    }

    @FloatRange(from=0.0)
    public float getWidth(@IntRange(from=0L) int start, @IntRange(from=0L) int end) {
        Objects.checkFromToIndex(start, end, this.mText.length());
        if (start == end) {
            return 0.0f;
        }
        int paraIndex = this.findParaIndex(start);
        int paraStart = this.getParagraphStart(paraIndex);
        int paraEnd = this.getParagraphEnd(paraIndex);
        if (start < paraStart || paraEnd < end) {
            throw new IllegalArgumentException("Cannot measured across the paragraph:para: (" + paraStart + ", " + paraEnd + "), request: (" + start + ", " + end + ")");
        }
        return this.getMeasuredParagraph(paraIndex).getAdvance(start - paraStart, end - paraStart);
    }

    public void getFontMetricsInt(@IntRange(from=0L) int start, @IntRange(from=0L) int end, @NonNull FontMetricsInt outMetrics) {
        Objects.checkFromToIndex(start, end, this.mText.length());
        Objects.requireNonNull(outMetrics);
        if (start == end) {
            this.mParams.getTextPaint().getFontMetricsInt(outMetrics);
            return;
        }
        int paraIndex = this.findParaIndex(start);
        int paraStart = this.getParagraphStart(paraIndex);
        int paraEnd = this.getParagraphEnd(paraIndex);
        if (start < paraStart || paraEnd < end) {
            throw new IllegalArgumentException("Cannot measured across the paragraph:para: (" + paraStart + ", " + paraEnd + "), request: (" + start + ", " + end + ")");
        }
        this.getMeasuredParagraph(paraIndex).getExtent(start - paraStart, end - paraStart, outMetrics);
    }

    @ApiStatus.Internal
    public int getMemoryUsage() {
        int r = 0;
        for (ParagraphInfo info : this.mParagraphInfo) {
            r += info.measured.getMemoryUsage();
        }
        return r;
    }

    @Override
    public void setSpan(@NonNull Object what, int start, int end, int flags) {
        if (what instanceof MetricAffectingSpan) {
            throw new IllegalArgumentException("MetricAffectingSpan can not be set to PrecomputedText.");
        }
        this.mText.setSpan(what, start, end, flags);
    }

    @Override
    public void removeSpan(@NonNull Object what) {
        if (what instanceof MetricAffectingSpan) {
            throw new IllegalArgumentException("MetricAffectingSpan can not be removed from PrecomputedText.");
        }
        this.mText.removeSpan(what);
    }

    @Override
    @NonNull
    public <T> List<T> getSpans(int start, int end, @Nullable Class<? extends T> type, @Nullable List<T> dest) {
        return this.mText.getSpans(start, end, (Class)type, (List)dest);
    }

    @Override
    public int getSpanStart(@NonNull Object tag) {
        return this.mText.getSpanStart(tag);
    }

    @Override
    public int getSpanEnd(@NonNull Object tag) {
        return this.mText.getSpanEnd(tag);
    }

    @Override
    public int getSpanFlags(@NonNull Object tag) {
        return this.mText.getSpanFlags(tag);
    }

    @Override
    public int nextSpanTransition(int start, int limit, @Nullable Class<?> type) {
        return this.mText.nextSpanTransition(start, limit, (Class)type);
    }

    @Override
    public int length() {
        return this.mText.length();
    }

    @Override
    public char charAt(int index) {
        return this.mText.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return PrecomputedText.create(this.mText.subSequence(start, end), this.mParams);
    }

    @Override
    public String toString() {
        return this.mText.toString();
    }

    public static final class Params {
        @NonNull
        private final TextPaint mPaint;
        @NonNull
        private final TextDirectionHeuristic mTextDir;
        @NonNull
        private final LineBreakConfig mLineBreakConfig;
        @ApiStatus.Internal
        public static final int UNUSABLE = 0;
        @ApiStatus.Internal
        public static final int NEED_RECOMPUTE = 1;
        @ApiStatus.Internal
        public static final int USABLE = 2;

        @ApiStatus.Internal
        public Params(@NonNull TextPaint paint, @NonNull LineBreakConfig lineBreakConfig, @NonNull TextDirectionHeuristic textDir) {
            this.mPaint = paint;
            this.mTextDir = textDir;
            this.mLineBreakConfig = lineBreakConfig;
        }

        @NonNull
        public TextPaint getTextPaint() {
            return this.mPaint;
        }

        @NonNull
        public TextDirectionHeuristic getTextDirection() {
            return this.mTextDir;
        }

        @NonNull
        public LineBreakConfig getLineBreakConfig() {
            return this.mLineBreakConfig;
        }

        @ApiStatus.Internal
        public int checkResultUsable(@NonNull TextPaint paint, @NonNull TextDirectionHeuristic textDir, @NonNull LineBreakConfig lbConfig) {
            if (this.mLineBreakConfig.equals(lbConfig) && this.mPaint.equalsForTextMeasurement(paint)) {
                return this.mTextDir == textDir ? 2 : 1;
            }
            return 0;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Params)) {
                return false;
            }
            Params param = (Params)o;
            return this.checkResultUsable(param.mPaint, param.mTextDir, param.mLineBreakConfig) == 2;
        }

        public int hashCode() {
            return Objects.hash(this.mPaint.getInternalPaint(), this.mTextDir, this.mLineBreakConfig);
        }

        public String toString() {
            return "{" + this.mPaint.getInternalPaint() + ", textDir=" + this.mTextDir + ", " + this.mLineBreakConfig + "}";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @ApiStatus.Internal
        public static @interface CheckResultUsableResult {
        }

        public static class Builder {
            @NonNull
            private final TextPaint mPaint;
            private TextDirectionHeuristic mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
            @NonNull
            private LineBreakConfig mLineBreakConfig = LineBreakConfig.NONE;

            public Builder(@NonNull TextPaint paint) {
                this.mPaint = paint;
            }

            public Builder(@NonNull Params params) {
                this.mPaint = params.mPaint;
                this.mTextDir = params.mTextDir;
                this.mLineBreakConfig = params.mLineBreakConfig;
            }

            public Builder setTextDirection(@NonNull TextDirectionHeuristic textDir) {
                this.mTextDir = textDir;
                return this;
            }

            @NonNull
            public Builder setLineBreakConfig(@NonNull LineBreakConfig lineBreakConfig) {
                this.mLineBreakConfig = lineBreakConfig;
                return this;
            }

            @NonNull
            public Params build() {
                return new Params(this.mPaint, this.mLineBreakConfig, this.mTextDir);
            }
        }
    }

    @ApiStatus.Internal
    public static class ParagraphInfo {
        @IntRange(from=0L)
        public final int paragraphEnd;
        @NonNull
        public final MeasuredParagraph measured;

        public ParagraphInfo(@IntRange(from=0L) int paraEnd, @NonNull MeasuredParagraph measured) {
            this.paragraphEnd = paraEnd;
            this.measured = measured;
        }
    }
}

