/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import yslelf.cloudpick.graphics.text.Editable;
import yslelf.cloudpick.graphics.text.Layout;
import yslelf.cloudpick.graphics.text.NoCopySpan;
import yslelf.cloudpick.graphics.text.Spannable;
import yslelf.cloudpick.graphics.text.Spanned;
import yslelf.cloudpick.graphics.text.TextWatcher;
import yslelf.cloudpick.graphics.text.method.WordIterator;

@ParametersAreNonnullByDefault
public final class Selection {
    public static final Object SELECTION_START = new NoCopySpan.Concrete();
    public static final Object SELECTION_END = new NoCopySpan.Concrete();
    private static final Object SELECTION_MEMORY = new NoCopySpan.Concrete();

    private Selection() {
    }

    public static int getSelectionStart(CharSequence text) {
        if (text instanceof Spanned) {
            return ((Spanned)text).getSpanStart(SELECTION_START);
        }
        return -1;
    }

    public static int getSelectionEnd(CharSequence text) {
        if (text instanceof Spanned) {
            return ((Spanned)text).getSpanStart(SELECTION_END);
        }
        return -1;
    }

    private static int getSelectionMemory(CharSequence text) {
        if (text instanceof Spanned) {
            return ((Spanned)text).getSpanStart(SELECTION_MEMORY);
        }
        return -1;
    }

    public static void setSelection(Spannable text, int start, int stop) {
        Selection.setSelection(text, start, stop, -1);
    }

    private static void setSelection(Spannable text, int start, int stop, int memory) {
        int ostart = Selection.getSelectionStart(text);
        int oend = Selection.getSelectionEnd(text);
        if (ostart != start || oend != stop) {
            text.setSpan(SELECTION_START, start, start, 546);
            text.setSpan(SELECTION_END, stop, stop, 34);
            Selection.updateMemory(text, memory);
        }
    }

    private static void updateMemory(Spannable text, int memory) {
        if (memory > -1) {
            int currentMemory = Selection.getSelectionMemory(text);
            if (memory != currentMemory) {
                text.setSpan(SELECTION_MEMORY, memory, memory, 34);
                if (currentMemory == -1) {
                    MemoryTextWatcher watcher = new MemoryTextWatcher();
                    text.setSpan(watcher, 0, text.length(), 18);
                }
            }
        } else {
            Selection.removeMemory(text);
        }
    }

    private static void removeMemory(Spannable text) {
        text.removeSpan(SELECTION_MEMORY);
        List<MemoryTextWatcher> watchers = text.getSpans(0, text.length(), MemoryTextWatcher.class);
        for (MemoryTextWatcher watcher : watchers) {
            text.removeSpan(watcher);
        }
    }

    public static void setSelection(Spannable text, int index) {
        Selection.setSelection(text, index, index);
    }

    public static void selectAll(Spannable text) {
        Selection.setSelection(text, 0, text.length());
    }

    public static void extendSelection(Spannable text, int index) {
        Selection.extendSelection(text, index, -1);
    }

    private static void extendSelection(Spannable text, int index, int memory) {
        if (text.getSpanStart(SELECTION_END) != index) {
            text.setSpan(SELECTION_END, index, index, 34);
        }
        Selection.updateMemory(text, memory);
    }

    public static void removeSelection(Spannable text) {
        text.removeSpan(SELECTION_START, 512);
        text.removeSpan(SELECTION_END);
        Selection.removeMemory(text);
    }

    public static boolean moveUp(Spannable text, Layout layout) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            int min = Math.min(start, end);
            int max = Math.max(start, end);
            Selection.setSelection(text, min);
            return min != 0 || max != text.length();
        }
        int line = layout.getLineForOffset(end);
        if (line > 0) {
            Selection.setSelectionAndMemory(text, layout, line, end, -1, false);
            return true;
        }
        if (end != 0) {
            Selection.setSelection(text, 0);
            return true;
        }
        return false;
    }

    private static void setSelectionAndMemory(Spannable text, Layout layout, int line, int end, int direction, boolean extend) {
        int newMemory;
        int move;
        if (layout.getParagraphDirection(line) == layout.getParagraphDirection(line + direction)) {
            int memory = Selection.getSelectionMemory(text);
            if (memory > -1) {
                float h2 = layout.getPrimaryHorizontal(memory);
                move = layout.getOffsetForHorizontal(line + direction, h2);
                newMemory = memory;
            } else {
                float h3 = layout.getPrimaryHorizontal(end);
                move = layout.getOffsetForHorizontal(line + direction, h3);
                newMemory = end;
            }
        } else {
            move = layout.getLineStart(line + direction);
            newMemory = -1;
        }
        if (extend) {
            Selection.extendSelection(text, move, newMemory);
        } else {
            Selection.setSelection(text, move, move, newMemory);
        }
    }

    public static boolean moveDown(Spannable text, Layout layout) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            int min = Math.min(start, end);
            int max = Math.max(start, end);
            Selection.setSelection(text, max);
            return min != 0 || max != text.length();
        }
        int line = layout.getLineForOffset(end);
        if (line < layout.getLineCount() - 1) {
            Selection.setSelectionAndMemory(text, layout, line, end, 1, false);
            return true;
        }
        if (end != text.length()) {
            Selection.setSelection(text, text.length());
            return true;
        }
        return false;
    }

    public static boolean moveLeft(Spannable text, Layout layout) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            Selection.setSelection(text, Selection.chooseHorizontal(layout, -1, start, end));
            return true;
        }
        int to = layout.getOffsetToLeftOf(end);
        if (to != end) {
            Selection.setSelection(text, to);
            return true;
        }
        return false;
    }

    public static boolean moveRight(Spannable text, Layout layout) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            Selection.setSelection(text, Selection.chooseHorizontal(layout, 1, start, end));
            return true;
        }
        int to = layout.getOffsetToRightOf(end);
        if (to != end) {
            Selection.setSelection(text, to);
            return true;
        }
        return false;
    }

    public static boolean extendUp(Spannable text, Layout layout) {
        int end = Selection.getSelectionEnd(text);
        int line = layout.getLineForOffset(end);
        if (line > 0) {
            Selection.setSelectionAndMemory(text, layout, line, end, -1, true);
            return true;
        }
        if (end != 0) {
            Selection.extendSelection(text, 0);
            return true;
        }
        return true;
    }

    public static boolean extendDown(Spannable text, Layout layout) {
        int end = Selection.getSelectionEnd(text);
        int line = layout.getLineForOffset(end);
        if (line < layout.getLineCount() - 1) {
            Selection.setSelectionAndMemory(text, layout, line, end, 1, true);
            return true;
        }
        if (end != text.length()) {
            Selection.extendSelection(text, text.length(), -1);
            return true;
        }
        return true;
    }

    public static boolean extendLeft(Spannable text, Layout layout) {
        int end = Selection.getSelectionEnd(text);
        int to = layout.getOffsetToLeftOf(end);
        if (to != end) {
            Selection.extendSelection(text, to);
            return true;
        }
        return true;
    }

    public static boolean extendRight(Spannable text, Layout layout) {
        int end = Selection.getSelectionEnd(text);
        int to = layout.getOffsetToRightOf(end);
        if (to != end) {
            Selection.extendSelection(text, to);
            return true;
        }
        return true;
    }

    public static boolean extendToLeftEdge(Spannable text, Layout layout) {
        int where = Selection.findEdge(text, layout, -1);
        Selection.extendSelection(text, where);
        return true;
    }

    public static boolean extendToRightEdge(Spannable text, Layout layout) {
        int where = Selection.findEdge(text, layout, 1);
        Selection.extendSelection(text, where);
        return true;
    }

    public static boolean moveToLeftEdge(Spannable text, Layout layout) {
        int where = Selection.findEdge(text, layout, -1);
        Selection.setSelection(text, where);
        return true;
    }

    public static boolean moveToRightEdge(Spannable text, Layout layout) {
        int where = Selection.findEdge(text, layout, 1);
        Selection.setSelection(text, where);
        return true;
    }

    public static boolean moveToPreceding(Spannable text, WordIterator iter, boolean extendSelection) {
        int offset = iter.preceding(Selection.getSelectionEnd(text));
        if (offset != -1) {
            if (extendSelection) {
                Selection.extendSelection(text, offset);
            } else {
                Selection.setSelection(text, offset);
            }
        }
        return true;
    }

    public static boolean moveToFollowing(Spannable text, WordIterator iter, boolean extendSelection) {
        int offset = iter.following(Selection.getSelectionEnd(text));
        if (offset != -1) {
            if (extendSelection) {
                Selection.extendSelection(text, offset);
            } else {
                Selection.setSelection(text, offset);
            }
        }
        return true;
    }

    private static int findEdge(Spannable text, Layout layout, int dir) {
        int pt = Selection.getSelectionEnd(text);
        int line = layout.getLineForOffset(pt);
        int pdir = layout.getParagraphDirection(line);
        if (dir * pdir < 0) {
            return layout.getLineStart(line);
        }
        int end = layout.getLineEnd(line);
        if (line == layout.getLineCount() - 1) {
            return end;
        }
        return end - 1;
    }

    private static int chooseHorizontal(Layout layout, int direction, int off1, int off2) {
        int line2;
        int line1 = layout.getLineForOffset(off1);
        if (line1 == (line2 = layout.getLineForOffset(off2))) {
            float h1 = layout.getPrimaryHorizontal(off1);
            float h2 = layout.getPrimaryHorizontal(off2);
            if (direction < 0) {
                if (h1 < h2) {
                    return off1;
                }
                return off2;
            }
            if (h1 > h2) {
                return off1;
            }
            return off2;
        }
        int line = layout.getLineForOffset(off1);
        int textdir = layout.getParagraphDirection(line);
        if (textdir == direction) {
            return Math.max(off1, off2);
        }
        return Math.min(off1, off2);
    }

    private static final class MemoryTextWatcher
    implements TextWatcher {
        private MemoryTextWatcher() {
        }

        @Override
        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        @Override
        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        @Override
        public void afterTextChanged(Editable s) {
            s.removeSpan(SELECTION_MEMORY);
            s.removeSpan(this);
        }
    }
}

