/*
 * Decompiled with CFR 0.152.
 */
package yslelf.cloudpick.graphics.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import yslelf.cloudpick.graphics.CloudPick;
import yslelf.cloudpick.graphics.annotation.FloatRange;
import yslelf.cloudpick.graphics.annotation.IntRange;
import yslelf.cloudpick.graphics.annotation.NonNull;
import yslelf.cloudpick.graphics.annotation.Nullable;
import yslelf.cloudpick.graphics.graphics.text.FontMetricsInt;
import yslelf.cloudpick.graphics.graphics.text.LayoutCache;
import yslelf.cloudpick.graphics.graphics.text.LineBreakConfig;
import yslelf.cloudpick.graphics.graphics.text.LineBreaker;
import yslelf.cloudpick.graphics.text.Directions;
import yslelf.cloudpick.graphics.text.Layout;
import yslelf.cloudpick.graphics.text.MeasuredParagraph;
import yslelf.cloudpick.graphics.text.PrecomputedText;
import yslelf.cloudpick.graphics.text.Spanned;
import yslelf.cloudpick.graphics.text.TextDirectionHeuristic;
import yslelf.cloudpick.graphics.text.TextDirectionHeuristics;
import yslelf.cloudpick.graphics.text.TextPaint;
import yslelf.cloudpick.graphics.text.TextUtils;
import yslelf.cloudpick.graphics.text.style.LeadingMarginSpan;
import yslelf.cloudpick.graphics.text.style.LineHeightSpan;
import yslelf.cloudpick.graphics.text.style.TabStopSpan;
import yslelf.cloudpick.graphics.text.style.TrailingMarginSpan;
import yslelf.cloudpick.graphics.util.GrowingArrayUtils;
import yslelf.cloudpick.graphics.util.Pools;

public class StaticLayout
extends Layout {
    public static final Marker MARKER = MarkerManager.getMarker((String)"StaticLayout");
    private static final Pools.Pool<Builder> sPool = Pools.newSynchronizedPool(2);
    private static final int COLUMNS_NORMAL = 4;
    private static final int COLUMNS_ELLIPSIZE = 6;
    private static final int START = 0;
    private static final int DIR = 0;
    private static final int TAB = 0;
    private static final int TOP = 1;
    private static final int DESCENT = 2;
    private static final int EXTRA = 3;
    private static final int ELLIPSIS_START = 4;
    private static final int ELLIPSIS_COUNT = 5;
    private static final int START_MASK = 0x1FFFFFFF;
    private static final int DIR_SHIFT = 30;
    private static final int TAB_MASK = 0x20000000;
    private static final int DEFAULT_MAX_LINE_HEIGHT = -1;
    private int mLineCount;
    private int mTopPadding;
    private int mBottomPadding;
    private final int mColumns;
    private int mEllipsizedWidth;
    private boolean mEllipsized;
    private int mMaxLineHeight = -1;
    private int[] mLines;
    private Directions[] mLineDirections;
    private int mMaximumVisibleLineCount = Integer.MAX_VALUE;
    @Nullable
    private int[] mLeftIndents;
    @Nullable
    private int[] mRightIndents;

    @NonNull
    public static Builder builder(@NonNull CharSequence source, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @NonNull TextPaint paint, @IntRange(from=0L) int width) {
        Builder b = sPool.acquire();
        if (b == null) {
            b = new Builder();
        }
        b.mText = source;
        b.mStart = start;
        b.mEnd = end;
        b.mPaint = paint;
        b.mWidth = width;
        b.mAlignment = Layout.Alignment.ALIGN_NORMAL;
        b.mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
        b.mSpacingMult = 1.0f;
        b.mSpacingAdd = 0.0f;
        b.mIncludePad = true;
        b.mFallbackLineSpacing = true;
        b.mEllipsizedWidth = width;
        b.mEllipsize = null;
        b.mMaxLines = Integer.MAX_VALUE;
        b.mLineBreakConfig = LineBreakConfig.NONE;
        return b;
    }

    StaticLayout(@Nullable CharSequence text) {
        super(text, null, 0, null, 1.0f, 0.0f);
        this.mColumns = 6;
        this.mLineDirections = new Directions[2];
        this.mLines = new int[2 * this.mColumns];
    }

    private StaticLayout(@NonNull Builder b) {
        super(b.mEllipsize == null ? b.mText : (b.mText instanceof Spanned ? new Layout.SpannedEllipsizer(b.mText) : new Layout.Ellipsizer(b.mText)), b.mPaint, b.mWidth, b.mAlignment, b.mTextDir, b.mSpacingMult, b.mSpacingAdd);
        if (b.mEllipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = b.mEllipsizedWidth;
            e.mMethod = b.mEllipsize;
            this.mEllipsizedWidth = b.mEllipsizedWidth;
            this.mColumns = 6;
        } else {
            this.mColumns = 4;
            this.mEllipsizedWidth = b.mWidth;
        }
        this.mLineDirections = new Directions[2];
        this.mLines = new int[2 * this.mColumns];
        this.mMaximumVisibleLineCount = b.mMaxLines;
        this.mLeftIndents = b.mLeftIndents;
        this.mRightIndents = b.mRightIndents;
        this.generate(b, b.mIncludePad, b.mIncludePad);
    }

    /*
     * WARNING - void declaration
     */
    void generate(@NonNull Builder b, boolean includePad, boolean trackPad) {
        Spanned spanned;
        int[] indents;
        CharSequence source = b.mText;
        int bufStart = b.mStart;
        int bufEnd = b.mEnd;
        TextPaint paint = b.mPaint;
        int outerWidth = b.mWidth;
        TextDirectionHeuristic textDir = b.mTextDir;
        float spacingmult = b.mSpacingMult;
        float spacingadd = b.mSpacingAdd;
        boolean fallbackLineSpacing = b.mFallbackLineSpacing;
        float ellipsizedWidth = b.mEllipsizedWidth;
        TextUtils.TruncateAt ellipsize = b.mEllipsize;
        boolean addLastLineSpacing = b.mAddLastLineLineSpacing;
        int lineBreakCapacity = 0;
        int[] breaks = null;
        float[] lineWidths = null;
        float[] ascents = null;
        float[] descents = null;
        boolean[] hasTabs = null;
        this.mLineCount = 0;
        this.mEllipsized = false;
        this.mMaxLineHeight = this.mMaximumVisibleLineCount < 1 ? 0 : -1;
        int v = 0;
        boolean needMultiply = spacingmult != 1.0f || spacingadd != 0.0f;
        FontMetricsInt fm = b.mFontMetricsInt;
        int[] chooseHtv = null;
        if (this.mLeftIndents != null || this.mRightIndents != null) {
            int leftLen = this.mLeftIndents == null ? 0 : this.mLeftIndents.length;
            int rightLen = this.mRightIndents == null ? 0 : this.mRightIndents.length;
            int indentsLen = Math.max(leftLen, rightLen);
            indents = new int[indentsLen];
            if (leftLen > 0) {
                System.arraycopy(this.mLeftIndents, 0, indents, 0, leftLen);
            }
            for (int i = 0; i < rightLen; ++i) {
                int n2 = i;
                indents[n2] = indents[n2] + this.mRightIndents[i];
            }
        } else {
            indents = null;
        }
        LineBreaker.ParagraphConstraints constraints = new LineBreaker.ParagraphConstraints();
        PrecomputedText.ParagraphInfo[] paragraphInfo = null;
        Spanned spanned2 = spanned = source instanceof Spanned ? (Spanned)source : null;
        if (source instanceof PrecomputedText) {
            PrecomputedText precomputed = (PrecomputedText)source;
            int checkResult = precomputed.checkResultUsable(bufStart, bufEnd, textDir, paint, b.mLineBreakConfig);
            switch (checkResult) {
                case 0: {
                    break;
                }
                case 1: {
                    PrecomputedText.Params newParams = new PrecomputedText.Params.Builder(paint).setTextDirection(textDir).setLineBreakConfig(b.mLineBreakConfig).build();
                    precomputed = PrecomputedText.create(precomputed, newParams);
                    paragraphInfo = precomputed.getParagraphInfo();
                    break;
                }
                case 2: {
                    paragraphInfo = precomputed.getParagraphInfo();
                }
            }
        }
        if (paragraphInfo == null) {
            PrecomputedText.Params param = new PrecomputedText.Params(paint, b.mLineBreakConfig, textDir);
            paragraphInfo = PrecomputedText.createMeasuredParagraphs(source, param, bufStart, bufEnd, false);
        }
        for (int paraIndex = 0; paraIndex < paragraphInfo.length; ++paraIndex) {
            boolean ellipsisMayBeApplied;
            List<TabStopSpan> spans;
            int paraStart = paraIndex == 0 ? bufStart : paragraphInfo[paraIndex - 1].paragraphEnd;
            int paraEnd = paragraphInfo[paraIndex].paragraphEnd;
            int firstWidthLineCount = 1;
            int firstWidth = outerWidth;
            int restWidth = outerWidth;
            List<Object> chooseHt = Collections.emptyList();
            if (spanned != null) {
                List<LeadingMarginSpan> leadingMarginSpans = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LeadingMarginSpan.class);
                for (LeadingMarginSpan leadingMarginSpan : leadingMarginSpans) {
                    firstWidth -= leadingMarginSpan.getLeadingMargin(true);
                    restWidth -= leadingMarginSpan.getLeadingMargin(false);
                    if (!(leadingMarginSpan instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    firstWidthLineCount = Math.max(firstWidthLineCount, ((LeadingMarginSpan.LeadingMarginSpan2)leadingMarginSpan).getLeadingMarginLineCount());
                }
                List<TrailingMarginSpan> trailingMarginSpans = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, TrailingMarginSpan.class);
                for (TrailingMarginSpan tms : trailingMarginSpans) {
                    int margin = tms.getTrailingMargin();
                    firstWidth -= margin;
                    restWidth -= margin;
                }
                chooseHt = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LineHeightSpan.class);
                if (!chooseHt.isEmpty()) {
                    void var39_51;
                    if (chooseHtv == null || chooseHtv.length < chooseHt.size()) {
                        chooseHtv = new int[chooseHt.size()];
                    }
                    boolean bl = false;
                    while (var39_51 < chooseHt.size()) {
                        int o = spanned.getSpanStart(chooseHt.get((int)var39_51));
                        chooseHtv[var39_51] = o < paraStart ? this.getLineTop(this.getLineForOffset(o)) : v;
                        ++var39_51;
                    }
                }
            }
            float[] variableTabStops = null;
            if (spanned != null && !(spans = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, TabStopSpan.class)).isEmpty()) {
                float[] fArray = new float[spans.size()];
                for (int i = 0; i < spans.size(); ++i) {
                    fArray[i] = spans.get(i).getTabStop();
                }
                Arrays.sort(fArray, 0, fArray.length);
                variableTabStops = fArray;
            }
            MeasuredParagraph measuredPara = paragraphInfo[paraIndex].measured;
            int[] nArray = measuredPara.getSpanEndCache().elements();
            int[] fmCache = measuredPara.getFontMetrics().elements();
            constraints.setWidth(restWidth);
            constraints.setIndent(firstWidth);
            constraints.setTabStops(variableTabStops, 20.0f);
            LineBreaker.Result res = LineBreaker.computeLineBreaks(measuredPara.getMeasuredText(), constraints, indents, this.mLineCount);
            int breakCount = res.getLineCount();
            if (breakCount > lineBreakCapacity) {
                lineBreakCapacity = breakCount;
                breaks = new int[lineBreakCapacity];
                lineWidths = new float[lineBreakCapacity];
                ascents = new float[lineBreakCapacity];
                descents = new float[lineBreakCapacity];
                hasTabs = new boolean[lineBreakCapacity];
            }
            for (int i = 0; i < breakCount; ++i) {
                breaks[i] = res.getLineBreakOffset(i);
                lineWidths[i] = res.getLineWidth(i);
                ascents[i] = res.getLineAscent(i);
                descents[i] = res.getLineDescent(i);
                hasTabs[i] = res.hasLineTab(i);
            }
            int remainingLineCount = this.mMaximumVisibleLineCount - this.mLineCount;
            boolean bl = ellipsisMayBeApplied = ellipsize != null && (ellipsize == TextUtils.TruncateAt.END || this.mMaximumVisibleLineCount == 1 && ellipsize != TextUtils.TruncateAt.MARQUEE);
            if (0 < remainingLineCount && remainingLineCount < breakCount && ellipsisMayBeApplied) {
                float width = 0.0f;
                boolean hasTab = false;
                for (int i = remainingLineCount - 1; i < breakCount; ++i) {
                    if (i == breakCount - 1) {
                        width += lineWidths[i];
                    } else {
                        int j;
                        int n3 = j = i == 0 ? 0 : breaks[i - 1];
                        while (j < breaks[i]) {
                            width += measuredPara.getAdvance(j);
                            ++j;
                        }
                    }
                    hasTab |= hasTabs[i];
                }
                breaks[remainingLineCount - 1] = breaks[breakCount - 1];
                lineWidths[remainingLineCount - 1] = width;
                hasTabs[remainingLineCount - 1] = hasTab;
                breakCount = remainingLineCount;
            }
            int here = paraStart;
            int fmAscent = 0;
            int fmDescent = 0;
            int cacheIndex = 0;
            int breakIndex = 0;
            int spanStart = paraStart;
            while (spanStart < paraEnd) {
                int spanEnd = nArray[cacheIndex];
                fm.ascent = fmCache[cacheIndex * 2];
                fm.descent = fmCache[cacheIndex * 2 + 1];
                ++cacheIndex;
                if (fm.ascent < fmAscent) {
                    fmAscent = fm.ascent;
                }
                if (fm.descent > fmDescent) {
                    fmDescent = fm.descent;
                }
                while (breakIndex < breakCount && paraStart + breaks[breakIndex] < spanStart) {
                    ++breakIndex;
                }
                while (breakIndex < breakCount && paraStart + breaks[breakIndex] <= spanEnd) {
                    int endPos = paraStart + breaks[breakIndex];
                    boolean moreChars = endPos < bufEnd;
                    int ascent = fallbackLineSpacing ? Math.min(fmAscent, Math.round(ascents[breakIndex])) : fmAscent;
                    int descent = fallbackLineSpacing ? Math.max(fmDescent, Math.round(descents[breakIndex])) : fmDescent;
                    v = this.out(source, here, endPos, ascent, descent, ascent, descent, v, spacingmult, spacingadd, chooseHt, chooseHtv, fm, hasTabs[breakIndex], needMultiply, measuredPara, bufEnd, includePad, trackPad, addLastLineSpacing, paraStart, ellipsize, ellipsizedWidth, lineWidths[breakIndex], paint, moreChars);
                    if (endPos < spanEnd) {
                        fmAscent = fm.ascent;
                        fmDescent = fm.descent;
                    } else {
                        fmDescent = 0;
                        fmAscent = 0;
                    }
                    here = endPos;
                    ++breakIndex;
                    if (this.mLineCount < this.mMaximumVisibleLineCount || !this.mEllipsized) continue;
                    return;
                }
                spanStart = spanEnd;
            }
            if (paraEnd < bufEnd) continue;
            assert (paraEnd == bufEnd);
            break;
        }
        if ((bufEnd == bufStart || source.charAt(bufEnd - 1) == '\n') && this.mLineCount < this.mMaximumVisibleLineCount) {
            MeasuredParagraph measuredPara = MeasuredParagraph.buildForBidi(source, bufEnd, bufEnd, textDir, null);
            paint.getFontMetricsInt(fm);
            this.out(source, bufEnd, bufEnd, fm.ascent, fm.descent, fm.ascent, fm.descent, v, spacingmult, spacingadd, Collections.emptyList(), null, fm, false, needMultiply, measuredPara, bufEnd, includePad, trackPad, addLastLineSpacing, bufStart, ellipsize, ellipsizedWidth, 0.0f, paint, false);
        }
    }

    private int out(CharSequence text, int start, int end, int above, int below, int top, int bottom, int v, float spacingmult, float spacingadd, List<LineHeightSpan> chooseHt, int[] chooseHtv, FontMetricsInt fm, boolean hasTab, boolean needMultiply, @NonNull MeasuredParagraph measured, int bufEnd, boolean includePad, boolean trackPad, boolean addLastLineLineSpacing, int widthStart, TextUtils.TruncateAt ellipsize, float ellipsisWidth, float textWidth, TextPaint paint, boolean moreChars) {
        double ex;
        boolean lastLine;
        boolean currentLineIsTheLastVisibleOne;
        int j = this.mLineCount;
        int off = j * this.mColumns;
        int want = off + this.mColumns + 1;
        int dir = measured.getParagraphDir();
        if (want >= this.mLines.length) {
            this.mLines = Arrays.copyOf(this.mLines, GrowingArrayUtils.growSize(want));
        }
        if (j >= this.mLineDirections.length) {
            this.mLineDirections = Arrays.copyOf(this.mLineDirections, GrowingArrayUtils.growSize(j));
        }
        if (!chooseHt.isEmpty()) {
            fm.ascent = above;
            fm.descent = below;
            for (int i = 0; i < chooseHt.size(); ++i) {
                chooseHt.get(i).chooseHeight(text, start, end, chooseHtv[i], v, fm, paint);
            }
            above = fm.ascent;
            below = fm.descent;
        }
        boolean firstLine = j == 0;
        boolean bl = currentLineIsTheLastVisibleOne = j + 1 == this.mMaximumVisibleLineCount;
        if (ellipsize != null) {
            boolean doEllipsis;
            boolean forceEllipsis = moreChars && this.mLineCount + 1 == this.mMaximumVisibleLineCount;
            boolean bl2 = doEllipsis = (this.mMaximumVisibleLineCount == 1 && moreChars || firstLine && !moreChars) && ellipsize != TextUtils.TruncateAt.MARQUEE || !firstLine && (currentLineIsTheLastVisibleOne || !moreChars) && ellipsize == TextUtils.TruncateAt.END;
            if (doEllipsis) {
                this.calculateEllipsis(start, end, measured, widthStart, ellipsisWidth, ellipsize, j, textWidth, paint, forceEllipsis);
            }
        }
        if (this.mEllipsized) {
            lastLine = true;
        } else {
            boolean lastCharIsNewLine;
            boolean bl3 = lastCharIsNewLine = widthStart != bufEnd && bufEnd > 0 && text.charAt(bufEnd - 1) == '\n';
            if (end == bufEnd && !lastCharIsNewLine) {
                lastLine = true;
            } else {
                boolean bl4 = lastLine = start == bufEnd && lastCharIsNewLine;
            }
        }
        if (firstLine) {
            if (trackPad) {
                this.mTopPadding = top - above;
            }
            if (includePad) {
                above = top;
            }
        }
        if (lastLine) {
            if (trackPad) {
                this.mBottomPadding = bottom - below;
            }
            if (includePad) {
                below = bottom;
            }
        }
        int extra = needMultiply && (addLastLineLineSpacing || !lastLine) ? ((ex = (double)((float)(below - above) * (spacingmult - 1.0f) + spacingadd)) >= 0.0 ? (int)(ex + 0.5) : -((int)(-ex + 0.5))) : 0;
        int[] lines = this.mLines;
        lines[off + 0] = start;
        lines[off + 1] = v;
        lines[off + 2] = below + extra;
        lines[off + 3] = extra;
        if (!this.mEllipsized && currentLineIsTheLastVisibleOne) {
            int maxLineBelow = includePad ? bottom : below;
            this.mMaxLineHeight = v + (maxLineBelow - above);
        }
        lines[off + this.mColumns + 0] = end;
        lines[off + this.mColumns + 1] = v += below - above + extra;
        int n2 = off + 0;
        lines[n2] = lines[n2] | (hasTab ? 0x20000000 : 0);
        int n3 = off + 0;
        lines[n3] = lines[n3] | dir << 30;
        this.mLineDirections[j] = measured.getDirections(start - widthStart, end - widthStart);
        ++this.mLineCount;
        return v;
    }

    private void calculateEllipsis(int lineStart, int lineEnd, MeasuredParagraph measured, int widthStart, float avail, TextUtils.TruncateAt where, int line, float textWidth, TextPaint paint, boolean forceEllipsis) {
        if (textWidth <= (avail -= this.getTotalInsets(line)) && !forceEllipsis) {
            this.mLines[this.mColumns * line + 4] = 0;
            this.mLines[this.mColumns * line + 5] = 0;
            return;
        }
        char[] ellipsisChars = TextUtils.getEllipsisChars(where);
        float ellipsisWidth = LayoutCache.getOrCreate(ellipsisChars, 0, ellipsisChars.length, 0, ellipsisChars.length, false, paint.getInternalPaint(), 0).getAdvance();
        int ellipsisStart = 0;
        int ellipsisCount = 0;
        int len = lineEnd - lineStart;
        if (where == TextUtils.TruncateAt.START) {
            if (this.mMaximumVisibleLineCount == 1) {
                int i;
                float sum = 0.0f;
                for (i = len; i > 0; --i) {
                    float w = measured.getAdvance(i - 1 + lineStart - widthStart);
                    if (w + sum + ellipsisWidth > avail) {
                        while (i < len && measured.getAdvance(i + lineStart - widthStart) == 0.0f) {
                            ++i;
                        }
                        break;
                    }
                    sum += w;
                }
                ellipsisStart = 0;
                ellipsisCount = i;
            } else {
                CloudPick.LOGGER.warn(MARKER, "Start Ellipsis only supported with one line");
            }
        } else if (where == TextUtils.TruncateAt.END || where == TextUtils.TruncateAt.MARQUEE) {
            float w;
            int i;
            float sum = 0.0f;
            for (i = 0; i < len && !((w = measured.getAdvance(i + lineStart - widthStart)) + sum + ellipsisWidth > avail); ++i) {
                sum += w;
            }
            ellipsisStart = i;
            ellipsisCount = len - i;
            if (forceEllipsis && ellipsisCount == 0 && len > 0) {
                ellipsisStart = len - 1;
                ellipsisCount = 1;
            }
        } else if (this.mMaximumVisibleLineCount == 1) {
            float w;
            int left;
            int right;
            float lsum = 0.0f;
            float rsum = 0.0f;
            float ravail = (avail - ellipsisWidth) / 2.0f;
            for (right = len; right > 0; --right) {
                float w2 = measured.getAdvance(right - 1 + lineStart - widthStart);
                if (w2 + rsum > ravail) {
                    while (right < len && measured.getAdvance(right + lineStart - widthStart) == 0.0f) {
                        ++right;
                    }
                    break;
                }
                rsum += w2;
            }
            float lavail = avail - ellipsisWidth - rsum;
            for (left = 0; left < right && !((w = measured.getAdvance(left + lineStart - widthStart)) + lsum > lavail); ++left) {
                lsum += w;
            }
            ellipsisStart = left;
            ellipsisCount = right - left;
        } else {
            CloudPick.LOGGER.warn(MARKER, "Middle Ellipsis only supported with one line");
        }
        this.mEllipsized = true;
        this.mLines[this.mColumns * line + 4] = ellipsisStart;
        this.mLines[this.mColumns * line + 5] = ellipsisCount;
    }

    private float getTotalInsets(int line) {
        int totalIndent = 0;
        if (this.mLeftIndents != null) {
            totalIndent = this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
        }
        if (this.mRightIndents != null) {
            totalIndent += this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
        }
        return totalIndent;
    }

    @Override
    public int getLineForVertical(int vertical) {
        int high = this.mLineCount;
        int low = -1;
        int[] lines = this.mLines;
        while (high - low > 1) {
            int guess = high + low >> 1;
            if (lines[this.mColumns * guess + 1] > vertical) {
                high = guess;
                continue;
            }
            low = guess;
        }
        return Math.max(low, 0);
    }

    @Override
    public int getLineCount() {
        return this.mLineCount;
    }

    @Override
    public int getLineTop(int line) {
        return this.mLines[this.mColumns * line + 1];
    }

    @Override
    public int getLineExtra(int line) {
        return this.mLines[this.mColumns * line + 3];
    }

    @Override
    public int getLineDescent(int line) {
        return this.mLines[this.mColumns * line + 2];
    }

    @Override
    public int getLineStart(int line) {
        return this.mLines[this.mColumns * line + 0] & 0x1FFFFFFF;
    }

    @Override
    public int getParagraphDirection(int line) {
        return this.mLines[this.mColumns * line + 0] >> 30;
    }

    @Override
    public boolean getLineContainsTab(int line) {
        return (this.mLines[this.mColumns * line + 0] & 0x20000000) != 0;
    }

    @Override
    public final Directions getLineDirections(int line) {
        if (line > this.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.mLineDirections[line];
    }

    @Override
    public int getTopPadding() {
        return this.mTopPadding;
    }

    @Override
    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    @Override
    public int getIndentAdjust(int line, Layout.Alignment align) {
        if (align == Layout.Alignment.ALIGN_LEFT) {
            if (this.mLeftIndents == null) {
                return 0;
            }
            return this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
        }
        if (align == Layout.Alignment.ALIGN_RIGHT) {
            if (this.mRightIndents == null) {
                return 0;
            }
            return -this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
        }
        if (align == Layout.Alignment.ALIGN_CENTER) {
            int left = 0;
            if (this.mLeftIndents != null) {
                left = this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
            }
            int right = 0;
            if (this.mRightIndents != null) {
                right = this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
            }
            return left - right >> 1;
        }
        throw new AssertionError((Object)("unhandled alignment " + align));
    }

    @Override
    public int getEllipsisCount(int line) {
        if (this.mColumns < 6) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 5];
    }

    @Override
    public int getEllipsisStart(int line) {
        if (this.mColumns < 6) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 4];
    }

    @Override
    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    @Override
    public int getHeight(boolean cap) {
        if (cap && this.mLineCount > this.mMaximumVisibleLineCount && this.mMaxLineHeight == -1) {
            CloudPick.LOGGER.warn(MARKER, "maxLineHeight should not be -1.  maxLines: {} lineCount: {}", (Object)this.mMaximumVisibleLineCount, (Object)this.mLineCount);
        }
        return cap && this.mLineCount > this.mMaximumVisibleLineCount && this.mMaxLineHeight != -1 ? this.mMaxLineHeight : super.getHeight();
    }

    public static final class Builder {
        private final FontMetricsInt mFontMetricsInt = new FontMetricsInt();
        private CharSequence mText;
        private int mStart;
        private int mEnd;
        private TextPaint mPaint;
        private int mWidth;
        private Layout.Alignment mAlignment;
        private TextDirectionHeuristic mTextDir;
        private float mSpacingMult;
        private float mSpacingAdd;
        private boolean mIncludePad;
        private boolean mFallbackLineSpacing;
        private int mEllipsizedWidth;
        @Nullable
        private TextUtils.TruncateAt mEllipsize;
        private int mMaxLines;
        @Nullable
        private int[] mLeftIndents;
        @Nullable
        private int[] mRightIndents;
        private boolean mAddLastLineLineSpacing;
        private LineBreakConfig mLineBreakConfig = LineBreakConfig.NONE;

        private Builder() {
        }

        private void recycle() {
            this.release();
            sPool.release(this);
        }

        void release() {
            this.mText = null;
            this.mPaint = null;
            this.mLeftIndents = null;
            this.mRightIndents = null;
        }

        @NonNull
        Builder setText(@NonNull CharSequence source, int start, int end) {
            this.mText = source;
            this.mStart = start;
            this.mEnd = end;
            return this;
        }

        @NonNull
        Builder setPaint(@NonNull TextPaint paint) {
            this.mPaint = paint;
            return this;
        }

        @NonNull
        Builder setWidth(int width) {
            this.mWidth = width;
            if (this.mEllipsize == null) {
                this.mEllipsizedWidth = width;
            }
            return this;
        }

        @NonNull
        public Builder setAlignment(@NonNull Layout.Alignment alignment) {
            this.mAlignment = alignment;
            return this;
        }

        @NonNull
        public Builder setTextDirection(@NonNull TextDirectionHeuristic textDir) {
            this.mTextDir = textDir;
            return this;
        }

        @NonNull
        public Builder setLineSpacing(float spacingAdd, @FloatRange(from=0.0) float spacingMult) {
            this.mSpacingAdd = spacingAdd;
            this.mSpacingMult = spacingMult;
            return this;
        }

        @NonNull
        public Builder setIncludePad(boolean includePad) {
            this.mIncludePad = includePad;
            return this;
        }

        @NonNull
        public Builder setFallbackLineSpacing(boolean fallbackLineSpacing) {
            this.mFallbackLineSpacing = fallbackLineSpacing;
            return this;
        }

        @NonNull
        public Builder setEllipsizedWidth(int ellipsizedWidth) {
            this.mEllipsizedWidth = ellipsizedWidth;
            return this;
        }

        @NonNull
        public Builder setEllipsize(@Nullable TextUtils.TruncateAt ellipsize) {
            this.mEllipsize = ellipsize;
            return this;
        }

        @NonNull
        public Builder setMaxLines(int maxLines) {
            this.mMaxLines = maxLines;
            return this;
        }

        @NonNull
        public Builder setIndents(@Nullable int[] leftIndents, @Nullable int[] rightIndents) {
            this.mLeftIndents = leftIndents;
            this.mRightIndents = rightIndents;
            return this;
        }

        @NonNull
        Builder setAddLastLineLineSpacing(boolean value) {
            this.mAddLastLineLineSpacing = value;
            return this;
        }

        @NonNull
        public Builder setLineBreakConfig(@NonNull LineBreakConfig lineBreakConfig) {
            this.mLineBreakConfig = lineBreakConfig;
            return this;
        }

        @NonNull
        public StaticLayout build() {
            StaticLayout result = new StaticLayout(this);
            this.recycle();
            return result;
        }
    }
}

